# URL-адреса метаданных и документации

Вы можете настроить несколько конфигураций метаданных в вашем **FastAPI** приложении.

## Метаданные для API

Вы можете задать следующие поля, которые используются в спецификации OpenAPI и в UI автоматической документации API:

| Параметр | Тип | Описание |
|------------|--|-------------|
| `title` | `str` | Заголовок API. |
| `description` | `str` | Краткое описание API. Может быть использован Markdown. |
| `version` | `string` | Версия API. Версия вашего собственного приложения, а не OpenAPI. К примеру `2.5.0`. |
| `terms_of_service` | `str` | Ссылка к условиям пользования API. Если указано, то это должен быть URL-адрес. |
| `contact` | `dict` | Контактная информация для открытого API. Может содержать несколько полей. <details><summary>поля <code>contact</code></summary><table><thead><tr><th>Параметр</th><th>Тип</th><th>Описание</th></tr></thead><tbody><tr><td><code>name</code></td><td><code>str</code></td><td>Идентификационное имя контактного лица/организации.</td></tr><tr><td><code>url</code></td><td><code>str</code></td><td>URL указывающий на контактную информацию. ДОЛЖЕН быть в формате URL.</td></tr><tr><td><code>email</code></td><td><code>str</code></td><td>Email адрес контактного лица/организации. ДОЛЖЕН быть в формате email адреса.</td></tr></tbody></table></details> |
| `license_info` | `dict` | Информация о лицензии открытого API. Может содержать несколько полей. <details><summary>поля <code>license_info</code></summary><table><thead><tr><th>Параметр</th><th>Тип</th><th>Описание</th></tr></thead><tbody><tr><td><code>name</code></td><td><code>str</code></td><td><strong>ОБЯЗАТЕЛЬНО</strong> (если установлен параметр <code>license_info</code>). Название лицензии, используемой для API</td></tr><tr><td><code>url</code></td><td><code>str</code></td><td>URL, указывающий на лицензию, используемую для API. ДОЛЖЕН быть в формате URL.</td></tr></tbody></table></details> |

Вы можете задать их следующим образом:

```Python hl_lines="3-16  19-31"
{!../../../docs_src/metadata/tutorial001.py!}
```

!!! tip "Подсказка"
    Вы можете использовать Markdown в поле `description`, и оно будет отображено в выводе.

С этой конфигурацией автоматическая документация API будут выглядеть так:

<img src="/img/tutorial/metadata/image01.png">

## Метаданные для тегов

Вы также можете добавить дополнительные метаданные для различных тегов, используемых для группировки ваших операций пути с помощью параметра `openapi_tags`.

Он принимает список, содержащий один словарь для каждого тега.

Каждый словарь может содержать в себе:

* `name` (**обязательно**): `str`-значение с тем же именем тега, которое вы используете в параметре `tags` в ваших *операциях пути* и `APIRouter`ах.
* `description`: `str`-значение с кратким описанием для тега. Может содержать Markdown и будет отображаться в UI документации.
* `externalDocs`:  `dict`-значение описывающее внешнюю документацию. Включает в себя:
    * `description`: `str`-значение с кратким описанием для внешней документации.
    * `url` (**обязательно**): `str`-значение с URL-адресом для внешней документации.

### Создание метаданных для тегов

Давайте попробуем сделать это на примере с тегами для `users` и `items`.

Создайте метаданные для ваших тегов и передайте их в параметре `openapi_tags`:

```Python hl_lines="3-16  18"
{!../../../docs_src/metadata/tutorial004.py!}
```

Помните, что вы можете использовать Markdown внутри описания, к примеру "login" будет отображен жирным шрифтом (**login**) и "fancy" будет отображаться курсивом (_fancy_).

!!! tip "Подсказка"
    Вам необязательно добавлять метаданные для всех используемых тегов

### Используйте собственные теги
Используйте параметр `tags` с вашими *операциями пути* (и `APIRouter`ами), чтобы присвоить им различные теги:

```Python hl_lines="21  26"
{!../../../docs_src/metadata/tutorial004.py!}
```

!!! info "Дополнительная информация"
    Узнайте больше о тегах в [Конфигурации операции пути](../path-operation-configuration/#tags){.internal-link target=_blank}.

### Проверьте документацию

Теперь, если вы проверите документацию, вы увидите всю дополнительную информацию:

<img src="/img/tutorial/metadata/image02.png">

### Порядок расположения тегов

Порядок расположения словарей метаданных для каждого тега определяет также порядок, отображаемый в документах UI

К примеру, несмотря на то, что `users` будут идти после `items` в алфавитном порядке, они отображаются раньше, потому что мы добавляем свои метаданные в качестве первого словаря в списке.

## URL-адреса OpenAPI

По умолчанию схема OpenAPI отображена по адресу `/openapi.json`.

Но вы можете изменить это с помощью параметра `openapi_url`.

К примеру, чтобы задать её отображение по адресу `/api/v1/openapi.json`:

```Python hl_lines="3"
{!../../../docs_src/metadata/tutorial002.py!}
```

Если вы хотите отключить схему OpenAPI полностью, вы можете задать `openapi_url=None`, это также отключит пользовательские интерфейсы документации, которые его использует.

## URL-адреса документации

Вы можете изменить конфигурацию двух пользовательских интерфейсов документации, среди которых

* **Swagger UI**: отображаемый по адресу `/docs`.
    * Вы можете задать его URL с помощью параметра `docs_url`.
    * Вы можете отключить это с помощью настройки `docs_url=None`.
* **ReDoc**: отображаемый по адресу `/redoc`.
    * Вы можете задать его URL с помощью параметра `redoc_url`.
    * Вы можете отключить это с помощью настройки `redoc_url=None`.

К примеру, чтобы задать отображение Swagger UI по адресу `/documentation` и отключить ReDoc:

```Python hl_lines="3"
{!../../../docs_src/metadata/tutorial003.py!}
```
