#ifndef FRAMEPRINCIPAL_H
#define FRAMEPRINCIPAL_H
#include <wx/wx.h>
#include <wx/notebook.h>

#include "PanelCadres.h"
#include "PanelSaisieParametresSignature.h"
#include "PanelParametresSortie.h"
#include "PanelChoixImages.h"
#include "PanelResultat.h"

class FramePrincipal: public wxFrame {
public:

    FramePrincipal(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_FRAME_STYLE);

private:
    void on_notebook_page_changing(wxNotebookEvent& event);
    void on_quit(wxCommandEvent& event);

protected:
    wxPanel* notebook_panel_principal_pane_cadres;
    wxPanel* notebook_panel_principal_pane_signature;
    wxPanel* notebook_panel_principal_pane_choix_Images;
    wxPanel* notebook_panel_principal_pane_parametres_sortie;
    wxPanel* notebook_panel_principal_pane_resultat;
    wxPanel* notebook_panel_principal_pane_a_propos;
    wxNotebook* notebook_panel_principal;
    wxPanel* panel_principal;
 
    PanelCadres *panel_cadres;
    PanelSaisieParametresSignature* panel_signature;
    PanelChoixImages* panel_choix_images;
    PanelParametresSortie* panel_parametres_sortie;
    PanelResultat* panel_resultat;
};

#endif // FRAMEPRINCIPAL_H
