﻿' <auto-generated />

Imports System
Imports System.Collections
Imports System.Collections.Generic
Imports System.Collections.Immutable
Imports System.Diagnostics
Imports System.Linq
Imports System.Runtime.CompilerServices
Imports System.Text
Imports System.Threading
Imports Microsoft.CodeAnalysis.Collections
Imports Microsoft.CodeAnalysis.Text
Imports Microsoft.CodeAnalysis.VisualBasic.Symbols
Imports Microsoft.CodeAnalysis.VisualBasic.Syntax
Imports Roslyn.Utilities

Namespace Microsoft.CodeAnalysis.VisualBasic
    Friend Enum BoundKind as Byte
        TypeArguments
        OmittedArgument
        LValueToRValueWrapper
        WithLValueExpressionPlaceholder
        WithRValueExpressionPlaceholder
        RValuePlaceholder
        LValuePlaceholder
        Dup
        BadExpression
        BadStatement
        Parenthesized
        BadVariable
        ArrayAccess
        ArrayLength
        [GetType]
        FieldInfo
        MethodInfo
        TypeExpression
        TypeOrValueExpression
        NamespaceExpression
        MethodDefIndex
        MaximumMethodDefIndex
        InstrumentationPayloadRoot
        ModuleVersionId
        ModuleVersionIdString
        SourceDocumentIndex
        UnaryOperator
        UserDefinedUnaryOperator
        NullableIsTrueOperator
        BinaryOperator
        UserDefinedBinaryOperator
        UserDefinedShortCircuitingOperator
        CompoundAssignmentTargetPlaceholder
        AssignmentOperator
        ReferenceAssignment
        AddressOfOperator
        TernaryConditionalExpression
        BinaryConditionalExpression
        Conversion
        RelaxationLambda
        ConvertedTupleElements
        UserDefinedConversion
        [DirectCast]
        [TryCast]
        [TypeOf]
        SequencePoint
        SequencePointExpression
        SequencePointWithSpan
        NoOpStatement
        MethodGroup
        PropertyGroup
        ReturnStatement
        YieldStatement
        ThrowStatement
        RedimStatement
        RedimClause
        EraseStatement
        [Call]
        Attribute
        LateMemberAccess
        LateInvocation
        LateAddressOfOperator
        TupleLiteral
        ConvertedTupleLiteral
        ObjectCreationExpression
        NoPiaObjectCreationExpression
        AnonymousTypeCreationExpression
        AnonymousTypePropertyAccess
        AnonymousTypeFieldInitializer
        ObjectInitializerExpression
        CollectionInitializerExpression
        NewT
        DelegateCreationExpression
        ArrayCreation
        ArrayLiteral
        ArrayInitialization
        FieldAccess
        PropertyAccess
        EventAccess
        Block
        StateMachineScope
        LocalDeclaration
        AsNewLocalDeclarations
        DimStatement
        Initializer
        FieldInitializer
        PropertyInitializer
        ParameterEqualsValue
        GlobalStatementInitializer
        Sequence
        ExpressionStatement
        IfStatement
        SelectStatement
        CaseBlock
        CaseStatement
        SimpleCaseClause
        RangeCaseClause
        RelationalCaseClause
        DoLoopStatement
        WhileStatement
        ForToUserDefinedOperators
        ForToStatement
        ForEachStatement
        ExitStatement
        ContinueStatement
        TryStatement
        CatchBlock
        Literal
        MeReference
        ValueTypeMeReference
        MyBaseReference
        MyClassReference
        PreviousSubmissionReference
        HostObjectMemberReference
        Local
        PseudoVariable
        Parameter
        ByRefArgumentPlaceholder
        ByRefArgumentWithCopyBack
        LateBoundArgumentSupportingAssignmentWithCapture
        LabelStatement
        Label
        GotoStatement
        StatementList
        ConditionalGoto
        WithStatement
        UnboundLambda
        Lambda
        QueryExpression
        QuerySource
        ToQueryableCollectionConversion
        QueryableSource
        QueryClause
        Ordering
        QueryLambda
        RangeVariableAssignment
        GroupTypeInferenceLambda
        AggregateClause
        GroupAggregation
        RangeVariable
        AddHandlerStatement
        RemoveHandlerStatement
        RaiseEventStatement
        UsingStatement
        SyncLockStatement
        XmlName
        XmlNamespace
        XmlDocument
        XmlDeclaration
        XmlProcessingInstruction
        XmlComment
        XmlAttribute
        XmlElement
        XmlMemberAccess
        XmlEmbeddedExpression
        XmlCData
        ResumeStatement
        OnErrorStatement
        UnstructuredExceptionHandlingStatement
        UnstructuredExceptionHandlingCatchFilter
        UnstructuredExceptionOnErrorSwitch
        UnstructuredExceptionResumeSwitch
        AwaitOperator
        SpillSequence
        StopStatement
        EndStatement
        MidResult
        ConditionalAccess
        ConditionalAccessReceiverPlaceholder
        LoweredConditionalAccess
        ComplexConditionalAccessReceiver
        NameOfOperator
        TypeAsValueExpression
        InterpolatedStringExpression
        Interpolation
    End Enum

















    Partial Friend MustInherit Class BoundExpression
        Inherits BoundNode

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, hasErrors)
            Me._Type = type
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol)
            MyBase.New(kind, syntax)
            Me._Type = type
        End Sub


        Private ReadOnly _Type As TypeSymbol
        Public ReadOnly Property Type As TypeSymbol
            Get
                Return _Type
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundTypeArguments
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, arguments As ImmutableArray(Of TypeSymbol), hasErrors As Boolean)
            MyBase.New(BoundKind.TypeArguments, syntax, Nothing, hasErrors)

            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Arguments = arguments
        End Sub

        Public Sub New(syntax As SyntaxNode, arguments As ImmutableArray(Of TypeSymbol))
            MyBase.New(BoundKind.TypeArguments, syntax, Nothing)

            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Arguments = arguments
        End Sub


        Private ReadOnly _Arguments As ImmutableArray(Of TypeSymbol)
        Public ReadOnly Property Arguments As ImmutableArray(Of TypeSymbol)
            Get
                Return _Arguments
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTypeArguments(Me)
        End Function

        Public Function Update(arguments As ImmutableArray(Of TypeSymbol)) As BoundTypeArguments
            If arguments <> Me.Arguments Then
                Dim result = New BoundTypeArguments(Me.Syntax, arguments, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundOmittedArgument
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.OmittedArgument, syntax, type, hasErrors)
        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.OmittedArgument, syntax, type)
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitOmittedArgument(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundOmittedArgument
            If type IsNot Me.Type Then
                Dim result = New BoundOmittedArgument(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundValuePlaceholderBase
        Inherits BoundExpression

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol)
            MyBase.New(kind, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

    End Class

    Partial Friend NotInheritable Class BoundLValueToRValueWrapper
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, underlyingLValue As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.LValueToRValueWrapper, syntax, type, hasErrors OrElse underlyingLValue.NonNullAndHasErrors())

            Debug.Assert(underlyingLValue IsNot Nothing, "Field 'underlyingLValue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._UnderlyingLValue = underlyingLValue

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _UnderlyingLValue As BoundExpression
        Public ReadOnly Property UnderlyingLValue As BoundExpression
            Get
                Return _UnderlyingLValue
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLValueToRValueWrapper(Me)
        End Function

        Public Function Update(underlyingLValue As BoundExpression, type As TypeSymbol) As BoundLValueToRValueWrapper
            If underlyingLValue IsNot Me.UnderlyingLValue OrElse type IsNot Me.Type Then
                Dim result = New BoundLValueToRValueWrapper(Me.Syntax, underlyingLValue, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundLValuePlaceholderBase
        Inherits BoundValuePlaceholderBase

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol)
            MyBase.New(kind, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

    End Class

    Partial Friend MustInherit Class BoundRValuePlaceholderBase
        Inherits BoundValuePlaceholderBase

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol)
            MyBase.New(kind, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

    End Class

    Partial Friend NotInheritable Class BoundWithLValueExpressionPlaceholder
        Inherits BoundLValuePlaceholderBase

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.WithLValueExpressionPlaceholder, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.WithLValueExpressionPlaceholder, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitWithLValueExpressionPlaceholder(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundWithLValueExpressionPlaceholder
            If type IsNot Me.Type Then
                Dim result = New BoundWithLValueExpressionPlaceholder(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundWithRValueExpressionPlaceholder
        Inherits BoundRValuePlaceholderBase

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.WithRValueExpressionPlaceholder, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.WithRValueExpressionPlaceholder, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitWithRValueExpressionPlaceholder(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundWithRValueExpressionPlaceholder
            If type IsNot Me.Type Then
                Dim result = New BoundWithRValueExpressionPlaceholder(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRValuePlaceholder
        Inherits BoundRValuePlaceholderBase

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.RValuePlaceholder, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.RValuePlaceholder, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRValuePlaceholder(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundRValuePlaceholder
            If type IsNot Me.Type Then
                Dim result = New BoundRValuePlaceholder(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLValuePlaceholder
        Inherits BoundLValuePlaceholderBase

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.LValuePlaceholder, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.LValuePlaceholder, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLValuePlaceholder(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundLValuePlaceholder
            If type IsNot Me.Type Then
                Dim result = New BoundLValuePlaceholder(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundDup
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, isReference As Boolean, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.Dup, syntax, type, hasErrors)
            Me._IsReference = isReference
        End Sub

        Public Sub New(syntax As SyntaxNode, isReference As Boolean, type As TypeSymbol)
            MyBase.New(BoundKind.Dup, syntax, type)
            Me._IsReference = isReference
        End Sub


        Private ReadOnly _IsReference As Boolean
        Public ReadOnly Property IsReference As Boolean
            Get
                Return _IsReference
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitDup(Me)
        End Function

        Public Function Update(isReference As Boolean, type As TypeSymbol) As BoundDup
            If isReference <> Me.IsReference OrElse type IsNot Me.Type Then
                Dim result = New BoundDup(Me.Syntax, isReference, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundBadExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, resultKind As LookupResultKind, symbols As ImmutableArray(Of Symbol), childBoundNodes As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.BadExpression, syntax, type, hasErrors OrElse childBoundNodes.NonNullAndHasErrors())

            Debug.Assert(Not (symbols.IsDefault), "Field 'symbols' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (childBoundNodes.IsDefault), "Field 'childBoundNodes' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ResultKind = resultKind
            Me._Symbols = symbols
            Me._ChildBoundNodes = childBoundNodes

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ResultKind As LookupResultKind
        Public Overrides ReadOnly Property ResultKind As LookupResultKind
            Get
                Return _ResultKind
            End Get
        End Property

        Private ReadOnly _Symbols As ImmutableArray(Of Symbol)
        Public ReadOnly Property Symbols As ImmutableArray(Of Symbol)
            Get
                Return _Symbols
            End Get
        End Property

        Private ReadOnly _ChildBoundNodes As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property ChildBoundNodes As ImmutableArray(Of BoundExpression)
            Get
                Return _ChildBoundNodes
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitBadExpression(Me)
        End Function

        Public Function Update(resultKind As LookupResultKind, symbols As ImmutableArray(Of Symbol), childBoundNodes As ImmutableArray(Of BoundExpression), type As TypeSymbol) As BoundBadExpression
            If resultKind <> Me.ResultKind OrElse symbols <> Me.Symbols OrElse childBoundNodes <> Me.ChildBoundNodes OrElse type IsNot Me.Type Then
                Dim result = New BoundBadExpression(Me.Syntax, resultKind, symbols, childBoundNodes, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundBadStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, childBoundNodes As ImmutableArray(Of BoundNode), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.BadStatement, syntax, hasErrors OrElse childBoundNodes.NonNullAndHasErrors())

            Debug.Assert(Not (childBoundNodes.IsDefault), "Field 'childBoundNodes' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ChildBoundNodes = childBoundNodes
        End Sub


        Private ReadOnly _ChildBoundNodes As ImmutableArray(Of BoundNode)
        Public ReadOnly Property ChildBoundNodes As ImmutableArray(Of BoundNode)
            Get
                Return _ChildBoundNodes
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitBadStatement(Me)
        End Function

        Public Function Update(childBoundNodes As ImmutableArray(Of BoundNode)) As BoundBadStatement
            If childBoundNodes <> Me.ChildBoundNodes Then
                Dim result = New BoundBadStatement(Me.Syntax, childBoundNodes, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundParenthesized
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Parenthesized, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitParenthesized(Me)
        End Function

        Public Function Update(expression As BoundExpression, type As TypeSymbol) As BoundParenthesized
            If expression IsNot Me.Expression OrElse type IsNot Me.Type Then
                Dim result = New BoundParenthesized(Me.Syntax, expression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundBadVariable
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, isLValue As Boolean, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.BadVariable, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
            Me._IsLValue = isLValue
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitBadVariable(Me)
        End Function

        Public Function Update(expression As BoundExpression, isLValue As Boolean, type As TypeSymbol) As BoundBadVariable
            If expression IsNot Me.Expression OrElse isLValue <> Me.IsLValue OrElse type IsNot Me.Type Then
                Dim result = New BoundBadVariable(Me.Syntax, expression, isLValue, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundArrayAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, indices As ImmutableArray(Of BoundExpression), isLValue As Boolean, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ArrayAccess, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors() OrElse indices.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (indices.IsDefault), "Field 'indices' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
            Me._Indices = indices
            Me._IsLValue = isLValue

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        Private ReadOnly _Indices As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Indices As ImmutableArray(Of BoundExpression)
            Get
                Return _Indices
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitArrayAccess(Me)
        End Function

        Public Function Update(expression As BoundExpression, indices As ImmutableArray(Of BoundExpression), isLValue As Boolean, type As TypeSymbol) As BoundArrayAccess
            If expression IsNot Me.Expression OrElse indices <> Me.Indices OrElse isLValue <> Me.IsLValue OrElse type IsNot Me.Type Then
                Dim result = New BoundArrayAccess(Me.Syntax, expression, indices, isLValue, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundArrayLength
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ArrayLength, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitArrayLength(Me)
        End Function

        Public Function Update(expression As BoundExpression, type As TypeSymbol) As BoundArrayLength
            If expression IsNot Me.Expression OrElse type IsNot Me.Type Then
                Dim result = New BoundArrayLength(Me.Syntax, expression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundGetType
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, sourceType As BoundTypeExpression, getTypeFromHandle As MethodSymbol, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.GetType, syntax, type, hasErrors OrElse sourceType.NonNullAndHasErrors())

            Debug.Assert(sourceType IsNot Nothing, "Field 'sourceType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._SourceType = sourceType
            Me._GetTypeFromHandle = getTypeFromHandle
        End Sub


        Private ReadOnly _SourceType As BoundTypeExpression
        Public ReadOnly Property SourceType As BoundTypeExpression
            Get
                Return _SourceType
            End Get
        End Property

        Private ReadOnly _GetTypeFromHandle As MethodSymbol
        Public ReadOnly Property GetTypeFromHandle As MethodSymbol
            Get
                Return _GetTypeFromHandle
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitGetType(Me)
        End Function

        Public Function Update(sourceType As BoundTypeExpression, getTypeFromHandle As MethodSymbol, type As TypeSymbol) As BoundGetType
            If sourceType IsNot Me.SourceType OrElse getTypeFromHandle IsNot Me.GetTypeFromHandle OrElse type IsNot Me.Type Then
                Dim result = New BoundGetType(Me.Syntax, sourceType, getTypeFromHandle, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundFieldInfo
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, field As FieldSymbol, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.FieldInfo, syntax, type, hasErrors)

            Debug.Assert(field IsNot Nothing, "Field 'field' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Field = field
        End Sub

        Public Sub New(syntax As SyntaxNode, field As FieldSymbol, type As TypeSymbol)
            MyBase.New(BoundKind.FieldInfo, syntax, type)

            Debug.Assert(field IsNot Nothing, "Field 'field' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Field = field
        End Sub


        Private ReadOnly _Field As FieldSymbol
        Public ReadOnly Property Field As FieldSymbol
            Get
                Return _Field
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitFieldInfo(Me)
        End Function

        Public Function Update(field As FieldSymbol, type As TypeSymbol) As BoundFieldInfo
            If field IsNot Me.Field OrElse type IsNot Me.Type Then
                Dim result = New BoundFieldInfo(Me.Syntax, field, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundMethodInfo
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, method As MethodSymbol, getMethodFromHandle As MethodSymbol, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.MethodInfo, syntax, type, hasErrors)

            Debug.Assert(method IsNot Nothing, "Field 'method' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(getMethodFromHandle IsNot Nothing, "Field 'getMethodFromHandle' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Method = method
            Me._GetMethodFromHandle = getMethodFromHandle
        End Sub

        Public Sub New(syntax As SyntaxNode, method As MethodSymbol, getMethodFromHandle As MethodSymbol, type As TypeSymbol)
            MyBase.New(BoundKind.MethodInfo, syntax, type)

            Debug.Assert(method IsNot Nothing, "Field 'method' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(getMethodFromHandle IsNot Nothing, "Field 'getMethodFromHandle' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Method = method
            Me._GetMethodFromHandle = getMethodFromHandle
        End Sub


        Private ReadOnly _Method As MethodSymbol
        Public ReadOnly Property Method As MethodSymbol
            Get
                Return _Method
            End Get
        End Property

        Private ReadOnly _GetMethodFromHandle As MethodSymbol
        Public ReadOnly Property GetMethodFromHandle As MethodSymbol
            Get
                Return _GetMethodFromHandle
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMethodInfo(Me)
        End Function

        Public Function Update(method As MethodSymbol, getMethodFromHandle As MethodSymbol, type As TypeSymbol) As BoundMethodInfo
            If method IsNot Me.Method OrElse getMethodFromHandle IsNot Me.GetMethodFromHandle OrElse type IsNot Me.Type Then
                Dim result = New BoundMethodInfo(Me.Syntax, method, getMethodFromHandle, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundTypeExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, unevaluatedReceiverOpt As BoundExpression, aliasOpt As AliasSymbol, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.TypeExpression, syntax, type, hasErrors OrElse unevaluatedReceiverOpt.NonNullAndHasErrors())

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._UnevaluatedReceiverOpt = unevaluatedReceiverOpt
            Me._AliasOpt = aliasOpt
        End Sub


        Private ReadOnly _UnevaluatedReceiverOpt As BoundExpression
        Public ReadOnly Property UnevaluatedReceiverOpt As BoundExpression
            Get
                Return _UnevaluatedReceiverOpt
            End Get
        End Property

        Private ReadOnly _AliasOpt As AliasSymbol
        Public ReadOnly Property AliasOpt As AliasSymbol
            Get
                Return _AliasOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTypeExpression(Me)
        End Function

        Public Function Update(unevaluatedReceiverOpt As BoundExpression, aliasOpt As AliasSymbol, type As TypeSymbol) As BoundTypeExpression
            If unevaluatedReceiverOpt IsNot Me.UnevaluatedReceiverOpt OrElse aliasOpt IsNot Me.AliasOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundTypeExpression(Me.Syntax, unevaluatedReceiverOpt, aliasOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundTypeOrValueExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, data As BoundTypeOrValueData, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.TypeOrValueExpression, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Data = data
        End Sub

        Public Sub New(syntax As SyntaxNode, data As BoundTypeOrValueData, type As TypeSymbol)
            MyBase.New(BoundKind.TypeOrValueExpression, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Data = data
        End Sub


        Private ReadOnly _Data As BoundTypeOrValueData
        Public ReadOnly Property Data As BoundTypeOrValueData
            Get
                Return _Data
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTypeOrValueExpression(Me)
        End Function

        Public Function Update(data As BoundTypeOrValueData, type As TypeSymbol) As BoundTypeOrValueExpression
            If data <> Me.Data OrElse type IsNot Me.Type Then
                Dim result = New BoundTypeOrValueExpression(Me.Syntax, data, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundNamespaceExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, unevaluatedReceiverOpt As BoundExpression, aliasOpt As AliasSymbol, namespaceSymbol As NamespaceSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.NamespaceExpression, syntax, Nothing, hasErrors OrElse unevaluatedReceiverOpt.NonNullAndHasErrors())

            Debug.Assert(namespaceSymbol IsNot Nothing, "Field 'namespaceSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._UnevaluatedReceiverOpt = unevaluatedReceiverOpt
            Me._AliasOpt = aliasOpt
            Me._NamespaceSymbol = namespaceSymbol

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _UnevaluatedReceiverOpt As BoundExpression
        Public ReadOnly Property UnevaluatedReceiverOpt As BoundExpression
            Get
                Return _UnevaluatedReceiverOpt
            End Get
        End Property

        Private ReadOnly _AliasOpt As AliasSymbol
        Public ReadOnly Property AliasOpt As AliasSymbol
            Get
                Return _AliasOpt
            End Get
        End Property

        Private ReadOnly _NamespaceSymbol As NamespaceSymbol
        Public ReadOnly Property NamespaceSymbol As NamespaceSymbol
            Get
                Return _NamespaceSymbol
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitNamespaceExpression(Me)
        End Function

        Public Function Update(unevaluatedReceiverOpt As BoundExpression, aliasOpt As AliasSymbol, namespaceSymbol As NamespaceSymbol) As BoundNamespaceExpression
            If unevaluatedReceiverOpt IsNot Me.UnevaluatedReceiverOpt OrElse aliasOpt IsNot Me.AliasOpt OrElse namespaceSymbol IsNot Me.NamespaceSymbol Then
                Dim result = New BoundNamespaceExpression(Me.Syntax, unevaluatedReceiverOpt, aliasOpt, namespaceSymbol, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundMethodDefIndex
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, method As MethodSymbol, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.MethodDefIndex, syntax, type, hasErrors)

            Debug.Assert(method IsNot Nothing, "Field 'method' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Method = method
        End Sub

        Public Sub New(syntax As SyntaxNode, method As MethodSymbol, type As TypeSymbol)
            MyBase.New(BoundKind.MethodDefIndex, syntax, type)

            Debug.Assert(method IsNot Nothing, "Field 'method' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Method = method
        End Sub


        Private ReadOnly _Method As MethodSymbol
        Public ReadOnly Property Method As MethodSymbol
            Get
                Return _Method
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMethodDefIndex(Me)
        End Function

        Public Function Update(method As MethodSymbol, type As TypeSymbol) As BoundMethodDefIndex
            If method IsNot Me.Method OrElse type IsNot Me.Type Then
                Dim result = New BoundMethodDefIndex(Me.Syntax, method, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundMaximumMethodDefIndex
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.MaximumMethodDefIndex, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.MaximumMethodDefIndex, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMaximumMethodDefIndex(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundMaximumMethodDefIndex
            If type IsNot Me.Type Then
                Dim result = New BoundMaximumMethodDefIndex(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundInstrumentationPayloadRoot
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, analysisKind As Integer, isLValue As Boolean, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.InstrumentationPayloadRoot, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._AnalysisKind = analysisKind
            Me._IsLValue = isLValue
        End Sub

        Public Sub New(syntax As SyntaxNode, analysisKind As Integer, isLValue As Boolean, type As TypeSymbol)
            MyBase.New(BoundKind.InstrumentationPayloadRoot, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._AnalysisKind = analysisKind
            Me._IsLValue = isLValue
        End Sub


        Private ReadOnly _AnalysisKind As Integer
        Public ReadOnly Property AnalysisKind As Integer
            Get
                Return _AnalysisKind
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitInstrumentationPayloadRoot(Me)
        End Function

        Public Function Update(analysisKind As Integer, isLValue As Boolean, type As TypeSymbol) As BoundInstrumentationPayloadRoot
            If analysisKind <> Me.AnalysisKind OrElse isLValue <> Me.IsLValue OrElse type IsNot Me.Type Then
                Dim result = New BoundInstrumentationPayloadRoot(Me.Syntax, analysisKind, isLValue, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundModuleVersionId
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, isLValue As Boolean, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.ModuleVersionId, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._IsLValue = isLValue
        End Sub

        Public Sub New(syntax As SyntaxNode, isLValue As Boolean, type As TypeSymbol)
            MyBase.New(BoundKind.ModuleVersionId, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._IsLValue = isLValue
        End Sub


        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitModuleVersionId(Me)
        End Function

        Public Function Update(isLValue As Boolean, type As TypeSymbol) As BoundModuleVersionId
            If isLValue <> Me.IsLValue OrElse type IsNot Me.Type Then
                Dim result = New BoundModuleVersionId(Me.Syntax, isLValue, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundModuleVersionIdString
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.ModuleVersionIdString, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.ModuleVersionIdString, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitModuleVersionIdString(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundModuleVersionIdString
            If type IsNot Me.Type Then
                Dim result = New BoundModuleVersionIdString(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundSourceDocumentIndex
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, document As Cci.DebugSourceDocument, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.SourceDocumentIndex, syntax, type, hasErrors)

            Debug.Assert(document IsNot Nothing, "Field 'document' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Document = document
        End Sub

        Public Sub New(syntax As SyntaxNode, document As Cci.DebugSourceDocument, type As TypeSymbol)
            MyBase.New(BoundKind.SourceDocumentIndex, syntax, type)

            Debug.Assert(document IsNot Nothing, "Field 'document' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Document = document
        End Sub


        Private ReadOnly _Document As Cci.DebugSourceDocument
        Public ReadOnly Property Document As Cci.DebugSourceDocument
            Get
                Return _Document
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSourceDocumentIndex(Me)
        End Function

        Public Function Update(document As Cci.DebugSourceDocument, type As TypeSymbol) As BoundSourceDocumentIndex
            If document IsNot Me.Document OrElse type IsNot Me.Type Then
                Dim result = New BoundSourceDocumentIndex(Me.Syntax, document, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUnaryOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, operatorKind As UnaryOperatorKind, operand As BoundExpression, checked As Boolean, constantValueOpt As ConstantValue, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UnaryOperator, syntax, type, hasErrors OrElse operand.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._OperatorKind = operatorKind
            Me._Operand = operand
            Me._Checked = checked
            Me._ConstantValueOpt = constantValueOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OperatorKind As UnaryOperatorKind
        Public ReadOnly Property OperatorKind As UnaryOperatorKind
            Get
                Return _OperatorKind
            End Get
        End Property

        Private ReadOnly _Operand As BoundExpression
        Public ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        Private ReadOnly _Checked As Boolean
        Public ReadOnly Property Checked As Boolean
            Get
                Return _Checked
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUnaryOperator(Me)
        End Function

        Public Function Update(operatorKind As UnaryOperatorKind, operand As BoundExpression, checked As Boolean, constantValueOpt As ConstantValue, type As TypeSymbol) As BoundUnaryOperator
            If operatorKind <> Me.OperatorKind OrElse operand IsNot Me.Operand OrElse checked <> Me.Checked OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundUnaryOperator(Me.Syntax, operatorKind, operand, checked, constantValueOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUserDefinedUnaryOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, operatorKind As UnaryOperatorKind, underlyingExpression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UserDefinedUnaryOperator, syntax, type, hasErrors OrElse underlyingExpression.NonNullAndHasErrors())

            Debug.Assert(underlyingExpression IsNot Nothing, "Field 'underlyingExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._OperatorKind = operatorKind
            Me._UnderlyingExpression = underlyingExpression

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OperatorKind As UnaryOperatorKind
        Public ReadOnly Property OperatorKind As UnaryOperatorKind
            Get
                Return _OperatorKind
            End Get
        End Property

        Private ReadOnly _UnderlyingExpression As BoundExpression
        Public ReadOnly Property UnderlyingExpression As BoundExpression
            Get
                Return _UnderlyingExpression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUserDefinedUnaryOperator(Me)
        End Function

        Public Function Update(operatorKind As UnaryOperatorKind, underlyingExpression As BoundExpression, type As TypeSymbol) As BoundUserDefinedUnaryOperator
            If operatorKind <> Me.OperatorKind OrElse underlyingExpression IsNot Me.UnderlyingExpression OrElse type IsNot Me.Type Then
                Dim result = New BoundUserDefinedUnaryOperator(Me.Syntax, operatorKind, underlyingExpression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundNullableIsTrueOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, operand As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.NullableIsTrueOperator, syntax, type, hasErrors OrElse operand.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Operand = operand

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Operand As BoundExpression
        Public ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitNullableIsTrueOperator(Me)
        End Function

        Public Function Update(operand As BoundExpression, type As TypeSymbol) As BoundNullableIsTrueOperator
            If operand IsNot Me.Operand OrElse type IsNot Me.Type Then
                Dim result = New BoundNullableIsTrueOperator(Me.Syntax, operand, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundBinaryOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, operatorKind As BinaryOperatorKind, left As BoundExpression, right As BoundExpression, checked As Boolean, constantValueOpt As ConstantValue, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.BinaryOperator, syntax, type, hasErrors OrElse left.NonNullAndHasErrors() OrElse right.NonNullAndHasErrors())

            Debug.Assert(left IsNot Nothing, "Field 'left' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(right IsNot Nothing, "Field 'right' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._OperatorKind = operatorKind
            Me._Left = left
            Me._Right = right
            Me._Checked = checked
            Me._ConstantValueOpt = constantValueOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OperatorKind As BinaryOperatorKind
        Public ReadOnly Property OperatorKind As BinaryOperatorKind
            Get
                Return _OperatorKind
            End Get
        End Property

        Private ReadOnly _Left As BoundExpression
        Public ReadOnly Property Left As BoundExpression
            Get
                Return _Left
            End Get
        End Property

        Private ReadOnly _Right As BoundExpression
        Public ReadOnly Property Right As BoundExpression
            Get
                Return _Right
            End Get
        End Property

        Private ReadOnly _Checked As Boolean
        Public ReadOnly Property Checked As Boolean
            Get
                Return _Checked
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitBinaryOperator(Me)
        End Function

        Public Function Update(operatorKind As BinaryOperatorKind, left As BoundExpression, right As BoundExpression, checked As Boolean, constantValueOpt As ConstantValue, type As TypeSymbol) As BoundBinaryOperator
            If operatorKind <> Me.OperatorKind OrElse left IsNot Me.Left OrElse right IsNot Me.Right OrElse checked <> Me.Checked OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundBinaryOperator(Me.Syntax, operatorKind, left, right, checked, constantValueOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUserDefinedBinaryOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, operatorKind As BinaryOperatorKind, underlyingExpression As BoundExpression, checked As Boolean, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UserDefinedBinaryOperator, syntax, type, hasErrors OrElse underlyingExpression.NonNullAndHasErrors())

            Debug.Assert(underlyingExpression IsNot Nothing, "Field 'underlyingExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._OperatorKind = operatorKind
            Me._UnderlyingExpression = underlyingExpression
            Me._Checked = checked

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OperatorKind As BinaryOperatorKind
        Public ReadOnly Property OperatorKind As BinaryOperatorKind
            Get
                Return _OperatorKind
            End Get
        End Property

        Private ReadOnly _UnderlyingExpression As BoundExpression
        Public ReadOnly Property UnderlyingExpression As BoundExpression
            Get
                Return _UnderlyingExpression
            End Get
        End Property

        Private ReadOnly _Checked As Boolean
        Public ReadOnly Property Checked As Boolean
            Get
                Return _Checked
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUserDefinedBinaryOperator(Me)
        End Function

        Public Function Update(operatorKind As BinaryOperatorKind, underlyingExpression As BoundExpression, checked As Boolean, type As TypeSymbol) As BoundUserDefinedBinaryOperator
            If operatorKind <> Me.OperatorKind OrElse underlyingExpression IsNot Me.UnderlyingExpression OrElse checked <> Me.Checked OrElse type IsNot Me.Type Then
                Dim result = New BoundUserDefinedBinaryOperator(Me.Syntax, operatorKind, underlyingExpression, checked, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUserDefinedShortCircuitingOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, leftOperand As BoundExpression, leftOperandPlaceholder As BoundRValuePlaceholder, leftTest As BoundExpression, bitwiseOperator As BoundUserDefinedBinaryOperator, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UserDefinedShortCircuitingOperator, syntax, type, hasErrors OrElse leftOperand.NonNullAndHasErrors() OrElse leftOperandPlaceholder.NonNullAndHasErrors() OrElse leftTest.NonNullAndHasErrors() OrElse bitwiseOperator.NonNullAndHasErrors())

            Debug.Assert(bitwiseOperator IsNot Nothing, "Field 'bitwiseOperator' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LeftOperand = leftOperand
            Me._LeftOperandPlaceholder = leftOperandPlaceholder
            Me._LeftTest = leftTest
            Me._BitwiseOperator = bitwiseOperator

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _LeftOperand As BoundExpression
        Public ReadOnly Property LeftOperand As BoundExpression
            Get
                Return _LeftOperand
            End Get
        End Property

        Private ReadOnly _LeftOperandPlaceholder As BoundRValuePlaceholder
        Public ReadOnly Property LeftOperandPlaceholder As BoundRValuePlaceholder
            Get
                Return _LeftOperandPlaceholder
            End Get
        End Property

        Private ReadOnly _LeftTest As BoundExpression
        Public ReadOnly Property LeftTest As BoundExpression
            Get
                Return _LeftTest
            End Get
        End Property

        Private ReadOnly _BitwiseOperator As BoundUserDefinedBinaryOperator
        Public ReadOnly Property BitwiseOperator As BoundUserDefinedBinaryOperator
            Get
                Return _BitwiseOperator
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUserDefinedShortCircuitingOperator(Me)
        End Function

        Public Function Update(leftOperand As BoundExpression, leftOperandPlaceholder As BoundRValuePlaceholder, leftTest As BoundExpression, bitwiseOperator As BoundUserDefinedBinaryOperator, type As TypeSymbol) As BoundUserDefinedShortCircuitingOperator
            If leftOperand IsNot Me.LeftOperand OrElse leftOperandPlaceholder IsNot Me.LeftOperandPlaceholder OrElse leftTest IsNot Me.LeftTest OrElse bitwiseOperator IsNot Me.BitwiseOperator OrElse type IsNot Me.Type Then
                Dim result = New BoundUserDefinedShortCircuitingOperator(Me.Syntax, leftOperand, leftOperandPlaceholder, leftTest, bitwiseOperator, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundCompoundAssignmentTargetPlaceholder
        Inherits BoundValuePlaceholderBase

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.CompoundAssignmentTargetPlaceholder, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.CompoundAssignmentTargetPlaceholder, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitCompoundAssignmentTargetPlaceholder(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundCompoundAssignmentTargetPlaceholder
            If type IsNot Me.Type Then
                Dim result = New BoundCompoundAssignmentTargetPlaceholder(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAssignmentOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, left As BoundExpression, leftOnTheRightOpt As BoundCompoundAssignmentTargetPlaceholder, right As BoundExpression, suppressObjectClone As Boolean, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AssignmentOperator, syntax, type, hasErrors OrElse left.NonNullAndHasErrors() OrElse leftOnTheRightOpt.NonNullAndHasErrors() OrElse right.NonNullAndHasErrors())

            Debug.Assert(left IsNot Nothing, "Field 'left' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(right IsNot Nothing, "Field 'right' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Left = left
            Me._LeftOnTheRightOpt = leftOnTheRightOpt
            Me._Right = right
            Me._SuppressObjectClone = suppressObjectClone

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Left As BoundExpression
        Public ReadOnly Property Left As BoundExpression
            Get
                Return _Left
            End Get
        End Property

        Private ReadOnly _LeftOnTheRightOpt As BoundCompoundAssignmentTargetPlaceholder
        Public ReadOnly Property LeftOnTheRightOpt As BoundCompoundAssignmentTargetPlaceholder
            Get
                Return _LeftOnTheRightOpt
            End Get
        End Property

        Private ReadOnly _Right As BoundExpression
        Public ReadOnly Property Right As BoundExpression
            Get
                Return _Right
            End Get
        End Property

        Private ReadOnly _SuppressObjectClone As Boolean
        Public ReadOnly Property SuppressObjectClone As Boolean
            Get
                Return _SuppressObjectClone
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAssignmentOperator(Me)
        End Function

        Public Function Update(left As BoundExpression, leftOnTheRightOpt As BoundCompoundAssignmentTargetPlaceholder, right As BoundExpression, suppressObjectClone As Boolean, type As TypeSymbol) As BoundAssignmentOperator
            If left IsNot Me.Left OrElse leftOnTheRightOpt IsNot Me.LeftOnTheRightOpt OrElse right IsNot Me.Right OrElse suppressObjectClone <> Me.SuppressObjectClone OrElse type IsNot Me.Type Then
                Dim result = New BoundAssignmentOperator(Me.Syntax, left, leftOnTheRightOpt, right, suppressObjectClone, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundReferenceAssignment
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, byRefLocal As BoundLocal, lValue As BoundExpression, isLValue As Boolean, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ReferenceAssignment, syntax, type, hasErrors OrElse byRefLocal.NonNullAndHasErrors() OrElse lValue.NonNullAndHasErrors())

            Debug.Assert(byRefLocal IsNot Nothing, "Field 'byRefLocal' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ByRefLocal = byRefLocal
            Me._LValue = lValue
            Me._IsLValue = isLValue

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ByRefLocal As BoundLocal
        Public ReadOnly Property ByRefLocal As BoundLocal
            Get
                Return _ByRefLocal
            End Get
        End Property

        Private ReadOnly _LValue As BoundExpression
        Public ReadOnly Property LValue As BoundExpression
            Get
                Return _LValue
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitReferenceAssignment(Me)
        End Function

        Public Function Update(byRefLocal As BoundLocal, lValue As BoundExpression, isLValue As Boolean, type As TypeSymbol) As BoundReferenceAssignment
            If byRefLocal IsNot Me.ByRefLocal OrElse lValue IsNot Me.LValue OrElse isLValue <> Me.IsLValue OrElse type IsNot Me.Type Then
                Dim result = New BoundReferenceAssignment(Me.Syntax, byRefLocal, lValue, isLValue, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAddressOfOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, binder As Binder, withDependencies As Boolean, methodGroup As BoundMethodGroup, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AddressOfOperator, syntax, Nothing, hasErrors OrElse methodGroup.NonNullAndHasErrors())

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(methodGroup IsNot Nothing, "Field 'methodGroup' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._WithDependencies = withDependencies
            Me._MethodGroup = methodGroup
        End Sub


        Private ReadOnly _Binder As Binder
        Public ReadOnly Property Binder As Binder
            Get
                Return _Binder
            End Get
        End Property

        Private ReadOnly _WithDependencies As Boolean
        Public ReadOnly Property WithDependencies As Boolean
            Get
                Return _WithDependencies
            End Get
        End Property

        Private ReadOnly _MethodGroup As BoundMethodGroup
        Public ReadOnly Property MethodGroup As BoundMethodGroup
            Get
                Return _MethodGroup
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAddressOfOperator(Me)
        End Function

        Public Function Update(binder As Binder, withDependencies As Boolean, methodGroup As BoundMethodGroup) As BoundAddressOfOperator
            If binder IsNot Me.Binder OrElse withDependencies <> Me.WithDependencies OrElse methodGroup IsNot Me.MethodGroup Then
                Dim result = New BoundAddressOfOperator(Me.Syntax, binder, withDependencies, methodGroup, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundTernaryConditionalExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, condition As BoundExpression, whenTrue As BoundExpression, whenFalse As BoundExpression, constantValueOpt As ConstantValue, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.TernaryConditionalExpression, syntax, type, hasErrors OrElse condition.NonNullAndHasErrors() OrElse whenTrue.NonNullAndHasErrors() OrElse whenFalse.NonNullAndHasErrors())

            Debug.Assert(condition IsNot Nothing, "Field 'condition' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(whenTrue IsNot Nothing, "Field 'whenTrue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(whenFalse IsNot Nothing, "Field 'whenFalse' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Condition = condition
            Me._WhenTrue = whenTrue
            Me._WhenFalse = whenFalse
            Me._ConstantValueOpt = constantValueOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Condition As BoundExpression
        Public ReadOnly Property Condition As BoundExpression
            Get
                Return _Condition
            End Get
        End Property

        Private ReadOnly _WhenTrue As BoundExpression
        Public ReadOnly Property WhenTrue As BoundExpression
            Get
                Return _WhenTrue
            End Get
        End Property

        Private ReadOnly _WhenFalse As BoundExpression
        Public ReadOnly Property WhenFalse As BoundExpression
            Get
                Return _WhenFalse
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTernaryConditionalExpression(Me)
        End Function

        Public Function Update(condition As BoundExpression, whenTrue As BoundExpression, whenFalse As BoundExpression, constantValueOpt As ConstantValue, type As TypeSymbol) As BoundTernaryConditionalExpression
            If condition IsNot Me.Condition OrElse whenTrue IsNot Me.WhenTrue OrElse whenFalse IsNot Me.WhenFalse OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundTernaryConditionalExpression(Me.Syntax, condition, whenTrue, whenFalse, constantValueOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundBinaryConditionalExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, testExpression As BoundExpression, convertedTestExpression As BoundExpression, testExpressionPlaceholder As BoundRValuePlaceholder, elseExpression As BoundExpression, constantValueOpt As ConstantValue, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.BinaryConditionalExpression, syntax, type, hasErrors OrElse testExpression.NonNullAndHasErrors() OrElse convertedTestExpression.NonNullAndHasErrors() OrElse testExpressionPlaceholder.NonNullAndHasErrors() OrElse elseExpression.NonNullAndHasErrors())

            Debug.Assert(testExpression IsNot Nothing, "Field 'testExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(elseExpression IsNot Nothing, "Field 'elseExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._TestExpression = testExpression
            Me._ConvertedTestExpression = convertedTestExpression
            Me._TestExpressionPlaceholder = testExpressionPlaceholder
            Me._ElseExpression = elseExpression
            Me._ConstantValueOpt = constantValueOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _TestExpression As BoundExpression
        Public ReadOnly Property TestExpression As BoundExpression
            Get
                Return _TestExpression
            End Get
        End Property

        Private ReadOnly _ConvertedTestExpression As BoundExpression
        Public ReadOnly Property ConvertedTestExpression As BoundExpression
            Get
                Return _ConvertedTestExpression
            End Get
        End Property

        Private ReadOnly _TestExpressionPlaceholder As BoundRValuePlaceholder
        Public ReadOnly Property TestExpressionPlaceholder As BoundRValuePlaceholder
            Get
                Return _TestExpressionPlaceholder
            End Get
        End Property

        Private ReadOnly _ElseExpression As BoundExpression
        Public ReadOnly Property ElseExpression As BoundExpression
            Get
                Return _ElseExpression
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitBinaryConditionalExpression(Me)
        End Function

        Public Function Update(testExpression As BoundExpression, convertedTestExpression As BoundExpression, testExpressionPlaceholder As BoundRValuePlaceholder, elseExpression As BoundExpression, constantValueOpt As ConstantValue, type As TypeSymbol) As BoundBinaryConditionalExpression
            If testExpression IsNot Me.TestExpression OrElse convertedTestExpression IsNot Me.ConvertedTestExpression OrElse testExpressionPlaceholder IsNot Me.TestExpressionPlaceholder OrElse elseExpression IsNot Me.ElseExpression OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundBinaryConditionalExpression(Me.Syntax, testExpression, convertedTestExpression, testExpressionPlaceholder, elseExpression, constantValueOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundConversionOrCast
        Inherits BoundExpression

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol)
            MyBase.New(kind, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

    End Class

    Partial Friend NotInheritable Class BoundConversion
        Inherits BoundConversionOrCast

        Public Sub New(syntax As SyntaxNode, operand As BoundExpression, conversionKind As ConversionKind, checked As Boolean, explicitCastInCode As Boolean, constantValueOpt As ConstantValue, extendedInfoOpt As BoundExtendedConversionInfo, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Conversion, syntax, type, hasErrors OrElse operand.NonNullAndHasErrors() OrElse extendedInfoOpt.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Operand = operand
            Me._ConversionKind = conversionKind
            Me._Checked = checked
            Me._ExplicitCastInCode = explicitCastInCode
            Me._ConstantValueOpt = constantValueOpt
            Me._ExtendedInfoOpt = extendedInfoOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Operand As BoundExpression
        Public Overrides ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        Private ReadOnly _ConversionKind As ConversionKind
        Public Overrides ReadOnly Property ConversionKind As ConversionKind
            Get
                Return _ConversionKind
            End Get
        End Property

        Private ReadOnly _Checked As Boolean
        Public ReadOnly Property Checked As Boolean
            Get
                Return _Checked
            End Get
        End Property

        Private ReadOnly _ExplicitCastInCode As Boolean
        Public Overrides ReadOnly Property ExplicitCastInCode As Boolean
            Get
                Return _ExplicitCastInCode
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        Private ReadOnly _ExtendedInfoOpt As BoundExtendedConversionInfo
        Public ReadOnly Property ExtendedInfoOpt As BoundExtendedConversionInfo
            Get
                Return _ExtendedInfoOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitConversion(Me)
        End Function

        Public Function Update(operand As BoundExpression, conversionKind As ConversionKind, checked As Boolean, explicitCastInCode As Boolean, constantValueOpt As ConstantValue, extendedInfoOpt As BoundExtendedConversionInfo, type As TypeSymbol) As BoundConversion
            If operand IsNot Me.Operand OrElse conversionKind <> Me.ConversionKind OrElse checked <> Me.Checked OrElse explicitCastInCode <> Me.ExplicitCastInCode OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse extendedInfoOpt IsNot Me.ExtendedInfoOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundConversion(Me.Syntax, operand, conversionKind, checked, explicitCastInCode, constantValueOpt, extendedInfoOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundExtendedConversionInfo
        Inherits BoundNode

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, hasErrors As Boolean)
            MyBase.New(kind, syntax, hasErrors)
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode)
            MyBase.New(kind, syntax)
        End Sub

    End Class

    Partial Friend NotInheritable Class BoundRelaxationLambda
        Inherits BoundExtendedConversionInfo

        Public Sub New(syntax As SyntaxNode, lambda As BoundLambda, receiverPlaceholderOpt As BoundRValuePlaceholder, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RelaxationLambda, syntax, hasErrors OrElse lambda.NonNullAndHasErrors() OrElse receiverPlaceholderOpt.NonNullAndHasErrors())

            Debug.Assert(lambda IsNot Nothing, "Field 'lambda' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Lambda = lambda
            Me._ReceiverPlaceholderOpt = receiverPlaceholderOpt
        End Sub


        Private ReadOnly _Lambda As BoundLambda
        Public ReadOnly Property Lambda As BoundLambda
            Get
                Return _Lambda
            End Get
        End Property

        Private ReadOnly _ReceiverPlaceholderOpt As BoundRValuePlaceholder
        Public ReadOnly Property ReceiverPlaceholderOpt As BoundRValuePlaceholder
            Get
                Return _ReceiverPlaceholderOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRelaxationLambda(Me)
        End Function

        Public Function Update(lambda As BoundLambda, receiverPlaceholderOpt As BoundRValuePlaceholder) As BoundRelaxationLambda
            If lambda IsNot Me.Lambda OrElse receiverPlaceholderOpt IsNot Me.ReceiverPlaceholderOpt Then
                Dim result = New BoundRelaxationLambda(Me.Syntax, lambda, receiverPlaceholderOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundConvertedTupleElements
        Inherits BoundExtendedConversionInfo

        Public Sub New(syntax As SyntaxNode, elementPlaceholders As ImmutableArray(Of BoundRValuePlaceholder), convertedElements As ImmutableArray(Of BoundExpression), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ConvertedTupleElements, syntax, hasErrors OrElse elementPlaceholders.NonNullAndHasErrors() OrElse convertedElements.NonNullAndHasErrors())

            Debug.Assert(Not (elementPlaceholders.IsDefault), "Field 'elementPlaceholders' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (convertedElements.IsDefault), "Field 'convertedElements' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ElementPlaceholders = elementPlaceholders
            Me._ConvertedElements = convertedElements

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ElementPlaceholders As ImmutableArray(Of BoundRValuePlaceholder)
        Public ReadOnly Property ElementPlaceholders As ImmutableArray(Of BoundRValuePlaceholder)
            Get
                Return _ElementPlaceholders
            End Get
        End Property

        Private ReadOnly _ConvertedElements As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property ConvertedElements As ImmutableArray(Of BoundExpression)
            Get
                Return _ConvertedElements
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitConvertedTupleElements(Me)
        End Function

        Public Function Update(elementPlaceholders As ImmutableArray(Of BoundRValuePlaceholder), convertedElements As ImmutableArray(Of BoundExpression)) As BoundConvertedTupleElements
            If elementPlaceholders <> Me.ElementPlaceholders OrElse convertedElements <> Me.ConvertedElements Then
                Dim result = New BoundConvertedTupleElements(Me.Syntax, elementPlaceholders, convertedElements, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUserDefinedConversion
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, underlyingExpression As BoundExpression, inOutConversionFlags As Byte, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UserDefinedConversion, syntax, type, hasErrors OrElse underlyingExpression.NonNullAndHasErrors())

            Debug.Assert(underlyingExpression IsNot Nothing, "Field 'underlyingExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._UnderlyingExpression = underlyingExpression
            Me._InOutConversionFlags = inOutConversionFlags

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _UnderlyingExpression As BoundExpression
        Public ReadOnly Property UnderlyingExpression As BoundExpression
            Get
                Return _UnderlyingExpression
            End Get
        End Property

        Private ReadOnly _InOutConversionFlags As Byte
        Public ReadOnly Property InOutConversionFlags As Byte
            Get
                Return _InOutConversionFlags
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUserDefinedConversion(Me)
        End Function

        Public Function Update(underlyingExpression As BoundExpression, inOutConversionFlags As Byte, type As TypeSymbol) As BoundUserDefinedConversion
            If underlyingExpression IsNot Me.UnderlyingExpression OrElse inOutConversionFlags <> Me.InOutConversionFlags OrElse type IsNot Me.Type Then
                Dim result = New BoundUserDefinedConversion(Me.Syntax, underlyingExpression, inOutConversionFlags, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundDirectCast
        Inherits BoundConversionOrCast

        Public Sub New(syntax As SyntaxNode, operand As BoundExpression, conversionKind As ConversionKind, suppressVirtualCalls As Boolean, constantValueOpt As ConstantValue, relaxationLambdaOpt As BoundLambda, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.DirectCast, syntax, type, hasErrors OrElse operand.NonNullAndHasErrors() OrElse relaxationLambdaOpt.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Operand = operand
            Me._ConversionKind = conversionKind
            Me._SuppressVirtualCalls = suppressVirtualCalls
            Me._ConstantValueOpt = constantValueOpt
            Me._RelaxationLambdaOpt = relaxationLambdaOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Operand As BoundExpression
        Public Overrides ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        Private ReadOnly _ConversionKind As ConversionKind
        Public Overrides ReadOnly Property ConversionKind As ConversionKind
            Get
                Return _ConversionKind
            End Get
        End Property

        Private ReadOnly _SuppressVirtualCalls As Boolean
        Public Overrides ReadOnly Property SuppressVirtualCalls As Boolean
            Get
                Return _SuppressVirtualCalls
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        Private ReadOnly _RelaxationLambdaOpt As BoundLambda
        Public ReadOnly Property RelaxationLambdaOpt As BoundLambda
            Get
                Return _RelaxationLambdaOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitDirectCast(Me)
        End Function

        Public Function Update(operand As BoundExpression, conversionKind As ConversionKind, suppressVirtualCalls As Boolean, constantValueOpt As ConstantValue, relaxationLambdaOpt As BoundLambda, type As TypeSymbol) As BoundDirectCast
            If operand IsNot Me.Operand OrElse conversionKind <> Me.ConversionKind OrElse suppressVirtualCalls <> Me.SuppressVirtualCalls OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse relaxationLambdaOpt IsNot Me.RelaxationLambdaOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundDirectCast(Me.Syntax, operand, conversionKind, suppressVirtualCalls, constantValueOpt, relaxationLambdaOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundTryCast
        Inherits BoundConversionOrCast

        Public Sub New(syntax As SyntaxNode, operand As BoundExpression, conversionKind As ConversionKind, constantValueOpt As ConstantValue, relaxationLambdaOpt As BoundLambda, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.TryCast, syntax, type, hasErrors OrElse operand.NonNullAndHasErrors() OrElse relaxationLambdaOpt.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Operand = operand
            Me._ConversionKind = conversionKind
            Me._ConstantValueOpt = constantValueOpt
            Me._RelaxationLambdaOpt = relaxationLambdaOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Operand As BoundExpression
        Public Overrides ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        Private ReadOnly _ConversionKind As ConversionKind
        Public Overrides ReadOnly Property ConversionKind As ConversionKind
            Get
                Return _ConversionKind
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        Private ReadOnly _RelaxationLambdaOpt As BoundLambda
        Public ReadOnly Property RelaxationLambdaOpt As BoundLambda
            Get
                Return _RelaxationLambdaOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTryCast(Me)
        End Function

        Public Function Update(operand As BoundExpression, conversionKind As ConversionKind, constantValueOpt As ConstantValue, relaxationLambdaOpt As BoundLambda, type As TypeSymbol) As BoundTryCast
            If operand IsNot Me.Operand OrElse conversionKind <> Me.ConversionKind OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse relaxationLambdaOpt IsNot Me.RelaxationLambdaOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundTryCast(Me.Syntax, operand, conversionKind, constantValueOpt, relaxationLambdaOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundTypeOf
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, operand As BoundExpression, isTypeOfIsNotExpression As Boolean, targetType As TypeSymbol, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.TypeOf, syntax, type, hasErrors OrElse operand.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(targetType IsNot Nothing, "Field 'targetType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Operand = operand
            Me._IsTypeOfIsNotExpression = isTypeOfIsNotExpression
            Me._TargetType = targetType
        End Sub


        Private ReadOnly _Operand As BoundExpression
        Public ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        Private ReadOnly _IsTypeOfIsNotExpression As Boolean
        Public ReadOnly Property IsTypeOfIsNotExpression As Boolean
            Get
                Return _IsTypeOfIsNotExpression
            End Get
        End Property

        Private ReadOnly _TargetType As TypeSymbol
        Public ReadOnly Property TargetType As TypeSymbol
            Get
                Return _TargetType
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTypeOf(Me)
        End Function

        Public Function Update(operand As BoundExpression, isTypeOfIsNotExpression As Boolean, targetType As TypeSymbol, type As TypeSymbol) As BoundTypeOf
            If operand IsNot Me.Operand OrElse isTypeOfIsNotExpression <> Me.IsTypeOfIsNotExpression OrElse targetType IsNot Me.TargetType OrElse type IsNot Me.Type Then
                Dim result = New BoundTypeOf(Me.Syntax, operand, isTypeOfIsNotExpression, targetType, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundStatement
        Inherits BoundNode

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, hasErrors As Boolean)
            MyBase.New(kind, syntax, hasErrors)
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode)
            MyBase.New(kind, syntax)
        End Sub

    End Class

    Partial Friend NotInheritable Class BoundSequencePoint
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, statementOpt As BoundStatement, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.SequencePoint, syntax, hasErrors OrElse statementOpt.NonNullAndHasErrors())
            Me._StatementOpt = statementOpt
        End Sub


        Private ReadOnly _StatementOpt As BoundStatement
        Public ReadOnly Property StatementOpt As BoundStatement
            Get
                Return _StatementOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSequencePoint(Me)
        End Function

        Public Function Update(statementOpt As BoundStatement) As BoundSequencePoint
            If statementOpt IsNot Me.StatementOpt Then
                Dim result = New BoundSequencePoint(Me.Syntax, statementOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundSequencePointExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.SequencePointExpression, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSequencePointExpression(Me)
        End Function

        Public Function Update(expression As BoundExpression, type As TypeSymbol) As BoundSequencePointExpression
            If expression IsNot Me.Expression OrElse type IsNot Me.Type Then
                Dim result = New BoundSequencePointExpression(Me.Syntax, expression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundSequencePointWithSpan
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, statementOpt As BoundStatement, span As TextSpan, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.SequencePointWithSpan, syntax, hasErrors OrElse statementOpt.NonNullAndHasErrors())
            Me._StatementOpt = statementOpt
            Me._Span = span
        End Sub


        Private ReadOnly _StatementOpt As BoundStatement
        Public ReadOnly Property StatementOpt As BoundStatement
            Get
                Return _StatementOpt
            End Get
        End Property

        Private ReadOnly _Span As TextSpan
        Public ReadOnly Property Span As TextSpan
            Get
                Return _Span
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSequencePointWithSpan(Me)
        End Function

        Public Function Update(statementOpt As BoundStatement, span As TextSpan) As BoundSequencePointWithSpan
            If statementOpt IsNot Me.StatementOpt OrElse span <> Me.Span Then
                Dim result = New BoundSequencePointWithSpan(Me.Syntax, statementOpt, span, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundNoOpStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, flavor As NoOpStatementFlavor, hasErrors As Boolean)
            MyBase.New(BoundKind.NoOpStatement, syntax, hasErrors)
            Me._Flavor = flavor
        End Sub

        Public Sub New(syntax As SyntaxNode, flavor As NoOpStatementFlavor)
            MyBase.New(BoundKind.NoOpStatement, syntax)
            Me._Flavor = flavor
        End Sub


        Private ReadOnly _Flavor As NoOpStatementFlavor
        Public ReadOnly Property Flavor As NoOpStatementFlavor
            Get
                Return _Flavor
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitNoOpStatement(Me)
        End Function

        Public Function Update(flavor As NoOpStatementFlavor) As BoundNoOpStatement
            If flavor <> Me.Flavor Then
                Dim result = New BoundNoOpStatement(Me.Syntax, flavor, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundMethodOrPropertyGroup
        Inherits BoundExpression

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, receiverOpt As BoundExpression, qualificationKind As QualificationKind, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, Nothing, hasErrors)
            Me._ReceiverOpt = receiverOpt
            Me._QualificationKind = qualificationKind
        End Sub


        Private ReadOnly _ReceiverOpt As BoundExpression
        Public ReadOnly Property ReceiverOpt As BoundExpression
            Get
                Return _ReceiverOpt
            End Get
        End Property

        Private ReadOnly _QualificationKind As QualificationKind
        Public ReadOnly Property QualificationKind As QualificationKind
            Get
                Return _QualificationKind
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundMethodGroup
        Inherits BoundMethodOrPropertyGroup

        Public Sub New(syntax As SyntaxNode, typeArgumentsOpt As BoundTypeArguments, methods As ImmutableArray(Of MethodSymbol), pendingExtensionMethodsOpt As ExtensionMethodGroup, resultKind As LookupResultKind, receiverOpt As BoundExpression, qualificationKind As QualificationKind, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.MethodGroup, syntax, receiverOpt, qualificationKind, hasErrors OrElse typeArgumentsOpt.NonNullAndHasErrors() OrElse receiverOpt.NonNullAndHasErrors())

            Debug.Assert(Not (methods.IsDefault), "Field 'methods' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._TypeArgumentsOpt = typeArgumentsOpt
            Me._Methods = methods
            Me._PendingExtensionMethodsOpt = pendingExtensionMethodsOpt
            Me._ResultKind = resultKind
        End Sub


        Private ReadOnly _TypeArgumentsOpt As BoundTypeArguments
        Public ReadOnly Property TypeArgumentsOpt As BoundTypeArguments
            Get
                Return _TypeArgumentsOpt
            End Get
        End Property

        Private ReadOnly _Methods As ImmutableArray(Of MethodSymbol)
        Public ReadOnly Property Methods As ImmutableArray(Of MethodSymbol)
            Get
                Return _Methods
            End Get
        End Property

        Private ReadOnly _PendingExtensionMethodsOpt As ExtensionMethodGroup
        Public ReadOnly Property PendingExtensionMethodsOpt As ExtensionMethodGroup
            Get
                Return _PendingExtensionMethodsOpt
            End Get
        End Property

        Private ReadOnly _ResultKind As LookupResultKind
        Public Overrides ReadOnly Property ResultKind As LookupResultKind
            Get
                Return _ResultKind
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMethodGroup(Me)
        End Function

        Public Function Update(typeArgumentsOpt As BoundTypeArguments, methods As ImmutableArray(Of MethodSymbol), pendingExtensionMethodsOpt As ExtensionMethodGroup, resultKind As LookupResultKind, receiverOpt As BoundExpression, qualificationKind As QualificationKind) As BoundMethodGroup
            If typeArgumentsOpt IsNot Me.TypeArgumentsOpt OrElse methods <> Me.Methods OrElse pendingExtensionMethodsOpt IsNot Me.PendingExtensionMethodsOpt OrElse resultKind <> Me.ResultKind OrElse receiverOpt IsNot Me.ReceiverOpt OrElse qualificationKind <> Me.QualificationKind Then
                Dim result = New BoundMethodGroup(Me.Syntax, typeArgumentsOpt, methods, pendingExtensionMethodsOpt, resultKind, receiverOpt, qualificationKind, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundPropertyGroup
        Inherits BoundMethodOrPropertyGroup

        Public Sub New(syntax As SyntaxNode, properties As ImmutableArray(Of PropertySymbol), resultKind As LookupResultKind, receiverOpt As BoundExpression, qualificationKind As QualificationKind, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.PropertyGroup, syntax, receiverOpt, qualificationKind, hasErrors OrElse receiverOpt.NonNullAndHasErrors())

            Debug.Assert(Not (properties.IsDefault), "Field 'properties' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Properties = properties
            Me._ResultKind = resultKind
        End Sub


        Private ReadOnly _Properties As ImmutableArray(Of PropertySymbol)
        Public ReadOnly Property Properties As ImmutableArray(Of PropertySymbol)
            Get
                Return _Properties
            End Get
        End Property

        Private ReadOnly _ResultKind As LookupResultKind
        Public Overrides ReadOnly Property ResultKind As LookupResultKind
            Get
                Return _ResultKind
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitPropertyGroup(Me)
        End Function

        Public Function Update(properties As ImmutableArray(Of PropertySymbol), resultKind As LookupResultKind, receiverOpt As BoundExpression, qualificationKind As QualificationKind) As BoundPropertyGroup
            If properties <> Me.Properties OrElse resultKind <> Me.ResultKind OrElse receiverOpt IsNot Me.ReceiverOpt OrElse qualificationKind <> Me.QualificationKind Then
                Dim result = New BoundPropertyGroup(Me.Syntax, properties, resultKind, receiverOpt, qualificationKind, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundReturnStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, expressionOpt As BoundExpression, functionLocalOpt As LocalSymbol, exitLabelOpt As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ReturnStatement, syntax, hasErrors OrElse expressionOpt.NonNullAndHasErrors())
            Me._ExpressionOpt = expressionOpt
            Me._FunctionLocalOpt = functionLocalOpt
            Me._ExitLabelOpt = exitLabelOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ExpressionOpt As BoundExpression
        Public ReadOnly Property ExpressionOpt As BoundExpression
            Get
                Return _ExpressionOpt
            End Get
        End Property

        Private ReadOnly _FunctionLocalOpt As LocalSymbol
        Public ReadOnly Property FunctionLocalOpt As LocalSymbol
            Get
                Return _FunctionLocalOpt
            End Get
        End Property

        Private ReadOnly _ExitLabelOpt As LabelSymbol
        Public ReadOnly Property ExitLabelOpt As LabelSymbol
            Get
                Return _ExitLabelOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitReturnStatement(Me)
        End Function

        Public Function Update(expressionOpt As BoundExpression, functionLocalOpt As LocalSymbol, exitLabelOpt As LabelSymbol) As BoundReturnStatement
            If expressionOpt IsNot Me.ExpressionOpt OrElse functionLocalOpt IsNot Me.FunctionLocalOpt OrElse exitLabelOpt IsNot Me.ExitLabelOpt Then
                Dim result = New BoundReturnStatement(Me.Syntax, expressionOpt, functionLocalOpt, exitLabelOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundYieldStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.YieldStatement, syntax, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitYieldStatement(Me)
        End Function

        Public Function Update(expression As BoundExpression) As BoundYieldStatement
            If expression IsNot Me.Expression Then
                Dim result = New BoundYieldStatement(Me.Syntax, expression, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundThrowStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, expressionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ThrowStatement, syntax, hasErrors OrElse expressionOpt.NonNullAndHasErrors())
            Me._ExpressionOpt = expressionOpt
        End Sub


        Private ReadOnly _ExpressionOpt As BoundExpression
        Public ReadOnly Property ExpressionOpt As BoundExpression
            Get
                Return _ExpressionOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitThrowStatement(Me)
        End Function

        Public Function Update(expressionOpt As BoundExpression) As BoundThrowStatement
            If expressionOpt IsNot Me.ExpressionOpt Then
                Dim result = New BoundThrowStatement(Me.Syntax, expressionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRedimStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, clauses As ImmutableArray(Of BoundRedimClause), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RedimStatement, syntax, hasErrors OrElse clauses.NonNullAndHasErrors())

            Debug.Assert(Not (clauses.IsDefault), "Field 'clauses' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Clauses = clauses
        End Sub


        Private ReadOnly _Clauses As ImmutableArray(Of BoundRedimClause)
        Public ReadOnly Property Clauses As ImmutableArray(Of BoundRedimClause)
            Get
                Return _Clauses
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRedimStatement(Me)
        End Function

        Public Function Update(clauses As ImmutableArray(Of BoundRedimClause)) As BoundRedimStatement
            If clauses <> Me.Clauses Then
                Dim result = New BoundRedimStatement(Me.Syntax, clauses, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRedimClause
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, operand As BoundExpression, indices As ImmutableArray(Of BoundExpression), arrayTypeOpt As ArrayTypeSymbol, preserve As Boolean, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RedimClause, syntax, hasErrors OrElse operand.NonNullAndHasErrors() OrElse indices.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (indices.IsDefault), "Field 'indices' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Operand = operand
            Me._Indices = indices
            Me._ArrayTypeOpt = arrayTypeOpt
            Me._Preserve = preserve

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Operand As BoundExpression
        Public ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        Private ReadOnly _Indices As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Indices As ImmutableArray(Of BoundExpression)
            Get
                Return _Indices
            End Get
        End Property

        Private ReadOnly _ArrayTypeOpt As ArrayTypeSymbol
        Public ReadOnly Property ArrayTypeOpt As ArrayTypeSymbol
            Get
                Return _ArrayTypeOpt
            End Get
        End Property

        Private ReadOnly _Preserve As Boolean
        Public ReadOnly Property Preserve As Boolean
            Get
                Return _Preserve
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRedimClause(Me)
        End Function

        Public Function Update(operand As BoundExpression, indices As ImmutableArray(Of BoundExpression), arrayTypeOpt As ArrayTypeSymbol, preserve As Boolean) As BoundRedimClause
            If operand IsNot Me.Operand OrElse indices <> Me.Indices OrElse arrayTypeOpt IsNot Me.ArrayTypeOpt OrElse preserve <> Me.Preserve Then
                Dim result = New BoundRedimClause(Me.Syntax, operand, indices, arrayTypeOpt, preserve, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundEraseStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, clauses As ImmutableArray(Of BoundAssignmentOperator), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.EraseStatement, syntax, hasErrors OrElse clauses.NonNullAndHasErrors())

            Debug.Assert(Not (clauses.IsDefault), "Field 'clauses' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Clauses = clauses
        End Sub


        Private ReadOnly _Clauses As ImmutableArray(Of BoundAssignmentOperator)
        Public ReadOnly Property Clauses As ImmutableArray(Of BoundAssignmentOperator)
            Get
                Return _Clauses
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitEraseStatement(Me)
        End Function

        Public Function Update(clauses As ImmutableArray(Of BoundAssignmentOperator)) As BoundEraseStatement
            If clauses <> Me.Clauses Then
                Dim result = New BoundEraseStatement(Me.Syntax, clauses, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundCall
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, method As MethodSymbol, methodGroupOpt As BoundMethodGroup, receiverOpt As BoundExpression, arguments As ImmutableArray(Of BoundExpression), defaultArguments As BitVector, constantValueOpt As ConstantValue, isLValue As Boolean, suppressObjectClone As Boolean, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Call, syntax, type, hasErrors OrElse methodGroupOpt.NonNullAndHasErrors() OrElse receiverOpt.NonNullAndHasErrors() OrElse arguments.NonNullAndHasErrors())

            Debug.Assert(method IsNot Nothing, "Field 'method' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Method = method
            Me._MethodGroupOpt = methodGroupOpt
            Me._ReceiverOpt = receiverOpt
            Me._Arguments = arguments
            Me._DefaultArguments = defaultArguments
            Me._ConstantValueOpt = constantValueOpt
            Me._IsLValue = isLValue
            Me._SuppressObjectClone = suppressObjectClone

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Method As MethodSymbol
        Public ReadOnly Property Method As MethodSymbol
            Get
                Return _Method
            End Get
        End Property

        Private ReadOnly _MethodGroupOpt As BoundMethodGroup
        Public ReadOnly Property MethodGroupOpt As BoundMethodGroup
            Get
                Return _MethodGroupOpt
            End Get
        End Property

        Private ReadOnly _ReceiverOpt As BoundExpression
        Public ReadOnly Property ReceiverOpt As BoundExpression
            Get
                Return _ReceiverOpt
            End Get
        End Property

        Private ReadOnly _Arguments As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Arguments As ImmutableArray(Of BoundExpression)
            Get
                Return _Arguments
            End Get
        End Property

        Private ReadOnly _DefaultArguments As BitVector
        Public ReadOnly Property DefaultArguments As BitVector
            Get
                Return _DefaultArguments
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        Private ReadOnly _SuppressObjectClone As Boolean
        Public ReadOnly Property SuppressObjectClone As Boolean
            Get
                Return _SuppressObjectClone
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitCall(Me)
        End Function

        Public Function Update(method As MethodSymbol, methodGroupOpt As BoundMethodGroup, receiverOpt As BoundExpression, arguments As ImmutableArray(Of BoundExpression), defaultArguments As BitVector, constantValueOpt As ConstantValue, isLValue As Boolean, suppressObjectClone As Boolean, type As TypeSymbol) As BoundCall
            If method IsNot Me.Method OrElse methodGroupOpt IsNot Me.MethodGroupOpt OrElse receiverOpt IsNot Me.ReceiverOpt OrElse arguments <> Me.Arguments OrElse defaultArguments <> Me.DefaultArguments OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse isLValue <> Me.IsLValue OrElse suppressObjectClone <> Me.SuppressObjectClone OrElse type IsNot Me.Type Then
                Dim result = New BoundCall(Me.Syntax, method, methodGroupOpt, receiverOpt, arguments, defaultArguments, constantValueOpt, isLValue, suppressObjectClone, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAttribute
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, constructor As MethodSymbol, constructorArguments As ImmutableArray(Of BoundExpression), constructorDefaultArguments As BitVector, namedArguments As ImmutableArray(Of BoundExpression), resultKind As LookupResultKind, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Attribute, syntax, type, hasErrors OrElse constructorArguments.NonNullAndHasErrors() OrElse namedArguments.NonNullAndHasErrors())

            Debug.Assert(Not (constructorArguments.IsDefault), "Field 'constructorArguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (namedArguments.IsDefault), "Field 'namedArguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Constructor = constructor
            Me._ConstructorArguments = constructorArguments
            Me._ConstructorDefaultArguments = constructorDefaultArguments
            Me._NamedArguments = namedArguments
            Me._ResultKind = resultKind
        End Sub


        Private ReadOnly _Constructor As MethodSymbol
        Public ReadOnly Property Constructor As MethodSymbol
            Get
                Return _Constructor
            End Get
        End Property

        Private ReadOnly _ConstructorArguments As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property ConstructorArguments As ImmutableArray(Of BoundExpression)
            Get
                Return _ConstructorArguments
            End Get
        End Property

        Private ReadOnly _ConstructorDefaultArguments As BitVector
        Public ReadOnly Property ConstructorDefaultArguments As BitVector
            Get
                Return _ConstructorDefaultArguments
            End Get
        End Property

        Private ReadOnly _NamedArguments As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property NamedArguments As ImmutableArray(Of BoundExpression)
            Get
                Return _NamedArguments
            End Get
        End Property

        Private ReadOnly _ResultKind As LookupResultKind
        Public Overrides ReadOnly Property ResultKind As LookupResultKind
            Get
                Return _ResultKind
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAttribute(Me)
        End Function

        Public Function Update(constructor As MethodSymbol, constructorArguments As ImmutableArray(Of BoundExpression), constructorDefaultArguments As BitVector, namedArguments As ImmutableArray(Of BoundExpression), resultKind As LookupResultKind, type As TypeSymbol) As BoundAttribute
            If constructor IsNot Me.Constructor OrElse constructorArguments <> Me.ConstructorArguments OrElse constructorDefaultArguments <> Me.ConstructorDefaultArguments OrElse namedArguments <> Me.NamedArguments OrElse resultKind <> Me.ResultKind OrElse type IsNot Me.Type Then
                Dim result = New BoundAttribute(Me.Syntax, constructor, constructorArguments, constructorDefaultArguments, namedArguments, resultKind, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLateMemberAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, nameOpt As String, containerTypeOpt As TypeSymbol, receiverOpt As BoundExpression, typeArgumentsOpt As BoundTypeArguments, accessKind As LateBoundAccessKind, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.LateMemberAccess, syntax, type, hasErrors OrElse receiverOpt.NonNullAndHasErrors() OrElse typeArgumentsOpt.NonNullAndHasErrors())

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._NameOpt = nameOpt
            Me._ContainerTypeOpt = containerTypeOpt
            Me._ReceiverOpt = receiverOpt
            Me._TypeArgumentsOpt = typeArgumentsOpt
            Me._AccessKind = accessKind

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _NameOpt As String
        Public ReadOnly Property NameOpt As String
            Get
                Return _NameOpt
            End Get
        End Property

        Private ReadOnly _ContainerTypeOpt As TypeSymbol
        Public ReadOnly Property ContainerTypeOpt As TypeSymbol
            Get
                Return _ContainerTypeOpt
            End Get
        End Property

        Private ReadOnly _ReceiverOpt As BoundExpression
        Public ReadOnly Property ReceiverOpt As BoundExpression
            Get
                Return _ReceiverOpt
            End Get
        End Property

        Private ReadOnly _TypeArgumentsOpt As BoundTypeArguments
        Public ReadOnly Property TypeArgumentsOpt As BoundTypeArguments
            Get
                Return _TypeArgumentsOpt
            End Get
        End Property

        Private ReadOnly _AccessKind As LateBoundAccessKind
        Public ReadOnly Property AccessKind As LateBoundAccessKind
            Get
                Return _AccessKind
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLateMemberAccess(Me)
        End Function

        Public Function Update(nameOpt As String, containerTypeOpt As TypeSymbol, receiverOpt As BoundExpression, typeArgumentsOpt As BoundTypeArguments, accessKind As LateBoundAccessKind, type As TypeSymbol) As BoundLateMemberAccess
            If nameOpt IsNot Me.NameOpt OrElse containerTypeOpt IsNot Me.ContainerTypeOpt OrElse receiverOpt IsNot Me.ReceiverOpt OrElse typeArgumentsOpt IsNot Me.TypeArgumentsOpt OrElse accessKind <> Me.AccessKind OrElse type IsNot Me.Type Then
                Dim result = New BoundLateMemberAccess(Me.Syntax, nameOpt, containerTypeOpt, receiverOpt, typeArgumentsOpt, accessKind, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLateInvocation
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, member As BoundExpression, argumentsOpt As ImmutableArray(Of BoundExpression), argumentNamesOpt As ImmutableArray(Of string), accessKind As LateBoundAccessKind, methodOrPropertyGroupOpt As BoundMethodOrPropertyGroup, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.LateInvocation, syntax, type, hasErrors OrElse member.NonNullAndHasErrors() OrElse argumentsOpt.NonNullAndHasErrors() OrElse methodOrPropertyGroupOpt.NonNullAndHasErrors())

            Debug.Assert(member IsNot Nothing, "Field 'member' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Member = member
            Me._ArgumentsOpt = argumentsOpt
            Me._ArgumentNamesOpt = argumentNamesOpt
            Me._AccessKind = accessKind
            Me._MethodOrPropertyGroupOpt = methodOrPropertyGroupOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Member As BoundExpression
        Public ReadOnly Property Member As BoundExpression
            Get
                Return _Member
            End Get
        End Property

        Private ReadOnly _ArgumentsOpt As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property ArgumentsOpt As ImmutableArray(Of BoundExpression)
            Get
                Return _ArgumentsOpt
            End Get
        End Property

        Private ReadOnly _ArgumentNamesOpt As ImmutableArray(Of string)
        Public ReadOnly Property ArgumentNamesOpt As ImmutableArray(Of string)
            Get
                Return _ArgumentNamesOpt
            End Get
        End Property

        Private ReadOnly _AccessKind As LateBoundAccessKind
        Public ReadOnly Property AccessKind As LateBoundAccessKind
            Get
                Return _AccessKind
            End Get
        End Property

        Private ReadOnly _MethodOrPropertyGroupOpt As BoundMethodOrPropertyGroup
        Public ReadOnly Property MethodOrPropertyGroupOpt As BoundMethodOrPropertyGroup
            Get
                Return _MethodOrPropertyGroupOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLateInvocation(Me)
        End Function

        Public Function Update(member As BoundExpression, argumentsOpt As ImmutableArray(Of BoundExpression), argumentNamesOpt As ImmutableArray(Of string), accessKind As LateBoundAccessKind, methodOrPropertyGroupOpt As BoundMethodOrPropertyGroup, type As TypeSymbol) As BoundLateInvocation
            If member IsNot Me.Member OrElse argumentsOpt <> Me.ArgumentsOpt OrElse argumentNamesOpt <> Me.ArgumentNamesOpt OrElse accessKind <> Me.AccessKind OrElse methodOrPropertyGroupOpt IsNot Me.MethodOrPropertyGroupOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundLateInvocation(Me.Syntax, member, argumentsOpt, argumentNamesOpt, accessKind, methodOrPropertyGroupOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLateAddressOfOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, binder As Binder, memberAccess As BoundLateMemberAccess, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.LateAddressOfOperator, syntax, type, hasErrors OrElse memberAccess.NonNullAndHasErrors())

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(memberAccess IsNot Nothing, "Field 'memberAccess' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._MemberAccess = memberAccess
        End Sub


        Private ReadOnly _Binder As Binder
        Public ReadOnly Property Binder As Binder
            Get
                Return _Binder
            End Get
        End Property

        Private ReadOnly _MemberAccess As BoundLateMemberAccess
        Public ReadOnly Property MemberAccess As BoundLateMemberAccess
            Get
                Return _MemberAccess
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLateAddressOfOperator(Me)
        End Function

        Public Function Update(binder As Binder, memberAccess As BoundLateMemberAccess, type As TypeSymbol) As BoundLateAddressOfOperator
            If binder IsNot Me.Binder OrElse memberAccess IsNot Me.MemberAccess OrElse type IsNot Me.Type Then
                Dim result = New BoundLateAddressOfOperator(Me.Syntax, binder, memberAccess, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundTupleExpression
        Inherits BoundExpression

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, arguments As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Arguments = arguments
        End Sub


        Private ReadOnly _Arguments As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Arguments As ImmutableArray(Of BoundExpression)
            Get
                Return _Arguments
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundTupleLiteral
        Inherits BoundTupleExpression

        Public Sub New(syntax As SyntaxNode, inferredType As TupleTypeSymbol, argumentNamesOpt As ImmutableArray(Of String), inferredNamesOpt As ImmutableArray(Of Boolean), arguments As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.TupleLiteral, syntax, arguments, type, hasErrors OrElse arguments.NonNullAndHasErrors())

            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._InferredType = inferredType
            Me._ArgumentNamesOpt = argumentNamesOpt
            Me._InferredNamesOpt = inferredNamesOpt
        End Sub


        Private ReadOnly _InferredType As TupleTypeSymbol
        Public ReadOnly Property InferredType As TupleTypeSymbol
            Get
                Return _InferredType
            End Get
        End Property

        Private ReadOnly _ArgumentNamesOpt As ImmutableArray(Of String)
        Public ReadOnly Property ArgumentNamesOpt As ImmutableArray(Of String)
            Get
                Return _ArgumentNamesOpt
            End Get
        End Property

        Private ReadOnly _InferredNamesOpt As ImmutableArray(Of Boolean)
        Public ReadOnly Property InferredNamesOpt As ImmutableArray(Of Boolean)
            Get
                Return _InferredNamesOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTupleLiteral(Me)
        End Function

        Public Function Update(inferredType As TupleTypeSymbol, argumentNamesOpt As ImmutableArray(Of String), inferredNamesOpt As ImmutableArray(Of Boolean), arguments As ImmutableArray(Of BoundExpression), type As TypeSymbol) As BoundTupleLiteral
            If inferredType IsNot Me.InferredType OrElse argumentNamesOpt <> Me.ArgumentNamesOpt OrElse inferredNamesOpt <> Me.InferredNamesOpt OrElse arguments <> Me.Arguments OrElse type IsNot Me.Type Then
                Dim result = New BoundTupleLiteral(Me.Syntax, inferredType, argumentNamesOpt, inferredNamesOpt, arguments, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundConvertedTupleLiteral
        Inherits BoundTupleExpression

        Public Sub New(syntax As SyntaxNode, naturalTypeOpt As TypeSymbol, arguments As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ConvertedTupleLiteral, syntax, arguments, type, hasErrors OrElse arguments.NonNullAndHasErrors())

            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._NaturalTypeOpt = naturalTypeOpt
        End Sub


        Private ReadOnly _NaturalTypeOpt As TypeSymbol
        Public ReadOnly Property NaturalTypeOpt As TypeSymbol
            Get
                Return _NaturalTypeOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitConvertedTupleLiteral(Me)
        End Function

        Public Function Update(naturalTypeOpt As TypeSymbol, arguments As ImmutableArray(Of BoundExpression), type As TypeSymbol) As BoundConvertedTupleLiteral
            If naturalTypeOpt IsNot Me.NaturalTypeOpt OrElse arguments <> Me.Arguments OrElse type IsNot Me.Type Then
                Dim result = New BoundConvertedTupleLiteral(Me.Syntax, naturalTypeOpt, arguments, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundObjectCreationExpressionBase
        Inherits BoundExpression

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, initializerOpt As BoundObjectInitializerExpressionBase, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._InitializerOpt = initializerOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _InitializerOpt As BoundObjectInitializerExpressionBase
        Public ReadOnly Property InitializerOpt As BoundObjectInitializerExpressionBase
            Get
                Return _InitializerOpt
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundObjectCreationExpression
        Inherits BoundObjectCreationExpressionBase

        Public Sub New(syntax As SyntaxNode, constructorOpt As MethodSymbol, methodGroupOpt As BoundMethodGroup, arguments As ImmutableArray(Of BoundExpression), defaultArguments As BitVector, initializerOpt As BoundObjectInitializerExpressionBase, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ObjectCreationExpression, syntax, initializerOpt, type, hasErrors OrElse methodGroupOpt.NonNullAndHasErrors() OrElse arguments.NonNullAndHasErrors() OrElse initializerOpt.NonNullAndHasErrors())

            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ConstructorOpt = constructorOpt
            Me._MethodGroupOpt = methodGroupOpt
            Me._Arguments = arguments
            Me._DefaultArguments = defaultArguments

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ConstructorOpt As MethodSymbol
        Public ReadOnly Property ConstructorOpt As MethodSymbol
            Get
                Return _ConstructorOpt
            End Get
        End Property

        Private ReadOnly _MethodGroupOpt As BoundMethodGroup
        Public ReadOnly Property MethodGroupOpt As BoundMethodGroup
            Get
                Return _MethodGroupOpt
            End Get
        End Property

        Private ReadOnly _Arguments As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Arguments As ImmutableArray(Of BoundExpression)
            Get
                Return _Arguments
            End Get
        End Property

        Private ReadOnly _DefaultArguments As BitVector
        Public ReadOnly Property DefaultArguments As BitVector
            Get
                Return _DefaultArguments
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitObjectCreationExpression(Me)
        End Function

        Public Function Update(constructorOpt As MethodSymbol, methodGroupOpt As BoundMethodGroup, arguments As ImmutableArray(Of BoundExpression), defaultArguments As BitVector, initializerOpt As BoundObjectInitializerExpressionBase, type As TypeSymbol) As BoundObjectCreationExpression
            If constructorOpt IsNot Me.ConstructorOpt OrElse methodGroupOpt IsNot Me.MethodGroupOpt OrElse arguments <> Me.Arguments OrElse defaultArguments <> Me.DefaultArguments OrElse initializerOpt IsNot Me.InitializerOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundObjectCreationExpression(Me.Syntax, constructorOpt, methodGroupOpt, arguments, defaultArguments, initializerOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundNoPiaObjectCreationExpression
        Inherits BoundObjectCreationExpressionBase

        Public Sub New(syntax As SyntaxNode, guidString As string, initializerOpt As BoundObjectInitializerExpressionBase, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.NoPiaObjectCreationExpression, syntax, initializerOpt, type, hasErrors OrElse initializerOpt.NonNullAndHasErrors())

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._GuidString = guidString
        End Sub


        Private ReadOnly _GuidString As string
        Public ReadOnly Property GuidString As string
            Get
                Return _GuidString
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitNoPiaObjectCreationExpression(Me)
        End Function

        Public Function Update(guidString As string, initializerOpt As BoundObjectInitializerExpressionBase, type As TypeSymbol) As BoundNoPiaObjectCreationExpression
            If guidString IsNot Me.GuidString OrElse initializerOpt IsNot Me.InitializerOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundNoPiaObjectCreationExpression(Me.Syntax, guidString, initializerOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAnonymousTypeCreationExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, binderOpt As Binder.AnonymousTypeCreationBinder, declarations As ImmutableArray(Of BoundAnonymousTypePropertyAccess), arguments As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AnonymousTypeCreationExpression, syntax, type, hasErrors OrElse declarations.NonNullAndHasErrors() OrElse arguments.NonNullAndHasErrors())

            Debug.Assert(Not (declarations.IsDefault), "Field 'declarations' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._BinderOpt = binderOpt
            Me._Declarations = declarations
            Me._Arguments = arguments
        End Sub


        Private ReadOnly _BinderOpt As Binder.AnonymousTypeCreationBinder
        Public ReadOnly Property BinderOpt As Binder.AnonymousTypeCreationBinder
            Get
                Return _BinderOpt
            End Get
        End Property

        Private ReadOnly _Declarations As ImmutableArray(Of BoundAnonymousTypePropertyAccess)
        Public ReadOnly Property Declarations As ImmutableArray(Of BoundAnonymousTypePropertyAccess)
            Get
                Return _Declarations
            End Get
        End Property

        Private ReadOnly _Arguments As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Arguments As ImmutableArray(Of BoundExpression)
            Get
                Return _Arguments
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAnonymousTypeCreationExpression(Me)
        End Function

        Public Function Update(binderOpt As Binder.AnonymousTypeCreationBinder, declarations As ImmutableArray(Of BoundAnonymousTypePropertyAccess), arguments As ImmutableArray(Of BoundExpression), type As TypeSymbol) As BoundAnonymousTypeCreationExpression
            If binderOpt IsNot Me.BinderOpt OrElse declarations <> Me.Declarations OrElse arguments <> Me.Arguments OrElse type IsNot Me.Type Then
                Dim result = New BoundAnonymousTypeCreationExpression(Me.Syntax, binderOpt, declarations, arguments, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAnonymousTypePropertyAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, binder As Binder.AnonymousTypeCreationBinder, propertyIndex As Integer, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.AnonymousTypePropertyAccess, syntax, type, hasErrors)

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._PropertyIndex = propertyIndex
        End Sub

        Public Sub New(syntax As SyntaxNode, binder As Binder.AnonymousTypeCreationBinder, propertyIndex As Integer, type As TypeSymbol)
            MyBase.New(BoundKind.AnonymousTypePropertyAccess, syntax, type)

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._PropertyIndex = propertyIndex
        End Sub


        Private ReadOnly _Binder As Binder.AnonymousTypeCreationBinder
        Public ReadOnly Property Binder As Binder.AnonymousTypeCreationBinder
            Get
                Return _Binder
            End Get
        End Property

        Private ReadOnly _PropertyIndex As Integer
        Public ReadOnly Property PropertyIndex As Integer
            Get
                Return _PropertyIndex
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAnonymousTypePropertyAccess(Me)
        End Function

        Public Function Update(binder As Binder.AnonymousTypeCreationBinder, propertyIndex As Integer, type As TypeSymbol) As BoundAnonymousTypePropertyAccess
            If binder IsNot Me.Binder OrElse propertyIndex <> Me.PropertyIndex OrElse type IsNot Me.Type Then
                Dim result = New BoundAnonymousTypePropertyAccess(Me.Syntax, binder, propertyIndex, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAnonymousTypeFieldInitializer
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, binder As Binder.AnonymousTypeFieldInitializerBinder, value As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AnonymousTypeFieldInitializer, syntax, type, hasErrors OrElse value.NonNullAndHasErrors())

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._Value = value
        End Sub


        Private ReadOnly _Binder As Binder.AnonymousTypeFieldInitializerBinder
        Public ReadOnly Property Binder As Binder.AnonymousTypeFieldInitializerBinder
            Get
                Return _Binder
            End Get
        End Property

        Private ReadOnly _Value As BoundExpression
        Public ReadOnly Property Value As BoundExpression
            Get
                Return _Value
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAnonymousTypeFieldInitializer(Me)
        End Function

        Public Function Update(binder As Binder.AnonymousTypeFieldInitializerBinder, value As BoundExpression, type As TypeSymbol) As BoundAnonymousTypeFieldInitializer
            If binder IsNot Me.Binder OrElse value IsNot Me.Value OrElse type IsNot Me.Type Then
                Dim result = New BoundAnonymousTypeFieldInitializer(Me.Syntax, binder, value, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundObjectInitializerExpressionBase
        Inherits BoundExpression

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, placeholderOpt As BoundWithLValueExpressionPlaceholder, initializers As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(Not (initializers.IsDefault), "Field 'initializers' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._PlaceholderOpt = placeholderOpt
            Me._Initializers = initializers
        End Sub


        Private ReadOnly _PlaceholderOpt As BoundWithLValueExpressionPlaceholder
        Public ReadOnly Property PlaceholderOpt As BoundWithLValueExpressionPlaceholder
            Get
                Return _PlaceholderOpt
            End Get
        End Property

        Private ReadOnly _Initializers As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Initializers As ImmutableArray(Of BoundExpression)
            Get
                Return _Initializers
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundObjectInitializerExpression
        Inherits BoundObjectInitializerExpressionBase

        Public Sub New(syntax As SyntaxNode, createTemporaryLocalForInitialization As Boolean, placeholderOpt As BoundWithLValueExpressionPlaceholder, initializers As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ObjectInitializerExpression, syntax, placeholderOpt, initializers, type, hasErrors OrElse placeholderOpt.NonNullAndHasErrors() OrElse initializers.NonNullAndHasErrors())

            Debug.Assert(Not (initializers.IsDefault), "Field 'initializers' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._CreateTemporaryLocalForInitialization = createTemporaryLocalForInitialization

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _CreateTemporaryLocalForInitialization As Boolean
        Public ReadOnly Property CreateTemporaryLocalForInitialization As Boolean
            Get
                Return _CreateTemporaryLocalForInitialization
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitObjectInitializerExpression(Me)
        End Function

        Public Function Update(createTemporaryLocalForInitialization As Boolean, placeholderOpt As BoundWithLValueExpressionPlaceholder, initializers As ImmutableArray(Of BoundExpression), type As TypeSymbol) As BoundObjectInitializerExpression
            If createTemporaryLocalForInitialization <> Me.CreateTemporaryLocalForInitialization OrElse placeholderOpt IsNot Me.PlaceholderOpt OrElse initializers <> Me.Initializers OrElse type IsNot Me.Type Then
                Dim result = New BoundObjectInitializerExpression(Me.Syntax, createTemporaryLocalForInitialization, placeholderOpt, initializers, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundCollectionInitializerExpression
        Inherits BoundObjectInitializerExpressionBase

        Public Sub New(syntax As SyntaxNode, placeholderOpt As BoundWithLValueExpressionPlaceholder, initializers As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.CollectionInitializerExpression, syntax, placeholderOpt, initializers, type, hasErrors OrElse placeholderOpt.NonNullAndHasErrors() OrElse initializers.NonNullAndHasErrors())

            Debug.Assert(Not (initializers.IsDefault), "Field 'initializers' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitCollectionInitializerExpression(Me)
        End Function

        Public Function Update(placeholderOpt As BoundWithLValueExpressionPlaceholder, initializers As ImmutableArray(Of BoundExpression), type As TypeSymbol) As BoundCollectionInitializerExpression
            If placeholderOpt IsNot Me.PlaceholderOpt OrElse initializers <> Me.Initializers OrElse type IsNot Me.Type Then
                Dim result = New BoundCollectionInitializerExpression(Me.Syntax, placeholderOpt, initializers, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundNewT
        Inherits BoundObjectCreationExpressionBase

        Public Sub New(syntax As SyntaxNode, initializerOpt As BoundObjectInitializerExpressionBase, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.NewT, syntax, initializerOpt, type, hasErrors OrElse initializerOpt.NonNullAndHasErrors())

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitNewT(Me)
        End Function

        Public Function Update(initializerOpt As BoundObjectInitializerExpressionBase, type As TypeSymbol) As BoundNewT
            If initializerOpt IsNot Me.InitializerOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundNewT(Me.Syntax, initializerOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundDelegateCreationExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, receiverOpt As BoundExpression, method As MethodSymbol, relaxationLambdaOpt As BoundLambda, relaxationReceiverPlaceholderOpt As BoundRValuePlaceholder, methodGroupOpt As BoundMethodGroup, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.DelegateCreationExpression, syntax, type, hasErrors OrElse receiverOpt.NonNullAndHasErrors() OrElse relaxationLambdaOpt.NonNullAndHasErrors() OrElse relaxationReceiverPlaceholderOpt.NonNullAndHasErrors() OrElse methodGroupOpt.NonNullAndHasErrors())

            Debug.Assert(method IsNot Nothing, "Field 'method' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ReceiverOpt = receiverOpt
            Me._Method = method
            Me._RelaxationLambdaOpt = relaxationLambdaOpt
            Me._RelaxationReceiverPlaceholderOpt = relaxationReceiverPlaceholderOpt
            Me._MethodGroupOpt = methodGroupOpt
        End Sub


        Private ReadOnly _ReceiverOpt As BoundExpression
        Public ReadOnly Property ReceiverOpt As BoundExpression
            Get
                Return _ReceiverOpt
            End Get
        End Property

        Private ReadOnly _Method As MethodSymbol
        Public ReadOnly Property Method As MethodSymbol
            Get
                Return _Method
            End Get
        End Property

        Private ReadOnly _RelaxationLambdaOpt As BoundLambda
        Public ReadOnly Property RelaxationLambdaOpt As BoundLambda
            Get
                Return _RelaxationLambdaOpt
            End Get
        End Property

        Private ReadOnly _RelaxationReceiverPlaceholderOpt As BoundRValuePlaceholder
        Public ReadOnly Property RelaxationReceiverPlaceholderOpt As BoundRValuePlaceholder
            Get
                Return _RelaxationReceiverPlaceholderOpt
            End Get
        End Property

        Private ReadOnly _MethodGroupOpt As BoundMethodGroup
        Public ReadOnly Property MethodGroupOpt As BoundMethodGroup
            Get
                Return _MethodGroupOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitDelegateCreationExpression(Me)
        End Function

        Public Function Update(receiverOpt As BoundExpression, method As MethodSymbol, relaxationLambdaOpt As BoundLambda, relaxationReceiverPlaceholderOpt As BoundRValuePlaceholder, methodGroupOpt As BoundMethodGroup, type As TypeSymbol) As BoundDelegateCreationExpression
            If receiverOpt IsNot Me.ReceiverOpt OrElse method IsNot Me.Method OrElse relaxationLambdaOpt IsNot Me.RelaxationLambdaOpt OrElse relaxationReceiverPlaceholderOpt IsNot Me.RelaxationReceiverPlaceholderOpt OrElse methodGroupOpt IsNot Me.MethodGroupOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundDelegateCreationExpression(Me.Syntax, receiverOpt, method, relaxationLambdaOpt, relaxationReceiverPlaceholderOpt, methodGroupOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundArrayCreation
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, isParamArrayArgument As Boolean, bounds As ImmutableArray(Of BoundExpression), initializerOpt As BoundArrayInitialization, arrayLiteralOpt As BoundArrayLiteral, arrayLiteralConversion As ConversionKind, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ArrayCreation, syntax, type, hasErrors OrElse bounds.NonNullAndHasErrors() OrElse initializerOpt.NonNullAndHasErrors() OrElse arrayLiteralOpt.NonNullAndHasErrors())

            Debug.Assert(Not (bounds.IsDefault), "Field 'bounds' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._IsParamArrayArgument = isParamArrayArgument
            Me._Bounds = bounds
            Me._InitializerOpt = initializerOpt
            Me._ArrayLiteralOpt = arrayLiteralOpt
            Me._ArrayLiteralConversion = arrayLiteralConversion

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _IsParamArrayArgument As Boolean
        Public ReadOnly Property IsParamArrayArgument As Boolean
            Get
                Return _IsParamArrayArgument
            End Get
        End Property

        Private ReadOnly _Bounds As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Bounds As ImmutableArray(Of BoundExpression)
            Get
                Return _Bounds
            End Get
        End Property

        Private ReadOnly _InitializerOpt As BoundArrayInitialization
        Public ReadOnly Property InitializerOpt As BoundArrayInitialization
            Get
                Return _InitializerOpt
            End Get
        End Property

        Private ReadOnly _ArrayLiteralOpt As BoundArrayLiteral
        Public ReadOnly Property ArrayLiteralOpt As BoundArrayLiteral
            Get
                Return _ArrayLiteralOpt
            End Get
        End Property

        Private ReadOnly _ArrayLiteralConversion As ConversionKind
        Public ReadOnly Property ArrayLiteralConversion As ConversionKind
            Get
                Return _ArrayLiteralConversion
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitArrayCreation(Me)
        End Function

        Public Function Update(isParamArrayArgument As Boolean, bounds As ImmutableArray(Of BoundExpression), initializerOpt As BoundArrayInitialization, arrayLiteralOpt As BoundArrayLiteral, arrayLiteralConversion As ConversionKind, type As TypeSymbol) As BoundArrayCreation
            If isParamArrayArgument <> Me.IsParamArrayArgument OrElse bounds <> Me.Bounds OrElse initializerOpt IsNot Me.InitializerOpt OrElse arrayLiteralOpt IsNot Me.ArrayLiteralOpt OrElse arrayLiteralConversion <> Me.ArrayLiteralConversion OrElse type IsNot Me.Type Then
                Dim result = New BoundArrayCreation(Me.Syntax, isParamArrayArgument, bounds, initializerOpt, arrayLiteralOpt, arrayLiteralConversion, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundArrayLiteral
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, hasDominantType As Boolean, numberOfCandidates As Integer, inferredType As ArrayTypeSymbol, bounds As ImmutableArray(Of BoundExpression), initializer As BoundArrayInitialization, binder As Binder, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ArrayLiteral, syntax, Nothing, hasErrors OrElse bounds.NonNullAndHasErrors() OrElse initializer.NonNullAndHasErrors())

            Debug.Assert(inferredType IsNot Nothing, "Field 'inferredType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (bounds.IsDefault), "Field 'bounds' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(initializer IsNot Nothing, "Field 'initializer' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._HasDominantType = hasDominantType
            Me._NumberOfCandidates = numberOfCandidates
            Me._InferredType = inferredType
            Me._Bounds = bounds
            Me._Initializer = initializer
            Me._Binder = binder
        End Sub


        Private ReadOnly _HasDominantType As Boolean
        Public ReadOnly Property HasDominantType As Boolean
            Get
                Return _HasDominantType
            End Get
        End Property

        Private ReadOnly _NumberOfCandidates As Integer
        Public ReadOnly Property NumberOfCandidates As Integer
            Get
                Return _NumberOfCandidates
            End Get
        End Property

        Private ReadOnly _InferredType As ArrayTypeSymbol
        Public ReadOnly Property InferredType As ArrayTypeSymbol
            Get
                Return _InferredType
            End Get
        End Property

        Private ReadOnly _Bounds As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Bounds As ImmutableArray(Of BoundExpression)
            Get
                Return _Bounds
            End Get
        End Property

        Private ReadOnly _Initializer As BoundArrayInitialization
        Public ReadOnly Property Initializer As BoundArrayInitialization
            Get
                Return _Initializer
            End Get
        End Property

        Private ReadOnly _Binder As Binder
        Public ReadOnly Property Binder As Binder
            Get
                Return _Binder
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitArrayLiteral(Me)
        End Function

        Public Function Update(hasDominantType As Boolean, numberOfCandidates As Integer, inferredType As ArrayTypeSymbol, bounds As ImmutableArray(Of BoundExpression), initializer As BoundArrayInitialization, binder As Binder) As BoundArrayLiteral
            If hasDominantType <> Me.HasDominantType OrElse numberOfCandidates <> Me.NumberOfCandidates OrElse inferredType IsNot Me.InferredType OrElse bounds <> Me.Bounds OrElse initializer IsNot Me.Initializer OrElse binder IsNot Me.Binder Then
                Dim result = New BoundArrayLiteral(Me.Syntax, hasDominantType, numberOfCandidates, inferredType, bounds, initializer, binder, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundArrayInitialization
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, initializers As ImmutableArray(Of BoundExpression), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ArrayInitialization, syntax, type, hasErrors OrElse initializers.NonNullAndHasErrors())

            Debug.Assert(Not (initializers.IsDefault), "Field 'initializers' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Initializers = initializers
        End Sub


        Private ReadOnly _Initializers As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Initializers As ImmutableArray(Of BoundExpression)
            Get
                Return _Initializers
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitArrayInitialization(Me)
        End Function

        Public Function Update(initializers As ImmutableArray(Of BoundExpression), type As TypeSymbol) As BoundArrayInitialization
            If initializers <> Me.Initializers OrElse type IsNot Me.Type Then
                Dim result = New BoundArrayInitialization(Me.Syntax, initializers, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundFieldAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, receiverOpt As BoundExpression, fieldSymbol As FieldSymbol, isLValue As Boolean, suppressVirtualCalls As Boolean, constantsInProgressOpt As ConstantFieldsInProgress, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.FieldAccess, syntax, type, hasErrors OrElse receiverOpt.NonNullAndHasErrors())

            Debug.Assert(fieldSymbol IsNot Nothing, "Field 'fieldSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ReceiverOpt = receiverOpt
            Me._FieldSymbol = fieldSymbol
            Me._IsLValue = isLValue
            Me._SuppressVirtualCalls = suppressVirtualCalls
            Me._ConstantsInProgressOpt = constantsInProgressOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ReceiverOpt As BoundExpression
        Public ReadOnly Property ReceiverOpt As BoundExpression
            Get
                Return _ReceiverOpt
            End Get
        End Property

        Private ReadOnly _FieldSymbol As FieldSymbol
        Public ReadOnly Property FieldSymbol As FieldSymbol
            Get
                Return _FieldSymbol
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        Private ReadOnly _SuppressVirtualCalls As Boolean
        Public Overrides ReadOnly Property SuppressVirtualCalls As Boolean
            Get
                Return _SuppressVirtualCalls
            End Get
        End Property

        Private ReadOnly _ConstantsInProgressOpt As ConstantFieldsInProgress
        Public ReadOnly Property ConstantsInProgressOpt As ConstantFieldsInProgress
            Get
                Return _ConstantsInProgressOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitFieldAccess(Me)
        End Function

        Public Function Update(receiverOpt As BoundExpression, fieldSymbol As FieldSymbol, isLValue As Boolean, suppressVirtualCalls As Boolean, constantsInProgressOpt As ConstantFieldsInProgress, type As TypeSymbol) As BoundFieldAccess
            If receiverOpt IsNot Me.ReceiverOpt OrElse fieldSymbol IsNot Me.FieldSymbol OrElse isLValue <> Me.IsLValue OrElse suppressVirtualCalls <> Me.SuppressVirtualCalls OrElse constantsInProgressOpt IsNot Me.ConstantsInProgressOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundFieldAccess(Me.Syntax, receiverOpt, fieldSymbol, isLValue, suppressVirtualCalls, constantsInProgressOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundPropertyAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, propertySymbol As PropertySymbol, propertyGroupOpt As BoundPropertyGroup, accessKind As PropertyAccessKind, isWriteable As Boolean, isLValue As Boolean, receiverOpt As BoundExpression, arguments As ImmutableArray(Of BoundExpression), defaultArguments As BitVector, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.PropertyAccess, syntax, type, hasErrors OrElse propertyGroupOpt.NonNullAndHasErrors() OrElse receiverOpt.NonNullAndHasErrors() OrElse arguments.NonNullAndHasErrors())

            Debug.Assert(propertySymbol IsNot Nothing, "Field 'propertySymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (arguments.IsDefault), "Field 'arguments' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._PropertySymbol = propertySymbol
            Me._PropertyGroupOpt = propertyGroupOpt
            Me._AccessKind = accessKind
            Me._IsWriteable = isWriteable
            Me._IsLValue = isLValue
            Me._ReceiverOpt = receiverOpt
            Me._Arguments = arguments
            Me._DefaultArguments = defaultArguments

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _PropertySymbol As PropertySymbol
        Public ReadOnly Property PropertySymbol As PropertySymbol
            Get
                Return _PropertySymbol
            End Get
        End Property

        Private ReadOnly _PropertyGroupOpt As BoundPropertyGroup
        Public ReadOnly Property PropertyGroupOpt As BoundPropertyGroup
            Get
                Return _PropertyGroupOpt
            End Get
        End Property

        Private ReadOnly _AccessKind As PropertyAccessKind
        Public ReadOnly Property AccessKind As PropertyAccessKind
            Get
                Return _AccessKind
            End Get
        End Property

        Private ReadOnly _IsWriteable As Boolean
        Public ReadOnly Property IsWriteable As Boolean
            Get
                Return _IsWriteable
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        Private ReadOnly _ReceiverOpt As BoundExpression
        Public ReadOnly Property ReceiverOpt As BoundExpression
            Get
                Return _ReceiverOpt
            End Get
        End Property

        Private ReadOnly _Arguments As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property Arguments As ImmutableArray(Of BoundExpression)
            Get
                Return _Arguments
            End Get
        End Property

        Private ReadOnly _DefaultArguments As BitVector
        Public ReadOnly Property DefaultArguments As BitVector
            Get
                Return _DefaultArguments
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitPropertyAccess(Me)
        End Function

        Public Function Update(propertySymbol As PropertySymbol, propertyGroupOpt As BoundPropertyGroup, accessKind As PropertyAccessKind, isWriteable As Boolean, isLValue As Boolean, receiverOpt As BoundExpression, arguments As ImmutableArray(Of BoundExpression), defaultArguments As BitVector, type As TypeSymbol) As BoundPropertyAccess
            If propertySymbol IsNot Me.PropertySymbol OrElse propertyGroupOpt IsNot Me.PropertyGroupOpt OrElse accessKind <> Me.AccessKind OrElse isWriteable <> Me.IsWriteable OrElse isLValue <> Me.IsLValue OrElse receiverOpt IsNot Me.ReceiverOpt OrElse arguments <> Me.Arguments OrElse defaultArguments <> Me.DefaultArguments OrElse type IsNot Me.Type Then
                Dim result = New BoundPropertyAccess(Me.Syntax, propertySymbol, propertyGroupOpt, accessKind, isWriteable, isLValue, receiverOpt, arguments, defaultArguments, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundEventAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, receiverOpt As BoundExpression, eventSymbol As EventSymbol, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.EventAccess, syntax, type, hasErrors OrElse receiverOpt.NonNullAndHasErrors())

            Debug.Assert(eventSymbol IsNot Nothing, "Field 'eventSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ReceiverOpt = receiverOpt
            Me._EventSymbol = eventSymbol
        End Sub


        Private ReadOnly _ReceiverOpt As BoundExpression
        Public ReadOnly Property ReceiverOpt As BoundExpression
            Get
                Return _ReceiverOpt
            End Get
        End Property

        Private ReadOnly _EventSymbol As EventSymbol
        Public ReadOnly Property EventSymbol As EventSymbol
            Get
                Return _EventSymbol
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitEventAccess(Me)
        End Function

        Public Function Update(receiverOpt As BoundExpression, eventSymbol As EventSymbol, type As TypeSymbol) As BoundEventAccess
            If receiverOpt IsNot Me.ReceiverOpt OrElse eventSymbol IsNot Me.EventSymbol OrElse type IsNot Me.Type Then
                Dim result = New BoundEventAccess(Me.Syntax, receiverOpt, eventSymbol, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundBlock
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, statementListSyntax As SyntaxList(Of StatementSyntax), locals As ImmutableArray(Of LocalSymbol), statements As ImmutableArray(Of BoundStatement), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Block, syntax, hasErrors OrElse statements.NonNullAndHasErrors())

            Debug.Assert(Not (locals.IsDefault), "Field 'locals' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (statements.IsDefault), "Field 'statements' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._StatementListSyntax = statementListSyntax
            Me._Locals = locals
            Me._Statements = statements
        End Sub


        Private ReadOnly _StatementListSyntax As SyntaxList(Of StatementSyntax)
        Public ReadOnly Property StatementListSyntax As SyntaxList(Of StatementSyntax)
            Get
                Return _StatementListSyntax
            End Get
        End Property

        Private ReadOnly _Locals As ImmutableArray(Of LocalSymbol)
        Public ReadOnly Property Locals As ImmutableArray(Of LocalSymbol)
            Get
                Return _Locals
            End Get
        End Property

        Private ReadOnly _Statements As ImmutableArray(Of BoundStatement)
        Public ReadOnly Property Statements As ImmutableArray(Of BoundStatement)
            Get
                Return _Statements
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitBlock(Me)
        End Function

        Public Function Update(statementListSyntax As SyntaxList(Of StatementSyntax), locals As ImmutableArray(Of LocalSymbol), statements As ImmutableArray(Of BoundStatement)) As BoundBlock
            If statementListSyntax <> Me.StatementListSyntax OrElse locals <> Me.Locals OrElse statements <> Me.Statements Then
                Dim result = New BoundBlock(Me.Syntax, statementListSyntax, locals, statements, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundStateMachineScope
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, fields As ImmutableArray(Of FieldSymbol), statement As BoundStatement, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.StateMachineScope, syntax, hasErrors OrElse statement.NonNullAndHasErrors())

            Debug.Assert(Not (fields.IsDefault), "Field 'fields' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(statement IsNot Nothing, "Field 'statement' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Fields = fields
            Me._Statement = statement
        End Sub


        Private ReadOnly _Fields As ImmutableArray(Of FieldSymbol)
        Public ReadOnly Property Fields As ImmutableArray(Of FieldSymbol)
            Get
                Return _Fields
            End Get
        End Property

        Private ReadOnly _Statement As BoundStatement
        Public ReadOnly Property Statement As BoundStatement
            Get
                Return _Statement
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitStateMachineScope(Me)
        End Function

        Public Function Update(fields As ImmutableArray(Of FieldSymbol), statement As BoundStatement) As BoundStateMachineScope
            If fields <> Me.Fields OrElse statement IsNot Me.Statement Then
                Dim result = New BoundStateMachineScope(Me.Syntax, fields, statement, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundLocalDeclarationBase
        Inherits BoundStatement

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, hasErrors As Boolean)
            MyBase.New(kind, syntax, hasErrors)
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode)
            MyBase.New(kind, syntax)
        End Sub

    End Class

    Partial Friend NotInheritable Class BoundLocalDeclaration
        Inherits BoundLocalDeclarationBase

        Public Sub New(syntax As SyntaxNode, localSymbol As LocalSymbol, declarationInitializerOpt As BoundExpression, identifierInitializerOpt As BoundArrayCreation, initializedByAsNew As Boolean, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.LocalDeclaration, syntax, hasErrors OrElse declarationInitializerOpt.NonNullAndHasErrors() OrElse identifierInitializerOpt.NonNullAndHasErrors())

            Debug.Assert(localSymbol IsNot Nothing, "Field 'localSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalSymbol = localSymbol
            Me._DeclarationInitializerOpt = declarationInitializerOpt
            Me._IdentifierInitializerOpt = identifierInitializerOpt
            Me._InitializedByAsNew = initializedByAsNew

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _LocalSymbol As LocalSymbol
        Public ReadOnly Property LocalSymbol As LocalSymbol
            Get
                Return _LocalSymbol
            End Get
        End Property

        Private ReadOnly _DeclarationInitializerOpt As BoundExpression
        Public ReadOnly Property DeclarationInitializerOpt As BoundExpression
            Get
                Return _DeclarationInitializerOpt
            End Get
        End Property

        Private ReadOnly _IdentifierInitializerOpt As BoundArrayCreation
        Public ReadOnly Property IdentifierInitializerOpt As BoundArrayCreation
            Get
                Return _IdentifierInitializerOpt
            End Get
        End Property

        Private ReadOnly _InitializedByAsNew As Boolean
        Public ReadOnly Property InitializedByAsNew As Boolean
            Get
                Return _InitializedByAsNew
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLocalDeclaration(Me)
        End Function

        Public Function Update(localSymbol As LocalSymbol, declarationInitializerOpt As BoundExpression, identifierInitializerOpt As BoundArrayCreation, initializedByAsNew As Boolean) As BoundLocalDeclaration
            If localSymbol IsNot Me.LocalSymbol OrElse declarationInitializerOpt IsNot Me.DeclarationInitializerOpt OrElse identifierInitializerOpt IsNot Me.IdentifierInitializerOpt OrElse initializedByAsNew <> Me.InitializedByAsNew Then
                Dim result = New BoundLocalDeclaration(Me.Syntax, localSymbol, declarationInitializerOpt, identifierInitializerOpt, initializedByAsNew, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAsNewLocalDeclarations
        Inherits BoundLocalDeclarationBase

        Public Sub New(syntax As SyntaxNode, localDeclarations As ImmutableArray(Of BoundLocalDeclaration), initializer As BoundExpression, binder As Binder, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AsNewLocalDeclarations, syntax, hasErrors OrElse localDeclarations.NonNullAndHasErrors() OrElse initializer.NonNullAndHasErrors())

            Debug.Assert(Not (localDeclarations.IsDefault), "Field 'localDeclarations' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(initializer IsNot Nothing, "Field 'initializer' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalDeclarations = localDeclarations
            Me._Initializer = initializer
            Me._Binder = binder
        End Sub


        Private ReadOnly _LocalDeclarations As ImmutableArray(Of BoundLocalDeclaration)
        Public ReadOnly Property LocalDeclarations As ImmutableArray(Of BoundLocalDeclaration)
            Get
                Return _LocalDeclarations
            End Get
        End Property

        Private ReadOnly _Initializer As BoundExpression
        Public ReadOnly Property Initializer As BoundExpression
            Get
                Return _Initializer
            End Get
        End Property

        Private ReadOnly _Binder As Binder
        Public ReadOnly Property Binder As Binder
            Get
                Return _Binder
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAsNewLocalDeclarations(Me)
        End Function

        Public Function Update(localDeclarations As ImmutableArray(Of BoundLocalDeclaration), initializer As BoundExpression, binder As Binder) As BoundAsNewLocalDeclarations
            If localDeclarations <> Me.LocalDeclarations OrElse initializer IsNot Me.Initializer OrElse binder IsNot Me.Binder Then
                Dim result = New BoundAsNewLocalDeclarations(Me.Syntax, localDeclarations, initializer, binder, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundDimStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, localDeclarations As ImmutableArray(Of BoundLocalDeclarationBase), initializerOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.DimStatement, syntax, hasErrors OrElse localDeclarations.NonNullAndHasErrors() OrElse initializerOpt.NonNullAndHasErrors())

            Debug.Assert(Not (localDeclarations.IsDefault), "Field 'localDeclarations' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalDeclarations = localDeclarations
            Me._InitializerOpt = initializerOpt
        End Sub


        Private ReadOnly _LocalDeclarations As ImmutableArray(Of BoundLocalDeclarationBase)
        Public ReadOnly Property LocalDeclarations As ImmutableArray(Of BoundLocalDeclarationBase)
            Get
                Return _LocalDeclarations
            End Get
        End Property

        Private ReadOnly _InitializerOpt As BoundExpression
        Public ReadOnly Property InitializerOpt As BoundExpression
            Get
                Return _InitializerOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitDimStatement(Me)
        End Function

        Public Function Update(localDeclarations As ImmutableArray(Of BoundLocalDeclarationBase), initializerOpt As BoundExpression) As BoundDimStatement
            If localDeclarations <> Me.LocalDeclarations OrElse initializerOpt IsNot Me.InitializerOpt Then
                Dim result = New BoundDimStatement(Me.Syntax, localDeclarations, initializerOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend Class BoundInitializer
        Inherits BoundStatement

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, hasErrors As Boolean)
            MyBase.New(kind, syntax, hasErrors)
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode)
            MyBase.New(kind, syntax)
        End Sub

        Public Sub New(syntax As SyntaxNode, hasErrors As Boolean)
            MyBase.New(BoundKind.Initializer, syntax, hasErrors)
        End Sub

        Public Sub New(syntax As SyntaxNode)
            MyBase.New(BoundKind.Initializer, syntax)
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitInitializer(Me)
        End Function
    End Class

    Partial Friend MustInherit Class BoundFieldOrPropertyInitializer
        Inherits BoundInitializer

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, memberAccessExpressionOpt As BoundExpression, initialValue As BoundExpression, binderOpt As Binder, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, hasErrors)

            Debug.Assert(initialValue IsNot Nothing, "Field 'initialValue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._MemberAccessExpressionOpt = memberAccessExpressionOpt
            Me._InitialValue = initialValue
            Me._BinderOpt = binderOpt
        End Sub


        Private ReadOnly _MemberAccessExpressionOpt As BoundExpression
        Public ReadOnly Property MemberAccessExpressionOpt As BoundExpression
            Get
                Return _MemberAccessExpressionOpt
            End Get
        End Property

        Private ReadOnly _InitialValue As BoundExpression
        Public ReadOnly Property InitialValue As BoundExpression
            Get
                Return _InitialValue
            End Get
        End Property

        Private ReadOnly _BinderOpt As Binder
        Public ReadOnly Property BinderOpt As Binder
            Get
                Return _BinderOpt
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundFieldInitializer
        Inherits BoundFieldOrPropertyInitializer

        Public Sub New(syntax As SyntaxNode, initializedFields As ImmutableArray(Of FieldSymbol), memberAccessExpressionOpt As BoundExpression, initialValue As BoundExpression, binderOpt As Binder, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.FieldInitializer, syntax, memberAccessExpressionOpt, initialValue, binderOpt, hasErrors OrElse memberAccessExpressionOpt.NonNullAndHasErrors() OrElse initialValue.NonNullAndHasErrors())

            Debug.Assert(Not (initializedFields.IsDefault), "Field 'initializedFields' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(initialValue IsNot Nothing, "Field 'initialValue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._InitializedFields = initializedFields
        End Sub


        Private ReadOnly _InitializedFields As ImmutableArray(Of FieldSymbol)
        Public ReadOnly Property InitializedFields As ImmutableArray(Of FieldSymbol)
            Get
                Return _InitializedFields
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitFieldInitializer(Me)
        End Function

        Public Function Update(initializedFields As ImmutableArray(Of FieldSymbol), memberAccessExpressionOpt As BoundExpression, initialValue As BoundExpression, binderOpt As Binder) As BoundFieldInitializer
            If initializedFields <> Me.InitializedFields OrElse memberAccessExpressionOpt IsNot Me.MemberAccessExpressionOpt OrElse initialValue IsNot Me.InitialValue OrElse binderOpt IsNot Me.BinderOpt Then
                Dim result = New BoundFieldInitializer(Me.Syntax, initializedFields, memberAccessExpressionOpt, initialValue, binderOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundPropertyInitializer
        Inherits BoundFieldOrPropertyInitializer

        Public Sub New(syntax As SyntaxNode, initializedProperties As ImmutableArray(Of PropertySymbol), memberAccessExpressionOpt As BoundExpression, initialValue As BoundExpression, binderOpt As Binder, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.PropertyInitializer, syntax, memberAccessExpressionOpt, initialValue, binderOpt, hasErrors OrElse memberAccessExpressionOpt.NonNullAndHasErrors() OrElse initialValue.NonNullAndHasErrors())

            Debug.Assert(Not (initializedProperties.IsDefault), "Field 'initializedProperties' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(initialValue IsNot Nothing, "Field 'initialValue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._InitializedProperties = initializedProperties
        End Sub


        Private ReadOnly _InitializedProperties As ImmutableArray(Of PropertySymbol)
        Public ReadOnly Property InitializedProperties As ImmutableArray(Of PropertySymbol)
            Get
                Return _InitializedProperties
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitPropertyInitializer(Me)
        End Function

        Public Function Update(initializedProperties As ImmutableArray(Of PropertySymbol), memberAccessExpressionOpt As BoundExpression, initialValue As BoundExpression, binderOpt As Binder) As BoundPropertyInitializer
            If initializedProperties <> Me.InitializedProperties OrElse memberAccessExpressionOpt IsNot Me.MemberAccessExpressionOpt OrElse initialValue IsNot Me.InitialValue OrElse binderOpt IsNot Me.BinderOpt Then
                Dim result = New BoundPropertyInitializer(Me.Syntax, initializedProperties, memberAccessExpressionOpt, initialValue, binderOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundParameterEqualsValue
        Inherits BoundNode

        Public Sub New(syntax As SyntaxNode, parameter As ParameterSymbol, value As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ParameterEqualsValue, syntax, hasErrors OrElse value.NonNullAndHasErrors())

            Debug.Assert(parameter IsNot Nothing, "Field 'parameter' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Parameter = parameter
            Me._Value = value
        End Sub


        Private ReadOnly _Parameter As ParameterSymbol
        Public ReadOnly Property Parameter As ParameterSymbol
            Get
                Return _Parameter
            End Get
        End Property

        Private ReadOnly _Value As BoundExpression
        Public ReadOnly Property Value As BoundExpression
            Get
                Return _Value
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitParameterEqualsValue(Me)
        End Function

        Public Function Update(parameter As ParameterSymbol, value As BoundExpression) As BoundParameterEqualsValue
            If parameter IsNot Me.Parameter OrElse value IsNot Me.Value Then
                Dim result = New BoundParameterEqualsValue(Me.Syntax, parameter, value, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundGlobalStatementInitializer
        Inherits BoundInitializer

        Public Sub New(syntax As SyntaxNode, statement As BoundStatement, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.GlobalStatementInitializer, syntax, hasErrors OrElse statement.NonNullAndHasErrors())

            Debug.Assert(statement IsNot Nothing, "Field 'statement' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Statement = statement
        End Sub


        Private ReadOnly _Statement As BoundStatement
        Public ReadOnly Property Statement As BoundStatement
            Get
                Return _Statement
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitGlobalStatementInitializer(Me)
        End Function

        Public Function Update(statement As BoundStatement) As BoundGlobalStatementInitializer
            If statement IsNot Me.Statement Then
                Dim result = New BoundGlobalStatementInitializer(Me.Syntax, statement, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundSequence
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, locals As ImmutableArray(Of LocalSymbol), sideEffects As ImmutableArray(Of BoundExpression), valueOpt As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Sequence, syntax, type, hasErrors OrElse sideEffects.NonNullAndHasErrors() OrElse valueOpt.NonNullAndHasErrors())

            Debug.Assert(Not (locals.IsDefault), "Field 'locals' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (sideEffects.IsDefault), "Field 'sideEffects' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Locals = locals
            Me._SideEffects = sideEffects
            Me._ValueOpt = valueOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Locals As ImmutableArray(Of LocalSymbol)
        Public ReadOnly Property Locals As ImmutableArray(Of LocalSymbol)
            Get
                Return _Locals
            End Get
        End Property

        Private ReadOnly _SideEffects As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property SideEffects As ImmutableArray(Of BoundExpression)
            Get
                Return _SideEffects
            End Get
        End Property

        Private ReadOnly _ValueOpt As BoundExpression
        Public ReadOnly Property ValueOpt As BoundExpression
            Get
                Return _ValueOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSequence(Me)
        End Function

        Public Function Update(locals As ImmutableArray(Of LocalSymbol), sideEffects As ImmutableArray(Of BoundExpression), valueOpt As BoundExpression, type As TypeSymbol) As BoundSequence
            If locals <> Me.Locals OrElse sideEffects <> Me.SideEffects OrElse valueOpt IsNot Me.ValueOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundSequence(Me.Syntax, locals, sideEffects, valueOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundExpressionStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ExpressionStatement, syntax, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitExpressionStatement(Me)
        End Function

        Public Function Update(expression As BoundExpression) As BoundExpressionStatement
            If expression IsNot Me.Expression Then
                Dim result = New BoundExpressionStatement(Me.Syntax, expression, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundIfStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, condition As BoundExpression, consequence As BoundStatement, alternativeOpt As BoundStatement, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.IfStatement, syntax, hasErrors OrElse condition.NonNullAndHasErrors() OrElse consequence.NonNullAndHasErrors() OrElse alternativeOpt.NonNullAndHasErrors())

            Debug.Assert(condition IsNot Nothing, "Field 'condition' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(consequence IsNot Nothing, "Field 'consequence' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Condition = condition
            Me._Consequence = consequence
            Me._AlternativeOpt = alternativeOpt
        End Sub


        Private ReadOnly _Condition As BoundExpression
        Public ReadOnly Property Condition As BoundExpression
            Get
                Return _Condition
            End Get
        End Property

        Private ReadOnly _Consequence As BoundStatement
        Public ReadOnly Property Consequence As BoundStatement
            Get
                Return _Consequence
            End Get
        End Property

        Private ReadOnly _AlternativeOpt As BoundStatement
        Public ReadOnly Property AlternativeOpt As BoundStatement
            Get
                Return _AlternativeOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitIfStatement(Me)
        End Function

        Public Function Update(condition As BoundExpression, consequence As BoundStatement, alternativeOpt As BoundStatement) As BoundIfStatement
            If condition IsNot Me.Condition OrElse consequence IsNot Me.Consequence OrElse alternativeOpt IsNot Me.AlternativeOpt Then
                Dim result = New BoundIfStatement(Me.Syntax, condition, consequence, alternativeOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundSelectStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, expressionStatement As BoundExpressionStatement, exprPlaceholderOpt As BoundRValuePlaceholder, caseBlocks As ImmutableArray(Of BoundCaseBlock), recommendSwitchTable As Boolean, exitLabel As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.SelectStatement, syntax, hasErrors OrElse expressionStatement.NonNullAndHasErrors() OrElse exprPlaceholderOpt.NonNullAndHasErrors() OrElse caseBlocks.NonNullAndHasErrors())

            Debug.Assert(expressionStatement IsNot Nothing, "Field 'expressionStatement' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (caseBlocks.IsDefault), "Field 'caseBlocks' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ExpressionStatement = expressionStatement
            Me._ExprPlaceholderOpt = exprPlaceholderOpt
            Me._CaseBlocks = caseBlocks
            Me._RecommendSwitchTable = recommendSwitchTable
            Me._ExitLabel = exitLabel
        End Sub


        Private ReadOnly _ExpressionStatement As BoundExpressionStatement
        Public ReadOnly Property ExpressionStatement As BoundExpressionStatement
            Get
                Return _ExpressionStatement
            End Get
        End Property

        Private ReadOnly _ExprPlaceholderOpt As BoundRValuePlaceholder
        Public ReadOnly Property ExprPlaceholderOpt As BoundRValuePlaceholder
            Get
                Return _ExprPlaceholderOpt
            End Get
        End Property

        Private ReadOnly _CaseBlocks As ImmutableArray(Of BoundCaseBlock)
        Public ReadOnly Property CaseBlocks As ImmutableArray(Of BoundCaseBlock)
            Get
                Return _CaseBlocks
            End Get
        End Property

        Private ReadOnly _RecommendSwitchTable As Boolean
        Public ReadOnly Property RecommendSwitchTable As Boolean
            Get
                Return _RecommendSwitchTable
            End Get
        End Property

        Private ReadOnly _ExitLabel As LabelSymbol
        Public ReadOnly Property ExitLabel As LabelSymbol
            Get
                Return _ExitLabel
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSelectStatement(Me)
        End Function

        Public Function Update(expressionStatement As BoundExpressionStatement, exprPlaceholderOpt As BoundRValuePlaceholder, caseBlocks As ImmutableArray(Of BoundCaseBlock), recommendSwitchTable As Boolean, exitLabel As LabelSymbol) As BoundSelectStatement
            If expressionStatement IsNot Me.ExpressionStatement OrElse exprPlaceholderOpt IsNot Me.ExprPlaceholderOpt OrElse caseBlocks <> Me.CaseBlocks OrElse recommendSwitchTable <> Me.RecommendSwitchTable OrElse exitLabel IsNot Me.ExitLabel Then
                Dim result = New BoundSelectStatement(Me.Syntax, expressionStatement, exprPlaceholderOpt, caseBlocks, recommendSwitchTable, exitLabel, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundCaseBlock
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, caseStatement As BoundCaseStatement, body As BoundBlock, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.CaseBlock, syntax, hasErrors OrElse caseStatement.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors())

            Debug.Assert(caseStatement IsNot Nothing, "Field 'caseStatement' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._CaseStatement = caseStatement
            Me._Body = body
        End Sub


        Private ReadOnly _CaseStatement As BoundCaseStatement
        Public ReadOnly Property CaseStatement As BoundCaseStatement
            Get
                Return _CaseStatement
            End Get
        End Property

        Private ReadOnly _Body As BoundBlock
        Public ReadOnly Property Body As BoundBlock
            Get
                Return _Body
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitCaseBlock(Me)
        End Function

        Public Function Update(caseStatement As BoundCaseStatement, body As BoundBlock) As BoundCaseBlock
            If caseStatement IsNot Me.CaseStatement OrElse body IsNot Me.Body Then
                Dim result = New BoundCaseBlock(Me.Syntax, caseStatement, body, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundCaseStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, caseClauses As ImmutableArray(Of BoundCaseClause), conditionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.CaseStatement, syntax, hasErrors OrElse caseClauses.NonNullAndHasErrors() OrElse conditionOpt.NonNullAndHasErrors())

            Debug.Assert(Not (caseClauses.IsDefault), "Field 'caseClauses' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._CaseClauses = caseClauses
            Me._ConditionOpt = conditionOpt
        End Sub


        Private ReadOnly _CaseClauses As ImmutableArray(Of BoundCaseClause)
        Public ReadOnly Property CaseClauses As ImmutableArray(Of BoundCaseClause)
            Get
                Return _CaseClauses
            End Get
        End Property

        Private ReadOnly _ConditionOpt As BoundExpression
        Public ReadOnly Property ConditionOpt As BoundExpression
            Get
                Return _ConditionOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitCaseStatement(Me)
        End Function

        Public Function Update(caseClauses As ImmutableArray(Of BoundCaseClause), conditionOpt As BoundExpression) As BoundCaseStatement
            If caseClauses <> Me.CaseClauses OrElse conditionOpt IsNot Me.ConditionOpt Then
                Dim result = New BoundCaseStatement(Me.Syntax, caseClauses, conditionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundCaseClause
        Inherits BoundNode

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, hasErrors As Boolean)
            MyBase.New(kind, syntax, hasErrors)
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode)
            MyBase.New(kind, syntax)
        End Sub

    End Class

    Partial Friend MustInherit Class BoundSingleValueCaseClause
        Inherits BoundCaseClause

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, valueOpt As BoundExpression, conditionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, hasErrors)
            Me._ValueOpt = valueOpt
            Me._ConditionOpt = conditionOpt
        End Sub


        Private ReadOnly _ValueOpt As BoundExpression
        Public ReadOnly Property ValueOpt As BoundExpression
            Get
                Return _ValueOpt
            End Get
        End Property

        Private ReadOnly _ConditionOpt As BoundExpression
        Public ReadOnly Property ConditionOpt As BoundExpression
            Get
                Return _ConditionOpt
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundSimpleCaseClause
        Inherits BoundSingleValueCaseClause

        Public Sub New(syntax As SyntaxNode, valueOpt As BoundExpression, conditionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.SimpleCaseClause, syntax, valueOpt, conditionOpt, hasErrors OrElse valueOpt.NonNullAndHasErrors() OrElse conditionOpt.NonNullAndHasErrors())

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSimpleCaseClause(Me)
        End Function

        Public Function Update(valueOpt As BoundExpression, conditionOpt As BoundExpression) As BoundSimpleCaseClause
            If valueOpt IsNot Me.ValueOpt OrElse conditionOpt IsNot Me.ConditionOpt Then
                Dim result = New BoundSimpleCaseClause(Me.Syntax, valueOpt, conditionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRangeCaseClause
        Inherits BoundCaseClause

        Public Sub New(syntax As SyntaxNode, lowerBoundOpt As BoundExpression, upperBoundOpt As BoundExpression, lowerBoundConditionOpt As BoundExpression, upperBoundConditionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RangeCaseClause, syntax, hasErrors OrElse lowerBoundOpt.NonNullAndHasErrors() OrElse upperBoundOpt.NonNullAndHasErrors() OrElse lowerBoundConditionOpt.NonNullAndHasErrors() OrElse upperBoundConditionOpt.NonNullAndHasErrors())
            Me._LowerBoundOpt = lowerBoundOpt
            Me._UpperBoundOpt = upperBoundOpt
            Me._LowerBoundConditionOpt = lowerBoundConditionOpt
            Me._UpperBoundConditionOpt = upperBoundConditionOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _LowerBoundOpt As BoundExpression
        Public ReadOnly Property LowerBoundOpt As BoundExpression
            Get
                Return _LowerBoundOpt
            End Get
        End Property

        Private ReadOnly _UpperBoundOpt As BoundExpression
        Public ReadOnly Property UpperBoundOpt As BoundExpression
            Get
                Return _UpperBoundOpt
            End Get
        End Property

        Private ReadOnly _LowerBoundConditionOpt As BoundExpression
        Public ReadOnly Property LowerBoundConditionOpt As BoundExpression
            Get
                Return _LowerBoundConditionOpt
            End Get
        End Property

        Private ReadOnly _UpperBoundConditionOpt As BoundExpression
        Public ReadOnly Property UpperBoundConditionOpt As BoundExpression
            Get
                Return _UpperBoundConditionOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRangeCaseClause(Me)
        End Function

        Public Function Update(lowerBoundOpt As BoundExpression, upperBoundOpt As BoundExpression, lowerBoundConditionOpt As BoundExpression, upperBoundConditionOpt As BoundExpression) As BoundRangeCaseClause
            If lowerBoundOpt IsNot Me.LowerBoundOpt OrElse upperBoundOpt IsNot Me.UpperBoundOpt OrElse lowerBoundConditionOpt IsNot Me.LowerBoundConditionOpt OrElse upperBoundConditionOpt IsNot Me.UpperBoundConditionOpt Then
                Dim result = New BoundRangeCaseClause(Me.Syntax, lowerBoundOpt, upperBoundOpt, lowerBoundConditionOpt, upperBoundConditionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRelationalCaseClause
        Inherits BoundSingleValueCaseClause

        Public Sub New(syntax As SyntaxNode, operatorKind As BinaryOperatorKind, valueOpt As BoundExpression, conditionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RelationalCaseClause, syntax, valueOpt, conditionOpt, hasErrors OrElse valueOpt.NonNullAndHasErrors() OrElse conditionOpt.NonNullAndHasErrors())
            Me._OperatorKind = operatorKind

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OperatorKind As BinaryOperatorKind
        Public ReadOnly Property OperatorKind As BinaryOperatorKind
            Get
                Return _OperatorKind
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRelationalCaseClause(Me)
        End Function

        Public Function Update(operatorKind As BinaryOperatorKind, valueOpt As BoundExpression, conditionOpt As BoundExpression) As BoundRelationalCaseClause
            If operatorKind <> Me.OperatorKind OrElse valueOpt IsNot Me.ValueOpt OrElse conditionOpt IsNot Me.ConditionOpt Then
                Dim result = New BoundRelationalCaseClause(Me.Syntax, operatorKind, valueOpt, conditionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundLoopStatement
        Inherits BoundStatement

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, continueLabel As LabelSymbol, exitLabel As LabelSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, hasErrors)

            Debug.Assert(continueLabel IsNot Nothing, "Field 'continueLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ContinueLabel = continueLabel
            Me._ExitLabel = exitLabel
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, continueLabel As LabelSymbol, exitLabel As LabelSymbol)
            MyBase.New(kind, syntax)

            Debug.Assert(continueLabel IsNot Nothing, "Field 'continueLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ContinueLabel = continueLabel
            Me._ExitLabel = exitLabel
        End Sub


        Private ReadOnly _ContinueLabel As LabelSymbol
        Public ReadOnly Property ContinueLabel As LabelSymbol
            Get
                Return _ContinueLabel
            End Get
        End Property

        Private ReadOnly _ExitLabel As LabelSymbol
        Public ReadOnly Property ExitLabel As LabelSymbol
            Get
                Return _ExitLabel
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundDoLoopStatement
        Inherits BoundLoopStatement

        Public Sub New(syntax As SyntaxNode, topConditionOpt As BoundExpression, bottomConditionOpt As BoundExpression, topConditionIsUntil As Boolean, bottomConditionIsUntil As Boolean, body As BoundStatement, continueLabel As LabelSymbol, exitLabel As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.DoLoopStatement, syntax, continueLabel, exitLabel, hasErrors OrElse topConditionOpt.NonNullAndHasErrors() OrElse bottomConditionOpt.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors())

            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(continueLabel IsNot Nothing, "Field 'continueLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._TopConditionOpt = topConditionOpt
            Me._BottomConditionOpt = bottomConditionOpt
            Me._TopConditionIsUntil = topConditionIsUntil
            Me._BottomConditionIsUntil = bottomConditionIsUntil
            Me._Body = body
        End Sub


        Private ReadOnly _TopConditionOpt As BoundExpression
        Public ReadOnly Property TopConditionOpt As BoundExpression
            Get
                Return _TopConditionOpt
            End Get
        End Property

        Private ReadOnly _BottomConditionOpt As BoundExpression
        Public ReadOnly Property BottomConditionOpt As BoundExpression
            Get
                Return _BottomConditionOpt
            End Get
        End Property

        Private ReadOnly _TopConditionIsUntil As Boolean
        Public ReadOnly Property TopConditionIsUntil As Boolean
            Get
                Return _TopConditionIsUntil
            End Get
        End Property

        Private ReadOnly _BottomConditionIsUntil As Boolean
        Public ReadOnly Property BottomConditionIsUntil As Boolean
            Get
                Return _BottomConditionIsUntil
            End Get
        End Property

        Private ReadOnly _Body As BoundStatement
        Public ReadOnly Property Body As BoundStatement
            Get
                Return _Body
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitDoLoopStatement(Me)
        End Function

        Public Function Update(topConditionOpt As BoundExpression, bottomConditionOpt As BoundExpression, topConditionIsUntil As Boolean, bottomConditionIsUntil As Boolean, body As BoundStatement, continueLabel As LabelSymbol, exitLabel As LabelSymbol) As BoundDoLoopStatement
            If topConditionOpt IsNot Me.TopConditionOpt OrElse bottomConditionOpt IsNot Me.BottomConditionOpt OrElse topConditionIsUntil <> Me.TopConditionIsUntil OrElse bottomConditionIsUntil <> Me.BottomConditionIsUntil OrElse body IsNot Me.Body OrElse continueLabel IsNot Me.ContinueLabel OrElse exitLabel IsNot Me.ExitLabel Then
                Dim result = New BoundDoLoopStatement(Me.Syntax, topConditionOpt, bottomConditionOpt, topConditionIsUntil, bottomConditionIsUntil, body, continueLabel, exitLabel, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundWhileStatement
        Inherits BoundLoopStatement

        Public Sub New(syntax As SyntaxNode, condition As BoundExpression, body As BoundStatement, continueLabel As LabelSymbol, exitLabel As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.WhileStatement, syntax, continueLabel, exitLabel, hasErrors OrElse condition.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors())

            Debug.Assert(condition IsNot Nothing, "Field 'condition' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(continueLabel IsNot Nothing, "Field 'continueLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Condition = condition
            Me._Body = body
        End Sub


        Private ReadOnly _Condition As BoundExpression
        Public ReadOnly Property Condition As BoundExpression
            Get
                Return _Condition
            End Get
        End Property

        Private ReadOnly _Body As BoundStatement
        Public ReadOnly Property Body As BoundStatement
            Get
                Return _Body
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitWhileStatement(Me)
        End Function

        Public Function Update(condition As BoundExpression, body As BoundStatement, continueLabel As LabelSymbol, exitLabel As LabelSymbol) As BoundWhileStatement
            If condition IsNot Me.Condition OrElse body IsNot Me.Body OrElse continueLabel IsNot Me.ContinueLabel OrElse exitLabel IsNot Me.ExitLabel Then
                Dim result = New BoundWhileStatement(Me.Syntax, condition, body, continueLabel, exitLabel, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundForStatement
        Inherits BoundLoopStatement

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, declaredOrInferredLocalOpt As LocalSymbol, controlVariable As BoundExpression, body As BoundStatement, nextVariablesOpt As ImmutableArray(Of BoundExpression), continueLabel As LabelSymbol, exitLabel As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, continueLabel, exitLabel, hasErrors)

            Debug.Assert(controlVariable IsNot Nothing, "Field 'controlVariable' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(continueLabel IsNot Nothing, "Field 'continueLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._DeclaredOrInferredLocalOpt = declaredOrInferredLocalOpt
            Me._ControlVariable = controlVariable
            Me._Body = body
            Me._NextVariablesOpt = nextVariablesOpt
        End Sub


        Private ReadOnly _DeclaredOrInferredLocalOpt As LocalSymbol
        Public ReadOnly Property DeclaredOrInferredLocalOpt As LocalSymbol
            Get
                Return _DeclaredOrInferredLocalOpt
            End Get
        End Property

        Private ReadOnly _ControlVariable As BoundExpression
        Public ReadOnly Property ControlVariable As BoundExpression
            Get
                Return _ControlVariable
            End Get
        End Property

        Private ReadOnly _Body As BoundStatement
        Public ReadOnly Property Body As BoundStatement
            Get
                Return _Body
            End Get
        End Property

        Private ReadOnly _NextVariablesOpt As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property NextVariablesOpt As ImmutableArray(Of BoundExpression)
            Get
                Return _NextVariablesOpt
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundForToUserDefinedOperators
        Inherits BoundNode

        Public Sub New(syntax As SyntaxNode, leftOperandPlaceholder As BoundRValuePlaceholder, rightOperandPlaceholder As BoundRValuePlaceholder, addition As BoundUserDefinedBinaryOperator, subtraction As BoundUserDefinedBinaryOperator, lessThanOrEqual As BoundExpression, greaterThanOrEqual As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ForToUserDefinedOperators, syntax, hasErrors OrElse leftOperandPlaceholder.NonNullAndHasErrors() OrElse rightOperandPlaceholder.NonNullAndHasErrors() OrElse addition.NonNullAndHasErrors() OrElse subtraction.NonNullAndHasErrors() OrElse lessThanOrEqual.NonNullAndHasErrors() OrElse greaterThanOrEqual.NonNullAndHasErrors())

            Debug.Assert(leftOperandPlaceholder IsNot Nothing, "Field 'leftOperandPlaceholder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(rightOperandPlaceholder IsNot Nothing, "Field 'rightOperandPlaceholder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(addition IsNot Nothing, "Field 'addition' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(subtraction IsNot Nothing, "Field 'subtraction' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(lessThanOrEqual IsNot Nothing, "Field 'lessThanOrEqual' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(greaterThanOrEqual IsNot Nothing, "Field 'greaterThanOrEqual' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LeftOperandPlaceholder = leftOperandPlaceholder
            Me._RightOperandPlaceholder = rightOperandPlaceholder
            Me._Addition = addition
            Me._Subtraction = subtraction
            Me._LessThanOrEqual = lessThanOrEqual
            Me._GreaterThanOrEqual = greaterThanOrEqual

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _LeftOperandPlaceholder As BoundRValuePlaceholder
        Public ReadOnly Property LeftOperandPlaceholder As BoundRValuePlaceholder
            Get
                Return _LeftOperandPlaceholder
            End Get
        End Property

        Private ReadOnly _RightOperandPlaceholder As BoundRValuePlaceholder
        Public ReadOnly Property RightOperandPlaceholder As BoundRValuePlaceholder
            Get
                Return _RightOperandPlaceholder
            End Get
        End Property

        Private ReadOnly _Addition As BoundUserDefinedBinaryOperator
        Public ReadOnly Property Addition As BoundUserDefinedBinaryOperator
            Get
                Return _Addition
            End Get
        End Property

        Private ReadOnly _Subtraction As BoundUserDefinedBinaryOperator
        Public ReadOnly Property Subtraction As BoundUserDefinedBinaryOperator
            Get
                Return _Subtraction
            End Get
        End Property

        Private ReadOnly _LessThanOrEqual As BoundExpression
        Public ReadOnly Property LessThanOrEqual As BoundExpression
            Get
                Return _LessThanOrEqual
            End Get
        End Property

        Private ReadOnly _GreaterThanOrEqual As BoundExpression
        Public ReadOnly Property GreaterThanOrEqual As BoundExpression
            Get
                Return _GreaterThanOrEqual
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitForToUserDefinedOperators(Me)
        End Function

        Public Function Update(leftOperandPlaceholder As BoundRValuePlaceholder, rightOperandPlaceholder As BoundRValuePlaceholder, addition As BoundUserDefinedBinaryOperator, subtraction As BoundUserDefinedBinaryOperator, lessThanOrEqual As BoundExpression, greaterThanOrEqual As BoundExpression) As BoundForToUserDefinedOperators
            If leftOperandPlaceholder IsNot Me.LeftOperandPlaceholder OrElse rightOperandPlaceholder IsNot Me.RightOperandPlaceholder OrElse addition IsNot Me.Addition OrElse subtraction IsNot Me.Subtraction OrElse lessThanOrEqual IsNot Me.LessThanOrEqual OrElse greaterThanOrEqual IsNot Me.GreaterThanOrEqual Then
                Dim result = New BoundForToUserDefinedOperators(Me.Syntax, leftOperandPlaceholder, rightOperandPlaceholder, addition, subtraction, lessThanOrEqual, greaterThanOrEqual, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundForToStatement
        Inherits BoundForStatement

        Public Sub New(syntax As SyntaxNode, initialValue As BoundExpression, limitValue As BoundExpression, stepValue As BoundExpression, checked As Boolean, operatorsOpt As BoundForToUserDefinedOperators, declaredOrInferredLocalOpt As LocalSymbol, controlVariable As BoundExpression, body As BoundStatement, nextVariablesOpt As ImmutableArray(Of BoundExpression), continueLabel As LabelSymbol, exitLabel As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ForToStatement, syntax, declaredOrInferredLocalOpt, controlVariable, body, nextVariablesOpt, continueLabel, exitLabel, hasErrors OrElse initialValue.NonNullAndHasErrors() OrElse limitValue.NonNullAndHasErrors() OrElse stepValue.NonNullAndHasErrors() OrElse operatorsOpt.NonNullAndHasErrors() OrElse controlVariable.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors() OrElse nextVariablesOpt.NonNullAndHasErrors())

            Debug.Assert(initialValue IsNot Nothing, "Field 'initialValue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(limitValue IsNot Nothing, "Field 'limitValue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(stepValue IsNot Nothing, "Field 'stepValue' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(controlVariable IsNot Nothing, "Field 'controlVariable' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(continueLabel IsNot Nothing, "Field 'continueLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._InitialValue = initialValue
            Me._LimitValue = limitValue
            Me._StepValue = stepValue
            Me._Checked = checked
            Me._OperatorsOpt = operatorsOpt
        End Sub


        Private ReadOnly _InitialValue As BoundExpression
        Public ReadOnly Property InitialValue As BoundExpression
            Get
                Return _InitialValue
            End Get
        End Property

        Private ReadOnly _LimitValue As BoundExpression
        Public ReadOnly Property LimitValue As BoundExpression
            Get
                Return _LimitValue
            End Get
        End Property

        Private ReadOnly _StepValue As BoundExpression
        Public ReadOnly Property StepValue As BoundExpression
            Get
                Return _StepValue
            End Get
        End Property

        Private ReadOnly _Checked As Boolean
        Public ReadOnly Property Checked As Boolean
            Get
                Return _Checked
            End Get
        End Property

        Private ReadOnly _OperatorsOpt As BoundForToUserDefinedOperators
        Public ReadOnly Property OperatorsOpt As BoundForToUserDefinedOperators
            Get
                Return _OperatorsOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitForToStatement(Me)
        End Function

        Public Function Update(initialValue As BoundExpression, limitValue As BoundExpression, stepValue As BoundExpression, checked As Boolean, operatorsOpt As BoundForToUserDefinedOperators, declaredOrInferredLocalOpt As LocalSymbol, controlVariable As BoundExpression, body As BoundStatement, nextVariablesOpt As ImmutableArray(Of BoundExpression), continueLabel As LabelSymbol, exitLabel As LabelSymbol) As BoundForToStatement
            If initialValue IsNot Me.InitialValue OrElse limitValue IsNot Me.LimitValue OrElse stepValue IsNot Me.StepValue OrElse checked <> Me.Checked OrElse operatorsOpt IsNot Me.OperatorsOpt OrElse declaredOrInferredLocalOpt IsNot Me.DeclaredOrInferredLocalOpt OrElse controlVariable IsNot Me.ControlVariable OrElse body IsNot Me.Body OrElse nextVariablesOpt <> Me.NextVariablesOpt OrElse continueLabel IsNot Me.ContinueLabel OrElse exitLabel IsNot Me.ExitLabel Then
                Dim result = New BoundForToStatement(Me.Syntax, initialValue, limitValue, stepValue, checked, operatorsOpt, declaredOrInferredLocalOpt, controlVariable, body, nextVariablesOpt, continueLabel, exitLabel, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundForEachStatement
        Inherits BoundForStatement

        Public Sub New(syntax As SyntaxNode, collection As BoundExpression, enumeratorInfo As ForEachEnumeratorInfo, declaredOrInferredLocalOpt As LocalSymbol, controlVariable As BoundExpression, body As BoundStatement, nextVariablesOpt As ImmutableArray(Of BoundExpression), continueLabel As LabelSymbol, exitLabel As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ForEachStatement, syntax, declaredOrInferredLocalOpt, controlVariable, body, nextVariablesOpt, continueLabel, exitLabel, hasErrors OrElse collection.NonNullAndHasErrors() OrElse controlVariable.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors() OrElse nextVariablesOpt.NonNullAndHasErrors())

            Debug.Assert(collection IsNot Nothing, "Field 'collection' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(enumeratorInfo IsNot Nothing, "Field 'enumeratorInfo' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(controlVariable IsNot Nothing, "Field 'controlVariable' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(continueLabel IsNot Nothing, "Field 'continueLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(exitLabel IsNot Nothing, "Field 'exitLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Collection = collection
            Me._EnumeratorInfo = enumeratorInfo
        End Sub


        Private ReadOnly _Collection As BoundExpression
        Public ReadOnly Property Collection As BoundExpression
            Get
                Return _Collection
            End Get
        End Property

        Private ReadOnly _EnumeratorInfo As ForEachEnumeratorInfo
        Public ReadOnly Property EnumeratorInfo As ForEachEnumeratorInfo
            Get
                Return _EnumeratorInfo
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitForEachStatement(Me)
        End Function

        Public Function Update(collection As BoundExpression, enumeratorInfo As ForEachEnumeratorInfo, declaredOrInferredLocalOpt As LocalSymbol, controlVariable As BoundExpression, body As BoundStatement, nextVariablesOpt As ImmutableArray(Of BoundExpression), continueLabel As LabelSymbol, exitLabel As LabelSymbol) As BoundForEachStatement
            If collection IsNot Me.Collection OrElse enumeratorInfo IsNot Me.EnumeratorInfo OrElse declaredOrInferredLocalOpt IsNot Me.DeclaredOrInferredLocalOpt OrElse controlVariable IsNot Me.ControlVariable OrElse body IsNot Me.Body OrElse nextVariablesOpt <> Me.NextVariablesOpt OrElse continueLabel IsNot Me.ContinueLabel OrElse exitLabel IsNot Me.ExitLabel Then
                Dim result = New BoundForEachStatement(Me.Syntax, collection, enumeratorInfo, declaredOrInferredLocalOpt, controlVariable, body, nextVariablesOpt, continueLabel, exitLabel, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundExitStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.ExitStatement, syntax, hasErrors)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol)
            MyBase.New(BoundKind.ExitStatement, syntax)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub


        Private ReadOnly _Label As LabelSymbol
        Public ReadOnly Property Label As LabelSymbol
            Get
                Return _Label
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitExitStatement(Me)
        End Function

        Public Function Update(label As LabelSymbol) As BoundExitStatement
            If label IsNot Me.Label Then
                Dim result = New BoundExitStatement(Me.Syntax, label, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundContinueStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.ContinueStatement, syntax, hasErrors)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol)
            MyBase.New(BoundKind.ContinueStatement, syntax)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub


        Private ReadOnly _Label As LabelSymbol
        Public ReadOnly Property Label As LabelSymbol
            Get
                Return _Label
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitContinueStatement(Me)
        End Function

        Public Function Update(label As LabelSymbol) As BoundContinueStatement
            If label IsNot Me.Label Then
                Dim result = New BoundContinueStatement(Me.Syntax, label, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundTryStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, tryBlock As BoundBlock, catchBlocks As ImmutableArray(Of BoundCatchBlock), finallyBlockOpt As BoundBlock, exitLabelOpt As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.TryStatement, syntax, hasErrors OrElse tryBlock.NonNullAndHasErrors() OrElse catchBlocks.NonNullAndHasErrors() OrElse finallyBlockOpt.NonNullAndHasErrors())

            Debug.Assert(tryBlock IsNot Nothing, "Field 'tryBlock' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (catchBlocks.IsDefault), "Field 'catchBlocks' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._TryBlock = tryBlock
            Me._CatchBlocks = catchBlocks
            Me._FinallyBlockOpt = finallyBlockOpt
            Me._ExitLabelOpt = exitLabelOpt
        End Sub


        Private ReadOnly _TryBlock As BoundBlock
        Public ReadOnly Property TryBlock As BoundBlock
            Get
                Return _TryBlock
            End Get
        End Property

        Private ReadOnly _CatchBlocks As ImmutableArray(Of BoundCatchBlock)
        Public ReadOnly Property CatchBlocks As ImmutableArray(Of BoundCatchBlock)
            Get
                Return _CatchBlocks
            End Get
        End Property

        Private ReadOnly _FinallyBlockOpt As BoundBlock
        Public ReadOnly Property FinallyBlockOpt As BoundBlock
            Get
                Return _FinallyBlockOpt
            End Get
        End Property

        Private ReadOnly _ExitLabelOpt As LabelSymbol
        Public ReadOnly Property ExitLabelOpt As LabelSymbol
            Get
                Return _ExitLabelOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTryStatement(Me)
        End Function

        Public Function Update(tryBlock As BoundBlock, catchBlocks As ImmutableArray(Of BoundCatchBlock), finallyBlockOpt As BoundBlock, exitLabelOpt As LabelSymbol) As BoundTryStatement
            If tryBlock IsNot Me.TryBlock OrElse catchBlocks <> Me.CatchBlocks OrElse finallyBlockOpt IsNot Me.FinallyBlockOpt OrElse exitLabelOpt IsNot Me.ExitLabelOpt Then
                Dim result = New BoundTryStatement(Me.Syntax, tryBlock, catchBlocks, finallyBlockOpt, exitLabelOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundCatchBlock
        Inherits BoundNode

        Public Sub New(syntax As SyntaxNode, localOpt As LocalSymbol, exceptionSourceOpt As BoundExpression, errorLineNumberOpt As BoundExpression, exceptionFilterOpt As BoundExpression, body As BoundBlock, isSynthesizedAsyncCatchAll As Boolean, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.CatchBlock, syntax, hasErrors OrElse exceptionSourceOpt.NonNullAndHasErrors() OrElse errorLineNumberOpt.NonNullAndHasErrors() OrElse exceptionFilterOpt.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors())

            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalOpt = localOpt
            Me._ExceptionSourceOpt = exceptionSourceOpt
            Me._ErrorLineNumberOpt = errorLineNumberOpt
            Me._ExceptionFilterOpt = exceptionFilterOpt
            Me._Body = body
            Me._IsSynthesizedAsyncCatchAll = isSynthesizedAsyncCatchAll
        End Sub


        Private ReadOnly _LocalOpt As LocalSymbol
        Public ReadOnly Property LocalOpt As LocalSymbol
            Get
                Return _LocalOpt
            End Get
        End Property

        Private ReadOnly _ExceptionSourceOpt As BoundExpression
        Public ReadOnly Property ExceptionSourceOpt As BoundExpression
            Get
                Return _ExceptionSourceOpt
            End Get
        End Property

        Private ReadOnly _ErrorLineNumberOpt As BoundExpression
        Public ReadOnly Property ErrorLineNumberOpt As BoundExpression
            Get
                Return _ErrorLineNumberOpt
            End Get
        End Property

        Private ReadOnly _ExceptionFilterOpt As BoundExpression
        Public ReadOnly Property ExceptionFilterOpt As BoundExpression
            Get
                Return _ExceptionFilterOpt
            End Get
        End Property

        Private ReadOnly _Body As BoundBlock
        Public ReadOnly Property Body As BoundBlock
            Get
                Return _Body
            End Get
        End Property

        Private ReadOnly _IsSynthesizedAsyncCatchAll As Boolean
        Public ReadOnly Property IsSynthesizedAsyncCatchAll As Boolean
            Get
                Return _IsSynthesizedAsyncCatchAll
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitCatchBlock(Me)
        End Function

        Public Function Update(localOpt As LocalSymbol, exceptionSourceOpt As BoundExpression, errorLineNumberOpt As BoundExpression, exceptionFilterOpt As BoundExpression, body As BoundBlock, isSynthesizedAsyncCatchAll As Boolean) As BoundCatchBlock
            If localOpt IsNot Me.LocalOpt OrElse exceptionSourceOpt IsNot Me.ExceptionSourceOpt OrElse errorLineNumberOpt IsNot Me.ErrorLineNumberOpt OrElse exceptionFilterOpt IsNot Me.ExceptionFilterOpt OrElse body IsNot Me.Body OrElse isSynthesizedAsyncCatchAll <> Me.IsSynthesizedAsyncCatchAll Then
                Dim result = New BoundCatchBlock(Me.Syntax, localOpt, exceptionSourceOpt, errorLineNumberOpt, exceptionFilterOpt, body, isSynthesizedAsyncCatchAll, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLiteral
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, value As ConstantValue, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.Literal, syntax, type, hasErrors)

            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Value = value

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, value As ConstantValue, type As TypeSymbol)
            MyBase.New(BoundKind.Literal, syntax, type)

            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Value = value

            Validate()
        End Sub


        Private ReadOnly _Value As ConstantValue
        Public ReadOnly Property Value As ConstantValue
            Get
                Return _Value
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLiteral(Me)
        End Function

        Public Function Update(value As ConstantValue, type As TypeSymbol) As BoundLiteral
            If value IsNot Me.Value OrElse type IsNot Me.Type Then
                Dim result = New BoundLiteral(Me.Syntax, value, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundMeReference
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.MeReference, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.MeReference, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMeReference(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundMeReference
            If type IsNot Me.Type Then
                Dim result = New BoundMeReference(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundValueTypeMeReference
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.ValueTypeMeReference, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.ValueTypeMeReference, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")


            Validate()
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitValueTypeMeReference(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundValueTypeMeReference
            If type IsNot Me.Type Then
                Dim result = New BoundValueTypeMeReference(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundMyBaseReference
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.MyBaseReference, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.MyBaseReference, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMyBaseReference(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundMyBaseReference
            If type IsNot Me.Type Then
                Dim result = New BoundMyBaseReference(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundMyClassReference
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.MyClassReference, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.MyClassReference, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMyClassReference(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundMyClassReference
            If type IsNot Me.Type Then
                Dim result = New BoundMyClassReference(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundPreviousSubmissionReference
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, sourceType As NamedTypeSymbol, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.PreviousSubmissionReference, syntax, type, hasErrors)

            Debug.Assert(sourceType IsNot Nothing, "Field 'sourceType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._SourceType = sourceType
        End Sub

        Public Sub New(syntax As SyntaxNode, sourceType As NamedTypeSymbol, type As TypeSymbol)
            MyBase.New(BoundKind.PreviousSubmissionReference, syntax, type)

            Debug.Assert(sourceType IsNot Nothing, "Field 'sourceType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._SourceType = sourceType
        End Sub


        Private ReadOnly _SourceType As NamedTypeSymbol
        Public ReadOnly Property SourceType As NamedTypeSymbol
            Get
                Return _SourceType
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitPreviousSubmissionReference(Me)
        End Function

        Public Function Update(sourceType As NamedTypeSymbol, type As TypeSymbol) As BoundPreviousSubmissionReference
            If sourceType IsNot Me.SourceType OrElse type IsNot Me.Type Then
                Dim result = New BoundPreviousSubmissionReference(Me.Syntax, sourceType, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundHostObjectMemberReference
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.HostObjectMemberReference, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Public Sub New(syntax As SyntaxNode, type As TypeSymbol)
            MyBase.New(BoundKind.HostObjectMemberReference, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitHostObjectMemberReference(Me)
        End Function

        Public Function Update(type As TypeSymbol) As BoundHostObjectMemberReference
            If type IsNot Me.Type Then
                Dim result = New BoundHostObjectMemberReference(Me.Syntax, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLocal
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, localSymbol As LocalSymbol, isLValue As Boolean, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.Local, syntax, type, hasErrors)

            Debug.Assert(localSymbol IsNot Nothing, "Field 'localSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalSymbol = localSymbol
            Me._IsLValue = isLValue

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, localSymbol As LocalSymbol, isLValue As Boolean, type As TypeSymbol)
            MyBase.New(BoundKind.Local, syntax, type)

            Debug.Assert(localSymbol IsNot Nothing, "Field 'localSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalSymbol = localSymbol
            Me._IsLValue = isLValue

            Validate()
        End Sub


        Private ReadOnly _LocalSymbol As LocalSymbol
        Public ReadOnly Property LocalSymbol As LocalSymbol
            Get
                Return _LocalSymbol
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLocal(Me)
        End Function

        Public Function Update(localSymbol As LocalSymbol, isLValue As Boolean, type As TypeSymbol) As BoundLocal
            If localSymbol IsNot Me.LocalSymbol OrElse isLValue <> Me.IsLValue OrElse type IsNot Me.Type Then
                Dim result = New BoundLocal(Me.Syntax, localSymbol, isLValue, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundPseudoVariable
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, localSymbol As LocalSymbol, isLValue As Boolean, emitExpressions As PseudoVariableExpressions, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.PseudoVariable, syntax, type, hasErrors)

            Debug.Assert(localSymbol IsNot Nothing, "Field 'localSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(emitExpressions IsNot Nothing, "Field 'emitExpressions' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalSymbol = localSymbol
            Me._IsLValue = isLValue
            Me._EmitExpressions = emitExpressions

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, localSymbol As LocalSymbol, isLValue As Boolean, emitExpressions As PseudoVariableExpressions, type As TypeSymbol)
            MyBase.New(BoundKind.PseudoVariable, syntax, type)

            Debug.Assert(localSymbol IsNot Nothing, "Field 'localSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(emitExpressions IsNot Nothing, "Field 'emitExpressions' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LocalSymbol = localSymbol
            Me._IsLValue = isLValue
            Me._EmitExpressions = emitExpressions

            Validate()
        End Sub


        Private ReadOnly _LocalSymbol As LocalSymbol
        Public ReadOnly Property LocalSymbol As LocalSymbol
            Get
                Return _LocalSymbol
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        Private ReadOnly _EmitExpressions As PseudoVariableExpressions
        Public ReadOnly Property EmitExpressions As PseudoVariableExpressions
            Get
                Return _EmitExpressions
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitPseudoVariable(Me)
        End Function

        Public Function Update(localSymbol As LocalSymbol, isLValue As Boolean, emitExpressions As PseudoVariableExpressions, type As TypeSymbol) As BoundPseudoVariable
            If localSymbol IsNot Me.LocalSymbol OrElse isLValue <> Me.IsLValue OrElse emitExpressions IsNot Me.EmitExpressions OrElse type IsNot Me.Type Then
                Dim result = New BoundPseudoVariable(Me.Syntax, localSymbol, isLValue, emitExpressions, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundParameter
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, parameterSymbol As ParameterSymbol, isLValue As Boolean, suppressVirtualCalls As Boolean, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.Parameter, syntax, type, hasErrors)

            Debug.Assert(parameterSymbol IsNot Nothing, "Field 'parameterSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ParameterSymbol = parameterSymbol
            Me._IsLValue = isLValue
            Me._SuppressVirtualCalls = suppressVirtualCalls
        End Sub

        Public Sub New(syntax As SyntaxNode, parameterSymbol As ParameterSymbol, isLValue As Boolean, suppressVirtualCalls As Boolean, type As TypeSymbol)
            MyBase.New(BoundKind.Parameter, syntax, type)

            Debug.Assert(parameterSymbol IsNot Nothing, "Field 'parameterSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ParameterSymbol = parameterSymbol
            Me._IsLValue = isLValue
            Me._SuppressVirtualCalls = suppressVirtualCalls
        End Sub


        Private ReadOnly _ParameterSymbol As ParameterSymbol
        Public ReadOnly Property ParameterSymbol As ParameterSymbol
            Get
                Return _ParameterSymbol
            End Get
        End Property

        Private ReadOnly _IsLValue As Boolean
        Public Overrides ReadOnly Property IsLValue As Boolean
            Get
                Return _IsLValue
            End Get
        End Property

        Private ReadOnly _SuppressVirtualCalls As Boolean
        Public Overrides ReadOnly Property SuppressVirtualCalls As Boolean
            Get
                Return _SuppressVirtualCalls
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitParameter(Me)
        End Function

        Public Function Update(parameterSymbol As ParameterSymbol, isLValue As Boolean, suppressVirtualCalls As Boolean, type As TypeSymbol) As BoundParameter
            If parameterSymbol IsNot Me.ParameterSymbol OrElse isLValue <> Me.IsLValue OrElse suppressVirtualCalls <> Me.SuppressVirtualCalls OrElse type IsNot Me.Type Then
                Dim result = New BoundParameter(Me.Syntax, parameterSymbol, isLValue, suppressVirtualCalls, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundByRefArgumentPlaceholder
        Inherits BoundValuePlaceholderBase

        Public Sub New(syntax As SyntaxNode, isOut As Boolean, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.ByRefArgumentPlaceholder, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._IsOut = isOut
        End Sub

        Public Sub New(syntax As SyntaxNode, isOut As Boolean, type As TypeSymbol)
            MyBase.New(BoundKind.ByRefArgumentPlaceholder, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._IsOut = isOut
        End Sub


        Private ReadOnly _IsOut As Boolean
        Public ReadOnly Property IsOut As Boolean
            Get
                Return _IsOut
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitByRefArgumentPlaceholder(Me)
        End Function

        Public Function Update(isOut As Boolean, type As TypeSymbol) As BoundByRefArgumentPlaceholder
            If isOut <> Me.IsOut OrElse type IsNot Me.Type Then
                Dim result = New BoundByRefArgumentPlaceholder(Me.Syntax, isOut, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundByRefArgumentWithCopyBack
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, originalArgument As BoundExpression, inConversion As BoundExpression, inPlaceholder As BoundByRefArgumentPlaceholder, outConversion As BoundExpression, outPlaceholder As BoundRValuePlaceholder, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ByRefArgumentWithCopyBack, syntax, type, hasErrors OrElse originalArgument.NonNullAndHasErrors() OrElse inConversion.NonNullAndHasErrors() OrElse inPlaceholder.NonNullAndHasErrors() OrElse outConversion.NonNullAndHasErrors() OrElse outPlaceholder.NonNullAndHasErrors())

            Debug.Assert(originalArgument IsNot Nothing, "Field 'originalArgument' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(inConversion IsNot Nothing, "Field 'inConversion' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(inPlaceholder IsNot Nothing, "Field 'inPlaceholder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(outConversion IsNot Nothing, "Field 'outConversion' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(outPlaceholder IsNot Nothing, "Field 'outPlaceholder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._OriginalArgument = originalArgument
            Me._InConversion = inConversion
            Me._InPlaceholder = inPlaceholder
            Me._OutConversion = outConversion
            Me._OutPlaceholder = outPlaceholder

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OriginalArgument As BoundExpression
        Public ReadOnly Property OriginalArgument As BoundExpression
            Get
                Return _OriginalArgument
            End Get
        End Property

        Private ReadOnly _InConversion As BoundExpression
        Public ReadOnly Property InConversion As BoundExpression
            Get
                Return _InConversion
            End Get
        End Property

        Private ReadOnly _InPlaceholder As BoundByRefArgumentPlaceholder
        Public ReadOnly Property InPlaceholder As BoundByRefArgumentPlaceholder
            Get
                Return _InPlaceholder
            End Get
        End Property

        Private ReadOnly _OutConversion As BoundExpression
        Public ReadOnly Property OutConversion As BoundExpression
            Get
                Return _OutConversion
            End Get
        End Property

        Private ReadOnly _OutPlaceholder As BoundRValuePlaceholder
        Public ReadOnly Property OutPlaceholder As BoundRValuePlaceholder
            Get
                Return _OutPlaceholder
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitByRefArgumentWithCopyBack(Me)
        End Function

        Public Function Update(originalArgument As BoundExpression, inConversion As BoundExpression, inPlaceholder As BoundByRefArgumentPlaceholder, outConversion As BoundExpression, outPlaceholder As BoundRValuePlaceholder, type As TypeSymbol) As BoundByRefArgumentWithCopyBack
            If originalArgument IsNot Me.OriginalArgument OrElse inConversion IsNot Me.InConversion OrElse inPlaceholder IsNot Me.InPlaceholder OrElse outConversion IsNot Me.OutConversion OrElse outPlaceholder IsNot Me.OutPlaceholder OrElse type IsNot Me.Type Then
                Dim result = New BoundByRefArgumentWithCopyBack(Me.Syntax, originalArgument, inConversion, inPlaceholder, outConversion, outPlaceholder, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLateBoundArgumentSupportingAssignmentWithCapture
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, originalArgument As BoundExpression, localSymbol As SynthesizedLocal, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.LateBoundArgumentSupportingAssignmentWithCapture, syntax, type, hasErrors OrElse originalArgument.NonNullAndHasErrors())

            Debug.Assert(originalArgument IsNot Nothing, "Field 'originalArgument' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(localSymbol IsNot Nothing, "Field 'localSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._OriginalArgument = originalArgument
            Me._LocalSymbol = localSymbol

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OriginalArgument As BoundExpression
        Public ReadOnly Property OriginalArgument As BoundExpression
            Get
                Return _OriginalArgument
            End Get
        End Property

        Private ReadOnly _LocalSymbol As SynthesizedLocal
        Public ReadOnly Property LocalSymbol As SynthesizedLocal
            Get
                Return _LocalSymbol
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLateBoundArgumentSupportingAssignmentWithCapture(Me)
        End Function

        Public Function Update(originalArgument As BoundExpression, localSymbol As SynthesizedLocal, type As TypeSymbol) As BoundLateBoundArgumentSupportingAssignmentWithCapture
            If originalArgument IsNot Me.OriginalArgument OrElse localSymbol IsNot Me.LocalSymbol OrElse type IsNot Me.Type Then
                Dim result = New BoundLateBoundArgumentSupportingAssignmentWithCapture(Me.Syntax, originalArgument, localSymbol, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLabelStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.LabelStatement, syntax, hasErrors)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol)
            MyBase.New(BoundKind.LabelStatement, syntax)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub


        Private ReadOnly _Label As LabelSymbol
        Public ReadOnly Property Label As LabelSymbol
            Get
                Return _Label
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLabelStatement(Me)
        End Function

        Public Function Update(label As LabelSymbol) As BoundLabelStatement
            If label IsNot Me.Label Then
                Dim result = New BoundLabelStatement(Me.Syntax, label, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLabel
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.Label, syntax, type, hasErrors)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol, type As TypeSymbol)
            MyBase.New(BoundKind.Label, syntax, type)

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
        End Sub


        Private ReadOnly _Label As LabelSymbol
        Public ReadOnly Property Label As LabelSymbol
            Get
                Return _Label
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLabel(Me)
        End Function

        Public Function Update(label As LabelSymbol, type As TypeSymbol) As BoundLabel
            If label IsNot Me.Label OrElse type IsNot Me.Type Then
                Dim result = New BoundLabel(Me.Syntax, label, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundGotoStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, label As LabelSymbol, labelExpressionOpt As BoundLabel, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.GotoStatement, syntax, hasErrors OrElse labelExpressionOpt.NonNullAndHasErrors())

            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Label = label
            Me._LabelExpressionOpt = labelExpressionOpt
        End Sub


        Private ReadOnly _Label As LabelSymbol
        Public ReadOnly Property Label As LabelSymbol
            Get
                Return _Label
            End Get
        End Property

        Private ReadOnly _LabelExpressionOpt As BoundLabel
        Public ReadOnly Property LabelExpressionOpt As BoundLabel
            Get
                Return _LabelExpressionOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitGotoStatement(Me)
        End Function

        Public Function Update(label As LabelSymbol, labelExpressionOpt As BoundLabel) As BoundGotoStatement
            If label IsNot Me.Label OrElse labelExpressionOpt IsNot Me.LabelExpressionOpt Then
                Dim result = New BoundGotoStatement(Me.Syntax, label, labelExpressionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundStatementList
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, statements As ImmutableArray(Of BoundStatement), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.StatementList, syntax, hasErrors OrElse statements.NonNullAndHasErrors())

            Debug.Assert(Not (statements.IsDefault), "Field 'statements' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Statements = statements
        End Sub


        Private ReadOnly _Statements As ImmutableArray(Of BoundStatement)
        Public ReadOnly Property Statements As ImmutableArray(Of BoundStatement)
            Get
                Return _Statements
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitStatementList(Me)
        End Function

        Public Function Update(statements As ImmutableArray(Of BoundStatement)) As BoundStatementList
            If statements <> Me.Statements Then
                Dim result = New BoundStatementList(Me.Syntax, statements, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundConditionalGoto
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, condition As BoundExpression, jumpIfTrue As Boolean, label As LabelSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ConditionalGoto, syntax, hasErrors OrElse condition.NonNullAndHasErrors())

            Debug.Assert(condition IsNot Nothing, "Field 'condition' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(label IsNot Nothing, "Field 'label' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Condition = condition
            Me._JumpIfTrue = jumpIfTrue
            Me._Label = label
        End Sub


        Private ReadOnly _Condition As BoundExpression
        Public ReadOnly Property Condition As BoundExpression
            Get
                Return _Condition
            End Get
        End Property

        Private ReadOnly _JumpIfTrue As Boolean
        Public ReadOnly Property JumpIfTrue As Boolean
            Get
                Return _JumpIfTrue
            End Get
        End Property

        Private ReadOnly _Label As LabelSymbol
        Public ReadOnly Property Label As LabelSymbol
            Get
                Return _Label
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitConditionalGoto(Me)
        End Function

        Public Function Update(condition As BoundExpression, jumpIfTrue As Boolean, label As LabelSymbol) As BoundConditionalGoto
            If condition IsNot Me.Condition OrElse jumpIfTrue <> Me.JumpIfTrue OrElse label IsNot Me.Label Then
                Dim result = New BoundConditionalGoto(Me.Syntax, condition, jumpIfTrue, label, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundWithStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, originalExpression As BoundExpression, body As BoundBlock, binder As WithBlockBinder, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.WithStatement, syntax, hasErrors OrElse originalExpression.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors())

            Debug.Assert(originalExpression IsNot Nothing, "Field 'originalExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._OriginalExpression = originalExpression
            Me._Body = body
            Me._Binder = binder
        End Sub


        Private ReadOnly _OriginalExpression As BoundExpression
        Public ReadOnly Property OriginalExpression As BoundExpression
            Get
                Return _OriginalExpression
            End Get
        End Property

        Private ReadOnly _Body As BoundBlock
        Public ReadOnly Property Body As BoundBlock
            Get
                Return _Body
            End Get
        End Property

        Private ReadOnly _Binder As WithBlockBinder
        Public ReadOnly Property Binder As WithBlockBinder
            Get
                Return _Binder
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitWithStatement(Me)
        End Function

        Public Function Update(originalExpression As BoundExpression, body As BoundBlock, binder As WithBlockBinder) As BoundWithStatement
            If originalExpression IsNot Me.OriginalExpression OrElse body IsNot Me.Body OrElse binder IsNot Me.Binder Then
                Dim result = New BoundWithStatement(Me.Syntax, originalExpression, body, binder, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class UnboundLambda
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, binder As Binder, flags As SourceMemberFlags, parameters As ImmutableArray(Of ParameterSymbol), returnType As TypeSymbol, bindingCache As UnboundLambda.UnboundLambdaBindingCache, hasErrors As Boolean)
            MyBase.New(BoundKind.UnboundLambda, syntax, Nothing, hasErrors)

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (parameters.IsDefault), "Field 'parameters' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(bindingCache IsNot Nothing, "Field 'bindingCache' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._Flags = flags
            Me._Parameters = parameters
            Me._ReturnType = returnType
            Me._BindingCache = bindingCache

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, binder As Binder, flags As SourceMemberFlags, parameters As ImmutableArray(Of ParameterSymbol), returnType As TypeSymbol, bindingCache As UnboundLambda.UnboundLambdaBindingCache)
            MyBase.New(BoundKind.UnboundLambda, syntax, Nothing)

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (parameters.IsDefault), "Field 'parameters' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(bindingCache IsNot Nothing, "Field 'bindingCache' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._Flags = flags
            Me._Parameters = parameters
            Me._ReturnType = returnType
            Me._BindingCache = bindingCache

            Validate()
        End Sub


        Private ReadOnly _Binder As Binder
        Public ReadOnly Property Binder As Binder
            Get
                Return _Binder
            End Get
        End Property

        Private ReadOnly _Flags As SourceMemberFlags
        Public ReadOnly Property Flags As SourceMemberFlags
            Get
                Return _Flags
            End Get
        End Property

        Private ReadOnly _Parameters As ImmutableArray(Of ParameterSymbol)
        Public ReadOnly Property Parameters As ImmutableArray(Of ParameterSymbol)
            Get
                Return _Parameters
            End Get
        End Property

        Private ReadOnly _ReturnType As TypeSymbol
        Public ReadOnly Property ReturnType As TypeSymbol
            Get
                Return _ReturnType
            End Get
        End Property

        Private ReadOnly _BindingCache As UnboundLambda.UnboundLambdaBindingCache
        Public ReadOnly Property BindingCache As UnboundLambda.UnboundLambdaBindingCache
            Get
                Return _BindingCache
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUnboundLambda(Me)
        End Function

        Public Function Update(binder As Binder, flags As SourceMemberFlags, parameters As ImmutableArray(Of ParameterSymbol), returnType As TypeSymbol, bindingCache As UnboundLambda.UnboundLambdaBindingCache) As UnboundLambda
            If binder IsNot Me.Binder OrElse flags <> Me.Flags OrElse parameters <> Me.Parameters OrElse returnType IsNot Me.ReturnType OrElse bindingCache IsNot Me.BindingCache Then
                Dim result = New UnboundLambda(Me.Syntax, binder, flags, parameters, returnType, bindingCache, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLambda
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, lambdaSymbol As LambdaSymbol, body As BoundBlock, diagnostics As ReadOnlyBindingDiagnostic(Of AssemblySymbol), lambdaBinderOpt As LambdaBodyBinder, delegateRelaxation As ConversionKind, methodConversionKind As MethodConversionKind, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Lambda, syntax, Nothing, hasErrors OrElse body.NonNullAndHasErrors())

            Debug.Assert(lambdaSymbol IsNot Nothing, "Field 'lambdaSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LambdaSymbol = lambdaSymbol
            Me._Body = body
            Me._Diagnostics = diagnostics
            Me._LambdaBinderOpt = lambdaBinderOpt
            Me._DelegateRelaxation = delegateRelaxation
            Me._MethodConversionKind = methodConversionKind

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _LambdaSymbol As LambdaSymbol
        Public ReadOnly Property LambdaSymbol As LambdaSymbol
            Get
                Return _LambdaSymbol
            End Get
        End Property

        Private ReadOnly _Body As BoundBlock
        Public ReadOnly Property Body As BoundBlock
            Get
                Return _Body
            End Get
        End Property

        Private ReadOnly _Diagnostics As ReadOnlyBindingDiagnostic(Of AssemblySymbol)
        Public ReadOnly Property Diagnostics As ReadOnlyBindingDiagnostic(Of AssemblySymbol)
            Get
                Return _Diagnostics
            End Get
        End Property

        Private ReadOnly _LambdaBinderOpt As LambdaBodyBinder
        Public ReadOnly Property LambdaBinderOpt As LambdaBodyBinder
            Get
                Return _LambdaBinderOpt
            End Get
        End Property

        Private ReadOnly _DelegateRelaxation As ConversionKind
        Public ReadOnly Property DelegateRelaxation As ConversionKind
            Get
                Return _DelegateRelaxation
            End Get
        End Property

        Private ReadOnly _MethodConversionKind As MethodConversionKind
        Public ReadOnly Property MethodConversionKind As MethodConversionKind
            Get
                Return _MethodConversionKind
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLambda(Me)
        End Function

        Public Function Update(lambdaSymbol As LambdaSymbol, body As BoundBlock, diagnostics As ReadOnlyBindingDiagnostic(Of AssemblySymbol), lambdaBinderOpt As LambdaBodyBinder, delegateRelaxation As ConversionKind, methodConversionKind As MethodConversionKind) As BoundLambda
            If lambdaSymbol IsNot Me.LambdaSymbol OrElse body IsNot Me.Body OrElse diagnostics <> Me.Diagnostics OrElse lambdaBinderOpt IsNot Me.LambdaBinderOpt OrElse delegateRelaxation <> Me.DelegateRelaxation OrElse methodConversionKind <> Me.MethodConversionKind Then
                Dim result = New BoundLambda(Me.Syntax, lambdaSymbol, body, diagnostics, lambdaBinderOpt, delegateRelaxation, methodConversionKind, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundQueryExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, lastOperator As BoundQueryClauseBase, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.QueryExpression, syntax, type, hasErrors OrElse lastOperator.NonNullAndHasErrors())

            Debug.Assert(lastOperator IsNot Nothing, "Field 'lastOperator' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LastOperator = lastOperator
        End Sub


        Private ReadOnly _LastOperator As BoundQueryClauseBase
        Public ReadOnly Property LastOperator As BoundQueryClauseBase
            Get
                Return _LastOperator
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitQueryExpression(Me)
        End Function

        Public Function Update(lastOperator As BoundQueryClauseBase, type As TypeSymbol) As BoundQueryExpression
            If lastOperator IsNot Me.LastOperator OrElse type IsNot Me.Type Then
                Dim result = New BoundQueryExpression(Me.Syntax, lastOperator, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundQueryPart
        Inherits BoundExpression

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, type As TypeSymbol)
            MyBase.New(kind, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub

    End Class

    Partial Friend NotInheritable Class BoundQuerySource
        Inherits BoundQueryPart

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.QuerySource, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitQuerySource(Me)
        End Function

        Public Function Update(expression As BoundExpression, type As TypeSymbol) As BoundQuerySource
            If expression IsNot Me.Expression OrElse type IsNot Me.Type Then
                Dim result = New BoundQuerySource(Me.Syntax, expression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundToQueryableCollectionConversion
        Inherits BoundQueryPart

        Public Sub New(syntax As SyntaxNode, conversionCall As BoundCall, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ToQueryableCollectionConversion, syntax, type, hasErrors OrElse conversionCall.NonNullAndHasErrors())

            Debug.Assert(conversionCall IsNot Nothing, "Field 'conversionCall' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ConversionCall = conversionCall
        End Sub


        Private ReadOnly _ConversionCall As BoundCall
        Public ReadOnly Property ConversionCall As BoundCall
            Get
                Return _ConversionCall
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitToQueryableCollectionConversion(Me)
        End Function

        Public Function Update(conversionCall As BoundCall, type As TypeSymbol) As BoundToQueryableCollectionConversion
            If conversionCall IsNot Me.ConversionCall OrElse type IsNot Me.Type Then
                Dim result = New BoundToQueryableCollectionConversion(Me.Syntax, conversionCall, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundQueryClauseBase
        Inherits BoundQueryPart

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(kind, syntax, type, hasErrors)

            Debug.Assert(Not (rangeVariables.IsDefault), "Field 'rangeVariables' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(compoundVariableType IsNot Nothing, "Field 'compoundVariableType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (binders.IsDefault), "Field 'binders' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._RangeVariables = rangeVariables
            Me._CompoundVariableType = compoundVariableType
            Me._Binders = binders
        End Sub

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol)
            MyBase.New(kind, syntax, type)

            Debug.Assert(Not (rangeVariables.IsDefault), "Field 'rangeVariables' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(compoundVariableType IsNot Nothing, "Field 'compoundVariableType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (binders.IsDefault), "Field 'binders' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._RangeVariables = rangeVariables
            Me._CompoundVariableType = compoundVariableType
            Me._Binders = binders
        End Sub


        Private ReadOnly _RangeVariables As ImmutableArray(Of RangeVariableSymbol)
        Public ReadOnly Property RangeVariables As ImmutableArray(Of RangeVariableSymbol)
            Get
                Return _RangeVariables
            End Get
        End Property

        Private ReadOnly _CompoundVariableType As TypeSymbol
        Public ReadOnly Property CompoundVariableType As TypeSymbol
            Get
                Return _CompoundVariableType
            End Get
        End Property

        Private ReadOnly _Binders As ImmutableArray(Of Binder)
        Public ReadOnly Property Binders As ImmutableArray(Of Binder)
            Get
                Return _Binders
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundQueryableSource
        Inherits BoundQueryClauseBase

        Public Sub New(syntax As SyntaxNode, source As BoundQueryPart, rangeVariableOpt As RangeVariableSymbol, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.QueryableSource, syntax, rangeVariables, compoundVariableType, binders, type, hasErrors OrElse source.NonNullAndHasErrors())

            Debug.Assert(source IsNot Nothing, "Field 'source' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (rangeVariables.IsDefault), "Field 'rangeVariables' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(compoundVariableType IsNot Nothing, "Field 'compoundVariableType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (binders.IsDefault), "Field 'binders' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Source = source
            Me._RangeVariableOpt = rangeVariableOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Source As BoundQueryPart
        Public ReadOnly Property Source As BoundQueryPart
            Get
                Return _Source
            End Get
        End Property

        Private ReadOnly _RangeVariableOpt As RangeVariableSymbol
        Public ReadOnly Property RangeVariableOpt As RangeVariableSymbol
            Get
                Return _RangeVariableOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitQueryableSource(Me)
        End Function

        Public Function Update(source As BoundQueryPart, rangeVariableOpt As RangeVariableSymbol, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol) As BoundQueryableSource
            If source IsNot Me.Source OrElse rangeVariableOpt IsNot Me.RangeVariableOpt OrElse rangeVariables <> Me.RangeVariables OrElse compoundVariableType IsNot Me.CompoundVariableType OrElse binders <> Me.Binders OrElse type IsNot Me.Type Then
                Dim result = New BoundQueryableSource(Me.Syntax, source, rangeVariableOpt, rangeVariables, compoundVariableType, binders, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundQueryClause
        Inherits BoundQueryClauseBase

        Public Sub New(syntax As SyntaxNode, underlyingExpression As BoundExpression, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.QueryClause, syntax, rangeVariables, compoundVariableType, binders, type, hasErrors OrElse underlyingExpression.NonNullAndHasErrors())

            Debug.Assert(underlyingExpression IsNot Nothing, "Field 'underlyingExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (rangeVariables.IsDefault), "Field 'rangeVariables' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(compoundVariableType IsNot Nothing, "Field 'compoundVariableType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (binders.IsDefault), "Field 'binders' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._UnderlyingExpression = underlyingExpression
        End Sub


        Private ReadOnly _UnderlyingExpression As BoundExpression
        Public ReadOnly Property UnderlyingExpression As BoundExpression
            Get
                Return _UnderlyingExpression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitQueryClause(Me)
        End Function

        Public Function Update(underlyingExpression As BoundExpression, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol) As BoundQueryClause
            If underlyingExpression IsNot Me.UnderlyingExpression OrElse rangeVariables <> Me.RangeVariables OrElse compoundVariableType IsNot Me.CompoundVariableType OrElse binders <> Me.Binders OrElse type IsNot Me.Type Then
                Dim result = New BoundQueryClause(Me.Syntax, underlyingExpression, rangeVariables, compoundVariableType, binders, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundOrdering
        Inherits BoundQueryPart

        Public Sub New(syntax As SyntaxNode, underlyingExpression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Ordering, syntax, type, hasErrors OrElse underlyingExpression.NonNullAndHasErrors())

            Debug.Assert(underlyingExpression IsNot Nothing, "Field 'underlyingExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._UnderlyingExpression = underlyingExpression
        End Sub


        Private ReadOnly _UnderlyingExpression As BoundExpression
        Public ReadOnly Property UnderlyingExpression As BoundExpression
            Get
                Return _UnderlyingExpression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitOrdering(Me)
        End Function

        Public Function Update(underlyingExpression As BoundExpression, type As TypeSymbol) As BoundOrdering
            If underlyingExpression IsNot Me.UnderlyingExpression OrElse type IsNot Me.Type Then
                Dim result = New BoundOrdering(Me.Syntax, underlyingExpression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundQueryLambda
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, lambdaSymbol As SynthesizedLambdaSymbol, rangeVariables As ImmutableArray(Of RangeVariableSymbol), expression As BoundExpression, exprIsOperandOfConditionalBranch As Boolean, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.QueryLambda, syntax, Nothing, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(lambdaSymbol IsNot Nothing, "Field 'lambdaSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (rangeVariables.IsDefault), "Field 'rangeVariables' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LambdaSymbol = lambdaSymbol
            Me._RangeVariables = rangeVariables
            Me._Expression = expression
            Me._ExprIsOperandOfConditionalBranch = exprIsOperandOfConditionalBranch
        End Sub


        Private ReadOnly _LambdaSymbol As SynthesizedLambdaSymbol
        Public ReadOnly Property LambdaSymbol As SynthesizedLambdaSymbol
            Get
                Return _LambdaSymbol
            End Get
        End Property

        Private ReadOnly _RangeVariables As ImmutableArray(Of RangeVariableSymbol)
        Public ReadOnly Property RangeVariables As ImmutableArray(Of RangeVariableSymbol)
            Get
                Return _RangeVariables
            End Get
        End Property

        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        Private ReadOnly _ExprIsOperandOfConditionalBranch As Boolean
        Public ReadOnly Property ExprIsOperandOfConditionalBranch As Boolean
            Get
                Return _ExprIsOperandOfConditionalBranch
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitQueryLambda(Me)
        End Function

        Public Function Update(lambdaSymbol As SynthesizedLambdaSymbol, rangeVariables As ImmutableArray(Of RangeVariableSymbol), expression As BoundExpression, exprIsOperandOfConditionalBranch As Boolean) As BoundQueryLambda
            If lambdaSymbol IsNot Me.LambdaSymbol OrElse rangeVariables <> Me.RangeVariables OrElse expression IsNot Me.Expression OrElse exprIsOperandOfConditionalBranch <> Me.ExprIsOperandOfConditionalBranch Then
                Dim result = New BoundQueryLambda(Me.Syntax, lambdaSymbol, rangeVariables, expression, exprIsOperandOfConditionalBranch, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRangeVariableAssignment
        Inherits BoundQueryPart

        Public Sub New(syntax As SyntaxNode, rangeVariable As RangeVariableSymbol, value As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RangeVariableAssignment, syntax, type, hasErrors OrElse value.NonNullAndHasErrors())

            Debug.Assert(rangeVariable IsNot Nothing, "Field 'rangeVariable' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._RangeVariable = rangeVariable
            Me._Value = value
        End Sub


        Private ReadOnly _RangeVariable As RangeVariableSymbol
        Public ReadOnly Property RangeVariable As RangeVariableSymbol
            Get
                Return _RangeVariable
            End Get
        End Property

        Private ReadOnly _Value As BoundExpression
        Public ReadOnly Property Value As BoundExpression
            Get
                Return _Value
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRangeVariableAssignment(Me)
        End Function

        Public Function Update(rangeVariable As RangeVariableSymbol, value As BoundExpression, type As TypeSymbol) As BoundRangeVariableAssignment
            If rangeVariable IsNot Me.RangeVariable OrElse value IsNot Me.Value OrElse type IsNot Me.Type Then
                Dim result = New BoundRangeVariableAssignment(Me.Syntax, rangeVariable, value, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class GroupTypeInferenceLambda
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, binder As Binder, parameters As ImmutableArray(Of ParameterSymbol), compilation As VisualBasicCompilation, hasErrors As Boolean)
            MyBase.New(BoundKind.GroupTypeInferenceLambda, syntax, Nothing, hasErrors)

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (parameters.IsDefault), "Field 'parameters' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(compilation IsNot Nothing, "Field 'compilation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._Parameters = parameters
            Me._Compilation = compilation
        End Sub

        Public Sub New(syntax As SyntaxNode, binder As Binder, parameters As ImmutableArray(Of ParameterSymbol), compilation As VisualBasicCompilation)
            MyBase.New(BoundKind.GroupTypeInferenceLambda, syntax, Nothing)

            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (parameters.IsDefault), "Field 'parameters' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(compilation IsNot Nothing, "Field 'compilation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Binder = binder
            Me._Parameters = parameters
            Me._Compilation = compilation
        End Sub


        Private ReadOnly _Binder As Binder
        Public ReadOnly Property Binder As Binder
            Get
                Return _Binder
            End Get
        End Property

        Private ReadOnly _Parameters As ImmutableArray(Of ParameterSymbol)
        Public ReadOnly Property Parameters As ImmutableArray(Of ParameterSymbol)
            Get
                Return _Parameters
            End Get
        End Property

        Private ReadOnly _Compilation As VisualBasicCompilation
        Public ReadOnly Property Compilation As VisualBasicCompilation
            Get
                Return _Compilation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitGroupTypeInferenceLambda(Me)
        End Function

        Public Function Update(binder As Binder, parameters As ImmutableArray(Of ParameterSymbol), compilation As VisualBasicCompilation) As GroupTypeInferenceLambda
            If binder IsNot Me.Binder OrElse parameters <> Me.Parameters OrElse compilation IsNot Me.Compilation Then
                Dim result = New GroupTypeInferenceLambda(Me.Syntax, binder, parameters, compilation, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAggregateClause
        Inherits BoundQueryClauseBase

        Public Sub New(syntax As SyntaxNode, capturedGroupOpt As BoundQueryClauseBase, groupPlaceholderOpt As BoundRValuePlaceholder, underlyingExpression As BoundExpression, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AggregateClause, syntax, rangeVariables, compoundVariableType, binders, type, hasErrors OrElse capturedGroupOpt.NonNullAndHasErrors() OrElse groupPlaceholderOpt.NonNullAndHasErrors() OrElse underlyingExpression.NonNullAndHasErrors())

            Debug.Assert(underlyingExpression IsNot Nothing, "Field 'underlyingExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (rangeVariables.IsDefault), "Field 'rangeVariables' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(compoundVariableType IsNot Nothing, "Field 'compoundVariableType' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (binders.IsDefault), "Field 'binders' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._CapturedGroupOpt = capturedGroupOpt
            Me._GroupPlaceholderOpt = groupPlaceholderOpt
            Me._UnderlyingExpression = underlyingExpression
        End Sub


        Private ReadOnly _CapturedGroupOpt As BoundQueryClauseBase
        Public ReadOnly Property CapturedGroupOpt As BoundQueryClauseBase
            Get
                Return _CapturedGroupOpt
            End Get
        End Property

        Private ReadOnly _GroupPlaceholderOpt As BoundRValuePlaceholder
        Public ReadOnly Property GroupPlaceholderOpt As BoundRValuePlaceholder
            Get
                Return _GroupPlaceholderOpt
            End Get
        End Property

        Private ReadOnly _UnderlyingExpression As BoundExpression
        Public ReadOnly Property UnderlyingExpression As BoundExpression
            Get
                Return _UnderlyingExpression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAggregateClause(Me)
        End Function

        Public Function Update(capturedGroupOpt As BoundQueryClauseBase, groupPlaceholderOpt As BoundRValuePlaceholder, underlyingExpression As BoundExpression, rangeVariables As ImmutableArray(Of RangeVariableSymbol), compoundVariableType As TypeSymbol, binders As ImmutableArray(Of Binder), type As TypeSymbol) As BoundAggregateClause
            If capturedGroupOpt IsNot Me.CapturedGroupOpt OrElse groupPlaceholderOpt IsNot Me.GroupPlaceholderOpt OrElse underlyingExpression IsNot Me.UnderlyingExpression OrElse rangeVariables <> Me.RangeVariables OrElse compoundVariableType IsNot Me.CompoundVariableType OrElse binders <> Me.Binders OrElse type IsNot Me.Type Then
                Dim result = New BoundAggregateClause(Me.Syntax, capturedGroupOpt, groupPlaceholderOpt, underlyingExpression, rangeVariables, compoundVariableType, binders, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundGroupAggregation
        Inherits BoundQueryPart

        Public Sub New(syntax As SyntaxNode, group As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.GroupAggregation, syntax, type, hasErrors OrElse group.NonNullAndHasErrors())

            Debug.Assert(group IsNot Nothing, "Field 'group' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Group = group
        End Sub


        Private ReadOnly _Group As BoundExpression
        Public ReadOnly Property Group As BoundExpression
            Get
                Return _Group
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitGroupAggregation(Me)
        End Function

        Public Function Update(group As BoundExpression, type As TypeSymbol) As BoundGroupAggregation
            If group IsNot Me.Group OrElse type IsNot Me.Type Then
                Dim result = New BoundGroupAggregation(Me.Syntax, group, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRangeVariable
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, rangeVariable As RangeVariableSymbol, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.RangeVariable, syntax, type, hasErrors)

            Debug.Assert(rangeVariable IsNot Nothing, "Field 'rangeVariable' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._RangeVariable = rangeVariable
        End Sub

        Public Sub New(syntax As SyntaxNode, rangeVariable As RangeVariableSymbol, type As TypeSymbol)
            MyBase.New(BoundKind.RangeVariable, syntax, type)

            Debug.Assert(rangeVariable IsNot Nothing, "Field 'rangeVariable' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._RangeVariable = rangeVariable
        End Sub


        Private ReadOnly _RangeVariable As RangeVariableSymbol
        Public ReadOnly Property RangeVariable As RangeVariableSymbol
            Get
                Return _RangeVariable
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRangeVariable(Me)
        End Function

        Public Function Update(rangeVariable As RangeVariableSymbol, type As TypeSymbol) As BoundRangeVariable
            If rangeVariable IsNot Me.RangeVariable OrElse type IsNot Me.Type Then
                Dim result = New BoundRangeVariable(Me.Syntax, rangeVariable, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend MustInherit Class BoundAddRemoveHandlerStatement
        Inherits BoundStatement

        Protected Sub New(kind As BoundKind, syntax as SyntaxNode, eventAccess As BoundExpression, handler As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(kind, syntax, hasErrors)

            Debug.Assert(eventAccess IsNot Nothing, "Field 'eventAccess' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(handler IsNot Nothing, "Field 'handler' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._EventAccess = eventAccess
            Me._Handler = handler
        End Sub


        Private ReadOnly _EventAccess As BoundExpression
        Public ReadOnly Property EventAccess As BoundExpression
            Get
                Return _EventAccess
            End Get
        End Property

        Private ReadOnly _Handler As BoundExpression
        Public ReadOnly Property Handler As BoundExpression
            Get
                Return _Handler
            End Get
        End Property
    End Class

    Partial Friend NotInheritable Class BoundAddHandlerStatement
        Inherits BoundAddRemoveHandlerStatement

        Public Sub New(syntax As SyntaxNode, eventAccess As BoundExpression, handler As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AddHandlerStatement, syntax, eventAccess, handler, hasErrors OrElse eventAccess.NonNullAndHasErrors() OrElse handler.NonNullAndHasErrors())

            Debug.Assert(eventAccess IsNot Nothing, "Field 'eventAccess' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(handler IsNot Nothing, "Field 'handler' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAddHandlerStatement(Me)
        End Function

        Public Function Update(eventAccess As BoundExpression, handler As BoundExpression) As BoundAddHandlerStatement
            If eventAccess IsNot Me.EventAccess OrElse handler IsNot Me.Handler Then
                Dim result = New BoundAddHandlerStatement(Me.Syntax, eventAccess, handler, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRemoveHandlerStatement
        Inherits BoundAddRemoveHandlerStatement

        Public Sub New(syntax As SyntaxNode, eventAccess As BoundExpression, handler As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RemoveHandlerStatement, syntax, eventAccess, handler, hasErrors OrElse eventAccess.NonNullAndHasErrors() OrElse handler.NonNullAndHasErrors())

            Debug.Assert(eventAccess IsNot Nothing, "Field 'eventAccess' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(handler IsNot Nothing, "Field 'handler' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRemoveHandlerStatement(Me)
        End Function

        Public Function Update(eventAccess As BoundExpression, handler As BoundExpression) As BoundRemoveHandlerStatement
            If eventAccess IsNot Me.EventAccess OrElse handler IsNot Me.Handler Then
                Dim result = New BoundRemoveHandlerStatement(Me.Syntax, eventAccess, handler, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundRaiseEventStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, eventSymbol As EventSymbol, eventInvocation As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.RaiseEventStatement, syntax, hasErrors OrElse eventInvocation.NonNullAndHasErrors())

            Debug.Assert(eventSymbol IsNot Nothing, "Field 'eventSymbol' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(eventInvocation IsNot Nothing, "Field 'eventInvocation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._EventSymbol = eventSymbol
            Me._EventInvocation = eventInvocation
        End Sub


        Private ReadOnly _EventSymbol As EventSymbol
        Public ReadOnly Property EventSymbol As EventSymbol
            Get
                Return _EventSymbol
            End Get
        End Property

        Private ReadOnly _EventInvocation As BoundExpression
        Public ReadOnly Property EventInvocation As BoundExpression
            Get
                Return _EventInvocation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitRaiseEventStatement(Me)
        End Function

        Public Function Update(eventSymbol As EventSymbol, eventInvocation As BoundExpression) As BoundRaiseEventStatement
            If eventSymbol IsNot Me.EventSymbol OrElse eventInvocation IsNot Me.EventInvocation Then
                Dim result = New BoundRaiseEventStatement(Me.Syntax, eventSymbol, eventInvocation, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUsingStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, resourceList As ImmutableArray(Of BoundLocalDeclarationBase), resourceExpressionOpt As BoundExpression, body As BoundBlock, usingInfo As UsingInfo, locals As ImmutableArray(Of LocalSymbol), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UsingStatement, syntax, hasErrors OrElse resourceList.NonNullAndHasErrors() OrElse resourceExpressionOpt.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors())

            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(usingInfo IsNot Nothing, "Field 'usingInfo' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (locals.IsDefault), "Field 'locals' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ResourceList = resourceList
            Me._ResourceExpressionOpt = resourceExpressionOpt
            Me._Body = body
            Me._UsingInfo = usingInfo
            Me._Locals = locals
        End Sub


        Private ReadOnly _ResourceList As ImmutableArray(Of BoundLocalDeclarationBase)
        Public ReadOnly Property ResourceList As ImmutableArray(Of BoundLocalDeclarationBase)
            Get
                Return _ResourceList
            End Get
        End Property

        Private ReadOnly _ResourceExpressionOpt As BoundExpression
        Public ReadOnly Property ResourceExpressionOpt As BoundExpression
            Get
                Return _ResourceExpressionOpt
            End Get
        End Property

        Private ReadOnly _Body As BoundBlock
        Public ReadOnly Property Body As BoundBlock
            Get
                Return _Body
            End Get
        End Property

        Private ReadOnly _UsingInfo As UsingInfo
        Public ReadOnly Property UsingInfo As UsingInfo
            Get
                Return _UsingInfo
            End Get
        End Property

        Private ReadOnly _Locals As ImmutableArray(Of LocalSymbol)
        Public ReadOnly Property Locals As ImmutableArray(Of LocalSymbol)
            Get
                Return _Locals
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUsingStatement(Me)
        End Function

        Public Function Update(resourceList As ImmutableArray(Of BoundLocalDeclarationBase), resourceExpressionOpt As BoundExpression, body As BoundBlock, usingInfo As UsingInfo, locals As ImmutableArray(Of LocalSymbol)) As BoundUsingStatement
            If resourceList <> Me.ResourceList OrElse resourceExpressionOpt IsNot Me.ResourceExpressionOpt OrElse body IsNot Me.Body OrElse usingInfo IsNot Me.UsingInfo OrElse locals <> Me.Locals Then
                Dim result = New BoundUsingStatement(Me.Syntax, resourceList, resourceExpressionOpt, body, usingInfo, locals, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundSyncLockStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, lockExpression As BoundExpression, body As BoundBlock, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.SyncLockStatement, syntax, hasErrors OrElse lockExpression.NonNullAndHasErrors() OrElse body.NonNullAndHasErrors())

            Debug.Assert(lockExpression IsNot Nothing, "Field 'lockExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._LockExpression = lockExpression
            Me._Body = body
        End Sub


        Private ReadOnly _LockExpression As BoundExpression
        Public ReadOnly Property LockExpression As BoundExpression
            Get
                Return _LockExpression
            End Get
        End Property

        Private ReadOnly _Body As BoundBlock
        Public ReadOnly Property Body As BoundBlock
            Get
                Return _Body
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSyncLockStatement(Me)
        End Function

        Public Function Update(lockExpression As BoundExpression, body As BoundBlock) As BoundSyncLockStatement
            If lockExpression IsNot Me.LockExpression OrElse body IsNot Me.Body Then
                Dim result = New BoundSyncLockStatement(Me.Syntax, lockExpression, body, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlName
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, xmlNamespace As BoundExpression, localName As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlName, syntax, type, hasErrors OrElse xmlNamespace.NonNullAndHasErrors() OrElse localName.NonNullAndHasErrors() OrElse objectCreation.NonNullAndHasErrors())

            Debug.Assert(xmlNamespace IsNot Nothing, "Field 'xmlNamespace' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(localName IsNot Nothing, "Field 'localName' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(objectCreation IsNot Nothing, "Field 'objectCreation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._XmlNamespace = xmlNamespace
            Me._LocalName = localName
            Me._ObjectCreation = objectCreation
        End Sub


        Private ReadOnly _XmlNamespace As BoundExpression
        Public ReadOnly Property XmlNamespace As BoundExpression
            Get
                Return _XmlNamespace
            End Get
        End Property

        Private ReadOnly _LocalName As BoundExpression
        Public ReadOnly Property LocalName As BoundExpression
            Get
                Return _LocalName
            End Get
        End Property

        Private ReadOnly _ObjectCreation As BoundExpression
        Public ReadOnly Property ObjectCreation As BoundExpression
            Get
                Return _ObjectCreation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlName(Me)
        End Function

        Public Function Update(xmlNamespace As BoundExpression, localName As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol) As BoundXmlName
            If xmlNamespace IsNot Me.XmlNamespace OrElse localName IsNot Me.LocalName OrElse objectCreation IsNot Me.ObjectCreation OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlName(Me.Syntax, xmlNamespace, localName, objectCreation, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlNamespace
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, xmlNamespace As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlNamespace, syntax, type, hasErrors OrElse xmlNamespace.NonNullAndHasErrors() OrElse objectCreation.NonNullAndHasErrors())

            Debug.Assert(xmlNamespace IsNot Nothing, "Field 'xmlNamespace' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(objectCreation IsNot Nothing, "Field 'objectCreation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._XmlNamespace = xmlNamespace
            Me._ObjectCreation = objectCreation
        End Sub


        Private ReadOnly _XmlNamespace As BoundExpression
        Public ReadOnly Property XmlNamespace As BoundExpression
            Get
                Return _XmlNamespace
            End Get
        End Property

        Private ReadOnly _ObjectCreation As BoundExpression
        Public ReadOnly Property ObjectCreation As BoundExpression
            Get
                Return _ObjectCreation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlNamespace(Me)
        End Function

        Public Function Update(xmlNamespace As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol) As BoundXmlNamespace
            If xmlNamespace IsNot Me.XmlNamespace OrElse objectCreation IsNot Me.ObjectCreation OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlNamespace(Me.Syntax, xmlNamespace, objectCreation, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlDocument
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, declaration As BoundExpression, childNodes As ImmutableArray(Of BoundExpression), rewriterInfo As BoundXmlContainerRewriterInfo, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlDocument, syntax, type, hasErrors OrElse declaration.NonNullAndHasErrors() OrElse childNodes.NonNullAndHasErrors())

            Debug.Assert(declaration IsNot Nothing, "Field 'declaration' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (childNodes.IsDefault), "Field 'childNodes' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(rewriterInfo IsNot Nothing, "Field 'rewriterInfo' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Declaration = declaration
            Me._ChildNodes = childNodes
            Me._RewriterInfo = rewriterInfo
        End Sub


        Private ReadOnly _Declaration As BoundExpression
        Public ReadOnly Property Declaration As BoundExpression
            Get
                Return _Declaration
            End Get
        End Property

        Private ReadOnly _ChildNodes As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property ChildNodes As ImmutableArray(Of BoundExpression)
            Get
                Return _ChildNodes
            End Get
        End Property

        Private ReadOnly _RewriterInfo As BoundXmlContainerRewriterInfo
        Public ReadOnly Property RewriterInfo As BoundXmlContainerRewriterInfo
            Get
                Return _RewriterInfo
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlDocument(Me)
        End Function

        Public Function Update(declaration As BoundExpression, childNodes As ImmutableArray(Of BoundExpression), rewriterInfo As BoundXmlContainerRewriterInfo, type As TypeSymbol) As BoundXmlDocument
            If declaration IsNot Me.Declaration OrElse childNodes <> Me.ChildNodes OrElse rewriterInfo IsNot Me.RewriterInfo OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlDocument(Me.Syntax, declaration, childNodes, rewriterInfo, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlDeclaration
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, version As BoundExpression, encoding As BoundExpression, standalone As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlDeclaration, syntax, type, hasErrors OrElse version.NonNullAndHasErrors() OrElse encoding.NonNullAndHasErrors() OrElse standalone.NonNullAndHasErrors() OrElse objectCreation.NonNullAndHasErrors())

            Debug.Assert(objectCreation IsNot Nothing, "Field 'objectCreation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Version = version
            Me._Encoding = encoding
            Me._Standalone = standalone
            Me._ObjectCreation = objectCreation
        End Sub


        Private ReadOnly _Version As BoundExpression
        Public ReadOnly Property Version As BoundExpression
            Get
                Return _Version
            End Get
        End Property

        Private ReadOnly _Encoding As BoundExpression
        Public ReadOnly Property Encoding As BoundExpression
            Get
                Return _Encoding
            End Get
        End Property

        Private ReadOnly _Standalone As BoundExpression
        Public ReadOnly Property Standalone As BoundExpression
            Get
                Return _Standalone
            End Get
        End Property

        Private ReadOnly _ObjectCreation As BoundExpression
        Public ReadOnly Property ObjectCreation As BoundExpression
            Get
                Return _ObjectCreation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlDeclaration(Me)
        End Function

        Public Function Update(version As BoundExpression, encoding As BoundExpression, standalone As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol) As BoundXmlDeclaration
            If version IsNot Me.Version OrElse encoding IsNot Me.Encoding OrElse standalone IsNot Me.Standalone OrElse objectCreation IsNot Me.ObjectCreation OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlDeclaration(Me.Syntax, version, encoding, standalone, objectCreation, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlProcessingInstruction
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, target As BoundExpression, data As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlProcessingInstruction, syntax, type, hasErrors OrElse target.NonNullAndHasErrors() OrElse data.NonNullAndHasErrors() OrElse objectCreation.NonNullAndHasErrors())

            Debug.Assert(target IsNot Nothing, "Field 'target' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(data IsNot Nothing, "Field 'data' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(objectCreation IsNot Nothing, "Field 'objectCreation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Target = target
            Me._Data = data
            Me._ObjectCreation = objectCreation
        End Sub


        Private ReadOnly _Target As BoundExpression
        Public ReadOnly Property Target As BoundExpression
            Get
                Return _Target
            End Get
        End Property

        Private ReadOnly _Data As BoundExpression
        Public ReadOnly Property Data As BoundExpression
            Get
                Return _Data
            End Get
        End Property

        Private ReadOnly _ObjectCreation As BoundExpression
        Public ReadOnly Property ObjectCreation As BoundExpression
            Get
                Return _ObjectCreation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlProcessingInstruction(Me)
        End Function

        Public Function Update(target As BoundExpression, data As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol) As BoundXmlProcessingInstruction
            If target IsNot Me.Target OrElse data IsNot Me.Data OrElse objectCreation IsNot Me.ObjectCreation OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlProcessingInstruction(Me.Syntax, target, data, objectCreation, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlComment
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, value As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlComment, syntax, type, hasErrors OrElse value.NonNullAndHasErrors() OrElse objectCreation.NonNullAndHasErrors())

            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(objectCreation IsNot Nothing, "Field 'objectCreation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Value = value
            Me._ObjectCreation = objectCreation
        End Sub


        Private ReadOnly _Value As BoundExpression
        Public ReadOnly Property Value As BoundExpression
            Get
                Return _Value
            End Get
        End Property

        Private ReadOnly _ObjectCreation As BoundExpression
        Public ReadOnly Property ObjectCreation As BoundExpression
            Get
                Return _ObjectCreation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlComment(Me)
        End Function

        Public Function Update(value As BoundExpression, objectCreation As BoundExpression, type As TypeSymbol) As BoundXmlComment
            If value IsNot Me.Value OrElse objectCreation IsNot Me.ObjectCreation OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlComment(Me.Syntax, value, objectCreation, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlAttribute
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, name As BoundExpression, value As BoundExpression, matchesImport As Boolean, objectCreation As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlAttribute, syntax, type, hasErrors OrElse name.NonNullAndHasErrors() OrElse value.NonNullAndHasErrors() OrElse objectCreation.NonNullAndHasErrors())

            Debug.Assert(name IsNot Nothing, "Field 'name' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(objectCreation IsNot Nothing, "Field 'objectCreation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Name = name
            Me._Value = value
            Me._MatchesImport = matchesImport
            Me._ObjectCreation = objectCreation

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Name As BoundExpression
        Public ReadOnly Property Name As BoundExpression
            Get
                Return _Name
            End Get
        End Property

        Private ReadOnly _Value As BoundExpression
        Public ReadOnly Property Value As BoundExpression
            Get
                Return _Value
            End Get
        End Property

        Private ReadOnly _MatchesImport As Boolean
        Public ReadOnly Property MatchesImport As Boolean
            Get
                Return _MatchesImport
            End Get
        End Property

        Private ReadOnly _ObjectCreation As BoundExpression
        Public ReadOnly Property ObjectCreation As BoundExpression
            Get
                Return _ObjectCreation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlAttribute(Me)
        End Function

        Public Function Update(name As BoundExpression, value As BoundExpression, matchesImport As Boolean, objectCreation As BoundExpression, type As TypeSymbol) As BoundXmlAttribute
            If name IsNot Me.Name OrElse value IsNot Me.Value OrElse matchesImport <> Me.MatchesImport OrElse objectCreation IsNot Me.ObjectCreation OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlAttribute(Me.Syntax, name, value, matchesImport, objectCreation, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlElement
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, argument As BoundExpression, childNodes As ImmutableArray(Of BoundExpression), rewriterInfo As BoundXmlContainerRewriterInfo, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlElement, syntax, type, hasErrors OrElse argument.NonNullAndHasErrors() OrElse childNodes.NonNullAndHasErrors())

            Debug.Assert(argument IsNot Nothing, "Field 'argument' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (childNodes.IsDefault), "Field 'childNodes' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(rewriterInfo IsNot Nothing, "Field 'rewriterInfo' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Argument = argument
            Me._ChildNodes = childNodes
            Me._RewriterInfo = rewriterInfo
        End Sub


        Private ReadOnly _Argument As BoundExpression
        Public ReadOnly Property Argument As BoundExpression
            Get
                Return _Argument
            End Get
        End Property

        Private ReadOnly _ChildNodes As ImmutableArray(Of BoundExpression)
        Public ReadOnly Property ChildNodes As ImmutableArray(Of BoundExpression)
            Get
                Return _ChildNodes
            End Get
        End Property

        Private ReadOnly _RewriterInfo As BoundXmlContainerRewriterInfo
        Public ReadOnly Property RewriterInfo As BoundXmlContainerRewriterInfo
            Get
                Return _RewriterInfo
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlElement(Me)
        End Function

        Public Function Update(argument As BoundExpression, childNodes As ImmutableArray(Of BoundExpression), rewriterInfo As BoundXmlContainerRewriterInfo, type As TypeSymbol) As BoundXmlElement
            If argument IsNot Me.Argument OrElse childNodes <> Me.ChildNodes OrElse rewriterInfo IsNot Me.RewriterInfo OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlElement(Me.Syntax, argument, childNodes, rewriterInfo, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlMemberAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, memberAccess As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlMemberAccess, syntax, type, hasErrors OrElse memberAccess.NonNullAndHasErrors())

            Debug.Assert(memberAccess IsNot Nothing, "Field 'memberAccess' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._MemberAccess = memberAccess
        End Sub


        Private ReadOnly _MemberAccess As BoundExpression
        Public ReadOnly Property MemberAccess As BoundExpression
            Get
                Return _MemberAccess
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlMemberAccess(Me)
        End Function

        Public Function Update(memberAccess As BoundExpression, type As TypeSymbol) As BoundXmlMemberAccess
            If memberAccess IsNot Me.MemberAccess OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlMemberAccess(Me.Syntax, memberAccess, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlEmbeddedExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlEmbeddedExpression, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlEmbeddedExpression(Me)
        End Function

        Public Function Update(expression As BoundExpression, type As TypeSymbol) As BoundXmlEmbeddedExpression
            If expression IsNot Me.Expression OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlEmbeddedExpression(Me.Syntax, expression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundXmlCData
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, value As BoundLiteral, objectCreation As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.XmlCData, syntax, type, hasErrors OrElse value.NonNullAndHasErrors() OrElse objectCreation.NonNullAndHasErrors())

            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(objectCreation IsNot Nothing, "Field 'objectCreation' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Value = value
            Me._ObjectCreation = objectCreation
        End Sub


        Private ReadOnly _Value As BoundLiteral
        Public ReadOnly Property Value As BoundLiteral
            Get
                Return _Value
            End Get
        End Property

        Private ReadOnly _ObjectCreation As BoundExpression
        Public ReadOnly Property ObjectCreation As BoundExpression
            Get
                Return _ObjectCreation
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitXmlCData(Me)
        End Function

        Public Function Update(value As BoundLiteral, objectCreation As BoundExpression, type As TypeSymbol) As BoundXmlCData
            If value IsNot Me.Value OrElse objectCreation IsNot Me.ObjectCreation OrElse type IsNot Me.Type Then
                Dim result = New BoundXmlCData(Me.Syntax, value, objectCreation, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundResumeStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, resumeKind As ResumeStatementKind, labelOpt As LabelSymbol, labelExpressionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ResumeStatement, syntax, hasErrors OrElse labelExpressionOpt.NonNullAndHasErrors())
            Me._ResumeKind = resumeKind
            Me._LabelOpt = labelOpt
            Me._LabelExpressionOpt = labelExpressionOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ResumeKind As ResumeStatementKind
        Public ReadOnly Property ResumeKind As ResumeStatementKind
            Get
                Return _ResumeKind
            End Get
        End Property

        Private ReadOnly _LabelOpt As LabelSymbol
        Public ReadOnly Property LabelOpt As LabelSymbol
            Get
                Return _LabelOpt
            End Get
        End Property

        Private ReadOnly _LabelExpressionOpt As BoundExpression
        Public ReadOnly Property LabelExpressionOpt As BoundExpression
            Get
                Return _LabelExpressionOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitResumeStatement(Me)
        End Function

        Public Function Update(resumeKind As ResumeStatementKind, labelOpt As LabelSymbol, labelExpressionOpt As BoundExpression) As BoundResumeStatement
            If resumeKind <> Me.ResumeKind OrElse labelOpt IsNot Me.LabelOpt OrElse labelExpressionOpt IsNot Me.LabelExpressionOpt Then
                Dim result = New BoundResumeStatement(Me.Syntax, resumeKind, labelOpt, labelExpressionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundOnErrorStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, onErrorKind As OnErrorStatementKind, labelOpt As LabelSymbol, labelExpressionOpt As BoundExpression, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.OnErrorStatement, syntax, hasErrors OrElse labelExpressionOpt.NonNullAndHasErrors())
            Me._OnErrorKind = onErrorKind
            Me._LabelOpt = labelOpt
            Me._LabelExpressionOpt = labelExpressionOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _OnErrorKind As OnErrorStatementKind
        Public ReadOnly Property OnErrorKind As OnErrorStatementKind
            Get
                Return _OnErrorKind
            End Get
        End Property

        Private ReadOnly _LabelOpt As LabelSymbol
        Public ReadOnly Property LabelOpt As LabelSymbol
            Get
                Return _LabelOpt
            End Get
        End Property

        Private ReadOnly _LabelExpressionOpt As BoundExpression
        Public ReadOnly Property LabelExpressionOpt As BoundExpression
            Get
                Return _LabelExpressionOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitOnErrorStatement(Me)
        End Function

        Public Function Update(onErrorKind As OnErrorStatementKind, labelOpt As LabelSymbol, labelExpressionOpt As BoundExpression) As BoundOnErrorStatement
            If onErrorKind <> Me.OnErrorKind OrElse labelOpt IsNot Me.LabelOpt OrElse labelExpressionOpt IsNot Me.LabelExpressionOpt Then
                Dim result = New BoundOnErrorStatement(Me.Syntax, onErrorKind, labelOpt, labelExpressionOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUnstructuredExceptionHandlingStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, containsOnError As Boolean, containsResume As Boolean, resumeWithoutLabelOpt As StatementSyntax, trackLineNumber As Boolean, body As BoundBlock, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UnstructuredExceptionHandlingStatement, syntax, hasErrors OrElse body.NonNullAndHasErrors())

            Debug.Assert(body IsNot Nothing, "Field 'body' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ContainsOnError = containsOnError
            Me._ContainsResume = containsResume
            Me._ResumeWithoutLabelOpt = resumeWithoutLabelOpt
            Me._TrackLineNumber = trackLineNumber
            Me._Body = body

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ContainsOnError As Boolean
        Public ReadOnly Property ContainsOnError As Boolean
            Get
                Return _ContainsOnError
            End Get
        End Property

        Private ReadOnly _ContainsResume As Boolean
        Public ReadOnly Property ContainsResume As Boolean
            Get
                Return _ContainsResume
            End Get
        End Property

        Private ReadOnly _ResumeWithoutLabelOpt As StatementSyntax
        Public ReadOnly Property ResumeWithoutLabelOpt As StatementSyntax
            Get
                Return _ResumeWithoutLabelOpt
            End Get
        End Property

        Private ReadOnly _TrackLineNumber As Boolean
        Public ReadOnly Property TrackLineNumber As Boolean
            Get
                Return _TrackLineNumber
            End Get
        End Property

        Private ReadOnly _Body As BoundBlock
        Public ReadOnly Property Body As BoundBlock
            Get
                Return _Body
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUnstructuredExceptionHandlingStatement(Me)
        End Function

        Public Function Update(containsOnError As Boolean, containsResume As Boolean, resumeWithoutLabelOpt As StatementSyntax, trackLineNumber As Boolean, body As BoundBlock) As BoundUnstructuredExceptionHandlingStatement
            If containsOnError <> Me.ContainsOnError OrElse containsResume <> Me.ContainsResume OrElse resumeWithoutLabelOpt IsNot Me.ResumeWithoutLabelOpt OrElse trackLineNumber <> Me.TrackLineNumber OrElse body IsNot Me.Body Then
                Dim result = New BoundUnstructuredExceptionHandlingStatement(Me.Syntax, containsOnError, containsResume, resumeWithoutLabelOpt, trackLineNumber, body, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUnstructuredExceptionHandlingCatchFilter
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, activeHandlerLocal As BoundLocal, resumeTargetLocal As BoundLocal, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UnstructuredExceptionHandlingCatchFilter, syntax, type, hasErrors OrElse activeHandlerLocal.NonNullAndHasErrors() OrElse resumeTargetLocal.NonNullAndHasErrors())

            Debug.Assert(activeHandlerLocal IsNot Nothing, "Field 'activeHandlerLocal' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(resumeTargetLocal IsNot Nothing, "Field 'resumeTargetLocal' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ActiveHandlerLocal = activeHandlerLocal
            Me._ResumeTargetLocal = resumeTargetLocal

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ActiveHandlerLocal As BoundLocal
        Public ReadOnly Property ActiveHandlerLocal As BoundLocal
            Get
                Return _ActiveHandlerLocal
            End Get
        End Property

        Private ReadOnly _ResumeTargetLocal As BoundLocal
        Public ReadOnly Property ResumeTargetLocal As BoundLocal
            Get
                Return _ResumeTargetLocal
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUnstructuredExceptionHandlingCatchFilter(Me)
        End Function

        Public Function Update(activeHandlerLocal As BoundLocal, resumeTargetLocal As BoundLocal, type As TypeSymbol) As BoundUnstructuredExceptionHandlingCatchFilter
            If activeHandlerLocal IsNot Me.ActiveHandlerLocal OrElse resumeTargetLocal IsNot Me.ResumeTargetLocal OrElse type IsNot Me.Type Then
                Dim result = New BoundUnstructuredExceptionHandlingCatchFilter(Me.Syntax, activeHandlerLocal, resumeTargetLocal, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUnstructuredExceptionOnErrorSwitch
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, value As BoundExpression, jumps As ImmutableArray(Of BoundGotoStatement), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UnstructuredExceptionOnErrorSwitch, syntax, hasErrors OrElse value.NonNullAndHasErrors() OrElse jumps.NonNullAndHasErrors())

            Debug.Assert(value IsNot Nothing, "Field 'value' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (jumps.IsDefault), "Field 'jumps' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Value = value
            Me._Jumps = jumps

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Value As BoundExpression
        Public ReadOnly Property Value As BoundExpression
            Get
                Return _Value
            End Get
        End Property

        Private ReadOnly _Jumps As ImmutableArray(Of BoundGotoStatement)
        Public ReadOnly Property Jumps As ImmutableArray(Of BoundGotoStatement)
            Get
                Return _Jumps
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUnstructuredExceptionOnErrorSwitch(Me)
        End Function

        Public Function Update(value As BoundExpression, jumps As ImmutableArray(Of BoundGotoStatement)) As BoundUnstructuredExceptionOnErrorSwitch
            If value IsNot Me.Value OrElse jumps <> Me.Jumps Then
                Dim result = New BoundUnstructuredExceptionOnErrorSwitch(Me.Syntax, value, jumps, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundUnstructuredExceptionResumeSwitch
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, resumeTargetTemporary As BoundLocal, resumeLabel As BoundLabelStatement, resumeNextLabel As BoundLabelStatement, jumps As ImmutableArray(Of BoundGotoStatement), Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.UnstructuredExceptionResumeSwitch, syntax, hasErrors OrElse resumeTargetTemporary.NonNullAndHasErrors() OrElse resumeLabel.NonNullAndHasErrors() OrElse resumeNextLabel.NonNullAndHasErrors() OrElse jumps.NonNullAndHasErrors())

            Debug.Assert(resumeTargetTemporary IsNot Nothing, "Field 'resumeTargetTemporary' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(resumeLabel IsNot Nothing, "Field 'resumeLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(resumeNextLabel IsNot Nothing, "Field 'resumeNextLabel' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (jumps.IsDefault), "Field 'jumps' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ResumeTargetTemporary = resumeTargetTemporary
            Me._ResumeLabel = resumeLabel
            Me._ResumeNextLabel = resumeNextLabel
            Me._Jumps = jumps

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ResumeTargetTemporary As BoundLocal
        Public ReadOnly Property ResumeTargetTemporary As BoundLocal
            Get
                Return _ResumeTargetTemporary
            End Get
        End Property

        Private ReadOnly _ResumeLabel As BoundLabelStatement
        Public ReadOnly Property ResumeLabel As BoundLabelStatement
            Get
                Return _ResumeLabel
            End Get
        End Property

        Private ReadOnly _ResumeNextLabel As BoundLabelStatement
        Public ReadOnly Property ResumeNextLabel As BoundLabelStatement
            Get
                Return _ResumeNextLabel
            End Get
        End Property

        Private ReadOnly _Jumps As ImmutableArray(Of BoundGotoStatement)
        Public ReadOnly Property Jumps As ImmutableArray(Of BoundGotoStatement)
            Get
                Return _Jumps
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitUnstructuredExceptionResumeSwitch(Me)
        End Function

        Public Function Update(resumeTargetTemporary As BoundLocal, resumeLabel As BoundLabelStatement, resumeNextLabel As BoundLabelStatement, jumps As ImmutableArray(Of BoundGotoStatement)) As BoundUnstructuredExceptionResumeSwitch
            If resumeTargetTemporary IsNot Me.ResumeTargetTemporary OrElse resumeLabel IsNot Me.ResumeLabel OrElse resumeNextLabel IsNot Me.ResumeNextLabel OrElse jumps <> Me.Jumps Then
                Dim result = New BoundUnstructuredExceptionResumeSwitch(Me.Syntax, resumeTargetTemporary, resumeLabel, resumeNextLabel, jumps, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundAwaitOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, operand As BoundExpression, awaitableInstancePlaceholder As BoundRValuePlaceholder, getAwaiter As BoundExpression, awaiterInstancePlaceholder As BoundLValuePlaceholder, isCompleted As BoundExpression, getResult As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.AwaitOperator, syntax, type, hasErrors OrElse operand.NonNullAndHasErrors() OrElse awaitableInstancePlaceholder.NonNullAndHasErrors() OrElse getAwaiter.NonNullAndHasErrors() OrElse awaiterInstancePlaceholder.NonNullAndHasErrors() OrElse isCompleted.NonNullAndHasErrors() OrElse getResult.NonNullAndHasErrors())

            Debug.Assert(operand IsNot Nothing, "Field 'operand' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(awaitableInstancePlaceholder IsNot Nothing, "Field 'awaitableInstancePlaceholder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(getAwaiter IsNot Nothing, "Field 'getAwaiter' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(awaiterInstancePlaceholder IsNot Nothing, "Field 'awaiterInstancePlaceholder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(isCompleted IsNot Nothing, "Field 'isCompleted' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(getResult IsNot Nothing, "Field 'getResult' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Operand = operand
            Me._AwaitableInstancePlaceholder = awaitableInstancePlaceholder
            Me._GetAwaiter = getAwaiter
            Me._AwaiterInstancePlaceholder = awaiterInstancePlaceholder
            Me._IsCompleted = isCompleted
            Me._GetResult = getResult

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Operand As BoundExpression
        Public ReadOnly Property Operand As BoundExpression
            Get
                Return _Operand
            End Get
        End Property

        Private ReadOnly _AwaitableInstancePlaceholder As BoundRValuePlaceholder
        Public ReadOnly Property AwaitableInstancePlaceholder As BoundRValuePlaceholder
            Get
                Return _AwaitableInstancePlaceholder
            End Get
        End Property

        Private ReadOnly _GetAwaiter As BoundExpression
        Public ReadOnly Property GetAwaiter As BoundExpression
            Get
                Return _GetAwaiter
            End Get
        End Property

        Private ReadOnly _AwaiterInstancePlaceholder As BoundLValuePlaceholder
        Public ReadOnly Property AwaiterInstancePlaceholder As BoundLValuePlaceholder
            Get
                Return _AwaiterInstancePlaceholder
            End Get
        End Property

        Private ReadOnly _IsCompleted As BoundExpression
        Public ReadOnly Property IsCompleted As BoundExpression
            Get
                Return _IsCompleted
            End Get
        End Property

        Private ReadOnly _GetResult As BoundExpression
        Public ReadOnly Property GetResult As BoundExpression
            Get
                Return _GetResult
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitAwaitOperator(Me)
        End Function

        Public Function Update(operand As BoundExpression, awaitableInstancePlaceholder As BoundRValuePlaceholder, getAwaiter As BoundExpression, awaiterInstancePlaceholder As BoundLValuePlaceholder, isCompleted As BoundExpression, getResult As BoundExpression, type As TypeSymbol) As BoundAwaitOperator
            If operand IsNot Me.Operand OrElse awaitableInstancePlaceholder IsNot Me.AwaitableInstancePlaceholder OrElse getAwaiter IsNot Me.GetAwaiter OrElse awaiterInstancePlaceholder IsNot Me.AwaiterInstancePlaceholder OrElse isCompleted IsNot Me.IsCompleted OrElse getResult IsNot Me.GetResult OrElse type IsNot Me.Type Then
                Dim result = New BoundAwaitOperator(Me.Syntax, operand, awaitableInstancePlaceholder, getAwaiter, awaiterInstancePlaceholder, isCompleted, getResult, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundSpillSequence
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, locals As ImmutableArray(Of LocalSymbol), spillFields As ImmutableArray(Of FieldSymbol), statements As ImmutableArray(Of BoundStatement), valueOpt As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.SpillSequence, syntax, type, hasErrors OrElse statements.NonNullAndHasErrors() OrElse valueOpt.NonNullAndHasErrors())

            Debug.Assert(Not (locals.IsDefault), "Field 'locals' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (spillFields.IsDefault), "Field 'spillFields' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(Not (statements.IsDefault), "Field 'statements' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Locals = locals
            Me._SpillFields = spillFields
            Me._Statements = statements
            Me._ValueOpt = valueOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Locals As ImmutableArray(Of LocalSymbol)
        Public ReadOnly Property Locals As ImmutableArray(Of LocalSymbol)
            Get
                Return _Locals
            End Get
        End Property

        Private ReadOnly _SpillFields As ImmutableArray(Of FieldSymbol)
        Public ReadOnly Property SpillFields As ImmutableArray(Of FieldSymbol)
            Get
                Return _SpillFields
            End Get
        End Property

        Private ReadOnly _Statements As ImmutableArray(Of BoundStatement)
        Public ReadOnly Property Statements As ImmutableArray(Of BoundStatement)
            Get
                Return _Statements
            End Get
        End Property

        Private ReadOnly _ValueOpt As BoundExpression
        Public ReadOnly Property ValueOpt As BoundExpression
            Get
                Return _ValueOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitSpillSequence(Me)
        End Function

        Public Function Update(locals As ImmutableArray(Of LocalSymbol), spillFields As ImmutableArray(Of FieldSymbol), statements As ImmutableArray(Of BoundStatement), valueOpt As BoundExpression, type As TypeSymbol) As BoundSpillSequence
            If locals <> Me.Locals OrElse spillFields <> Me.SpillFields OrElse statements <> Me.Statements OrElse valueOpt IsNot Me.ValueOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundSpillSequence(Me.Syntax, locals, spillFields, statements, valueOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundStopStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, hasErrors As Boolean)
            MyBase.New(BoundKind.StopStatement, syntax, hasErrors)
        End Sub

        Public Sub New(syntax As SyntaxNode)
            MyBase.New(BoundKind.StopStatement, syntax)
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitStopStatement(Me)
        End Function
    End Class

    Partial Friend NotInheritable Class BoundEndStatement
        Inherits BoundStatement

        Public Sub New(syntax As SyntaxNode, hasErrors As Boolean)
            MyBase.New(BoundKind.EndStatement, syntax, hasErrors)
        End Sub

        Public Sub New(syntax As SyntaxNode)
            MyBase.New(BoundKind.EndStatement, syntax)
        End Sub


        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitEndStatement(Me)
        End Function
    End Class

    Partial Friend NotInheritable Class BoundMidResult
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, original As BoundExpression, start As BoundExpression, lengthOpt As BoundExpression, source As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.MidResult, syntax, type, hasErrors OrElse original.NonNullAndHasErrors() OrElse start.NonNullAndHasErrors() OrElse lengthOpt.NonNullAndHasErrors() OrElse source.NonNullAndHasErrors())

            Debug.Assert(original IsNot Nothing, "Field 'original' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(start IsNot Nothing, "Field 'start' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(source IsNot Nothing, "Field 'source' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Original = original
            Me._Start = start
            Me._LengthOpt = lengthOpt
            Me._Source = source

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Original As BoundExpression
        Public ReadOnly Property Original As BoundExpression
            Get
                Return _Original
            End Get
        End Property

        Private ReadOnly _Start As BoundExpression
        Public ReadOnly Property Start As BoundExpression
            Get
                Return _Start
            End Get
        End Property

        Private ReadOnly _LengthOpt As BoundExpression
        Public ReadOnly Property LengthOpt As BoundExpression
            Get
                Return _LengthOpt
            End Get
        End Property

        Private ReadOnly _Source As BoundExpression
        Public ReadOnly Property Source As BoundExpression
            Get
                Return _Source
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitMidResult(Me)
        End Function

        Public Function Update(original As BoundExpression, start As BoundExpression, lengthOpt As BoundExpression, source As BoundExpression, type As TypeSymbol) As BoundMidResult
            If original IsNot Me.Original OrElse start IsNot Me.Start OrElse lengthOpt IsNot Me.LengthOpt OrElse source IsNot Me.Source OrElse type IsNot Me.Type Then
                Dim result = New BoundMidResult(Me.Syntax, original, start, lengthOpt, source, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundConditionalAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, receiver As BoundExpression, placeholder As BoundRValuePlaceholder, accessExpression As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ConditionalAccess, syntax, type, hasErrors OrElse receiver.NonNullAndHasErrors() OrElse placeholder.NonNullAndHasErrors() OrElse accessExpression.NonNullAndHasErrors())

            Debug.Assert(receiver IsNot Nothing, "Field 'receiver' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(placeholder IsNot Nothing, "Field 'placeholder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(accessExpression IsNot Nothing, "Field 'accessExpression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Receiver = receiver
            Me._Placeholder = placeholder
            Me._AccessExpression = accessExpression
        End Sub


        Private ReadOnly _Receiver As BoundExpression
        Public ReadOnly Property Receiver As BoundExpression
            Get
                Return _Receiver
            End Get
        End Property

        Private ReadOnly _Placeholder As BoundRValuePlaceholder
        Public ReadOnly Property Placeholder As BoundRValuePlaceholder
            Get
                Return _Placeholder
            End Get
        End Property

        Private ReadOnly _AccessExpression As BoundExpression
        Public ReadOnly Property AccessExpression As BoundExpression
            Get
                Return _AccessExpression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitConditionalAccess(Me)
        End Function

        Public Function Update(receiver As BoundExpression, placeholder As BoundRValuePlaceholder, accessExpression As BoundExpression, type As TypeSymbol) As BoundConditionalAccess
            If receiver IsNot Me.Receiver OrElse placeholder IsNot Me.Placeholder OrElse accessExpression IsNot Me.AccessExpression OrElse type IsNot Me.Type Then
                Dim result = New BoundConditionalAccess(Me.Syntax, receiver, placeholder, accessExpression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundConditionalAccessReceiverPlaceholder
        Inherits BoundRValuePlaceholderBase

        Public Sub New(syntax As SyntaxNode, placeholderId As Integer, capture As Boolean, type As TypeSymbol, hasErrors As Boolean)
            MyBase.New(BoundKind.ConditionalAccessReceiverPlaceholder, syntax, type, hasErrors)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._PlaceholderId = placeholderId
            Me._Capture = capture

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub

        Public Sub New(syntax As SyntaxNode, placeholderId As Integer, capture As Boolean, type As TypeSymbol)
            MyBase.New(BoundKind.ConditionalAccessReceiverPlaceholder, syntax, type)

            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._PlaceholderId = placeholderId
            Me._Capture = capture

            Validate()
        End Sub


        Private ReadOnly _PlaceholderId As Integer
        Public ReadOnly Property PlaceholderId As Integer
            Get
                Return _PlaceholderId
            End Get
        End Property

        Private ReadOnly _Capture As Boolean
        Public ReadOnly Property Capture As Boolean
            Get
                Return _Capture
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitConditionalAccessReceiverPlaceholder(Me)
        End Function

        Public Function Update(placeholderId As Integer, capture As Boolean, type As TypeSymbol) As BoundConditionalAccessReceiverPlaceholder
            If placeholderId <> Me.PlaceholderId OrElse capture <> Me.Capture OrElse type IsNot Me.Type Then
                Dim result = New BoundConditionalAccessReceiverPlaceholder(Me.Syntax, placeholderId, capture, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundLoweredConditionalAccess
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, receiverOrCondition As BoundExpression, captureReceiver As Boolean, placeholderId As Integer, whenNotNull As BoundExpression, whenNullOpt As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.LoweredConditionalAccess, syntax, type, hasErrors OrElse receiverOrCondition.NonNullAndHasErrors() OrElse whenNotNull.NonNullAndHasErrors() OrElse whenNullOpt.NonNullAndHasErrors())

            Debug.Assert(receiverOrCondition IsNot Nothing, "Field 'receiverOrCondition' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(whenNotNull IsNot Nothing, "Field 'whenNotNull' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ReceiverOrCondition = receiverOrCondition
            Me._CaptureReceiver = captureReceiver
            Me._PlaceholderId = placeholderId
            Me._WhenNotNull = whenNotNull
            Me._WhenNullOpt = whenNullOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ReceiverOrCondition As BoundExpression
        Public ReadOnly Property ReceiverOrCondition As BoundExpression
            Get
                Return _ReceiverOrCondition
            End Get
        End Property

        Private ReadOnly _CaptureReceiver As Boolean
        Public ReadOnly Property CaptureReceiver As Boolean
            Get
                Return _CaptureReceiver
            End Get
        End Property

        Private ReadOnly _PlaceholderId As Integer
        Public ReadOnly Property PlaceholderId As Integer
            Get
                Return _PlaceholderId
            End Get
        End Property

        Private ReadOnly _WhenNotNull As BoundExpression
        Public ReadOnly Property WhenNotNull As BoundExpression
            Get
                Return _WhenNotNull
            End Get
        End Property

        Private ReadOnly _WhenNullOpt As BoundExpression
        Public ReadOnly Property WhenNullOpt As BoundExpression
            Get
                Return _WhenNullOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitLoweredConditionalAccess(Me)
        End Function

        Public Function Update(receiverOrCondition As BoundExpression, captureReceiver As Boolean, placeholderId As Integer, whenNotNull As BoundExpression, whenNullOpt As BoundExpression, type As TypeSymbol) As BoundLoweredConditionalAccess
            If receiverOrCondition IsNot Me.ReceiverOrCondition OrElse captureReceiver <> Me.CaptureReceiver OrElse placeholderId <> Me.PlaceholderId OrElse whenNotNull IsNot Me.WhenNotNull OrElse whenNullOpt IsNot Me.WhenNullOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundLoweredConditionalAccess(Me.Syntax, receiverOrCondition, captureReceiver, placeholderId, whenNotNull, whenNullOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundComplexConditionalAccessReceiver
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, valueTypeReceiver As BoundExpression, referenceTypeReceiver As BoundExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.ComplexConditionalAccessReceiver, syntax, type, hasErrors OrElse valueTypeReceiver.NonNullAndHasErrors() OrElse referenceTypeReceiver.NonNullAndHasErrors())

            Debug.Assert(valueTypeReceiver IsNot Nothing, "Field 'valueTypeReceiver' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(referenceTypeReceiver IsNot Nothing, "Field 'referenceTypeReceiver' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._ValueTypeReceiver = valueTypeReceiver
            Me._ReferenceTypeReceiver = referenceTypeReceiver

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _ValueTypeReceiver As BoundExpression
        Public ReadOnly Property ValueTypeReceiver As BoundExpression
            Get
                Return _ValueTypeReceiver
            End Get
        End Property

        Private ReadOnly _ReferenceTypeReceiver As BoundExpression
        Public ReadOnly Property ReferenceTypeReceiver As BoundExpression
            Get
                Return _ReferenceTypeReceiver
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitComplexConditionalAccessReceiver(Me)
        End Function

        Public Function Update(valueTypeReceiver As BoundExpression, referenceTypeReceiver As BoundExpression, type As TypeSymbol) As BoundComplexConditionalAccessReceiver
            If valueTypeReceiver IsNot Me.ValueTypeReceiver OrElse referenceTypeReceiver IsNot Me.ReferenceTypeReceiver OrElse type IsNot Me.Type Then
                Dim result = New BoundComplexConditionalAccessReceiver(Me.Syntax, valueTypeReceiver, referenceTypeReceiver, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundNameOfOperator
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, argument As BoundExpression, constantValueOpt As ConstantValue, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.NameOfOperator, syntax, type, hasErrors OrElse argument.NonNullAndHasErrors())

            Debug.Assert(argument IsNot Nothing, "Field 'argument' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Argument = argument
            Me._ConstantValueOpt = constantValueOpt

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Argument As BoundExpression
        Public ReadOnly Property Argument As BoundExpression
            Get
                Return _Argument
            End Get
        End Property

        Private ReadOnly _ConstantValueOpt As ConstantValue
        Public Overrides ReadOnly Property ConstantValueOpt As ConstantValue
            Get
                Return _ConstantValueOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitNameOfOperator(Me)
        End Function

        Public Function Update(argument As BoundExpression, constantValueOpt As ConstantValue, type As TypeSymbol) As BoundNameOfOperator
            If argument IsNot Me.Argument OrElse constantValueOpt IsNot Me.ConstantValueOpt OrElse type IsNot Me.Type Then
                Dim result = New BoundNameOfOperator(Me.Syntax, argument, constantValueOpt, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundTypeAsValueExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, expression As BoundTypeExpression, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.TypeAsValueExpression, syntax, type, hasErrors OrElse expression.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Expression As BoundTypeExpression
        Public ReadOnly Property Expression As BoundTypeExpression
            Get
                Return _Expression
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitTypeAsValueExpression(Me)
        End Function

        Public Function Update(expression As BoundTypeExpression, type As TypeSymbol) As BoundTypeAsValueExpression
            If expression IsNot Me.Expression OrElse type IsNot Me.Type Then
                Dim result = New BoundTypeAsValueExpression(Me.Syntax, expression, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundInterpolatedStringExpression
        Inherits BoundExpression

        Public Sub New(syntax As SyntaxNode, contents As ImmutableArray(Of BoundNode), binder As Binder, type As TypeSymbol, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.InterpolatedStringExpression, syntax, type, hasErrors OrElse contents.NonNullAndHasErrors())

            Debug.Assert(Not (contents.IsDefault), "Field 'contents' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(binder IsNot Nothing, "Field 'binder' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")
            Debug.Assert(type IsNot Nothing, "Field 'type' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Contents = contents
            Me._Binder = binder

            Validate()
        End Sub

        Private Partial Sub Validate()
        End Sub


        Private ReadOnly _Contents As ImmutableArray(Of BoundNode)
        Public ReadOnly Property Contents As ImmutableArray(Of BoundNode)
            Get
                Return _Contents
            End Get
        End Property

        Private ReadOnly _Binder As Binder
        Public ReadOnly Property Binder As Binder
            Get
                Return _Binder
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitInterpolatedStringExpression(Me)
        End Function

        Public Function Update(contents As ImmutableArray(Of BoundNode), binder As Binder, type As TypeSymbol) As BoundInterpolatedStringExpression
            If contents <> Me.Contents OrElse binder IsNot Me.Binder OrElse type IsNot Me.Type Then
                Dim result = New BoundInterpolatedStringExpression(Me.Syntax, contents, binder, type, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Partial Friend NotInheritable Class BoundInterpolation
        Inherits BoundNode

        Public Sub New(syntax As SyntaxNode, expression As BoundExpression, alignmentOpt As BoundExpression, formatStringOpt As BoundLiteral, Optional hasErrors As Boolean = False)
            MyBase.New(BoundKind.Interpolation, syntax, hasErrors OrElse expression.NonNullAndHasErrors() OrElse alignmentOpt.NonNullAndHasErrors() OrElse formatStringOpt.NonNullAndHasErrors())

            Debug.Assert(expression IsNot Nothing, "Field 'expression' cannot be null (use Null=""allow"" in BoundNodes.xml to remove this check)")

            Me._Expression = expression
            Me._AlignmentOpt = alignmentOpt
            Me._FormatStringOpt = formatStringOpt
        End Sub


        Private ReadOnly _Expression As BoundExpression
        Public ReadOnly Property Expression As BoundExpression
            Get
                Return _Expression
            End Get
        End Property

        Private ReadOnly _AlignmentOpt As BoundExpression
        Public ReadOnly Property AlignmentOpt As BoundExpression
            Get
                Return _AlignmentOpt
            End Get
        End Property

        Private ReadOnly _FormatStringOpt As BoundLiteral
        Public ReadOnly Property FormatStringOpt As BoundLiteral
            Get
                Return _FormatStringOpt
            End Get
        End Property

        <DebuggerStepThrough>
        Public Overrides Function Accept(visitor as BoundTreeVisitor) As BoundNode
            Return visitor.VisitInterpolation(Me)
        End Function

        Public Function Update(expression As BoundExpression, alignmentOpt As BoundExpression, formatStringOpt As BoundLiteral) As BoundInterpolation
            If expression IsNot Me.Expression OrElse alignmentOpt IsNot Me.AlignmentOpt OrElse formatStringOpt IsNot Me.FormatStringOpt Then
                Dim result = New BoundInterpolation(Me.Syntax, expression, alignmentOpt, formatStringOpt, Me.HasErrors)
                result.CopyAttributes(Me)
                Return result
            End If
            Return Me
        End Function
    End Class

    Friend MustInherit Partial Class BoundTreeVisitor(Of A, R)

        <MethodImpl(MethodImplOptions.NoInlining), DebuggerStepThrough>
        Friend Function VisitInternal(node As BoundNode, arg As A) As R
            Select Case node.Kind
                Case BoundKind.TypeArguments
                    Return VisitTypeArguments(CType(node, BoundTypeArguments), arg)
                Case BoundKind.OmittedArgument
                    Return VisitOmittedArgument(CType(node, BoundOmittedArgument), arg)
                Case BoundKind.LValueToRValueWrapper
                    Return VisitLValueToRValueWrapper(CType(node, BoundLValueToRValueWrapper), arg)
                Case BoundKind.WithLValueExpressionPlaceholder
                    Return VisitWithLValueExpressionPlaceholder(CType(node, BoundWithLValueExpressionPlaceholder), arg)
                Case BoundKind.WithRValueExpressionPlaceholder
                    Return VisitWithRValueExpressionPlaceholder(CType(node, BoundWithRValueExpressionPlaceholder), arg)
                Case BoundKind.RValuePlaceholder
                    Return VisitRValuePlaceholder(CType(node, BoundRValuePlaceholder), arg)
                Case BoundKind.LValuePlaceholder
                    Return VisitLValuePlaceholder(CType(node, BoundLValuePlaceholder), arg)
                Case BoundKind.Dup
                    Return VisitDup(CType(node, BoundDup), arg)
                Case BoundKind.BadExpression
                    Return VisitBadExpression(CType(node, BoundBadExpression), arg)
                Case BoundKind.BadStatement
                    Return VisitBadStatement(CType(node, BoundBadStatement), arg)
                Case BoundKind.Parenthesized
                    Return VisitParenthesized(CType(node, BoundParenthesized), arg)
                Case BoundKind.BadVariable
                    Return VisitBadVariable(CType(node, BoundBadVariable), arg)
                Case BoundKind.ArrayAccess
                    Return VisitArrayAccess(CType(node, BoundArrayAccess), arg)
                Case BoundKind.ArrayLength
                    Return VisitArrayLength(CType(node, BoundArrayLength), arg)
                Case BoundKind.[GetType]
                    Return VisitGetType(CType(node, BoundGetType), arg)
                Case BoundKind.FieldInfo
                    Return VisitFieldInfo(CType(node, BoundFieldInfo), arg)
                Case BoundKind.MethodInfo
                    Return VisitMethodInfo(CType(node, BoundMethodInfo), arg)
                Case BoundKind.TypeExpression
                    Return VisitTypeExpression(CType(node, BoundTypeExpression), arg)
                Case BoundKind.TypeOrValueExpression
                    Return VisitTypeOrValueExpression(CType(node, BoundTypeOrValueExpression), arg)
                Case BoundKind.NamespaceExpression
                    Return VisitNamespaceExpression(CType(node, BoundNamespaceExpression), arg)
                Case BoundKind.MethodDefIndex
                    Return VisitMethodDefIndex(CType(node, BoundMethodDefIndex), arg)
                Case BoundKind.MaximumMethodDefIndex
                    Return VisitMaximumMethodDefIndex(CType(node, BoundMaximumMethodDefIndex), arg)
                Case BoundKind.InstrumentationPayloadRoot
                    Return VisitInstrumentationPayloadRoot(CType(node, BoundInstrumentationPayloadRoot), arg)
                Case BoundKind.ModuleVersionId
                    Return VisitModuleVersionId(CType(node, BoundModuleVersionId), arg)
                Case BoundKind.ModuleVersionIdString
                    Return VisitModuleVersionIdString(CType(node, BoundModuleVersionIdString), arg)
                Case BoundKind.SourceDocumentIndex
                    Return VisitSourceDocumentIndex(CType(node, BoundSourceDocumentIndex), arg)
                Case BoundKind.UnaryOperator
                    Return VisitUnaryOperator(CType(node, BoundUnaryOperator), arg)
                Case BoundKind.UserDefinedUnaryOperator
                    Return VisitUserDefinedUnaryOperator(CType(node, BoundUserDefinedUnaryOperator), arg)
                Case BoundKind.NullableIsTrueOperator
                    Return VisitNullableIsTrueOperator(CType(node, BoundNullableIsTrueOperator), arg)
                Case BoundKind.BinaryOperator
                    Return VisitBinaryOperator(CType(node, BoundBinaryOperator), arg)
                Case BoundKind.UserDefinedBinaryOperator
                    Return VisitUserDefinedBinaryOperator(CType(node, BoundUserDefinedBinaryOperator), arg)
                Case BoundKind.UserDefinedShortCircuitingOperator
                    Return VisitUserDefinedShortCircuitingOperator(CType(node, BoundUserDefinedShortCircuitingOperator), arg)
                Case BoundKind.CompoundAssignmentTargetPlaceholder
                    Return VisitCompoundAssignmentTargetPlaceholder(CType(node, BoundCompoundAssignmentTargetPlaceholder), arg)
                Case BoundKind.AssignmentOperator
                    Return VisitAssignmentOperator(CType(node, BoundAssignmentOperator), arg)
                Case BoundKind.ReferenceAssignment
                    Return VisitReferenceAssignment(CType(node, BoundReferenceAssignment), arg)
                Case BoundKind.AddressOfOperator
                    Return VisitAddressOfOperator(CType(node, BoundAddressOfOperator), arg)
                Case BoundKind.TernaryConditionalExpression
                    Return VisitTernaryConditionalExpression(CType(node, BoundTernaryConditionalExpression), arg)
                Case BoundKind.BinaryConditionalExpression
                    Return VisitBinaryConditionalExpression(CType(node, BoundBinaryConditionalExpression), arg)
                Case BoundKind.Conversion
                    Return VisitConversion(CType(node, BoundConversion), arg)
                Case BoundKind.RelaxationLambda
                    Return VisitRelaxationLambda(CType(node, BoundRelaxationLambda), arg)
                Case BoundKind.ConvertedTupleElements
                    Return VisitConvertedTupleElements(CType(node, BoundConvertedTupleElements), arg)
                Case BoundKind.UserDefinedConversion
                    Return VisitUserDefinedConversion(CType(node, BoundUserDefinedConversion), arg)
                Case BoundKind.[DirectCast]
                    Return VisitDirectCast(CType(node, BoundDirectCast), arg)
                Case BoundKind.[TryCast]
                    Return VisitTryCast(CType(node, BoundTryCast), arg)
                Case BoundKind.[TypeOf]
                    Return VisitTypeOf(CType(node, BoundTypeOf), arg)
                Case BoundKind.SequencePoint
                    Return VisitSequencePoint(CType(node, BoundSequencePoint), arg)
                Case BoundKind.SequencePointExpression
                    Return VisitSequencePointExpression(CType(node, BoundSequencePointExpression), arg)
                Case BoundKind.SequencePointWithSpan
                    Return VisitSequencePointWithSpan(CType(node, BoundSequencePointWithSpan), arg)
                Case BoundKind.NoOpStatement
                    Return VisitNoOpStatement(CType(node, BoundNoOpStatement), arg)
                Case BoundKind.MethodGroup
                    Return VisitMethodGroup(CType(node, BoundMethodGroup), arg)
                Case BoundKind.PropertyGroup
                    Return VisitPropertyGroup(CType(node, BoundPropertyGroup), arg)
                Case BoundKind.ReturnStatement
                    Return VisitReturnStatement(CType(node, BoundReturnStatement), arg)
                Case BoundKind.YieldStatement
                    Return VisitYieldStatement(CType(node, BoundYieldStatement), arg)
                Case BoundKind.ThrowStatement
                    Return VisitThrowStatement(CType(node, BoundThrowStatement), arg)
                Case BoundKind.RedimStatement
                    Return VisitRedimStatement(CType(node, BoundRedimStatement), arg)
                Case BoundKind.RedimClause
                    Return VisitRedimClause(CType(node, BoundRedimClause), arg)
                Case BoundKind.EraseStatement
                    Return VisitEraseStatement(CType(node, BoundEraseStatement), arg)
                Case BoundKind.[Call]
                    Return VisitCall(CType(node, BoundCall), arg)
                Case BoundKind.Attribute
                    Return VisitAttribute(CType(node, BoundAttribute), arg)
                Case BoundKind.LateMemberAccess
                    Return VisitLateMemberAccess(CType(node, BoundLateMemberAccess), arg)
                Case BoundKind.LateInvocation
                    Return VisitLateInvocation(CType(node, BoundLateInvocation), arg)
                Case BoundKind.LateAddressOfOperator
                    Return VisitLateAddressOfOperator(CType(node, BoundLateAddressOfOperator), arg)
                Case BoundKind.TupleLiteral
                    Return VisitTupleLiteral(CType(node, BoundTupleLiteral), arg)
                Case BoundKind.ConvertedTupleLiteral
                    Return VisitConvertedTupleLiteral(CType(node, BoundConvertedTupleLiteral), arg)
                Case BoundKind.ObjectCreationExpression
                    Return VisitObjectCreationExpression(CType(node, BoundObjectCreationExpression), arg)
                Case BoundKind.NoPiaObjectCreationExpression
                    Return VisitNoPiaObjectCreationExpression(CType(node, BoundNoPiaObjectCreationExpression), arg)
                Case BoundKind.AnonymousTypeCreationExpression
                    Return VisitAnonymousTypeCreationExpression(CType(node, BoundAnonymousTypeCreationExpression), arg)
                Case BoundKind.AnonymousTypePropertyAccess
                    Return VisitAnonymousTypePropertyAccess(CType(node, BoundAnonymousTypePropertyAccess), arg)
                Case BoundKind.AnonymousTypeFieldInitializer
                    Return VisitAnonymousTypeFieldInitializer(CType(node, BoundAnonymousTypeFieldInitializer), arg)
                Case BoundKind.ObjectInitializerExpression
                    Return VisitObjectInitializerExpression(CType(node, BoundObjectInitializerExpression), arg)
                Case BoundKind.CollectionInitializerExpression
                    Return VisitCollectionInitializerExpression(CType(node, BoundCollectionInitializerExpression), arg)
                Case BoundKind.NewT
                    Return VisitNewT(CType(node, BoundNewT), arg)
                Case BoundKind.DelegateCreationExpression
                    Return VisitDelegateCreationExpression(CType(node, BoundDelegateCreationExpression), arg)
                Case BoundKind.ArrayCreation
                    Return VisitArrayCreation(CType(node, BoundArrayCreation), arg)
                Case BoundKind.ArrayLiteral
                    Return VisitArrayLiteral(CType(node, BoundArrayLiteral), arg)
                Case BoundKind.ArrayInitialization
                    Return VisitArrayInitialization(CType(node, BoundArrayInitialization), arg)
                Case BoundKind.FieldAccess
                    Return VisitFieldAccess(CType(node, BoundFieldAccess), arg)
                Case BoundKind.PropertyAccess
                    Return VisitPropertyAccess(CType(node, BoundPropertyAccess), arg)
                Case BoundKind.EventAccess
                    Return VisitEventAccess(CType(node, BoundEventAccess), arg)
                Case BoundKind.Block
                    Return VisitBlock(CType(node, BoundBlock), arg)
                Case BoundKind.StateMachineScope
                    Return VisitStateMachineScope(CType(node, BoundStateMachineScope), arg)
                Case BoundKind.LocalDeclaration
                    Return VisitLocalDeclaration(CType(node, BoundLocalDeclaration), arg)
                Case BoundKind.AsNewLocalDeclarations
                    Return VisitAsNewLocalDeclarations(CType(node, BoundAsNewLocalDeclarations), arg)
                Case BoundKind.DimStatement
                    Return VisitDimStatement(CType(node, BoundDimStatement), arg)
                Case BoundKind.Initializer
                    Return VisitInitializer(CType(node, BoundInitializer), arg)
                Case BoundKind.FieldInitializer
                    Return VisitFieldInitializer(CType(node, BoundFieldInitializer), arg)
                Case BoundKind.PropertyInitializer
                    Return VisitPropertyInitializer(CType(node, BoundPropertyInitializer), arg)
                Case BoundKind.ParameterEqualsValue
                    Return VisitParameterEqualsValue(CType(node, BoundParameterEqualsValue), arg)
                Case BoundKind.GlobalStatementInitializer
                    Return VisitGlobalStatementInitializer(CType(node, BoundGlobalStatementInitializer), arg)
                Case BoundKind.Sequence
                    Return VisitSequence(CType(node, BoundSequence), arg)
                Case BoundKind.ExpressionStatement
                    Return VisitExpressionStatement(CType(node, BoundExpressionStatement), arg)
                Case BoundKind.IfStatement
                    Return VisitIfStatement(CType(node, BoundIfStatement), arg)
                Case BoundKind.SelectStatement
                    Return VisitSelectStatement(CType(node, BoundSelectStatement), arg)
                Case BoundKind.CaseBlock
                    Return VisitCaseBlock(CType(node, BoundCaseBlock), arg)
                Case BoundKind.CaseStatement
                    Return VisitCaseStatement(CType(node, BoundCaseStatement), arg)
                Case BoundKind.SimpleCaseClause
                    Return VisitSimpleCaseClause(CType(node, BoundSimpleCaseClause), arg)
                Case BoundKind.RangeCaseClause
                    Return VisitRangeCaseClause(CType(node, BoundRangeCaseClause), arg)
                Case BoundKind.RelationalCaseClause
                    Return VisitRelationalCaseClause(CType(node, BoundRelationalCaseClause), arg)
                Case BoundKind.DoLoopStatement
                    Return VisitDoLoopStatement(CType(node, BoundDoLoopStatement), arg)
                Case BoundKind.WhileStatement
                    Return VisitWhileStatement(CType(node, BoundWhileStatement), arg)
                Case BoundKind.ForToUserDefinedOperators
                    Return VisitForToUserDefinedOperators(CType(node, BoundForToUserDefinedOperators), arg)
                Case BoundKind.ForToStatement
                    Return VisitForToStatement(CType(node, BoundForToStatement), arg)
                Case BoundKind.ForEachStatement
                    Return VisitForEachStatement(CType(node, BoundForEachStatement), arg)
                Case BoundKind.ExitStatement
                    Return VisitExitStatement(CType(node, BoundExitStatement), arg)
                Case BoundKind.ContinueStatement
                    Return VisitContinueStatement(CType(node, BoundContinueStatement), arg)
                Case BoundKind.TryStatement
                    Return VisitTryStatement(CType(node, BoundTryStatement), arg)
                Case BoundKind.CatchBlock
                    Return VisitCatchBlock(CType(node, BoundCatchBlock), arg)
                Case BoundKind.Literal
                    Return VisitLiteral(CType(node, BoundLiteral), arg)
                Case BoundKind.MeReference
                    Return VisitMeReference(CType(node, BoundMeReference), arg)
                Case BoundKind.ValueTypeMeReference
                    Return VisitValueTypeMeReference(CType(node, BoundValueTypeMeReference), arg)
                Case BoundKind.MyBaseReference
                    Return VisitMyBaseReference(CType(node, BoundMyBaseReference), arg)
                Case BoundKind.MyClassReference
                    Return VisitMyClassReference(CType(node, BoundMyClassReference), arg)
                Case BoundKind.PreviousSubmissionReference
                    Return VisitPreviousSubmissionReference(CType(node, BoundPreviousSubmissionReference), arg)
                Case BoundKind.HostObjectMemberReference
                    Return VisitHostObjectMemberReference(CType(node, BoundHostObjectMemberReference), arg)
                Case BoundKind.Local
                    Return VisitLocal(CType(node, BoundLocal), arg)
                Case BoundKind.PseudoVariable
                    Return VisitPseudoVariable(CType(node, BoundPseudoVariable), arg)
                Case BoundKind.Parameter
                    Return VisitParameter(CType(node, BoundParameter), arg)
                Case BoundKind.ByRefArgumentPlaceholder
                    Return VisitByRefArgumentPlaceholder(CType(node, BoundByRefArgumentPlaceholder), arg)
                Case BoundKind.ByRefArgumentWithCopyBack
                    Return VisitByRefArgumentWithCopyBack(CType(node, BoundByRefArgumentWithCopyBack), arg)
                Case BoundKind.LateBoundArgumentSupportingAssignmentWithCapture
                    Return VisitLateBoundArgumentSupportingAssignmentWithCapture(CType(node, BoundLateBoundArgumentSupportingAssignmentWithCapture), arg)
                Case BoundKind.LabelStatement
                    Return VisitLabelStatement(CType(node, BoundLabelStatement), arg)
                Case BoundKind.Label
                    Return VisitLabel(CType(node, BoundLabel), arg)
                Case BoundKind.GotoStatement
                    Return VisitGotoStatement(CType(node, BoundGotoStatement), arg)
                Case BoundKind.StatementList
                    Return VisitStatementList(CType(node, BoundStatementList), arg)
                Case BoundKind.ConditionalGoto
                    Return VisitConditionalGoto(CType(node, BoundConditionalGoto), arg)
                Case BoundKind.WithStatement
                    Return VisitWithStatement(CType(node, BoundWithStatement), arg)
                Case BoundKind.UnboundLambda
                    Return VisitUnboundLambda(CType(node, UnboundLambda), arg)
                Case BoundKind.Lambda
                    Return VisitLambda(CType(node, BoundLambda), arg)
                Case BoundKind.QueryExpression
                    Return VisitQueryExpression(CType(node, BoundQueryExpression), arg)
                Case BoundKind.QuerySource
                    Return VisitQuerySource(CType(node, BoundQuerySource), arg)
                Case BoundKind.ToQueryableCollectionConversion
                    Return VisitToQueryableCollectionConversion(CType(node, BoundToQueryableCollectionConversion), arg)
                Case BoundKind.QueryableSource
                    Return VisitQueryableSource(CType(node, BoundQueryableSource), arg)
                Case BoundKind.QueryClause
                    Return VisitQueryClause(CType(node, BoundQueryClause), arg)
                Case BoundKind.Ordering
                    Return VisitOrdering(CType(node, BoundOrdering), arg)
                Case BoundKind.QueryLambda
                    Return VisitQueryLambda(CType(node, BoundQueryLambda), arg)
                Case BoundKind.RangeVariableAssignment
                    Return VisitRangeVariableAssignment(CType(node, BoundRangeVariableAssignment), arg)
                Case BoundKind.GroupTypeInferenceLambda
                    Return VisitGroupTypeInferenceLambda(CType(node, GroupTypeInferenceLambda), arg)
                Case BoundKind.AggregateClause
                    Return VisitAggregateClause(CType(node, BoundAggregateClause), arg)
                Case BoundKind.GroupAggregation
                    Return VisitGroupAggregation(CType(node, BoundGroupAggregation), arg)
                Case BoundKind.RangeVariable
                    Return VisitRangeVariable(CType(node, BoundRangeVariable), arg)
                Case BoundKind.AddHandlerStatement
                    Return VisitAddHandlerStatement(CType(node, BoundAddHandlerStatement), arg)
                Case BoundKind.RemoveHandlerStatement
                    Return VisitRemoveHandlerStatement(CType(node, BoundRemoveHandlerStatement), arg)
                Case BoundKind.RaiseEventStatement
                    Return VisitRaiseEventStatement(CType(node, BoundRaiseEventStatement), arg)
                Case BoundKind.UsingStatement
                    Return VisitUsingStatement(CType(node, BoundUsingStatement), arg)
                Case BoundKind.SyncLockStatement
                    Return VisitSyncLockStatement(CType(node, BoundSyncLockStatement), arg)
                Case BoundKind.XmlName
                    Return VisitXmlName(CType(node, BoundXmlName), arg)
                Case BoundKind.XmlNamespace
                    Return VisitXmlNamespace(CType(node, BoundXmlNamespace), arg)
                Case BoundKind.XmlDocument
                    Return VisitXmlDocument(CType(node, BoundXmlDocument), arg)
                Case BoundKind.XmlDeclaration
                    Return VisitXmlDeclaration(CType(node, BoundXmlDeclaration), arg)
                Case BoundKind.XmlProcessingInstruction
                    Return VisitXmlProcessingInstruction(CType(node, BoundXmlProcessingInstruction), arg)
                Case BoundKind.XmlComment
                    Return VisitXmlComment(CType(node, BoundXmlComment), arg)
                Case BoundKind.XmlAttribute
                    Return VisitXmlAttribute(CType(node, BoundXmlAttribute), arg)
                Case BoundKind.XmlElement
                    Return VisitXmlElement(CType(node, BoundXmlElement), arg)
                Case BoundKind.XmlMemberAccess
                    Return VisitXmlMemberAccess(CType(node, BoundXmlMemberAccess), arg)
                Case BoundKind.XmlEmbeddedExpression
                    Return VisitXmlEmbeddedExpression(CType(node, BoundXmlEmbeddedExpression), arg)
                Case BoundKind.XmlCData
                    Return VisitXmlCData(CType(node, BoundXmlCData), arg)
                Case BoundKind.ResumeStatement
                    Return VisitResumeStatement(CType(node, BoundResumeStatement), arg)
                Case BoundKind.OnErrorStatement
                    Return VisitOnErrorStatement(CType(node, BoundOnErrorStatement), arg)
                Case BoundKind.UnstructuredExceptionHandlingStatement
                    Return VisitUnstructuredExceptionHandlingStatement(CType(node, BoundUnstructuredExceptionHandlingStatement), arg)
                Case BoundKind.UnstructuredExceptionHandlingCatchFilter
                    Return VisitUnstructuredExceptionHandlingCatchFilter(CType(node, BoundUnstructuredExceptionHandlingCatchFilter), arg)
                Case BoundKind.UnstructuredExceptionOnErrorSwitch
                    Return VisitUnstructuredExceptionOnErrorSwitch(CType(node, BoundUnstructuredExceptionOnErrorSwitch), arg)
                Case BoundKind.UnstructuredExceptionResumeSwitch
                    Return VisitUnstructuredExceptionResumeSwitch(CType(node, BoundUnstructuredExceptionResumeSwitch), arg)
                Case BoundKind.AwaitOperator
                    Return VisitAwaitOperator(CType(node, BoundAwaitOperator), arg)
                Case BoundKind.SpillSequence
                    Return VisitSpillSequence(CType(node, BoundSpillSequence), arg)
                Case BoundKind.StopStatement
                    Return VisitStopStatement(CType(node, BoundStopStatement), arg)
                Case BoundKind.EndStatement
                    Return VisitEndStatement(CType(node, BoundEndStatement), arg)
                Case BoundKind.MidResult
                    Return VisitMidResult(CType(node, BoundMidResult), arg)
                Case BoundKind.ConditionalAccess
                    Return VisitConditionalAccess(CType(node, BoundConditionalAccess), arg)
                Case BoundKind.ConditionalAccessReceiverPlaceholder
                    Return VisitConditionalAccessReceiverPlaceholder(CType(node, BoundConditionalAccessReceiverPlaceholder), arg)
                Case BoundKind.LoweredConditionalAccess
                    Return VisitLoweredConditionalAccess(CType(node, BoundLoweredConditionalAccess), arg)
                Case BoundKind.ComplexConditionalAccessReceiver
                    Return VisitComplexConditionalAccessReceiver(CType(node, BoundComplexConditionalAccessReceiver), arg)
                Case BoundKind.NameOfOperator
                    Return VisitNameOfOperator(CType(node, BoundNameOfOperator), arg)
                Case BoundKind.TypeAsValueExpression
                    Return VisitTypeAsValueExpression(CType(node, BoundTypeAsValueExpression), arg)
                Case BoundKind.InterpolatedStringExpression
                    Return VisitInterpolatedStringExpression(CType(node, BoundInterpolatedStringExpression), arg)
                Case BoundKind.Interpolation
                    Return VisitInterpolation(CType(node, BoundInterpolation), arg)
            End Select
            Return DefaultVisit(node, arg)
        End Function

    End Class

    Friend MustInherit Partial Class BoundTreeVisitor(Of A, R)
        Public Overridable Function VisitTypeArguments(node As BoundTypeArguments, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitOmittedArgument(node As BoundOmittedArgument, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLValueToRValueWrapper(node As BoundLValueToRValueWrapper, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitWithLValueExpressionPlaceholder(node As BoundWithLValueExpressionPlaceholder, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitWithRValueExpressionPlaceholder(node As BoundWithRValueExpressionPlaceholder, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRValuePlaceholder(node As BoundRValuePlaceholder, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLValuePlaceholder(node As BoundLValuePlaceholder, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitDup(node As BoundDup, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitBadExpression(node As BoundBadExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitBadStatement(node As BoundBadStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitParenthesized(node As BoundParenthesized, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitBadVariable(node As BoundBadVariable, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitArrayAccess(node As BoundArrayAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitArrayLength(node As BoundArrayLength, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitGetType(node As BoundGetType, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitFieldInfo(node As BoundFieldInfo, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMethodInfo(node As BoundMethodInfo, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTypeExpression(node As BoundTypeExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTypeOrValueExpression(node As BoundTypeOrValueExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitNamespaceExpression(node As BoundNamespaceExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMethodDefIndex(node As BoundMethodDefIndex, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMaximumMethodDefIndex(node As BoundMaximumMethodDefIndex, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitInstrumentationPayloadRoot(node As BoundInstrumentationPayloadRoot, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitModuleVersionId(node As BoundModuleVersionId, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitModuleVersionIdString(node As BoundModuleVersionIdString, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSourceDocumentIndex(node As BoundSourceDocumentIndex, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUnaryOperator(node As BoundUnaryOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUserDefinedUnaryOperator(node As BoundUserDefinedUnaryOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitNullableIsTrueOperator(node As BoundNullableIsTrueOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitBinaryOperator(node As BoundBinaryOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUserDefinedBinaryOperator(node As BoundUserDefinedBinaryOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUserDefinedShortCircuitingOperator(node As BoundUserDefinedShortCircuitingOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitCompoundAssignmentTargetPlaceholder(node As BoundCompoundAssignmentTargetPlaceholder, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAssignmentOperator(node As BoundAssignmentOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitReferenceAssignment(node As BoundReferenceAssignment, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAddressOfOperator(node As BoundAddressOfOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTernaryConditionalExpression(node As BoundTernaryConditionalExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitBinaryConditionalExpression(node As BoundBinaryConditionalExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitConversion(node As BoundConversion, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRelaxationLambda(node As BoundRelaxationLambda, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitConvertedTupleElements(node As BoundConvertedTupleElements, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUserDefinedConversion(node As BoundUserDefinedConversion, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitDirectCast(node As BoundDirectCast, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTryCast(node As BoundTryCast, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTypeOf(node As BoundTypeOf, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSequencePoint(node As BoundSequencePoint, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSequencePointExpression(node As BoundSequencePointExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSequencePointWithSpan(node As BoundSequencePointWithSpan, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitNoOpStatement(node As BoundNoOpStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMethodGroup(node As BoundMethodGroup, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitPropertyGroup(node As BoundPropertyGroup, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitReturnStatement(node As BoundReturnStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitYieldStatement(node As BoundYieldStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitThrowStatement(node As BoundThrowStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRedimStatement(node As BoundRedimStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRedimClause(node As BoundRedimClause, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitEraseStatement(node As BoundEraseStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitCall(node As BoundCall, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAttribute(node As BoundAttribute, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLateMemberAccess(node As BoundLateMemberAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLateInvocation(node As BoundLateInvocation, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLateAddressOfOperator(node As BoundLateAddressOfOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTupleLiteral(node As BoundTupleLiteral, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitConvertedTupleLiteral(node As BoundConvertedTupleLiteral, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitObjectCreationExpression(node As BoundObjectCreationExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitNoPiaObjectCreationExpression(node As BoundNoPiaObjectCreationExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAnonymousTypeCreationExpression(node As BoundAnonymousTypeCreationExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAnonymousTypePropertyAccess(node As BoundAnonymousTypePropertyAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAnonymousTypeFieldInitializer(node As BoundAnonymousTypeFieldInitializer, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitObjectInitializerExpression(node As BoundObjectInitializerExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitCollectionInitializerExpression(node As BoundCollectionInitializerExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitNewT(node As BoundNewT, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitDelegateCreationExpression(node As BoundDelegateCreationExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitArrayCreation(node As BoundArrayCreation, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitArrayLiteral(node As BoundArrayLiteral, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitArrayInitialization(node As BoundArrayInitialization, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitFieldAccess(node As BoundFieldAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitPropertyAccess(node As BoundPropertyAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitEventAccess(node As BoundEventAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitBlock(node As BoundBlock, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitStateMachineScope(node As BoundStateMachineScope, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLocalDeclaration(node As BoundLocalDeclaration, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAsNewLocalDeclarations(node As BoundAsNewLocalDeclarations, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitDimStatement(node As BoundDimStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitInitializer(node As BoundInitializer, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitFieldInitializer(node As BoundFieldInitializer, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitPropertyInitializer(node As BoundPropertyInitializer, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitParameterEqualsValue(node As BoundParameterEqualsValue, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitGlobalStatementInitializer(node As BoundGlobalStatementInitializer, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSequence(node As BoundSequence, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitExpressionStatement(node As BoundExpressionStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitIfStatement(node As BoundIfStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSelectStatement(node As BoundSelectStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitCaseBlock(node As BoundCaseBlock, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitCaseStatement(node As BoundCaseStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSimpleCaseClause(node As BoundSimpleCaseClause, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRangeCaseClause(node As BoundRangeCaseClause, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRelationalCaseClause(node As BoundRelationalCaseClause, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitDoLoopStatement(node As BoundDoLoopStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitWhileStatement(node As BoundWhileStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitForToUserDefinedOperators(node As BoundForToUserDefinedOperators, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitForToStatement(node As BoundForToStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitForEachStatement(node As BoundForEachStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitExitStatement(node As BoundExitStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitContinueStatement(node As BoundContinueStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTryStatement(node As BoundTryStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitCatchBlock(node As BoundCatchBlock, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLiteral(node As BoundLiteral, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMeReference(node As BoundMeReference, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitValueTypeMeReference(node As BoundValueTypeMeReference, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMyBaseReference(node As BoundMyBaseReference, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMyClassReference(node As BoundMyClassReference, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitPreviousSubmissionReference(node As BoundPreviousSubmissionReference, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitHostObjectMemberReference(node As BoundHostObjectMemberReference, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLocal(node As BoundLocal, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitPseudoVariable(node As BoundPseudoVariable, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitParameter(node As BoundParameter, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitByRefArgumentPlaceholder(node As BoundByRefArgumentPlaceholder, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitByRefArgumentWithCopyBack(node As BoundByRefArgumentWithCopyBack, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLateBoundArgumentSupportingAssignmentWithCapture(node As BoundLateBoundArgumentSupportingAssignmentWithCapture, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLabelStatement(node As BoundLabelStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLabel(node As BoundLabel, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitGotoStatement(node As BoundGotoStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitStatementList(node As BoundStatementList, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitConditionalGoto(node As BoundConditionalGoto, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitWithStatement(node As BoundWithStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUnboundLambda(node As UnboundLambda, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLambda(node As BoundLambda, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitQueryExpression(node As BoundQueryExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitQuerySource(node As BoundQuerySource, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitToQueryableCollectionConversion(node As BoundToQueryableCollectionConversion, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitQueryableSource(node As BoundQueryableSource, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitQueryClause(node As BoundQueryClause, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitOrdering(node As BoundOrdering, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitQueryLambda(node As BoundQueryLambda, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRangeVariableAssignment(node As BoundRangeVariableAssignment, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitGroupTypeInferenceLambda(node As GroupTypeInferenceLambda, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAggregateClause(node As BoundAggregateClause, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitGroupAggregation(node As BoundGroupAggregation, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRangeVariable(node As BoundRangeVariable, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAddHandlerStatement(node As BoundAddHandlerStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRemoveHandlerStatement(node As BoundRemoveHandlerStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitRaiseEventStatement(node As BoundRaiseEventStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUsingStatement(node As BoundUsingStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSyncLockStatement(node As BoundSyncLockStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlName(node As BoundXmlName, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlNamespace(node As BoundXmlNamespace, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlDocument(node As BoundXmlDocument, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlDeclaration(node As BoundXmlDeclaration, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlProcessingInstruction(node As BoundXmlProcessingInstruction, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlComment(node As BoundXmlComment, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlAttribute(node As BoundXmlAttribute, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlElement(node As BoundXmlElement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlMemberAccess(node As BoundXmlMemberAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlEmbeddedExpression(node As BoundXmlEmbeddedExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitXmlCData(node As BoundXmlCData, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitResumeStatement(node As BoundResumeStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitOnErrorStatement(node As BoundOnErrorStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUnstructuredExceptionHandlingStatement(node As BoundUnstructuredExceptionHandlingStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUnstructuredExceptionHandlingCatchFilter(node As BoundUnstructuredExceptionHandlingCatchFilter, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUnstructuredExceptionOnErrorSwitch(node As BoundUnstructuredExceptionOnErrorSwitch, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitUnstructuredExceptionResumeSwitch(node As BoundUnstructuredExceptionResumeSwitch, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitAwaitOperator(node As BoundAwaitOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitSpillSequence(node As BoundSpillSequence, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitStopStatement(node As BoundStopStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitEndStatement(node As BoundEndStatement, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitMidResult(node As BoundMidResult, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitConditionalAccess(node As BoundConditionalAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitConditionalAccessReceiverPlaceholder(node As BoundConditionalAccessReceiverPlaceholder, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitLoweredConditionalAccess(node As BoundLoweredConditionalAccess, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitComplexConditionalAccessReceiver(node As BoundComplexConditionalAccessReceiver, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitNameOfOperator(node As BoundNameOfOperator, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitTypeAsValueExpression(node As BoundTypeAsValueExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitInterpolatedStringExpression(node As BoundInterpolatedStringExpression, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

        Public Overridable Function VisitInterpolation(node As BoundInterpolation, arg As A) As R
            Return Me.DefaultVisit(node, arg)
        End Function

    End Class

    Friend MustInherit Partial Class BoundTreeVisitor
        Public Overridable Function VisitTypeArguments(node As BoundTypeArguments) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitOmittedArgument(node As BoundOmittedArgument) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLValueToRValueWrapper(node As BoundLValueToRValueWrapper) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitWithLValueExpressionPlaceholder(node As BoundWithLValueExpressionPlaceholder) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitWithRValueExpressionPlaceholder(node As BoundWithRValueExpressionPlaceholder) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRValuePlaceholder(node As BoundRValuePlaceholder) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLValuePlaceholder(node As BoundLValuePlaceholder) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitDup(node As BoundDup) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitBadExpression(node As BoundBadExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitBadStatement(node As BoundBadStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitParenthesized(node As BoundParenthesized) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitBadVariable(node As BoundBadVariable) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitArrayAccess(node As BoundArrayAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitArrayLength(node As BoundArrayLength) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitGetType(node As BoundGetType) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitFieldInfo(node As BoundFieldInfo) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMethodInfo(node As BoundMethodInfo) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTypeExpression(node As BoundTypeExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTypeOrValueExpression(node As BoundTypeOrValueExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitNamespaceExpression(node As BoundNamespaceExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMethodDefIndex(node As BoundMethodDefIndex) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMaximumMethodDefIndex(node As BoundMaximumMethodDefIndex) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitInstrumentationPayloadRoot(node As BoundInstrumentationPayloadRoot) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitModuleVersionId(node As BoundModuleVersionId) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitModuleVersionIdString(node As BoundModuleVersionIdString) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSourceDocumentIndex(node As BoundSourceDocumentIndex) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUnaryOperator(node As BoundUnaryOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUserDefinedUnaryOperator(node As BoundUserDefinedUnaryOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitNullableIsTrueOperator(node As BoundNullableIsTrueOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitBinaryOperator(node As BoundBinaryOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUserDefinedBinaryOperator(node As BoundUserDefinedBinaryOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUserDefinedShortCircuitingOperator(node As BoundUserDefinedShortCircuitingOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitCompoundAssignmentTargetPlaceholder(node As BoundCompoundAssignmentTargetPlaceholder) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAssignmentOperator(node As BoundAssignmentOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitReferenceAssignment(node As BoundReferenceAssignment) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAddressOfOperator(node As BoundAddressOfOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTernaryConditionalExpression(node As BoundTernaryConditionalExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitBinaryConditionalExpression(node As BoundBinaryConditionalExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitConversion(node As BoundConversion) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRelaxationLambda(node As BoundRelaxationLambda) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitConvertedTupleElements(node As BoundConvertedTupleElements) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUserDefinedConversion(node As BoundUserDefinedConversion) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitDirectCast(node As BoundDirectCast) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTryCast(node As BoundTryCast) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTypeOf(node As BoundTypeOf) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSequencePoint(node As BoundSequencePoint) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSequencePointExpression(node As BoundSequencePointExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSequencePointWithSpan(node As BoundSequencePointWithSpan) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitNoOpStatement(node As BoundNoOpStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMethodGroup(node As BoundMethodGroup) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitPropertyGroup(node As BoundPropertyGroup) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitReturnStatement(node As BoundReturnStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitYieldStatement(node As BoundYieldStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitThrowStatement(node As BoundThrowStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRedimStatement(node As BoundRedimStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRedimClause(node As BoundRedimClause) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitEraseStatement(node As BoundEraseStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitCall(node As BoundCall) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAttribute(node As BoundAttribute) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLateMemberAccess(node As BoundLateMemberAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLateInvocation(node As BoundLateInvocation) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLateAddressOfOperator(node As BoundLateAddressOfOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTupleLiteral(node As BoundTupleLiteral) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitConvertedTupleLiteral(node As BoundConvertedTupleLiteral) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitObjectCreationExpression(node As BoundObjectCreationExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitNoPiaObjectCreationExpression(node As BoundNoPiaObjectCreationExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAnonymousTypeCreationExpression(node As BoundAnonymousTypeCreationExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAnonymousTypePropertyAccess(node As BoundAnonymousTypePropertyAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAnonymousTypeFieldInitializer(node As BoundAnonymousTypeFieldInitializer) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitObjectInitializerExpression(node As BoundObjectInitializerExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitCollectionInitializerExpression(node As BoundCollectionInitializerExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitNewT(node As BoundNewT) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitDelegateCreationExpression(node As BoundDelegateCreationExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitArrayCreation(node As BoundArrayCreation) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitArrayLiteral(node As BoundArrayLiteral) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitArrayInitialization(node As BoundArrayInitialization) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitFieldAccess(node As BoundFieldAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitPropertyAccess(node As BoundPropertyAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitEventAccess(node As BoundEventAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitBlock(node As BoundBlock) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitStateMachineScope(node As BoundStateMachineScope) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLocalDeclaration(node As BoundLocalDeclaration) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAsNewLocalDeclarations(node As BoundAsNewLocalDeclarations) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitDimStatement(node As BoundDimStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitInitializer(node As BoundInitializer) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitFieldInitializer(node As BoundFieldInitializer) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitPropertyInitializer(node As BoundPropertyInitializer) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitParameterEqualsValue(node As BoundParameterEqualsValue) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitGlobalStatementInitializer(node As BoundGlobalStatementInitializer) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSequence(node As BoundSequence) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitExpressionStatement(node As BoundExpressionStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitIfStatement(node As BoundIfStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSelectStatement(node As BoundSelectStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitCaseBlock(node As BoundCaseBlock) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitCaseStatement(node As BoundCaseStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSimpleCaseClause(node As BoundSimpleCaseClause) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRangeCaseClause(node As BoundRangeCaseClause) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRelationalCaseClause(node As BoundRelationalCaseClause) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitDoLoopStatement(node As BoundDoLoopStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitWhileStatement(node As BoundWhileStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitForToUserDefinedOperators(node As BoundForToUserDefinedOperators) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitForToStatement(node As BoundForToStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitForEachStatement(node As BoundForEachStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitExitStatement(node As BoundExitStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitContinueStatement(node As BoundContinueStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTryStatement(node As BoundTryStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitCatchBlock(node As BoundCatchBlock) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLiteral(node As BoundLiteral) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMeReference(node As BoundMeReference) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitValueTypeMeReference(node As BoundValueTypeMeReference) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMyBaseReference(node As BoundMyBaseReference) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMyClassReference(node As BoundMyClassReference) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitPreviousSubmissionReference(node As BoundPreviousSubmissionReference) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitHostObjectMemberReference(node As BoundHostObjectMemberReference) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLocal(node As BoundLocal) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitPseudoVariable(node As BoundPseudoVariable) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitParameter(node As BoundParameter) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitByRefArgumentPlaceholder(node As BoundByRefArgumentPlaceholder) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitByRefArgumentWithCopyBack(node As BoundByRefArgumentWithCopyBack) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLateBoundArgumentSupportingAssignmentWithCapture(node As BoundLateBoundArgumentSupportingAssignmentWithCapture) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLabelStatement(node As BoundLabelStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLabel(node As BoundLabel) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitGotoStatement(node As BoundGotoStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitStatementList(node As BoundStatementList) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitConditionalGoto(node As BoundConditionalGoto) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitWithStatement(node As BoundWithStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUnboundLambda(node As UnboundLambda) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLambda(node As BoundLambda) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitQueryExpression(node As BoundQueryExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitQuerySource(node As BoundQuerySource) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitToQueryableCollectionConversion(node As BoundToQueryableCollectionConversion) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitQueryableSource(node As BoundQueryableSource) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitQueryClause(node As BoundQueryClause) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitOrdering(node As BoundOrdering) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitQueryLambda(node As BoundQueryLambda) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRangeVariableAssignment(node As BoundRangeVariableAssignment) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitGroupTypeInferenceLambda(node As GroupTypeInferenceLambda) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAggregateClause(node As BoundAggregateClause) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitGroupAggregation(node As BoundGroupAggregation) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRangeVariable(node As BoundRangeVariable) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAddHandlerStatement(node As BoundAddHandlerStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRemoveHandlerStatement(node As BoundRemoveHandlerStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitRaiseEventStatement(node As BoundRaiseEventStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUsingStatement(node As BoundUsingStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSyncLockStatement(node As BoundSyncLockStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlName(node As BoundXmlName) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlNamespace(node As BoundXmlNamespace) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlDocument(node As BoundXmlDocument) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlDeclaration(node As BoundXmlDeclaration) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlProcessingInstruction(node As BoundXmlProcessingInstruction) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlComment(node As BoundXmlComment) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlAttribute(node As BoundXmlAttribute) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlElement(node As BoundXmlElement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlMemberAccess(node As BoundXmlMemberAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlEmbeddedExpression(node As BoundXmlEmbeddedExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitXmlCData(node As BoundXmlCData) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitResumeStatement(node As BoundResumeStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitOnErrorStatement(node As BoundOnErrorStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUnstructuredExceptionHandlingStatement(node As BoundUnstructuredExceptionHandlingStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUnstructuredExceptionHandlingCatchFilter(node As BoundUnstructuredExceptionHandlingCatchFilter) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUnstructuredExceptionOnErrorSwitch(node As BoundUnstructuredExceptionOnErrorSwitch) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitUnstructuredExceptionResumeSwitch(node As BoundUnstructuredExceptionResumeSwitch) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitAwaitOperator(node As BoundAwaitOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitSpillSequence(node As BoundSpillSequence) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitStopStatement(node As BoundStopStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitEndStatement(node As BoundEndStatement) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitMidResult(node As BoundMidResult) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitConditionalAccess(node As BoundConditionalAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitConditionalAccessReceiverPlaceholder(node As BoundConditionalAccessReceiverPlaceholder) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitLoweredConditionalAccess(node As BoundLoweredConditionalAccess) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitComplexConditionalAccessReceiver(node As BoundComplexConditionalAccessReceiver) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitNameOfOperator(node As BoundNameOfOperator) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitTypeAsValueExpression(node As BoundTypeAsValueExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitInterpolatedStringExpression(node As BoundInterpolatedStringExpression) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

        Public Overridable Function VisitInterpolation(node As BoundInterpolation) As BoundNode
            Return Me.DefaultVisit(node)
        End Function

    End Class

    Friend MustInherit Partial Class BoundTreeWalker
        Inherits BoundTreeVisitor

        Public Overrides Function VisitTypeArguments(node As BoundTypeArguments) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitOmittedArgument(node As BoundOmittedArgument) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitLValueToRValueWrapper(node As BoundLValueToRValueWrapper) As BoundNode
            Me.Visit(node.UnderlyingLValue)
            Return Nothing
        End Function

        Public Overrides Function VisitWithLValueExpressionPlaceholder(node As BoundWithLValueExpressionPlaceholder) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitWithRValueExpressionPlaceholder(node As BoundWithRValueExpressionPlaceholder) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitRValuePlaceholder(node As BoundRValuePlaceholder) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitLValuePlaceholder(node As BoundLValuePlaceholder) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitDup(node As BoundDup) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitBadExpression(node As BoundBadExpression) As BoundNode
            Me.VisitList(node.ChildBoundNodes)
            Return Nothing
        End Function

        Public Overrides Function VisitBadStatement(node As BoundBadStatement) As BoundNode
            Me.VisitList(node.ChildBoundNodes)
            Return Nothing
        End Function

        Public Overrides Function VisitParenthesized(node As BoundParenthesized) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitBadVariable(node As BoundBadVariable) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitArrayAccess(node As BoundArrayAccess) As BoundNode
            Me.Visit(node.Expression)
            Me.VisitList(node.Indices)
            Return Nothing
        End Function

        Public Overrides Function VisitArrayLength(node As BoundArrayLength) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitGetType(node As BoundGetType) As BoundNode
            Me.Visit(node.SourceType)
            Return Nothing
        End Function

        Public Overrides Function VisitFieldInfo(node As BoundFieldInfo) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitMethodInfo(node As BoundMethodInfo) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitTypeExpression(node As BoundTypeExpression) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitTypeOrValueExpression(node As BoundTypeOrValueExpression) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitNamespaceExpression(node As BoundNamespaceExpression) As BoundNode
            Me.Visit(node.UnevaluatedReceiverOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitMethodDefIndex(node As BoundMethodDefIndex) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitMaximumMethodDefIndex(node As BoundMaximumMethodDefIndex) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitInstrumentationPayloadRoot(node As BoundInstrumentationPayloadRoot) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitModuleVersionId(node As BoundModuleVersionId) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitModuleVersionIdString(node As BoundModuleVersionIdString) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitSourceDocumentIndex(node As BoundSourceDocumentIndex) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitUnaryOperator(node As BoundUnaryOperator) As BoundNode
            Me.Visit(node.Operand)
            Return Nothing
        End Function

        Public Overrides Function VisitUserDefinedUnaryOperator(node As BoundUserDefinedUnaryOperator) As BoundNode
            Me.Visit(node.UnderlyingExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitNullableIsTrueOperator(node As BoundNullableIsTrueOperator) As BoundNode
            Me.Visit(node.Operand)
            Return Nothing
        End Function

        Public Overrides Function VisitBinaryOperator(node As BoundBinaryOperator) As BoundNode
            Me.Visit(node.Left)
            Me.Visit(node.Right)
            Return Nothing
        End Function

        Public Overrides Function VisitUserDefinedBinaryOperator(node As BoundUserDefinedBinaryOperator) As BoundNode
            Me.Visit(node.UnderlyingExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitUserDefinedShortCircuitingOperator(node As BoundUserDefinedShortCircuitingOperator) As BoundNode
            Me.Visit(node.LeftOperand)
            Me.Visit(node.LeftOperandPlaceholder)
            Me.Visit(node.LeftTest)
            Me.Visit(node.BitwiseOperator)
            Return Nothing
        End Function

        Public Overrides Function VisitCompoundAssignmentTargetPlaceholder(node As BoundCompoundAssignmentTargetPlaceholder) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitAssignmentOperator(node As BoundAssignmentOperator) As BoundNode
            Me.Visit(node.Left)
            Me.Visit(node.LeftOnTheRightOpt)
            Me.Visit(node.Right)
            Return Nothing
        End Function

        Public Overrides Function VisitReferenceAssignment(node As BoundReferenceAssignment) As BoundNode
            Me.Visit(node.ByRefLocal)
            Me.Visit(node.LValue)
            Return Nothing
        End Function

        Public Overrides Function VisitAddressOfOperator(node As BoundAddressOfOperator) As BoundNode
            Me.Visit(node.MethodGroup)
            Return Nothing
        End Function

        Public Overrides Function VisitTernaryConditionalExpression(node As BoundTernaryConditionalExpression) As BoundNode
            Me.Visit(node.Condition)
            Me.Visit(node.WhenTrue)
            Me.Visit(node.WhenFalse)
            Return Nothing
        End Function

        Public Overrides Function VisitBinaryConditionalExpression(node As BoundBinaryConditionalExpression) As BoundNode
            Me.Visit(node.TestExpression)
            Me.Visit(node.ElseExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitConversion(node As BoundConversion) As BoundNode
            Me.Visit(node.Operand)
            Me.Visit(node.ExtendedInfoOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitRelaxationLambda(node As BoundRelaxationLambda) As BoundNode
            Me.Visit(node.Lambda)
            Me.Visit(node.ReceiverPlaceholderOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitConvertedTupleElements(node As BoundConvertedTupleElements) As BoundNode
            Me.VisitList(node.ElementPlaceholders)
            Me.VisitList(node.ConvertedElements)
            Return Nothing
        End Function

        Public Overrides Function VisitUserDefinedConversion(node As BoundUserDefinedConversion) As BoundNode
            Me.Visit(node.UnderlyingExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitDirectCast(node As BoundDirectCast) As BoundNode
            Me.Visit(node.Operand)
            Me.Visit(node.RelaxationLambdaOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitTryCast(node As BoundTryCast) As BoundNode
            Me.Visit(node.Operand)
            Me.Visit(node.RelaxationLambdaOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitTypeOf(node As BoundTypeOf) As BoundNode
            Me.Visit(node.Operand)
            Return Nothing
        End Function

        Public Overrides Function VisitSequencePoint(node As BoundSequencePoint) As BoundNode
            Me.Visit(node.StatementOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitSequencePointExpression(node As BoundSequencePointExpression) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitSequencePointWithSpan(node As BoundSequencePointWithSpan) As BoundNode
            Me.Visit(node.StatementOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitNoOpStatement(node As BoundNoOpStatement) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitMethodGroup(node As BoundMethodGroup) As BoundNode
            Me.Visit(node.TypeArgumentsOpt)
            Me.Visit(node.ReceiverOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitPropertyGroup(node As BoundPropertyGroup) As BoundNode
            Me.Visit(node.ReceiverOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitReturnStatement(node As BoundReturnStatement) As BoundNode
            Me.Visit(node.ExpressionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitYieldStatement(node As BoundYieldStatement) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitThrowStatement(node As BoundThrowStatement) As BoundNode
            Me.Visit(node.ExpressionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitRedimStatement(node As BoundRedimStatement) As BoundNode
            Me.VisitList(node.Clauses)
            Return Nothing
        End Function

        Public Overrides Function VisitRedimClause(node As BoundRedimClause) As BoundNode
            Me.Visit(node.Operand)
            Me.VisitList(node.Indices)
            Return Nothing
        End Function

        Public Overrides Function VisitEraseStatement(node As BoundEraseStatement) As BoundNode
            Me.VisitList(node.Clauses)
            Return Nothing
        End Function

        Public Overrides Function VisitCall(node As BoundCall) As BoundNode
            Me.Visit(node.ReceiverOpt)
            Me.VisitList(node.Arguments)
            Return Nothing
        End Function

        Public Overrides Function VisitAttribute(node As BoundAttribute) As BoundNode
            Me.VisitList(node.ConstructorArguments)
            Me.VisitList(node.NamedArguments)
            Return Nothing
        End Function

        Public Overrides Function VisitLateMemberAccess(node As BoundLateMemberAccess) As BoundNode
            Me.Visit(node.ReceiverOpt)
            Me.Visit(node.TypeArgumentsOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitLateInvocation(node As BoundLateInvocation) As BoundNode
            Me.Visit(node.Member)
            Me.VisitList(node.ArgumentsOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitLateAddressOfOperator(node As BoundLateAddressOfOperator) As BoundNode
            Me.Visit(node.MemberAccess)
            Return Nothing
        End Function

        Public Overrides Function VisitTupleLiteral(node As BoundTupleLiteral) As BoundNode
            Me.VisitList(node.Arguments)
            Return Nothing
        End Function

        Public Overrides Function VisitConvertedTupleLiteral(node As BoundConvertedTupleLiteral) As BoundNode
            Me.VisitList(node.Arguments)
            Return Nothing
        End Function

        Public Overrides Function VisitObjectCreationExpression(node As BoundObjectCreationExpression) As BoundNode
            Me.VisitList(node.Arguments)
            Me.Visit(node.InitializerOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitNoPiaObjectCreationExpression(node As BoundNoPiaObjectCreationExpression) As BoundNode
            Me.Visit(node.InitializerOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitAnonymousTypeCreationExpression(node As BoundAnonymousTypeCreationExpression) As BoundNode
            Me.VisitList(node.Declarations)
            Me.VisitList(node.Arguments)
            Return Nothing
        End Function

        Public Overrides Function VisitAnonymousTypePropertyAccess(node As BoundAnonymousTypePropertyAccess) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitAnonymousTypeFieldInitializer(node As BoundAnonymousTypeFieldInitializer) As BoundNode
            Me.Visit(node.Value)
            Return Nothing
        End Function

        Public Overrides Function VisitObjectInitializerExpression(node As BoundObjectInitializerExpression) As BoundNode
            Me.Visit(node.PlaceholderOpt)
            Me.VisitList(node.Initializers)
            Return Nothing
        End Function

        Public Overrides Function VisitCollectionInitializerExpression(node As BoundCollectionInitializerExpression) As BoundNode
            Me.Visit(node.PlaceholderOpt)
            Me.VisitList(node.Initializers)
            Return Nothing
        End Function

        Public Overrides Function VisitNewT(node As BoundNewT) As BoundNode
            Me.Visit(node.InitializerOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitDelegateCreationExpression(node As BoundDelegateCreationExpression) As BoundNode
            Me.Visit(node.ReceiverOpt)
            Me.Visit(node.RelaxationLambdaOpt)
            Me.Visit(node.RelaxationReceiverPlaceholderOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitArrayCreation(node As BoundArrayCreation) As BoundNode
            Me.VisitList(node.Bounds)
            Me.Visit(node.InitializerOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitArrayLiteral(node As BoundArrayLiteral) As BoundNode
            Me.VisitList(node.Bounds)
            Me.Visit(node.Initializer)
            Return Nothing
        End Function

        Public Overrides Function VisitArrayInitialization(node As BoundArrayInitialization) As BoundNode
            Me.VisitList(node.Initializers)
            Return Nothing
        End Function

        Public Overrides Function VisitFieldAccess(node As BoundFieldAccess) As BoundNode
            Me.Visit(node.ReceiverOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitPropertyAccess(node As BoundPropertyAccess) As BoundNode
            Me.Visit(node.ReceiverOpt)
            Me.VisitList(node.Arguments)
            Return Nothing
        End Function

        Public Overrides Function VisitEventAccess(node As BoundEventAccess) As BoundNode
            Me.Visit(node.ReceiverOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitBlock(node As BoundBlock) As BoundNode
            Me.VisitList(node.Statements)
            Return Nothing
        End Function

        Public Overrides Function VisitStateMachineScope(node As BoundStateMachineScope) As BoundNode
            Me.Visit(node.Statement)
            Return Nothing
        End Function

        Public Overrides Function VisitLocalDeclaration(node As BoundLocalDeclaration) As BoundNode
            Me.Visit(node.DeclarationInitializerOpt)
            Me.Visit(node.IdentifierInitializerOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitAsNewLocalDeclarations(node As BoundAsNewLocalDeclarations) As BoundNode
            Me.VisitList(node.LocalDeclarations)
            Me.Visit(node.Initializer)
            Return Nothing
        End Function

        Public Overrides Function VisitDimStatement(node As BoundDimStatement) As BoundNode
            Me.VisitList(node.LocalDeclarations)
            Me.Visit(node.InitializerOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitInitializer(node As BoundInitializer) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitFieldInitializer(node As BoundFieldInitializer) As BoundNode
            Me.Visit(node.MemberAccessExpressionOpt)
            Me.Visit(node.InitialValue)
            Return Nothing
        End Function

        Public Overrides Function VisitPropertyInitializer(node As BoundPropertyInitializer) As BoundNode
            Me.Visit(node.MemberAccessExpressionOpt)
            Me.Visit(node.InitialValue)
            Return Nothing
        End Function

        Public Overrides Function VisitParameterEqualsValue(node As BoundParameterEqualsValue) As BoundNode
            Me.Visit(node.Value)
            Return Nothing
        End Function

        Public Overrides Function VisitGlobalStatementInitializer(node As BoundGlobalStatementInitializer) As BoundNode
            Me.Visit(node.Statement)
            Return Nothing
        End Function

        Public Overrides Function VisitSequence(node As BoundSequence) As BoundNode
            Me.VisitList(node.SideEffects)
            Me.Visit(node.ValueOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitExpressionStatement(node As BoundExpressionStatement) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitIfStatement(node As BoundIfStatement) As BoundNode
            Me.Visit(node.Condition)
            Me.Visit(node.Consequence)
            Me.Visit(node.AlternativeOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitSelectStatement(node As BoundSelectStatement) As BoundNode
            Me.Visit(node.ExpressionStatement)
            Me.Visit(node.ExprPlaceholderOpt)
            Me.VisitList(node.CaseBlocks)
            Return Nothing
        End Function

        Public Overrides Function VisitCaseBlock(node As BoundCaseBlock) As BoundNode
            Me.Visit(node.CaseStatement)
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitCaseStatement(node As BoundCaseStatement) As BoundNode
            Me.VisitList(node.CaseClauses)
            Me.Visit(node.ConditionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitSimpleCaseClause(node As BoundSimpleCaseClause) As BoundNode
            Me.Visit(node.ValueOpt)
            Me.Visit(node.ConditionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitRangeCaseClause(node As BoundRangeCaseClause) As BoundNode
            Me.Visit(node.LowerBoundOpt)
            Me.Visit(node.UpperBoundOpt)
            Me.Visit(node.LowerBoundConditionOpt)
            Me.Visit(node.UpperBoundConditionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitRelationalCaseClause(node As BoundRelationalCaseClause) As BoundNode
            Me.Visit(node.ValueOpt)
            Me.Visit(node.ConditionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitDoLoopStatement(node As BoundDoLoopStatement) As BoundNode
            Me.Visit(node.TopConditionOpt)
            Me.Visit(node.BottomConditionOpt)
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitWhileStatement(node As BoundWhileStatement) As BoundNode
            Me.Visit(node.Condition)
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitForToUserDefinedOperators(node As BoundForToUserDefinedOperators) As BoundNode
            Me.Visit(node.LeftOperandPlaceholder)
            Me.Visit(node.RightOperandPlaceholder)
            Me.Visit(node.Addition)
            Me.Visit(node.Subtraction)
            Me.Visit(node.LessThanOrEqual)
            Me.Visit(node.GreaterThanOrEqual)
            Return Nothing
        End Function

        Public Overrides Function VisitForToStatement(node As BoundForToStatement) As BoundNode
            Me.Visit(node.InitialValue)
            Me.Visit(node.LimitValue)
            Me.Visit(node.StepValue)
            Me.Visit(node.OperatorsOpt)
            Me.Visit(node.ControlVariable)
            Me.Visit(node.Body)
            Me.VisitList(node.NextVariablesOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitForEachStatement(node As BoundForEachStatement) As BoundNode
            Me.Visit(node.Collection)
            Me.Visit(node.ControlVariable)
            Me.Visit(node.Body)
            Me.VisitList(node.NextVariablesOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitExitStatement(node As BoundExitStatement) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitContinueStatement(node As BoundContinueStatement) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitTryStatement(node As BoundTryStatement) As BoundNode
            Me.Visit(node.TryBlock)
            Me.VisitList(node.CatchBlocks)
            Me.Visit(node.FinallyBlockOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitCatchBlock(node As BoundCatchBlock) As BoundNode
            Me.Visit(node.ExceptionSourceOpt)
            Me.Visit(node.ErrorLineNumberOpt)
            Me.Visit(node.ExceptionFilterOpt)
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitLiteral(node As BoundLiteral) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitMeReference(node As BoundMeReference) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitValueTypeMeReference(node As BoundValueTypeMeReference) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitMyBaseReference(node As BoundMyBaseReference) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitMyClassReference(node As BoundMyClassReference) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitPreviousSubmissionReference(node As BoundPreviousSubmissionReference) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitHostObjectMemberReference(node As BoundHostObjectMemberReference) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitLocal(node As BoundLocal) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitPseudoVariable(node As BoundPseudoVariable) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitParameter(node As BoundParameter) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitByRefArgumentPlaceholder(node As BoundByRefArgumentPlaceholder) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitByRefArgumentWithCopyBack(node As BoundByRefArgumentWithCopyBack) As BoundNode
            Me.Visit(node.OriginalArgument)
            Me.Visit(node.InConversion)
            Me.Visit(node.InPlaceholder)
            Me.Visit(node.OutConversion)
            Me.Visit(node.OutPlaceholder)
            Return Nothing
        End Function

        Public Overrides Function VisitLateBoundArgumentSupportingAssignmentWithCapture(node As BoundLateBoundArgumentSupportingAssignmentWithCapture) As BoundNode
            Me.Visit(node.OriginalArgument)
            Return Nothing
        End Function

        Public Overrides Function VisitLabelStatement(node As BoundLabelStatement) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitLabel(node As BoundLabel) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitGotoStatement(node As BoundGotoStatement) As BoundNode
            Me.Visit(node.LabelExpressionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitStatementList(node As BoundStatementList) As BoundNode
            Me.VisitList(node.Statements)
            Return Nothing
        End Function

        Public Overrides Function VisitConditionalGoto(node As BoundConditionalGoto) As BoundNode
            Me.Visit(node.Condition)
            Return Nothing
        End Function

        Public Overrides Function VisitWithStatement(node As BoundWithStatement) As BoundNode
            Me.Visit(node.OriginalExpression)
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitUnboundLambda(node As UnboundLambda) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitLambda(node As BoundLambda) As BoundNode
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitQueryExpression(node As BoundQueryExpression) As BoundNode
            Me.Visit(node.LastOperator)
            Return Nothing
        End Function

        Public Overrides Function VisitQuerySource(node As BoundQuerySource) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitToQueryableCollectionConversion(node As BoundToQueryableCollectionConversion) As BoundNode
            Me.Visit(node.ConversionCall)
            Return Nothing
        End Function

        Public Overrides Function VisitQueryableSource(node As BoundQueryableSource) As BoundNode
            Me.Visit(node.Source)
            Return Nothing
        End Function

        Public Overrides Function VisitQueryClause(node As BoundQueryClause) As BoundNode
            Me.Visit(node.UnderlyingExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitOrdering(node As BoundOrdering) As BoundNode
            Me.Visit(node.UnderlyingExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitQueryLambda(node As BoundQueryLambda) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitRangeVariableAssignment(node As BoundRangeVariableAssignment) As BoundNode
            Me.Visit(node.Value)
            Return Nothing
        End Function

        Public Overrides Function VisitGroupTypeInferenceLambda(node As GroupTypeInferenceLambda) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitAggregateClause(node As BoundAggregateClause) As BoundNode
            Me.Visit(node.CapturedGroupOpt)
            Me.Visit(node.GroupPlaceholderOpt)
            Me.Visit(node.UnderlyingExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitGroupAggregation(node As BoundGroupAggregation) As BoundNode
            Me.Visit(node.Group)
            Return Nothing
        End Function

        Public Overrides Function VisitRangeVariable(node As BoundRangeVariable) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitAddHandlerStatement(node As BoundAddHandlerStatement) As BoundNode
            Me.Visit(node.EventAccess)
            Me.Visit(node.Handler)
            Return Nothing
        End Function

        Public Overrides Function VisitRemoveHandlerStatement(node As BoundRemoveHandlerStatement) As BoundNode
            Me.Visit(node.EventAccess)
            Me.Visit(node.Handler)
            Return Nothing
        End Function

        Public Overrides Function VisitRaiseEventStatement(node As BoundRaiseEventStatement) As BoundNode
            Me.Visit(node.EventInvocation)
            Return Nothing
        End Function

        Public Overrides Function VisitUsingStatement(node As BoundUsingStatement) As BoundNode
            Me.VisitList(node.ResourceList)
            Me.Visit(node.ResourceExpressionOpt)
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitSyncLockStatement(node As BoundSyncLockStatement) As BoundNode
            Me.Visit(node.LockExpression)
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlName(node As BoundXmlName) As BoundNode
            Me.Visit(node.XmlNamespace)
            Me.Visit(node.LocalName)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlNamespace(node As BoundXmlNamespace) As BoundNode
            Me.Visit(node.XmlNamespace)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlDocument(node As BoundXmlDocument) As BoundNode
            Me.Visit(node.Declaration)
            Me.VisitList(node.ChildNodes)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlDeclaration(node As BoundXmlDeclaration) As BoundNode
            Me.Visit(node.Version)
            Me.Visit(node.Encoding)
            Me.Visit(node.Standalone)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlProcessingInstruction(node As BoundXmlProcessingInstruction) As BoundNode
            Me.Visit(node.Target)
            Me.Visit(node.Data)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlComment(node As BoundXmlComment) As BoundNode
            Me.Visit(node.Value)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlAttribute(node As BoundXmlAttribute) As BoundNode
            Me.Visit(node.Name)
            Me.Visit(node.Value)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlElement(node As BoundXmlElement) As BoundNode
            Me.Visit(node.Argument)
            Me.VisitList(node.ChildNodes)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlMemberAccess(node As BoundXmlMemberAccess) As BoundNode
            Me.Visit(node.MemberAccess)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlEmbeddedExpression(node As BoundXmlEmbeddedExpression) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitXmlCData(node As BoundXmlCData) As BoundNode
            Me.Visit(node.Value)
            Return Nothing
        End Function

        Public Overrides Function VisitResumeStatement(node As BoundResumeStatement) As BoundNode
            Me.Visit(node.LabelExpressionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitOnErrorStatement(node As BoundOnErrorStatement) As BoundNode
            Me.Visit(node.LabelExpressionOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitUnstructuredExceptionHandlingStatement(node As BoundUnstructuredExceptionHandlingStatement) As BoundNode
            Me.Visit(node.Body)
            Return Nothing
        End Function

        Public Overrides Function VisitUnstructuredExceptionHandlingCatchFilter(node As BoundUnstructuredExceptionHandlingCatchFilter) As BoundNode
            Me.Visit(node.ActiveHandlerLocal)
            Me.Visit(node.ResumeTargetLocal)
            Return Nothing
        End Function

        Public Overrides Function VisitUnstructuredExceptionOnErrorSwitch(node As BoundUnstructuredExceptionOnErrorSwitch) As BoundNode
            Me.Visit(node.Value)
            Me.VisitList(node.Jumps)
            Return Nothing
        End Function

        Public Overrides Function VisitUnstructuredExceptionResumeSwitch(node As BoundUnstructuredExceptionResumeSwitch) As BoundNode
            Me.Visit(node.ResumeTargetTemporary)
            Me.Visit(node.ResumeLabel)
            Me.Visit(node.ResumeNextLabel)
            Me.VisitList(node.Jumps)
            Return Nothing
        End Function

        Public Overrides Function VisitAwaitOperator(node As BoundAwaitOperator) As BoundNode
            Me.Visit(node.Operand)
            Me.Visit(node.AwaitableInstancePlaceholder)
            Me.Visit(node.GetAwaiter)
            Me.Visit(node.AwaiterInstancePlaceholder)
            Me.Visit(node.IsCompleted)
            Me.Visit(node.GetResult)
            Return Nothing
        End Function

        Public Overrides Function VisitSpillSequence(node As BoundSpillSequence) As BoundNode
            Me.VisitList(node.Statements)
            Me.Visit(node.ValueOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitStopStatement(node As BoundStopStatement) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitEndStatement(node As BoundEndStatement) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitMidResult(node As BoundMidResult) As BoundNode
            Me.Visit(node.Original)
            Me.Visit(node.Start)
            Me.Visit(node.LengthOpt)
            Me.Visit(node.Source)
            Return Nothing
        End Function

        Public Overrides Function VisitConditionalAccess(node As BoundConditionalAccess) As BoundNode
            Me.Visit(node.Receiver)
            Me.Visit(node.Placeholder)
            Me.Visit(node.AccessExpression)
            Return Nothing
        End Function

        Public Overrides Function VisitConditionalAccessReceiverPlaceholder(node As BoundConditionalAccessReceiverPlaceholder) As BoundNode
            Return Nothing
        End Function

        Public Overrides Function VisitLoweredConditionalAccess(node As BoundLoweredConditionalAccess) As BoundNode
            Me.Visit(node.ReceiverOrCondition)
            Me.Visit(node.WhenNotNull)
            Me.Visit(node.WhenNullOpt)
            Return Nothing
        End Function

        Public Overrides Function VisitComplexConditionalAccessReceiver(node As BoundComplexConditionalAccessReceiver) As BoundNode
            Me.Visit(node.ValueTypeReceiver)
            Me.Visit(node.ReferenceTypeReceiver)
            Return Nothing
        End Function

        Public Overrides Function VisitNameOfOperator(node As BoundNameOfOperator) As BoundNode
            Me.Visit(node.Argument)
            Return Nothing
        End Function

        Public Overrides Function VisitTypeAsValueExpression(node As BoundTypeAsValueExpression) As BoundNode
            Me.Visit(node.Expression)
            Return Nothing
        End Function

        Public Overrides Function VisitInterpolatedStringExpression(node As BoundInterpolatedStringExpression) As BoundNode
            Me.VisitList(node.Contents)
            Return Nothing
        End Function

        Public Overrides Function VisitInterpolation(node As BoundInterpolation) As BoundNode
            Me.Visit(node.Expression)
            Me.Visit(node.AlignmentOpt)
            Me.Visit(node.FormatStringOpt)
            Return Nothing
        End Function

    End Class

    Friend MustInherit Partial Class BoundTreeRewriter
        Inherits BoundTreeVisitor

        Public Overrides Function VisitTypeArguments(node As BoundTypeArguments) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Arguments)
        End Function

        Public Overrides Function VisitOmittedArgument(node As BoundOmittedArgument) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitLValueToRValueWrapper(node As BoundLValueToRValueWrapper) As BoundNode
            Dim underlyingLValue As BoundExpression = DirectCast(Me.Visit(node.UnderlyingLValue), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(underlyingLValue, type)
        End Function

        Public Overrides Function VisitWithLValueExpressionPlaceholder(node As BoundWithLValueExpressionPlaceholder) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitWithRValueExpressionPlaceholder(node As BoundWithRValueExpressionPlaceholder) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitRValuePlaceholder(node As BoundRValuePlaceholder) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitLValuePlaceholder(node As BoundLValuePlaceholder) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitDup(node As BoundDup) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.IsReference, type)
        End Function

        Public Overrides Function VisitBadExpression(node As BoundBadExpression) As BoundNode
            Dim childBoundNodes As ImmutableArray(Of BoundExpression) = Me.VisitList(node.ChildBoundNodes)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.ResultKind, node.Symbols, childBoundNodes, type)
        End Function

        Public Overrides Function VisitBadStatement(node As BoundBadStatement) As BoundNode
            Dim childBoundNodes As ImmutableArray(Of BoundNode) = Me.VisitList(node.ChildBoundNodes)
            Return node.Update(childBoundNodes)
        End Function

        Public Overrides Function VisitParenthesized(node As BoundParenthesized) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, type)
        End Function

        Public Overrides Function VisitBadVariable(node As BoundBadVariable) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, node.IsLValue, type)
        End Function

        Public Overrides Function VisitArrayAccess(node As BoundArrayAccess) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim indices As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Indices)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, indices, node.IsLValue, type)
        End Function

        Public Overrides Function VisitArrayLength(node As BoundArrayLength) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, type)
        End Function

        Public Overrides Function VisitGetType(node As BoundGetType) As BoundNode
            Dim sourceType As BoundTypeExpression = DirectCast(Me.Visit(node.SourceType), BoundTypeExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(sourceType, node.GetTypeFromHandle, type)
        End Function

        Public Overrides Function VisitFieldInfo(node As BoundFieldInfo) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Field, type)
        End Function

        Public Overrides Function VisitMethodInfo(node As BoundMethodInfo) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Method, node.GetMethodFromHandle, type)
        End Function

        Public Overrides Function VisitTypeExpression(node As BoundTypeExpression) As BoundNode
            Dim unevaluatedReceiverOpt As BoundExpression = node.UnevaluatedReceiverOpt
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(unevaluatedReceiverOpt, node.AliasOpt, type)
        End Function

        Public Overrides Function VisitTypeOrValueExpression(node As BoundTypeOrValueExpression) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Data, type)
        End Function

        Public Overrides Function VisitNamespaceExpression(node As BoundNamespaceExpression) As BoundNode
            Dim unevaluatedReceiverOpt As BoundExpression = DirectCast(Me.Visit(node.UnevaluatedReceiverOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(unevaluatedReceiverOpt, node.AliasOpt, node.NamespaceSymbol)
        End Function

        Public Overrides Function VisitMethodDefIndex(node As BoundMethodDefIndex) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Method, type)
        End Function

        Public Overrides Function VisitMaximumMethodDefIndex(node As BoundMaximumMethodDefIndex) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitInstrumentationPayloadRoot(node As BoundInstrumentationPayloadRoot) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.AnalysisKind, node.IsLValue, type)
        End Function

        Public Overrides Function VisitModuleVersionId(node As BoundModuleVersionId) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.IsLValue, type)
        End Function

        Public Overrides Function VisitModuleVersionIdString(node As BoundModuleVersionIdString) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitSourceDocumentIndex(node As BoundSourceDocumentIndex) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Document, type)
        End Function

        Public Overrides Function VisitUnaryOperator(node As BoundUnaryOperator) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.OperatorKind, operand, node.Checked, node.ConstantValueOpt, type)
        End Function

        Public Overrides Function VisitUserDefinedUnaryOperator(node As BoundUserDefinedUnaryOperator) As BoundNode
            Dim underlyingExpression As BoundExpression = DirectCast(Me.Visit(node.UnderlyingExpression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.OperatorKind, underlyingExpression, type)
        End Function

        Public Overrides Function VisitNullableIsTrueOperator(node As BoundNullableIsTrueOperator) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(operand, type)
        End Function

        Public Overrides Function VisitBinaryOperator(node As BoundBinaryOperator) As BoundNode
            Dim left As BoundExpression = DirectCast(Me.Visit(node.Left), BoundExpression)
            Dim right As BoundExpression = DirectCast(Me.Visit(node.Right), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.OperatorKind, left, right, node.Checked, node.ConstantValueOpt, type)
        End Function

        Public Overrides Function VisitUserDefinedBinaryOperator(node As BoundUserDefinedBinaryOperator) As BoundNode
            Dim underlyingExpression As BoundExpression = DirectCast(Me.Visit(node.UnderlyingExpression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.OperatorKind, underlyingExpression, node.Checked, type)
        End Function

        Public Overrides Function VisitUserDefinedShortCircuitingOperator(node As BoundUserDefinedShortCircuitingOperator) As BoundNode
            Dim leftOperand As BoundExpression = DirectCast(Me.Visit(node.LeftOperand), BoundExpression)
            Dim leftOperandPlaceholder As BoundRValuePlaceholder = DirectCast(Me.Visit(node.LeftOperandPlaceholder), BoundRValuePlaceholder)
            Dim leftTest As BoundExpression = DirectCast(Me.Visit(node.LeftTest), BoundExpression)
            Dim bitwiseOperator As BoundUserDefinedBinaryOperator = DirectCast(Me.Visit(node.BitwiseOperator), BoundUserDefinedBinaryOperator)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(leftOperand, leftOperandPlaceholder, leftTest, bitwiseOperator, type)
        End Function

        Public Overrides Function VisitCompoundAssignmentTargetPlaceholder(node As BoundCompoundAssignmentTargetPlaceholder) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitAssignmentOperator(node As BoundAssignmentOperator) As BoundNode
            Dim left As BoundExpression = DirectCast(Me.Visit(node.Left), BoundExpression)
            Dim leftOnTheRightOpt As BoundCompoundAssignmentTargetPlaceholder = DirectCast(Me.Visit(node.LeftOnTheRightOpt), BoundCompoundAssignmentTargetPlaceholder)
            Dim right As BoundExpression = DirectCast(Me.Visit(node.Right), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(left, leftOnTheRightOpt, right, node.SuppressObjectClone, type)
        End Function

        Public Overrides Function VisitReferenceAssignment(node As BoundReferenceAssignment) As BoundNode
            Dim byRefLocal As BoundLocal = DirectCast(Me.Visit(node.ByRefLocal), BoundLocal)
            Dim lValue As BoundExpression = DirectCast(Me.Visit(node.LValue), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(byRefLocal, lValue, node.IsLValue, type)
        End Function

        Public Overrides Function VisitAddressOfOperator(node As BoundAddressOfOperator) As BoundNode
            Dim methodGroup As BoundMethodGroup = DirectCast(Me.Visit(node.MethodGroup), BoundMethodGroup)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Binder, node.WithDependencies, methodGroup)
        End Function

        Public Overrides Function VisitTernaryConditionalExpression(node As BoundTernaryConditionalExpression) As BoundNode
            Dim condition As BoundExpression = DirectCast(Me.Visit(node.Condition), BoundExpression)
            Dim whenTrue As BoundExpression = DirectCast(Me.Visit(node.WhenTrue), BoundExpression)
            Dim whenFalse As BoundExpression = DirectCast(Me.Visit(node.WhenFalse), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(condition, whenTrue, whenFalse, node.ConstantValueOpt, type)
        End Function

        Public Overrides Function VisitBinaryConditionalExpression(node As BoundBinaryConditionalExpression) As BoundNode
            Dim testExpression As BoundExpression = DirectCast(Me.Visit(node.TestExpression), BoundExpression)
            Dim convertedTestExpression As BoundExpression = node.ConvertedTestExpression
            Dim testExpressionPlaceholder As BoundRValuePlaceholder = node.TestExpressionPlaceholder
            Dim elseExpression As BoundExpression = DirectCast(Me.Visit(node.ElseExpression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(testExpression, convertedTestExpression, testExpressionPlaceholder, elseExpression, node.ConstantValueOpt, type)
        End Function

        Public Overrides Function VisitConversion(node As BoundConversion) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim extendedInfoOpt As BoundExtendedConversionInfo = DirectCast(Me.Visit(node.ExtendedInfoOpt), BoundExtendedConversionInfo)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(operand, node.ConversionKind, node.Checked, node.ExplicitCastInCode, node.ConstantValueOpt, extendedInfoOpt, type)
        End Function

        Public Overrides Function VisitRelaxationLambda(node As BoundRelaxationLambda) As BoundNode
            Dim lambda As BoundLambda = DirectCast(Me.Visit(node.Lambda), BoundLambda)
            Dim receiverPlaceholderOpt As BoundRValuePlaceholder = DirectCast(Me.Visit(node.ReceiverPlaceholderOpt), BoundRValuePlaceholder)
            Return node.Update(lambda, receiverPlaceholderOpt)
        End Function

        Public Overrides Function VisitConvertedTupleElements(node As BoundConvertedTupleElements) As BoundNode
            Dim elementPlaceholders As ImmutableArray(Of BoundRValuePlaceholder) = Me.VisitList(node.ElementPlaceholders)
            Dim convertedElements As ImmutableArray(Of BoundExpression) = Me.VisitList(node.ConvertedElements)
            Return node.Update(elementPlaceholders, convertedElements)
        End Function

        Public Overrides Function VisitUserDefinedConversion(node As BoundUserDefinedConversion) As BoundNode
            Dim underlyingExpression As BoundExpression = DirectCast(Me.Visit(node.UnderlyingExpression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(underlyingExpression, node.InOutConversionFlags, type)
        End Function

        Public Overrides Function VisitDirectCast(node As BoundDirectCast) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim relaxationLambdaOpt As BoundLambda = DirectCast(Me.Visit(node.RelaxationLambdaOpt), BoundLambda)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(operand, node.ConversionKind, node.SuppressVirtualCalls, node.ConstantValueOpt, relaxationLambdaOpt, type)
        End Function

        Public Overrides Function VisitTryCast(node As BoundTryCast) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim relaxationLambdaOpt As BoundLambda = DirectCast(Me.Visit(node.RelaxationLambdaOpt), BoundLambda)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(operand, node.ConversionKind, node.ConstantValueOpt, relaxationLambdaOpt, type)
        End Function

        Public Overrides Function VisitTypeOf(node As BoundTypeOf) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim targetType as TypeSymbol = Me.VisitType(node.TargetType)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(operand, node.IsTypeOfIsNotExpression, targetType, type)
        End Function

        Public Overrides Function VisitSequencePoint(node As BoundSequencePoint) As BoundNode
            Dim statementOpt As BoundStatement = DirectCast(Me.Visit(node.StatementOpt), BoundStatement)
            Return node.Update(statementOpt)
        End Function

        Public Overrides Function VisitSequencePointExpression(node As BoundSequencePointExpression) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, type)
        End Function

        Public Overrides Function VisitSequencePointWithSpan(node As BoundSequencePointWithSpan) As BoundNode
            Dim statementOpt As BoundStatement = DirectCast(Me.Visit(node.StatementOpt), BoundStatement)
            Return node.Update(statementOpt, node.Span)
        End Function

        Public Overrides Function VisitNoOpStatement(node As BoundNoOpStatement) As BoundNode
            Return node
        End Function

        Public Overrides Function VisitMethodGroup(node As BoundMethodGroup) As BoundNode
            Dim typeArgumentsOpt As BoundTypeArguments = DirectCast(Me.Visit(node.TypeArgumentsOpt), BoundTypeArguments)
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(typeArgumentsOpt, node.Methods, node.PendingExtensionMethodsOpt, node.ResultKind, receiverOpt, node.QualificationKind)
        End Function

        Public Overrides Function VisitPropertyGroup(node As BoundPropertyGroup) As BoundNode
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Properties, node.ResultKind, receiverOpt, node.QualificationKind)
        End Function

        Public Overrides Function VisitReturnStatement(node As BoundReturnStatement) As BoundNode
            Dim expressionOpt As BoundExpression = DirectCast(Me.Visit(node.ExpressionOpt), BoundExpression)
            Return node.Update(expressionOpt, node.FunctionLocalOpt, node.ExitLabelOpt)
        End Function

        Public Overrides Function VisitYieldStatement(node As BoundYieldStatement) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Return node.Update(expression)
        End Function

        Public Overrides Function VisitThrowStatement(node As BoundThrowStatement) As BoundNode
            Dim expressionOpt As BoundExpression = DirectCast(Me.Visit(node.ExpressionOpt), BoundExpression)
            Return node.Update(expressionOpt)
        End Function

        Public Overrides Function VisitRedimStatement(node As BoundRedimStatement) As BoundNode
            Dim clauses As ImmutableArray(Of BoundRedimClause) = Me.VisitList(node.Clauses)
            Return node.Update(clauses)
        End Function

        Public Overrides Function VisitRedimClause(node As BoundRedimClause) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim indices As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Indices)
            Return node.Update(operand, indices, node.ArrayTypeOpt, node.Preserve)
        End Function

        Public Overrides Function VisitEraseStatement(node As BoundEraseStatement) As BoundNode
            Dim clauses As ImmutableArray(Of BoundAssignmentOperator) = Me.VisitList(node.Clauses)
            Return node.Update(clauses)
        End Function

        Public Overrides Function VisitCall(node As BoundCall) As BoundNode
            Dim methodGroupOpt As BoundMethodGroup = node.MethodGroupOpt
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim arguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Arguments)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Method, methodGroupOpt, receiverOpt, arguments, node.DefaultArguments, node.ConstantValueOpt, node.IsLValue, node.SuppressObjectClone, type)
        End Function

        Public Overrides Function VisitAttribute(node As BoundAttribute) As BoundNode
            Dim constructorArguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.ConstructorArguments)
            Dim namedArguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.NamedArguments)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Constructor, constructorArguments, node.ConstructorDefaultArguments, namedArguments, node.ResultKind, type)
        End Function

        Public Overrides Function VisitLateMemberAccess(node As BoundLateMemberAccess) As BoundNode
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim typeArgumentsOpt As BoundTypeArguments = DirectCast(Me.Visit(node.TypeArgumentsOpt), BoundTypeArguments)
            Dim containerTypeOpt as TypeSymbol = Me.VisitType(node.ContainerTypeOpt)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.NameOpt, containerTypeOpt, receiverOpt, typeArgumentsOpt, node.AccessKind, type)
        End Function

        Public Overrides Function VisitLateInvocation(node As BoundLateInvocation) As BoundNode
            Dim member As BoundExpression = DirectCast(Me.Visit(node.Member), BoundExpression)
            Dim argumentsOpt As ImmutableArray(Of BoundExpression) = Me.VisitList(node.ArgumentsOpt)
            Dim methodOrPropertyGroupOpt As BoundMethodOrPropertyGroup = node.MethodOrPropertyGroupOpt
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(member, argumentsOpt, node.ArgumentNamesOpt, node.AccessKind, methodOrPropertyGroupOpt, type)
        End Function

        Public Overrides Function VisitLateAddressOfOperator(node As BoundLateAddressOfOperator) As BoundNode
            Dim memberAccess As BoundLateMemberAccess = DirectCast(Me.Visit(node.MemberAccess), BoundLateMemberAccess)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Binder, memberAccess, type)
        End Function

        Public Overrides Function VisitTupleLiteral(node As BoundTupleLiteral) As BoundNode
            Dim arguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Arguments)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.InferredType, node.ArgumentNamesOpt, node.InferredNamesOpt, arguments, type)
        End Function

        Public Overrides Function VisitConvertedTupleLiteral(node As BoundConvertedTupleLiteral) As BoundNode
            Dim arguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Arguments)
            Dim naturalTypeOpt as TypeSymbol = Me.VisitType(node.NaturalTypeOpt)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(naturalTypeOpt, arguments, type)
        End Function

        Public Overrides Function VisitObjectCreationExpression(node As BoundObjectCreationExpression) As BoundNode
            Dim methodGroupOpt As BoundMethodGroup = node.MethodGroupOpt
            Dim arguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Arguments)
            Dim initializerOpt As BoundObjectInitializerExpressionBase = DirectCast(Me.Visit(node.InitializerOpt), BoundObjectInitializerExpressionBase)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.ConstructorOpt, methodGroupOpt, arguments, node.DefaultArguments, initializerOpt, type)
        End Function

        Public Overrides Function VisitNoPiaObjectCreationExpression(node As BoundNoPiaObjectCreationExpression) As BoundNode
            Dim initializerOpt As BoundObjectInitializerExpressionBase = DirectCast(Me.Visit(node.InitializerOpt), BoundObjectInitializerExpressionBase)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.GuidString, initializerOpt, type)
        End Function

        Public Overrides Function VisitAnonymousTypeCreationExpression(node As BoundAnonymousTypeCreationExpression) As BoundNode
            Dim declarations As ImmutableArray(Of BoundAnonymousTypePropertyAccess) = Me.VisitList(node.Declarations)
            Dim arguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Arguments)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.BinderOpt, declarations, arguments, type)
        End Function

        Public Overrides Function VisitAnonymousTypePropertyAccess(node As BoundAnonymousTypePropertyAccess) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Binder, node.PropertyIndex, type)
        End Function

        Public Overrides Function VisitAnonymousTypeFieldInitializer(node As BoundAnonymousTypeFieldInitializer) As BoundNode
            Dim value As BoundExpression = DirectCast(Me.Visit(node.Value), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Binder, value, type)
        End Function

        Public Overrides Function VisitObjectInitializerExpression(node As BoundObjectInitializerExpression) As BoundNode
            Dim placeholderOpt As BoundWithLValueExpressionPlaceholder = DirectCast(Me.Visit(node.PlaceholderOpt), BoundWithLValueExpressionPlaceholder)
            Dim initializers As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Initializers)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.CreateTemporaryLocalForInitialization, placeholderOpt, initializers, type)
        End Function

        Public Overrides Function VisitCollectionInitializerExpression(node As BoundCollectionInitializerExpression) As BoundNode
            Dim placeholderOpt As BoundWithLValueExpressionPlaceholder = DirectCast(Me.Visit(node.PlaceholderOpt), BoundWithLValueExpressionPlaceholder)
            Dim initializers As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Initializers)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(placeholderOpt, initializers, type)
        End Function

        Public Overrides Function VisitNewT(node As BoundNewT) As BoundNode
            Dim initializerOpt As BoundObjectInitializerExpressionBase = DirectCast(Me.Visit(node.InitializerOpt), BoundObjectInitializerExpressionBase)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(initializerOpt, type)
        End Function

        Public Overrides Function VisitDelegateCreationExpression(node As BoundDelegateCreationExpression) As BoundNode
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim relaxationLambdaOpt As BoundLambda = DirectCast(Me.Visit(node.RelaxationLambdaOpt), BoundLambda)
            Dim relaxationReceiverPlaceholderOpt As BoundRValuePlaceholder = DirectCast(Me.Visit(node.RelaxationReceiverPlaceholderOpt), BoundRValuePlaceholder)
            Dim methodGroupOpt As BoundMethodGroup = node.MethodGroupOpt
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(receiverOpt, node.Method, relaxationLambdaOpt, relaxationReceiverPlaceholderOpt, methodGroupOpt, type)
        End Function

        Public Overrides Function VisitArrayCreation(node As BoundArrayCreation) As BoundNode
            Dim bounds As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Bounds)
            Dim initializerOpt As BoundArrayInitialization = DirectCast(Me.Visit(node.InitializerOpt), BoundArrayInitialization)
            Dim arrayLiteralOpt As BoundArrayLiteral = node.ArrayLiteralOpt
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.IsParamArrayArgument, bounds, initializerOpt, arrayLiteralOpt, node.ArrayLiteralConversion, type)
        End Function

        Public Overrides Function VisitArrayLiteral(node As BoundArrayLiteral) As BoundNode
            Dim bounds As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Bounds)
            Dim initializer As BoundArrayInitialization = DirectCast(Me.Visit(node.Initializer), BoundArrayInitialization)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.HasDominantType, node.NumberOfCandidates, node.InferredType, bounds, initializer, node.Binder)
        End Function

        Public Overrides Function VisitArrayInitialization(node As BoundArrayInitialization) As BoundNode
            Dim initializers As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Initializers)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(initializers, type)
        End Function

        Public Overrides Function VisitFieldAccess(node As BoundFieldAccess) As BoundNode
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(receiverOpt, node.FieldSymbol, node.IsLValue, node.SuppressVirtualCalls, node.ConstantsInProgressOpt, type)
        End Function

        Public Overrides Function VisitPropertyAccess(node As BoundPropertyAccess) As BoundNode
            Dim propertyGroupOpt As BoundPropertyGroup = node.PropertyGroupOpt
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim arguments As ImmutableArray(Of BoundExpression) = Me.VisitList(node.Arguments)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.PropertySymbol, propertyGroupOpt, node.AccessKind, node.IsWriteable, node.IsLValue, receiverOpt, arguments, node.DefaultArguments, type)
        End Function

        Public Overrides Function VisitEventAccess(node As BoundEventAccess) As BoundNode
            Dim receiverOpt As BoundExpression = DirectCast(Me.Visit(node.ReceiverOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(receiverOpt, node.EventSymbol, type)
        End Function

        Public Overrides Function VisitBlock(node As BoundBlock) As BoundNode
            Dim statements As ImmutableArray(Of BoundStatement) = Me.VisitList(node.Statements)
            Return node.Update(node.StatementListSyntax, node.Locals, statements)
        End Function

        Public Overrides Function VisitStateMachineScope(node As BoundStateMachineScope) As BoundNode
            Dim statement As BoundStatement = DirectCast(Me.Visit(node.Statement), BoundStatement)
            Return node.Update(node.Fields, statement)
        End Function

        Public Overrides Function VisitLocalDeclaration(node As BoundLocalDeclaration) As BoundNode
            Dim declarationInitializerOpt As BoundExpression = DirectCast(Me.Visit(node.DeclarationInitializerOpt), BoundExpression)
            Dim identifierInitializerOpt As BoundArrayCreation = DirectCast(Me.Visit(node.IdentifierInitializerOpt), BoundArrayCreation)
            Return node.Update(node.LocalSymbol, declarationInitializerOpt, identifierInitializerOpt, node.InitializedByAsNew)
        End Function

        Public Overrides Function VisitAsNewLocalDeclarations(node As BoundAsNewLocalDeclarations) As BoundNode
            Dim localDeclarations As ImmutableArray(Of BoundLocalDeclaration) = Me.VisitList(node.LocalDeclarations)
            Dim initializer As BoundExpression = DirectCast(Me.Visit(node.Initializer), BoundExpression)
            Return node.Update(localDeclarations, initializer, node.Binder)
        End Function

        Public Overrides Function VisitDimStatement(node As BoundDimStatement) As BoundNode
            Dim localDeclarations As ImmutableArray(Of BoundLocalDeclarationBase) = Me.VisitList(node.LocalDeclarations)
            Dim initializerOpt As BoundExpression = DirectCast(Me.Visit(node.InitializerOpt), BoundExpression)
            Return node.Update(localDeclarations, initializerOpt)
        End Function

        Public Overrides Function VisitInitializer(node As BoundInitializer) As BoundNode
            Return node
        End Function

        Public Overrides Function VisitFieldInitializer(node As BoundFieldInitializer) As BoundNode
            Dim memberAccessExpressionOpt As BoundExpression = DirectCast(Me.Visit(node.MemberAccessExpressionOpt), BoundExpression)
            Dim initialValue As BoundExpression = DirectCast(Me.Visit(node.InitialValue), BoundExpression)
            Return node.Update(node.InitializedFields, memberAccessExpressionOpt, initialValue, node.BinderOpt)
        End Function

        Public Overrides Function VisitPropertyInitializer(node As BoundPropertyInitializer) As BoundNode
            Dim memberAccessExpressionOpt As BoundExpression = DirectCast(Me.Visit(node.MemberAccessExpressionOpt), BoundExpression)
            Dim initialValue As BoundExpression = DirectCast(Me.Visit(node.InitialValue), BoundExpression)
            Return node.Update(node.InitializedProperties, memberAccessExpressionOpt, initialValue, node.BinderOpt)
        End Function

        Public Overrides Function VisitParameterEqualsValue(node As BoundParameterEqualsValue) As BoundNode
            Dim value As BoundExpression = DirectCast(Me.Visit(node.Value), BoundExpression)
            Return node.Update(node.Parameter, value)
        End Function

        Public Overrides Function VisitGlobalStatementInitializer(node As BoundGlobalStatementInitializer) As BoundNode
            Dim statement As BoundStatement = DirectCast(Me.Visit(node.Statement), BoundStatement)
            Return node.Update(statement)
        End Function

        Public Overrides Function VisitSequence(node As BoundSequence) As BoundNode
            Dim sideEffects As ImmutableArray(Of BoundExpression) = Me.VisitList(node.SideEffects)
            Dim valueOpt As BoundExpression = DirectCast(Me.Visit(node.ValueOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Locals, sideEffects, valueOpt, type)
        End Function

        Public Overrides Function VisitExpressionStatement(node As BoundExpressionStatement) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Return node.Update(expression)
        End Function

        Public Overrides Function VisitIfStatement(node As BoundIfStatement) As BoundNode
            Dim condition As BoundExpression = DirectCast(Me.Visit(node.Condition), BoundExpression)
            Dim consequence As BoundStatement = DirectCast(Me.Visit(node.Consequence), BoundStatement)
            Dim alternativeOpt As BoundStatement = DirectCast(Me.Visit(node.AlternativeOpt), BoundStatement)
            Return node.Update(condition, consequence, alternativeOpt)
        End Function

        Public Overrides Function VisitSelectStatement(node As BoundSelectStatement) As BoundNode
            Dim expressionStatement As BoundExpressionStatement = DirectCast(Me.Visit(node.ExpressionStatement), BoundExpressionStatement)
            Dim exprPlaceholderOpt As BoundRValuePlaceholder = DirectCast(Me.Visit(node.ExprPlaceholderOpt), BoundRValuePlaceholder)
            Dim caseBlocks As ImmutableArray(Of BoundCaseBlock) = Me.VisitList(node.CaseBlocks)
            Return node.Update(expressionStatement, exprPlaceholderOpt, caseBlocks, node.RecommendSwitchTable, node.ExitLabel)
        End Function

        Public Overrides Function VisitCaseBlock(node As BoundCaseBlock) As BoundNode
            Dim caseStatement As BoundCaseStatement = DirectCast(Me.Visit(node.CaseStatement), BoundCaseStatement)
            Dim body As BoundBlock = DirectCast(Me.Visit(node.Body), BoundBlock)
            Return node.Update(caseStatement, body)
        End Function

        Public Overrides Function VisitCaseStatement(node As BoundCaseStatement) As BoundNode
            Dim caseClauses As ImmutableArray(Of BoundCaseClause) = Me.VisitList(node.CaseClauses)
            Dim conditionOpt As BoundExpression = DirectCast(Me.Visit(node.ConditionOpt), BoundExpression)
            Return node.Update(caseClauses, conditionOpt)
        End Function

        Public Overrides Function VisitSimpleCaseClause(node As BoundSimpleCaseClause) As BoundNode
            Dim valueOpt As BoundExpression = DirectCast(Me.Visit(node.ValueOpt), BoundExpression)
            Dim conditionOpt As BoundExpression = DirectCast(Me.Visit(node.ConditionOpt), BoundExpression)
            Return node.Update(valueOpt, conditionOpt)
        End Function

        Public Overrides Function VisitRangeCaseClause(node As BoundRangeCaseClause) As BoundNode
            Dim lowerBoundOpt As BoundExpression = DirectCast(Me.Visit(node.LowerBoundOpt), BoundExpression)
            Dim upperBoundOpt As BoundExpression = DirectCast(Me.Visit(node.UpperBoundOpt), BoundExpression)
            Dim lowerBoundConditionOpt As BoundExpression = DirectCast(Me.Visit(node.LowerBoundConditionOpt), BoundExpression)
            Dim upperBoundConditionOpt As BoundExpression = DirectCast(Me.Visit(node.UpperBoundConditionOpt), BoundExpression)
            Return node.Update(lowerBoundOpt, upperBoundOpt, lowerBoundConditionOpt, upperBoundConditionOpt)
        End Function

        Public Overrides Function VisitRelationalCaseClause(node As BoundRelationalCaseClause) As BoundNode
            Dim valueOpt As BoundExpression = DirectCast(Me.Visit(node.ValueOpt), BoundExpression)
            Dim conditionOpt As BoundExpression = DirectCast(Me.Visit(node.ConditionOpt), BoundExpression)
            Return node.Update(node.OperatorKind, valueOpt, conditionOpt)
        End Function

        Public Overrides Function VisitDoLoopStatement(node As BoundDoLoopStatement) As BoundNode
            Dim topConditionOpt As BoundExpression = DirectCast(Me.Visit(node.TopConditionOpt), BoundExpression)
            Dim bottomConditionOpt As BoundExpression = DirectCast(Me.Visit(node.BottomConditionOpt), BoundExpression)
            Dim body As BoundStatement = DirectCast(Me.Visit(node.Body), BoundStatement)
            Return node.Update(topConditionOpt, bottomConditionOpt, node.TopConditionIsUntil, node.BottomConditionIsUntil, body, node.ContinueLabel, node.ExitLabel)
        End Function

        Public Overrides Function VisitWhileStatement(node As BoundWhileStatement) As BoundNode
            Dim condition As BoundExpression = DirectCast(Me.Visit(node.Condition), BoundExpression)
            Dim body As BoundStatement = DirectCast(Me.Visit(node.Body), BoundStatement)
            Return node.Update(condition, body, node.ContinueLabel, node.ExitLabel)
        End Function

        Public Overrides Function VisitForToUserDefinedOperators(node As BoundForToUserDefinedOperators) As BoundNode
            Dim leftOperandPlaceholder As BoundRValuePlaceholder = DirectCast(Me.Visit(node.LeftOperandPlaceholder), BoundRValuePlaceholder)
            Dim rightOperandPlaceholder As BoundRValuePlaceholder = DirectCast(Me.Visit(node.RightOperandPlaceholder), BoundRValuePlaceholder)
            Dim addition As BoundUserDefinedBinaryOperator = DirectCast(Me.Visit(node.Addition), BoundUserDefinedBinaryOperator)
            Dim subtraction As BoundUserDefinedBinaryOperator = DirectCast(Me.Visit(node.Subtraction), BoundUserDefinedBinaryOperator)
            Dim lessThanOrEqual As BoundExpression = DirectCast(Me.Visit(node.LessThanOrEqual), BoundExpression)
            Dim greaterThanOrEqual As BoundExpression = DirectCast(Me.Visit(node.GreaterThanOrEqual), BoundExpression)
            Return node.Update(leftOperandPlaceholder, rightOperandPlaceholder, addition, subtraction, lessThanOrEqual, greaterThanOrEqual)
        End Function

        Public Overrides Function VisitForToStatement(node As BoundForToStatement) As BoundNode
            Dim initialValue As BoundExpression = DirectCast(Me.Visit(node.InitialValue), BoundExpression)
            Dim limitValue As BoundExpression = DirectCast(Me.Visit(node.LimitValue), BoundExpression)
            Dim stepValue As BoundExpression = DirectCast(Me.Visit(node.StepValue), BoundExpression)
            Dim operatorsOpt As BoundForToUserDefinedOperators = DirectCast(Me.Visit(node.OperatorsOpt), BoundForToUserDefinedOperators)
            Dim controlVariable As BoundExpression = DirectCast(Me.Visit(node.ControlVariable), BoundExpression)
            Dim body As BoundStatement = DirectCast(Me.Visit(node.Body), BoundStatement)
            Dim nextVariablesOpt As ImmutableArray(Of BoundExpression) = Me.VisitList(node.NextVariablesOpt)
            Return node.Update(initialValue, limitValue, stepValue, node.Checked, operatorsOpt, node.DeclaredOrInferredLocalOpt, controlVariable, body, nextVariablesOpt, node.ContinueLabel, node.ExitLabel)
        End Function

        Public Overrides Function VisitForEachStatement(node As BoundForEachStatement) As BoundNode
            Dim collection As BoundExpression = DirectCast(Me.Visit(node.Collection), BoundExpression)
            Dim controlVariable As BoundExpression = DirectCast(Me.Visit(node.ControlVariable), BoundExpression)
            Dim body As BoundStatement = DirectCast(Me.Visit(node.Body), BoundStatement)
            Dim nextVariablesOpt As ImmutableArray(Of BoundExpression) = Me.VisitList(node.NextVariablesOpt)
            Return node.Update(collection, node.EnumeratorInfo, node.DeclaredOrInferredLocalOpt, controlVariable, body, nextVariablesOpt, node.ContinueLabel, node.ExitLabel)
        End Function

        Public Overrides Function VisitExitStatement(node As BoundExitStatement) As BoundNode
            Return node
        End Function

        Public Overrides Function VisitContinueStatement(node As BoundContinueStatement) As BoundNode
            Return node
        End Function

        Public Overrides Function VisitTryStatement(node As BoundTryStatement) As BoundNode
            Dim tryBlock As BoundBlock = DirectCast(Me.Visit(node.TryBlock), BoundBlock)
            Dim catchBlocks As ImmutableArray(Of BoundCatchBlock) = Me.VisitList(node.CatchBlocks)
            Dim finallyBlockOpt As BoundBlock = DirectCast(Me.Visit(node.FinallyBlockOpt), BoundBlock)
            Return node.Update(tryBlock, catchBlocks, finallyBlockOpt, node.ExitLabelOpt)
        End Function

        Public Overrides Function VisitCatchBlock(node As BoundCatchBlock) As BoundNode
            Dim exceptionSourceOpt As BoundExpression = DirectCast(Me.Visit(node.ExceptionSourceOpt), BoundExpression)
            Dim errorLineNumberOpt As BoundExpression = DirectCast(Me.Visit(node.ErrorLineNumberOpt), BoundExpression)
            Dim exceptionFilterOpt As BoundExpression = DirectCast(Me.Visit(node.ExceptionFilterOpt), BoundExpression)
            Dim body As BoundBlock = DirectCast(Me.Visit(node.Body), BoundBlock)
            Return node.Update(node.LocalOpt, exceptionSourceOpt, errorLineNumberOpt, exceptionFilterOpt, body, node.IsSynthesizedAsyncCatchAll)
        End Function

        Public Overrides Function VisitLiteral(node As BoundLiteral) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Value, type)
        End Function

        Public Overrides Function VisitMeReference(node As BoundMeReference) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitValueTypeMeReference(node As BoundValueTypeMeReference) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitMyBaseReference(node As BoundMyBaseReference) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitMyClassReference(node As BoundMyClassReference) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitPreviousSubmissionReference(node As BoundPreviousSubmissionReference) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.SourceType, type)
        End Function

        Public Overrides Function VisitHostObjectMemberReference(node As BoundHostObjectMemberReference) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(type)
        End Function

        Public Overrides Function VisitLocal(node As BoundLocal) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.LocalSymbol, node.IsLValue, type)
        End Function

        Public Overrides Function VisitPseudoVariable(node As BoundPseudoVariable) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.LocalSymbol, node.IsLValue, node.EmitExpressions, type)
        End Function

        Public Overrides Function VisitParameter(node As BoundParameter) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.ParameterSymbol, node.IsLValue, node.SuppressVirtualCalls, type)
        End Function

        Public Overrides Function VisitByRefArgumentPlaceholder(node As BoundByRefArgumentPlaceholder) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.IsOut, type)
        End Function

        Public Overrides Function VisitByRefArgumentWithCopyBack(node As BoundByRefArgumentWithCopyBack) As BoundNode
            Dim originalArgument As BoundExpression = DirectCast(Me.Visit(node.OriginalArgument), BoundExpression)
            Dim inConversion As BoundExpression = DirectCast(Me.Visit(node.InConversion), BoundExpression)
            Dim inPlaceholder As BoundByRefArgumentPlaceholder = DirectCast(Me.Visit(node.InPlaceholder), BoundByRefArgumentPlaceholder)
            Dim outConversion As BoundExpression = DirectCast(Me.Visit(node.OutConversion), BoundExpression)
            Dim outPlaceholder As BoundRValuePlaceholder = DirectCast(Me.Visit(node.OutPlaceholder), BoundRValuePlaceholder)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(originalArgument, inConversion, inPlaceholder, outConversion, outPlaceholder, type)
        End Function

        Public Overrides Function VisitLateBoundArgumentSupportingAssignmentWithCapture(node As BoundLateBoundArgumentSupportingAssignmentWithCapture) As BoundNode
            Dim originalArgument As BoundExpression = DirectCast(Me.Visit(node.OriginalArgument), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(originalArgument, node.LocalSymbol, type)
        End Function

        Public Overrides Function VisitLabelStatement(node As BoundLabelStatement) As BoundNode
            Return node
        End Function

        Public Overrides Function VisitLabel(node As BoundLabel) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Label, type)
        End Function

        Public Overrides Function VisitGotoStatement(node As BoundGotoStatement) As BoundNode
            Dim labelExpressionOpt As BoundLabel = DirectCast(Me.Visit(node.LabelExpressionOpt), BoundLabel)
            Return node.Update(node.Label, labelExpressionOpt)
        End Function

        Public Overrides Function VisitStatementList(node As BoundStatementList) As BoundNode
            Dim statements As ImmutableArray(Of BoundStatement) = Me.VisitList(node.Statements)
            Return node.Update(statements)
        End Function

        Public Overrides Function VisitConditionalGoto(node As BoundConditionalGoto) As BoundNode
            Dim condition As BoundExpression = DirectCast(Me.Visit(node.Condition), BoundExpression)
            Return node.Update(condition, node.JumpIfTrue, node.Label)
        End Function

        Public Overrides Function VisitWithStatement(node As BoundWithStatement) As BoundNode
            Dim originalExpression As BoundExpression = DirectCast(Me.Visit(node.OriginalExpression), BoundExpression)
            Dim body As BoundBlock = DirectCast(Me.Visit(node.Body), BoundBlock)
            Return node.Update(originalExpression, body, node.Binder)
        End Function

        Public Overrides Function VisitUnboundLambda(node As UnboundLambda) As BoundNode
            Dim returnType as TypeSymbol = Me.VisitType(node.ReturnType)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Binder, node.Flags, node.Parameters, returnType, node.BindingCache)
        End Function

        Public Overrides Function VisitLambda(node As BoundLambda) As BoundNode
            Dim body As BoundBlock = DirectCast(Me.Visit(node.Body), BoundBlock)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.LambdaSymbol, body, node.Diagnostics, node.LambdaBinderOpt, node.DelegateRelaxation, node.MethodConversionKind)
        End Function

        Public Overrides Function VisitQueryExpression(node As BoundQueryExpression) As BoundNode
            Dim lastOperator As BoundQueryClauseBase = DirectCast(Me.Visit(node.LastOperator), BoundQueryClauseBase)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(lastOperator, type)
        End Function

        Public Overrides Function VisitQuerySource(node As BoundQuerySource) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, type)
        End Function

        Public Overrides Function VisitToQueryableCollectionConversion(node As BoundToQueryableCollectionConversion) As BoundNode
            Dim conversionCall As BoundCall = DirectCast(Me.Visit(node.ConversionCall), BoundCall)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(conversionCall, type)
        End Function

        Public Overrides Function VisitQueryableSource(node As BoundQueryableSource) As BoundNode
            Dim source As BoundQueryPart = DirectCast(Me.Visit(node.Source), BoundQueryPart)
            Dim compoundVariableType as TypeSymbol = Me.VisitType(node.CompoundVariableType)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(source, node.RangeVariableOpt, node.RangeVariables, compoundVariableType, node.Binders, type)
        End Function

        Public Overrides Function VisitQueryClause(node As BoundQueryClause) As BoundNode
            Dim underlyingExpression As BoundExpression = DirectCast(Me.Visit(node.UnderlyingExpression), BoundExpression)
            Dim compoundVariableType as TypeSymbol = Me.VisitType(node.CompoundVariableType)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(underlyingExpression, node.RangeVariables, compoundVariableType, node.Binders, type)
        End Function

        Public Overrides Function VisitOrdering(node As BoundOrdering) As BoundNode
            Dim underlyingExpression As BoundExpression = DirectCast(Me.Visit(node.UnderlyingExpression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(underlyingExpression, type)
        End Function

        Public Overrides Function VisitQueryLambda(node As BoundQueryLambda) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.LambdaSymbol, node.RangeVariables, expression, node.ExprIsOperandOfConditionalBranch)
        End Function

        Public Overrides Function VisitRangeVariableAssignment(node As BoundRangeVariableAssignment) As BoundNode
            Dim value As BoundExpression = DirectCast(Me.Visit(node.Value), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.RangeVariable, value, type)
        End Function

        Public Overrides Function VisitGroupTypeInferenceLambda(node As GroupTypeInferenceLambda) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Binder, node.Parameters, node.Compilation)
        End Function

        Public Overrides Function VisitAggregateClause(node As BoundAggregateClause) As BoundNode
            Dim capturedGroupOpt As BoundQueryClauseBase = DirectCast(Me.Visit(node.CapturedGroupOpt), BoundQueryClauseBase)
            Dim groupPlaceholderOpt As BoundRValuePlaceholder = DirectCast(Me.Visit(node.GroupPlaceholderOpt), BoundRValuePlaceholder)
            Dim underlyingExpression As BoundExpression = DirectCast(Me.Visit(node.UnderlyingExpression), BoundExpression)
            Dim compoundVariableType as TypeSymbol = Me.VisitType(node.CompoundVariableType)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(capturedGroupOpt, groupPlaceholderOpt, underlyingExpression, node.RangeVariables, compoundVariableType, node.Binders, type)
        End Function

        Public Overrides Function VisitGroupAggregation(node As BoundGroupAggregation) As BoundNode
            Dim group As BoundExpression = DirectCast(Me.Visit(node.Group), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(group, type)
        End Function

        Public Overrides Function VisitRangeVariable(node As BoundRangeVariable) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.RangeVariable, type)
        End Function

        Public Overrides Function VisitAddHandlerStatement(node As BoundAddHandlerStatement) As BoundNode
            Dim eventAccess As BoundExpression = DirectCast(Me.Visit(node.EventAccess), BoundExpression)
            Dim handler As BoundExpression = DirectCast(Me.Visit(node.Handler), BoundExpression)
            Return node.Update(eventAccess, handler)
        End Function

        Public Overrides Function VisitRemoveHandlerStatement(node As BoundRemoveHandlerStatement) As BoundNode
            Dim eventAccess As BoundExpression = DirectCast(Me.Visit(node.EventAccess), BoundExpression)
            Dim handler As BoundExpression = DirectCast(Me.Visit(node.Handler), BoundExpression)
            Return node.Update(eventAccess, handler)
        End Function

        Public Overrides Function VisitRaiseEventStatement(node As BoundRaiseEventStatement) As BoundNode
            Dim eventInvocation As BoundExpression = DirectCast(Me.Visit(node.EventInvocation), BoundExpression)
            Return node.Update(node.EventSymbol, eventInvocation)
        End Function

        Public Overrides Function VisitUsingStatement(node As BoundUsingStatement) As BoundNode
            Dim resourceList As ImmutableArray(Of BoundLocalDeclarationBase) = Me.VisitList(node.ResourceList)
            Dim resourceExpressionOpt As BoundExpression = DirectCast(Me.Visit(node.ResourceExpressionOpt), BoundExpression)
            Dim body As BoundBlock = DirectCast(Me.Visit(node.Body), BoundBlock)
            Return node.Update(resourceList, resourceExpressionOpt, body, node.UsingInfo, node.Locals)
        End Function

        Public Overrides Function VisitSyncLockStatement(node As BoundSyncLockStatement) As BoundNode
            Dim lockExpression As BoundExpression = DirectCast(Me.Visit(node.LockExpression), BoundExpression)
            Dim body As BoundBlock = DirectCast(Me.Visit(node.Body), BoundBlock)
            Return node.Update(lockExpression, body)
        End Function

        Public Overrides Function VisitXmlName(node As BoundXmlName) As BoundNode
            Dim xmlNamespace As BoundExpression = DirectCast(Me.Visit(node.XmlNamespace), BoundExpression)
            Dim localName As BoundExpression = DirectCast(Me.Visit(node.LocalName), BoundExpression)
            Dim objectCreation As BoundExpression = node.ObjectCreation
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(xmlNamespace, localName, objectCreation, type)
        End Function

        Public Overrides Function VisitXmlNamespace(node As BoundXmlNamespace) As BoundNode
            Dim xmlNamespace As BoundExpression = DirectCast(Me.Visit(node.XmlNamespace), BoundExpression)
            Dim objectCreation As BoundExpression = node.ObjectCreation
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(xmlNamespace, objectCreation, type)
        End Function

        Public Overrides Function VisitXmlDocument(node As BoundXmlDocument) As BoundNode
            Dim declaration As BoundExpression = DirectCast(Me.Visit(node.Declaration), BoundExpression)
            Dim childNodes As ImmutableArray(Of BoundExpression) = Me.VisitList(node.ChildNodes)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(declaration, childNodes, node.RewriterInfo, type)
        End Function

        Public Overrides Function VisitXmlDeclaration(node As BoundXmlDeclaration) As BoundNode
            Dim version As BoundExpression = DirectCast(Me.Visit(node.Version), BoundExpression)
            Dim encoding As BoundExpression = DirectCast(Me.Visit(node.Encoding), BoundExpression)
            Dim standalone As BoundExpression = DirectCast(Me.Visit(node.Standalone), BoundExpression)
            Dim objectCreation As BoundExpression = node.ObjectCreation
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(version, encoding, standalone, objectCreation, type)
        End Function

        Public Overrides Function VisitXmlProcessingInstruction(node As BoundXmlProcessingInstruction) As BoundNode
            Dim target As BoundExpression = DirectCast(Me.Visit(node.Target), BoundExpression)
            Dim data As BoundExpression = DirectCast(Me.Visit(node.Data), BoundExpression)
            Dim objectCreation As BoundExpression = node.ObjectCreation
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(target, data, objectCreation, type)
        End Function

        Public Overrides Function VisitXmlComment(node As BoundXmlComment) As BoundNode
            Dim value As BoundExpression = DirectCast(Me.Visit(node.Value), BoundExpression)
            Dim objectCreation As BoundExpression = node.ObjectCreation
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(value, objectCreation, type)
        End Function

        Public Overrides Function VisitXmlAttribute(node As BoundXmlAttribute) As BoundNode
            Dim name As BoundExpression = DirectCast(Me.Visit(node.Name), BoundExpression)
            Dim value As BoundExpression = DirectCast(Me.Visit(node.Value), BoundExpression)
            Dim objectCreation As BoundExpression = node.ObjectCreation
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(name, value, node.MatchesImport, objectCreation, type)
        End Function

        Public Overrides Function VisitXmlElement(node As BoundXmlElement) As BoundNode
            Dim argument As BoundExpression = DirectCast(Me.Visit(node.Argument), BoundExpression)
            Dim childNodes As ImmutableArray(Of BoundExpression) = Me.VisitList(node.ChildNodes)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(argument, childNodes, node.RewriterInfo, type)
        End Function

        Public Overrides Function VisitXmlMemberAccess(node As BoundXmlMemberAccess) As BoundNode
            Dim memberAccess As BoundExpression = DirectCast(Me.Visit(node.MemberAccess), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(memberAccess, type)
        End Function

        Public Overrides Function VisitXmlEmbeddedExpression(node As BoundXmlEmbeddedExpression) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, type)
        End Function

        Public Overrides Function VisitXmlCData(node As BoundXmlCData) As BoundNode
            Dim value As BoundLiteral = DirectCast(Me.Visit(node.Value), BoundLiteral)
            Dim objectCreation As BoundExpression = node.ObjectCreation
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(value, objectCreation, type)
        End Function

        Public Overrides Function VisitResumeStatement(node As BoundResumeStatement) As BoundNode
            Dim labelExpressionOpt As BoundExpression = DirectCast(Me.Visit(node.LabelExpressionOpt), BoundExpression)
            Return node.Update(node.ResumeKind, node.LabelOpt, labelExpressionOpt)
        End Function

        Public Overrides Function VisitOnErrorStatement(node As BoundOnErrorStatement) As BoundNode
            Dim labelExpressionOpt As BoundExpression = DirectCast(Me.Visit(node.LabelExpressionOpt), BoundExpression)
            Return node.Update(node.OnErrorKind, node.LabelOpt, labelExpressionOpt)
        End Function

        Public Overrides Function VisitUnstructuredExceptionHandlingStatement(node As BoundUnstructuredExceptionHandlingStatement) As BoundNode
            Dim body As BoundBlock = DirectCast(Me.Visit(node.Body), BoundBlock)
            Return node.Update(node.ContainsOnError, node.ContainsResume, node.ResumeWithoutLabelOpt, node.TrackLineNumber, body)
        End Function

        Public Overrides Function VisitUnstructuredExceptionHandlingCatchFilter(node As BoundUnstructuredExceptionHandlingCatchFilter) As BoundNode
            Dim activeHandlerLocal As BoundLocal = DirectCast(Me.Visit(node.ActiveHandlerLocal), BoundLocal)
            Dim resumeTargetLocal As BoundLocal = DirectCast(Me.Visit(node.ResumeTargetLocal), BoundLocal)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(activeHandlerLocal, resumeTargetLocal, type)
        End Function

        Public Overrides Function VisitUnstructuredExceptionOnErrorSwitch(node As BoundUnstructuredExceptionOnErrorSwitch) As BoundNode
            Dim value As BoundExpression = DirectCast(Me.Visit(node.Value), BoundExpression)
            Dim jumps As ImmutableArray(Of BoundGotoStatement) = Me.VisitList(node.Jumps)
            Return node.Update(value, jumps)
        End Function

        Public Overrides Function VisitUnstructuredExceptionResumeSwitch(node As BoundUnstructuredExceptionResumeSwitch) As BoundNode
            Dim resumeTargetTemporary As BoundLocal = DirectCast(Me.Visit(node.ResumeTargetTemporary), BoundLocal)
            Dim resumeLabel As BoundLabelStatement = DirectCast(Me.Visit(node.ResumeLabel), BoundLabelStatement)
            Dim resumeNextLabel As BoundLabelStatement = DirectCast(Me.Visit(node.ResumeNextLabel), BoundLabelStatement)
            Dim jumps As ImmutableArray(Of BoundGotoStatement) = Me.VisitList(node.Jumps)
            Return node.Update(resumeTargetTemporary, resumeLabel, resumeNextLabel, jumps)
        End Function

        Public Overrides Function VisitAwaitOperator(node As BoundAwaitOperator) As BoundNode
            Dim operand As BoundExpression = DirectCast(Me.Visit(node.Operand), BoundExpression)
            Dim awaitableInstancePlaceholder As BoundRValuePlaceholder = DirectCast(Me.Visit(node.AwaitableInstancePlaceholder), BoundRValuePlaceholder)
            Dim getAwaiter As BoundExpression = DirectCast(Me.Visit(node.GetAwaiter), BoundExpression)
            Dim awaiterInstancePlaceholder As BoundLValuePlaceholder = DirectCast(Me.Visit(node.AwaiterInstancePlaceholder), BoundLValuePlaceholder)
            Dim isCompleted As BoundExpression = DirectCast(Me.Visit(node.IsCompleted), BoundExpression)
            Dim getResult As BoundExpression = DirectCast(Me.Visit(node.GetResult), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(operand, awaitableInstancePlaceholder, getAwaiter, awaiterInstancePlaceholder, isCompleted, getResult, type)
        End Function

        Public Overrides Function VisitSpillSequence(node As BoundSpillSequence) As BoundNode
            Dim statements As ImmutableArray(Of BoundStatement) = Me.VisitList(node.Statements)
            Dim valueOpt As BoundExpression = DirectCast(Me.Visit(node.ValueOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.Locals, node.SpillFields, statements, valueOpt, type)
        End Function

        Public Overrides Function VisitStopStatement(node As BoundStopStatement) As BoundNode
            Return node
        End Function

        Public Overrides Function VisitEndStatement(node As BoundEndStatement) As BoundNode
            Return node
        End Function

        Public Overrides Function VisitMidResult(node As BoundMidResult) As BoundNode
            Dim original As BoundExpression = DirectCast(Me.Visit(node.Original), BoundExpression)
            Dim start As BoundExpression = DirectCast(Me.Visit(node.Start), BoundExpression)
            Dim lengthOpt As BoundExpression = DirectCast(Me.Visit(node.LengthOpt), BoundExpression)
            Dim source As BoundExpression = DirectCast(Me.Visit(node.Source), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(original, start, lengthOpt, source, type)
        End Function

        Public Overrides Function VisitConditionalAccess(node As BoundConditionalAccess) As BoundNode
            Dim receiver As BoundExpression = DirectCast(Me.Visit(node.Receiver), BoundExpression)
            Dim placeholder As BoundRValuePlaceholder = DirectCast(Me.Visit(node.Placeholder), BoundRValuePlaceholder)
            Dim accessExpression As BoundExpression = DirectCast(Me.Visit(node.AccessExpression), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(receiver, placeholder, accessExpression, type)
        End Function

        Public Overrides Function VisitConditionalAccessReceiverPlaceholder(node As BoundConditionalAccessReceiverPlaceholder) As BoundNode
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(node.PlaceholderId, node.Capture, type)
        End Function

        Public Overrides Function VisitLoweredConditionalAccess(node As BoundLoweredConditionalAccess) As BoundNode
            Dim receiverOrCondition As BoundExpression = DirectCast(Me.Visit(node.ReceiverOrCondition), BoundExpression)
            Dim whenNotNull As BoundExpression = DirectCast(Me.Visit(node.WhenNotNull), BoundExpression)
            Dim whenNullOpt As BoundExpression = DirectCast(Me.Visit(node.WhenNullOpt), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(receiverOrCondition, node.CaptureReceiver, node.PlaceholderId, whenNotNull, whenNullOpt, type)
        End Function

        Public Overrides Function VisitComplexConditionalAccessReceiver(node As BoundComplexConditionalAccessReceiver) As BoundNode
            Dim valueTypeReceiver As BoundExpression = DirectCast(Me.Visit(node.ValueTypeReceiver), BoundExpression)
            Dim referenceTypeReceiver As BoundExpression = DirectCast(Me.Visit(node.ReferenceTypeReceiver), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(valueTypeReceiver, referenceTypeReceiver, type)
        End Function

        Public Overrides Function VisitNameOfOperator(node As BoundNameOfOperator) As BoundNode
            Dim argument As BoundExpression = DirectCast(Me.Visit(node.Argument), BoundExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(argument, node.ConstantValueOpt, type)
        End Function

        Public Overrides Function VisitTypeAsValueExpression(node As BoundTypeAsValueExpression) As BoundNode
            Dim expression As BoundTypeExpression = DirectCast(Me.Visit(node.Expression), BoundTypeExpression)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(expression, type)
        End Function

        Public Overrides Function VisitInterpolatedStringExpression(node As BoundInterpolatedStringExpression) As BoundNode
            Dim contents As ImmutableArray(Of BoundNode) = Me.VisitList(node.Contents)
            Dim type as TypeSymbol = Me.VisitType(node.Type)
            Return node.Update(contents, node.Binder, type)
        End Function

        Public Overrides Function VisitInterpolation(node As BoundInterpolation) As BoundNode
            Dim expression As BoundExpression = DirectCast(Me.Visit(node.Expression), BoundExpression)
            Dim alignmentOpt As BoundExpression = DirectCast(Me.Visit(node.AlignmentOpt), BoundExpression)
            Dim formatStringOpt As BoundLiteral = DirectCast(Me.Visit(node.FormatStringOpt), BoundLiteral)
            Return node.Update(expression, alignmentOpt, formatStringOpt)
        End Function

    End Class

    Friend NotInheritable Class BoundTreeDumperNodeProducer
        Inherits BoundTreeVisitor(Of Object, TreeDumperNode)

        Private Sub New()
        End Sub

        Public Shared Function MakeTree(node As BoundNode) As TreeDumperNode
            Return (New BoundTreeDumperNodeProducer()).Visit(node, Nothing)
        End Function

        Public Overrides Function VisitTypeArguments(node As BoundTypeArguments, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("typeArguments", Nothing, New TreeDumperNode() {
                New TreeDumperNode("arguments", node.Arguments, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitOmittedArgument(node As BoundOmittedArgument, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("omittedArgument", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLValueToRValueWrapper(node As BoundLValueToRValueWrapper, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("lValueToRValueWrapper", Nothing, New TreeDumperNode() {
                New TreeDumperNode("underlyingLValue", Nothing, new TreeDumperNode() {Visit(node.UnderlyingLValue, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitWithLValueExpressionPlaceholder(node As BoundWithLValueExpressionPlaceholder, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("withLValueExpressionPlaceholder", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitWithRValueExpressionPlaceholder(node As BoundWithRValueExpressionPlaceholder, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("withRValueExpressionPlaceholder", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitRValuePlaceholder(node As BoundRValuePlaceholder, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("rValuePlaceholder", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLValuePlaceholder(node As BoundLValuePlaceholder, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("lValuePlaceholder", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitDup(node As BoundDup, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("dup", Nothing, New TreeDumperNode() {
                New TreeDumperNode("isReference", node.IsReference, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitBadExpression(node As BoundBadExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("badExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("resultKind", node.ResultKind, Nothing),
                New TreeDumperNode("symbols", node.Symbols, Nothing),
                New TreeDumperNode("childBoundNodes", Nothing, From x In node.ChildBoundNodes Select Visit(x, Nothing)),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitBadStatement(node As BoundBadStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("badStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("childBoundNodes", Nothing, From x In node.ChildBoundNodes Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitParenthesized(node As BoundParenthesized, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("parenthesized", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitBadVariable(node As BoundBadVariable, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("badVariable", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitArrayAccess(node As BoundArrayAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("arrayAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("indices", Nothing, From x In node.Indices Select Visit(x, Nothing)),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitArrayLength(node As BoundArrayLength, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("arrayLength", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitGetType(node As BoundGetType, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("[getType]", Nothing, New TreeDumperNode() {
                New TreeDumperNode("sourceType", Nothing, new TreeDumperNode() {Visit(node.SourceType, Nothing)}),
                New TreeDumperNode("getTypeFromHandle", node.GetTypeFromHandle, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitFieldInfo(node As BoundFieldInfo, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("fieldInfo", Nothing, New TreeDumperNode() {
                New TreeDumperNode("field", node.Field, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitMethodInfo(node As BoundMethodInfo, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("methodInfo", Nothing, New TreeDumperNode() {
                New TreeDumperNode("method", node.Method, Nothing),
                New TreeDumperNode("getMethodFromHandle", node.GetMethodFromHandle, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitTypeExpression(node As BoundTypeExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("typeExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("unevaluatedReceiverOpt", Nothing, new TreeDumperNode() {Visit(node.UnevaluatedReceiverOpt, Nothing)}),
                New TreeDumperNode("aliasOpt", node.AliasOpt, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitTypeOrValueExpression(node As BoundTypeOrValueExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("typeOrValueExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("data", node.Data, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitNamespaceExpression(node As BoundNamespaceExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("namespaceExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("unevaluatedReceiverOpt", Nothing, new TreeDumperNode() {Visit(node.UnevaluatedReceiverOpt, Nothing)}),
                New TreeDumperNode("aliasOpt", node.AliasOpt, Nothing),
                New TreeDumperNode("namespaceSymbol", node.NamespaceSymbol, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitMethodDefIndex(node As BoundMethodDefIndex, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("methodDefIndex", Nothing, New TreeDumperNode() {
                New TreeDumperNode("method", node.Method, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitMaximumMethodDefIndex(node As BoundMaximumMethodDefIndex, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("maximumMethodDefIndex", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitInstrumentationPayloadRoot(node As BoundInstrumentationPayloadRoot, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("instrumentationPayloadRoot", Nothing, New TreeDumperNode() {
                New TreeDumperNode("analysisKind", node.AnalysisKind, Nothing),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitModuleVersionId(node As BoundModuleVersionId, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("moduleVersionId", Nothing, New TreeDumperNode() {
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitModuleVersionIdString(node As BoundModuleVersionIdString, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("moduleVersionIdString", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitSourceDocumentIndex(node As BoundSourceDocumentIndex, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("sourceDocumentIndex", Nothing, New TreeDumperNode() {
                New TreeDumperNode("document", node.Document, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitUnaryOperator(node As BoundUnaryOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("unaryOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operatorKind", node.OperatorKind, Nothing),
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("checked", node.Checked, Nothing),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitUserDefinedUnaryOperator(node As BoundUserDefinedUnaryOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("userDefinedUnaryOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operatorKind", node.OperatorKind, Nothing),
                New TreeDumperNode("underlyingExpression", Nothing, new TreeDumperNode() {Visit(node.UnderlyingExpression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitNullableIsTrueOperator(node As BoundNullableIsTrueOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("nullableIsTrueOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitBinaryOperator(node As BoundBinaryOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("binaryOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operatorKind", node.OperatorKind, Nothing),
                New TreeDumperNode("left", Nothing, new TreeDumperNode() {Visit(node.Left, Nothing)}),
                New TreeDumperNode("right", Nothing, new TreeDumperNode() {Visit(node.Right, Nothing)}),
                New TreeDumperNode("checked", node.Checked, Nothing),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitUserDefinedBinaryOperator(node As BoundUserDefinedBinaryOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("userDefinedBinaryOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operatorKind", node.OperatorKind, Nothing),
                New TreeDumperNode("underlyingExpression", Nothing, new TreeDumperNode() {Visit(node.UnderlyingExpression, Nothing)}),
                New TreeDumperNode("checked", node.Checked, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitUserDefinedShortCircuitingOperator(node As BoundUserDefinedShortCircuitingOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("userDefinedShortCircuitingOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("leftOperand", Nothing, new TreeDumperNode() {Visit(node.LeftOperand, Nothing)}),
                New TreeDumperNode("leftOperandPlaceholder", Nothing, new TreeDumperNode() {Visit(node.LeftOperandPlaceholder, Nothing)}),
                New TreeDumperNode("leftTest", Nothing, new TreeDumperNode() {Visit(node.LeftTest, Nothing)}),
                New TreeDumperNode("bitwiseOperator", Nothing, new TreeDumperNode() {Visit(node.BitwiseOperator, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitCompoundAssignmentTargetPlaceholder(node As BoundCompoundAssignmentTargetPlaceholder, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("compoundAssignmentTargetPlaceholder", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAssignmentOperator(node As BoundAssignmentOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("assignmentOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("left", Nothing, new TreeDumperNode() {Visit(node.Left, Nothing)}),
                New TreeDumperNode("leftOnTheRightOpt", Nothing, new TreeDumperNode() {Visit(node.LeftOnTheRightOpt, Nothing)}),
                New TreeDumperNode("right", Nothing, new TreeDumperNode() {Visit(node.Right, Nothing)}),
                New TreeDumperNode("suppressObjectClone", node.SuppressObjectClone, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitReferenceAssignment(node As BoundReferenceAssignment, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("referenceAssignment", Nothing, New TreeDumperNode() {
                New TreeDumperNode("byRefLocal", Nothing, new TreeDumperNode() {Visit(node.ByRefLocal, Nothing)}),
                New TreeDumperNode("lValue", Nothing, new TreeDumperNode() {Visit(node.LValue, Nothing)}),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAddressOfOperator(node As BoundAddressOfOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("addressOfOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("withDependencies", node.WithDependencies, Nothing),
                New TreeDumperNode("methodGroup", Nothing, new TreeDumperNode() {Visit(node.MethodGroup, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitTernaryConditionalExpression(node As BoundTernaryConditionalExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("ternaryConditionalExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("condition", Nothing, new TreeDumperNode() {Visit(node.Condition, Nothing)}),
                New TreeDumperNode("whenTrue", Nothing, new TreeDumperNode() {Visit(node.WhenTrue, Nothing)}),
                New TreeDumperNode("whenFalse", Nothing, new TreeDumperNode() {Visit(node.WhenFalse, Nothing)}),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitBinaryConditionalExpression(node As BoundBinaryConditionalExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("binaryConditionalExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("testExpression", Nothing, new TreeDumperNode() {Visit(node.TestExpression, Nothing)}),
                New TreeDumperNode("convertedTestExpression", Nothing, new TreeDumperNode() {Visit(node.ConvertedTestExpression, Nothing)}),
                New TreeDumperNode("testExpressionPlaceholder", Nothing, new TreeDumperNode() {Visit(node.TestExpressionPlaceholder, Nothing)}),
                New TreeDumperNode("elseExpression", Nothing, new TreeDumperNode() {Visit(node.ElseExpression, Nothing)}),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitConversion(node As BoundConversion, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("conversion", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("conversionKind", node.ConversionKind, Nothing),
                New TreeDumperNode("checked", node.Checked, Nothing),
                New TreeDumperNode("explicitCastInCode", node.ExplicitCastInCode, Nothing),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("extendedInfoOpt", Nothing, new TreeDumperNode() {Visit(node.ExtendedInfoOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitRelaxationLambda(node As BoundRelaxationLambda, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("relaxationLambda", Nothing, New TreeDumperNode() {
                New TreeDumperNode("lambda", Nothing, new TreeDumperNode() {Visit(node.Lambda, Nothing)}),
                New TreeDumperNode("receiverPlaceholderOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverPlaceholderOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitConvertedTupleElements(node As BoundConvertedTupleElements, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("convertedTupleElements", Nothing, New TreeDumperNode() {
                New TreeDumperNode("elementPlaceholders", Nothing, From x In node.ElementPlaceholders Select Visit(x, Nothing)),
                New TreeDumperNode("convertedElements", Nothing, From x In node.ConvertedElements Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitUserDefinedConversion(node As BoundUserDefinedConversion, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("userDefinedConversion", Nothing, New TreeDumperNode() {
                New TreeDumperNode("underlyingExpression", Nothing, new TreeDumperNode() {Visit(node.UnderlyingExpression, Nothing)}),
                New TreeDumperNode("inOutConversionFlags", node.InOutConversionFlags, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitDirectCast(node As BoundDirectCast, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("[directCast]", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("conversionKind", node.ConversionKind, Nothing),
                New TreeDumperNode("suppressVirtualCalls", node.SuppressVirtualCalls, Nothing),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("relaxationLambdaOpt", Nothing, new TreeDumperNode() {Visit(node.RelaxationLambdaOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitTryCast(node As BoundTryCast, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("[tryCast]", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("conversionKind", node.ConversionKind, Nothing),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("relaxationLambdaOpt", Nothing, new TreeDumperNode() {Visit(node.RelaxationLambdaOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitTypeOf(node As BoundTypeOf, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("[typeOf]", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("isTypeOfIsNotExpression", node.IsTypeOfIsNotExpression, Nothing),
                New TreeDumperNode("targetType", node.TargetType, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitSequencePoint(node As BoundSequencePoint, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("sequencePoint", Nothing, New TreeDumperNode() {
                New TreeDumperNode("statementOpt", Nothing, new TreeDumperNode() {Visit(node.StatementOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitSequencePointExpression(node As BoundSequencePointExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("sequencePointExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitSequencePointWithSpan(node As BoundSequencePointWithSpan, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("sequencePointWithSpan", Nothing, New TreeDumperNode() {
                New TreeDumperNode("statementOpt", Nothing, new TreeDumperNode() {Visit(node.StatementOpt, Nothing)}),
                New TreeDumperNode("span", node.Span, Nothing)
            })
        End Function

        Public Overrides Function VisitNoOpStatement(node As BoundNoOpStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("noOpStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("flavor", node.Flavor, Nothing)
            })
        End Function

        Public Overrides Function VisitMethodGroup(node As BoundMethodGroup, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("methodGroup", Nothing, New TreeDumperNode() {
                New TreeDumperNode("typeArgumentsOpt", Nothing, new TreeDumperNode() {Visit(node.TypeArgumentsOpt, Nothing)}),
                New TreeDumperNode("methods", node.Methods, Nothing),
                New TreeDumperNode("pendingExtensionMethodsOpt", node.PendingExtensionMethodsOpt, Nothing),
                New TreeDumperNode("resultKind", node.ResultKind, Nothing),
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("qualificationKind", node.QualificationKind, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitPropertyGroup(node As BoundPropertyGroup, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("propertyGroup", Nothing, New TreeDumperNode() {
                New TreeDumperNode("properties", node.Properties, Nothing),
                New TreeDumperNode("resultKind", node.ResultKind, Nothing),
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("qualificationKind", node.QualificationKind, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitReturnStatement(node As BoundReturnStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("returnStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expressionOpt", Nothing, new TreeDumperNode() {Visit(node.ExpressionOpt, Nothing)}),
                New TreeDumperNode("functionLocalOpt", node.FunctionLocalOpt, Nothing),
                New TreeDumperNode("exitLabelOpt", node.ExitLabelOpt, Nothing)
            })
        End Function

        Public Overrides Function VisitYieldStatement(node As BoundYieldStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("yieldStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)})
            })
        End Function

        Public Overrides Function VisitThrowStatement(node As BoundThrowStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("throwStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expressionOpt", Nothing, new TreeDumperNode() {Visit(node.ExpressionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitRedimStatement(node As BoundRedimStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("redimStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("clauses", Nothing, From x In node.Clauses Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitRedimClause(node As BoundRedimClause, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("redimClause", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("indices", Nothing, From x In node.Indices Select Visit(x, Nothing)),
                New TreeDumperNode("arrayTypeOpt", node.ArrayTypeOpt, Nothing),
                New TreeDumperNode("preserve", node.Preserve, Nothing)
            })
        End Function

        Public Overrides Function VisitEraseStatement(node As BoundEraseStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("eraseStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("clauses", Nothing, From x In node.Clauses Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitCall(node As BoundCall, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("[call]", Nothing, New TreeDumperNode() {
                New TreeDumperNode("method", node.Method, Nothing),
                New TreeDumperNode("methodGroupOpt", Nothing, new TreeDumperNode() {Visit(node.MethodGroupOpt, Nothing)}),
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("arguments", Nothing, From x In node.Arguments Select Visit(x, Nothing)),
                New TreeDumperNode("defaultArguments", node.DefaultArguments, Nothing),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("suppressObjectClone", node.SuppressObjectClone, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAttribute(node As BoundAttribute, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("attribute", Nothing, New TreeDumperNode() {
                New TreeDumperNode("constructor", node.Constructor, Nothing),
                New TreeDumperNode("constructorArguments", Nothing, From x In node.ConstructorArguments Select Visit(x, Nothing)),
                New TreeDumperNode("constructorDefaultArguments", node.ConstructorDefaultArguments, Nothing),
                New TreeDumperNode("namedArguments", Nothing, From x In node.NamedArguments Select Visit(x, Nothing)),
                New TreeDumperNode("resultKind", node.ResultKind, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLateMemberAccess(node As BoundLateMemberAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("lateMemberAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("nameOpt", node.NameOpt, Nothing),
                New TreeDumperNode("containerTypeOpt", node.ContainerTypeOpt, Nothing),
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("typeArgumentsOpt", Nothing, new TreeDumperNode() {Visit(node.TypeArgumentsOpt, Nothing)}),
                New TreeDumperNode("accessKind", node.AccessKind, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLateInvocation(node As BoundLateInvocation, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("lateInvocation", Nothing, New TreeDumperNode() {
                New TreeDumperNode("member", Nothing, new TreeDumperNode() {Visit(node.Member, Nothing)}),
                New TreeDumperNode("argumentsOpt", Nothing, From x In node.ArgumentsOpt Select Visit(x, Nothing)),
                New TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, Nothing),
                New TreeDumperNode("accessKind", node.AccessKind, Nothing),
                New TreeDumperNode("methodOrPropertyGroupOpt", Nothing, new TreeDumperNode() {Visit(node.MethodOrPropertyGroupOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLateAddressOfOperator(node As BoundLateAddressOfOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("lateAddressOfOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("memberAccess", Nothing, new TreeDumperNode() {Visit(node.MemberAccess, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitTupleLiteral(node As BoundTupleLiteral, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("tupleLiteral", Nothing, New TreeDumperNode() {
                New TreeDumperNode("inferredType", node.InferredType, Nothing),
                New TreeDumperNode("argumentNamesOpt", node.ArgumentNamesOpt, Nothing),
                New TreeDumperNode("inferredNamesOpt", node.InferredNamesOpt, Nothing),
                New TreeDumperNode("arguments", Nothing, From x In node.Arguments Select Visit(x, Nothing)),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitConvertedTupleLiteral(node As BoundConvertedTupleLiteral, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("convertedTupleLiteral", Nothing, New TreeDumperNode() {
                New TreeDumperNode("naturalTypeOpt", node.NaturalTypeOpt, Nothing),
                New TreeDumperNode("arguments", Nothing, From x In node.Arguments Select Visit(x, Nothing)),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitObjectCreationExpression(node As BoundObjectCreationExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("objectCreationExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("constructorOpt", node.ConstructorOpt, Nothing),
                New TreeDumperNode("methodGroupOpt", Nothing, new TreeDumperNode() {Visit(node.MethodGroupOpt, Nothing)}),
                New TreeDumperNode("arguments", Nothing, From x In node.Arguments Select Visit(x, Nothing)),
                New TreeDumperNode("defaultArguments", node.DefaultArguments, Nothing),
                New TreeDumperNode("initializerOpt", Nothing, new TreeDumperNode() {Visit(node.InitializerOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitNoPiaObjectCreationExpression(node As BoundNoPiaObjectCreationExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("noPiaObjectCreationExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("guidString", node.GuidString, Nothing),
                New TreeDumperNode("initializerOpt", Nothing, new TreeDumperNode() {Visit(node.InitializerOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAnonymousTypeCreationExpression(node As BoundAnonymousTypeCreationExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("anonymousTypeCreationExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("binderOpt", node.BinderOpt, Nothing),
                New TreeDumperNode("declarations", Nothing, From x In node.Declarations Select Visit(x, Nothing)),
                New TreeDumperNode("arguments", Nothing, From x In node.Arguments Select Visit(x, Nothing)),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAnonymousTypePropertyAccess(node As BoundAnonymousTypePropertyAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("anonymousTypePropertyAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("propertyIndex", node.PropertyIndex, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAnonymousTypeFieldInitializer(node As BoundAnonymousTypeFieldInitializer, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("anonymousTypeFieldInitializer", Nothing, New TreeDumperNode() {
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("value", Nothing, new TreeDumperNode() {Visit(node.Value, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitObjectInitializerExpression(node As BoundObjectInitializerExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("objectInitializerExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("createTemporaryLocalForInitialization", node.CreateTemporaryLocalForInitialization, Nothing),
                New TreeDumperNode("placeholderOpt", Nothing, new TreeDumperNode() {Visit(node.PlaceholderOpt, Nothing)}),
                New TreeDumperNode("initializers", Nothing, From x In node.Initializers Select Visit(x, Nothing)),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitCollectionInitializerExpression(node As BoundCollectionInitializerExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("collectionInitializerExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("placeholderOpt", Nothing, new TreeDumperNode() {Visit(node.PlaceholderOpt, Nothing)}),
                New TreeDumperNode("initializers", Nothing, From x In node.Initializers Select Visit(x, Nothing)),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitNewT(node As BoundNewT, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("newT", Nothing, New TreeDumperNode() {
                New TreeDumperNode("initializerOpt", Nothing, new TreeDumperNode() {Visit(node.InitializerOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitDelegateCreationExpression(node As BoundDelegateCreationExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("delegateCreationExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("method", node.Method, Nothing),
                New TreeDumperNode("relaxationLambdaOpt", Nothing, new TreeDumperNode() {Visit(node.RelaxationLambdaOpt, Nothing)}),
                New TreeDumperNode("relaxationReceiverPlaceholderOpt", Nothing, new TreeDumperNode() {Visit(node.RelaxationReceiverPlaceholderOpt, Nothing)}),
                New TreeDumperNode("methodGroupOpt", Nothing, new TreeDumperNode() {Visit(node.MethodGroupOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitArrayCreation(node As BoundArrayCreation, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("arrayCreation", Nothing, New TreeDumperNode() {
                New TreeDumperNode("isParamArrayArgument", node.IsParamArrayArgument, Nothing),
                New TreeDumperNode("bounds", Nothing, From x In node.Bounds Select Visit(x, Nothing)),
                New TreeDumperNode("initializerOpt", Nothing, new TreeDumperNode() {Visit(node.InitializerOpt, Nothing)}),
                New TreeDumperNode("arrayLiteralOpt", Nothing, new TreeDumperNode() {Visit(node.ArrayLiteralOpt, Nothing)}),
                New TreeDumperNode("arrayLiteralConversion", node.ArrayLiteralConversion, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitArrayLiteral(node As BoundArrayLiteral, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("arrayLiteral", Nothing, New TreeDumperNode() {
                New TreeDumperNode("hasDominantType", node.HasDominantType, Nothing),
                New TreeDumperNode("numberOfCandidates", node.NumberOfCandidates, Nothing),
                New TreeDumperNode("inferredType", node.InferredType, Nothing),
                New TreeDumperNode("bounds", Nothing, From x In node.Bounds Select Visit(x, Nothing)),
                New TreeDumperNode("initializer", Nothing, new TreeDumperNode() {Visit(node.Initializer, Nothing)}),
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitArrayInitialization(node As BoundArrayInitialization, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("arrayInitialization", Nothing, New TreeDumperNode() {
                New TreeDumperNode("initializers", Nothing, From x In node.Initializers Select Visit(x, Nothing)),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitFieldAccess(node As BoundFieldAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("fieldAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("fieldSymbol", node.FieldSymbol, Nothing),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("suppressVirtualCalls", node.SuppressVirtualCalls, Nothing),
                New TreeDumperNode("constantsInProgressOpt", node.ConstantsInProgressOpt, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitPropertyAccess(node As BoundPropertyAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("propertyAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("propertySymbol", node.PropertySymbol, Nothing),
                New TreeDumperNode("propertyGroupOpt", Nothing, new TreeDumperNode() {Visit(node.PropertyGroupOpt, Nothing)}),
                New TreeDumperNode("accessKind", node.AccessKind, Nothing),
                New TreeDumperNode("isWriteable", node.IsWriteable, Nothing),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("arguments", Nothing, From x In node.Arguments Select Visit(x, Nothing)),
                New TreeDumperNode("defaultArguments", node.DefaultArguments, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitEventAccess(node As BoundEventAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("eventAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("receiverOpt", Nothing, new TreeDumperNode() {Visit(node.ReceiverOpt, Nothing)}),
                New TreeDumperNode("eventSymbol", node.EventSymbol, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitBlock(node As BoundBlock, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("block", Nothing, New TreeDumperNode() {
                New TreeDumperNode("statementListSyntax", node.StatementListSyntax, Nothing),
                New TreeDumperNode("locals", node.Locals, Nothing),
                New TreeDumperNode("statements", Nothing, From x In node.Statements Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitStateMachineScope(node As BoundStateMachineScope, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("stateMachineScope", Nothing, New TreeDumperNode() {
                New TreeDumperNode("fields", node.Fields, Nothing),
                New TreeDumperNode("statement", Nothing, new TreeDumperNode() {Visit(node.Statement, Nothing)})
            })
        End Function

        Public Overrides Function VisitLocalDeclaration(node As BoundLocalDeclaration, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("localDeclaration", Nothing, New TreeDumperNode() {
                New TreeDumperNode("localSymbol", node.LocalSymbol, Nothing),
                New TreeDumperNode("declarationInitializerOpt", Nothing, new TreeDumperNode() {Visit(node.DeclarationInitializerOpt, Nothing)}),
                New TreeDumperNode("identifierInitializerOpt", Nothing, new TreeDumperNode() {Visit(node.IdentifierInitializerOpt, Nothing)}),
                New TreeDumperNode("initializedByAsNew", node.InitializedByAsNew, Nothing)
            })
        End Function

        Public Overrides Function VisitAsNewLocalDeclarations(node As BoundAsNewLocalDeclarations, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("asNewLocalDeclarations", Nothing, New TreeDumperNode() {
                New TreeDumperNode("localDeclarations", Nothing, From x In node.LocalDeclarations Select Visit(x, Nothing)),
                New TreeDumperNode("initializer", Nothing, new TreeDumperNode() {Visit(node.Initializer, Nothing)}),
                New TreeDumperNode("binder", node.Binder, Nothing)
            })
        End Function

        Public Overrides Function VisitDimStatement(node As BoundDimStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("dimStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("localDeclarations", Nothing, From x In node.LocalDeclarations Select Visit(x, Nothing)),
                New TreeDumperNode("initializerOpt", Nothing, new TreeDumperNode() {Visit(node.InitializerOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitInitializer(node As BoundInitializer, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("initializer", Nothing, Array.Empty(Of TreeDumperNode)())
        End Function

        Public Overrides Function VisitFieldInitializer(node As BoundFieldInitializer, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("fieldInitializer", Nothing, New TreeDumperNode() {
                New TreeDumperNode("initializedFields", node.InitializedFields, Nothing),
                New TreeDumperNode("memberAccessExpressionOpt", Nothing, new TreeDumperNode() {Visit(node.MemberAccessExpressionOpt, Nothing)}),
                New TreeDumperNode("initialValue", Nothing, new TreeDumperNode() {Visit(node.InitialValue, Nothing)}),
                New TreeDumperNode("binderOpt", node.BinderOpt, Nothing)
            })
        End Function

        Public Overrides Function VisitPropertyInitializer(node As BoundPropertyInitializer, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("propertyInitializer", Nothing, New TreeDumperNode() {
                New TreeDumperNode("initializedProperties", node.InitializedProperties, Nothing),
                New TreeDumperNode("memberAccessExpressionOpt", Nothing, new TreeDumperNode() {Visit(node.MemberAccessExpressionOpt, Nothing)}),
                New TreeDumperNode("initialValue", Nothing, new TreeDumperNode() {Visit(node.InitialValue, Nothing)}),
                New TreeDumperNode("binderOpt", node.BinderOpt, Nothing)
            })
        End Function

        Public Overrides Function VisitParameterEqualsValue(node As BoundParameterEqualsValue, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("parameterEqualsValue", Nothing, New TreeDumperNode() {
                New TreeDumperNode("parameter", node.Parameter, Nothing),
                New TreeDumperNode("value", Nothing, new TreeDumperNode() {Visit(node.Value, Nothing)})
            })
        End Function

        Public Overrides Function VisitGlobalStatementInitializer(node As BoundGlobalStatementInitializer, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("globalStatementInitializer", Nothing, New TreeDumperNode() {
                New TreeDumperNode("statement", Nothing, new TreeDumperNode() {Visit(node.Statement, Nothing)})
            })
        End Function

        Public Overrides Function VisitSequence(node As BoundSequence, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("sequence", Nothing, New TreeDumperNode() {
                New TreeDumperNode("locals", node.Locals, Nothing),
                New TreeDumperNode("sideEffects", Nothing, From x In node.SideEffects Select Visit(x, Nothing)),
                New TreeDumperNode("valueOpt", Nothing, new TreeDumperNode() {Visit(node.ValueOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitExpressionStatement(node As BoundExpressionStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("expressionStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)})
            })
        End Function

        Public Overrides Function VisitIfStatement(node As BoundIfStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("ifStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("condition", Nothing, new TreeDumperNode() {Visit(node.Condition, Nothing)}),
                New TreeDumperNode("consequence", Nothing, new TreeDumperNode() {Visit(node.Consequence, Nothing)}),
                New TreeDumperNode("alternativeOpt", Nothing, new TreeDumperNode() {Visit(node.AlternativeOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitSelectStatement(node As BoundSelectStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("selectStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expressionStatement", Nothing, new TreeDumperNode() {Visit(node.ExpressionStatement, Nothing)}),
                New TreeDumperNode("exprPlaceholderOpt", Nothing, new TreeDumperNode() {Visit(node.ExprPlaceholderOpt, Nothing)}),
                New TreeDumperNode("caseBlocks", Nothing, From x In node.CaseBlocks Select Visit(x, Nothing)),
                New TreeDumperNode("recommendSwitchTable", node.RecommendSwitchTable, Nothing),
                New TreeDumperNode("exitLabel", node.ExitLabel, Nothing)
            })
        End Function

        Public Overrides Function VisitCaseBlock(node As BoundCaseBlock, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("caseBlock", Nothing, New TreeDumperNode() {
                New TreeDumperNode("caseStatement", Nothing, new TreeDumperNode() {Visit(node.CaseStatement, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)})
            })
        End Function

        Public Overrides Function VisitCaseStatement(node As BoundCaseStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("caseStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("caseClauses", Nothing, From x In node.CaseClauses Select Visit(x, Nothing)),
                New TreeDumperNode("conditionOpt", Nothing, new TreeDumperNode() {Visit(node.ConditionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitSimpleCaseClause(node As BoundSimpleCaseClause, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("simpleCaseClause", Nothing, New TreeDumperNode() {
                New TreeDumperNode("valueOpt", Nothing, new TreeDumperNode() {Visit(node.ValueOpt, Nothing)}),
                New TreeDumperNode("conditionOpt", Nothing, new TreeDumperNode() {Visit(node.ConditionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitRangeCaseClause(node As BoundRangeCaseClause, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("rangeCaseClause", Nothing, New TreeDumperNode() {
                New TreeDumperNode("lowerBoundOpt", Nothing, new TreeDumperNode() {Visit(node.LowerBoundOpt, Nothing)}),
                New TreeDumperNode("upperBoundOpt", Nothing, new TreeDumperNode() {Visit(node.UpperBoundOpt, Nothing)}),
                New TreeDumperNode("lowerBoundConditionOpt", Nothing, new TreeDumperNode() {Visit(node.LowerBoundConditionOpt, Nothing)}),
                New TreeDumperNode("upperBoundConditionOpt", Nothing, new TreeDumperNode() {Visit(node.UpperBoundConditionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitRelationalCaseClause(node As BoundRelationalCaseClause, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("relationalCaseClause", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operatorKind", node.OperatorKind, Nothing),
                New TreeDumperNode("valueOpt", Nothing, new TreeDumperNode() {Visit(node.ValueOpt, Nothing)}),
                New TreeDumperNode("conditionOpt", Nothing, new TreeDumperNode() {Visit(node.ConditionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitDoLoopStatement(node As BoundDoLoopStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("doLoopStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("topConditionOpt", Nothing, new TreeDumperNode() {Visit(node.TopConditionOpt, Nothing)}),
                New TreeDumperNode("bottomConditionOpt", Nothing, new TreeDumperNode() {Visit(node.BottomConditionOpt, Nothing)}),
                New TreeDumperNode("topConditionIsUntil", node.TopConditionIsUntil, Nothing),
                New TreeDumperNode("bottomConditionIsUntil", node.BottomConditionIsUntil, Nothing),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("continueLabel", node.ContinueLabel, Nothing),
                New TreeDumperNode("exitLabel", node.ExitLabel, Nothing)
            })
        End Function

        Public Overrides Function VisitWhileStatement(node As BoundWhileStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("whileStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("condition", Nothing, new TreeDumperNode() {Visit(node.Condition, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("continueLabel", node.ContinueLabel, Nothing),
                New TreeDumperNode("exitLabel", node.ExitLabel, Nothing)
            })
        End Function

        Public Overrides Function VisitForToUserDefinedOperators(node As BoundForToUserDefinedOperators, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("forToUserDefinedOperators", Nothing, New TreeDumperNode() {
                New TreeDumperNode("leftOperandPlaceholder", Nothing, new TreeDumperNode() {Visit(node.LeftOperandPlaceholder, Nothing)}),
                New TreeDumperNode("rightOperandPlaceholder", Nothing, new TreeDumperNode() {Visit(node.RightOperandPlaceholder, Nothing)}),
                New TreeDumperNode("addition", Nothing, new TreeDumperNode() {Visit(node.Addition, Nothing)}),
                New TreeDumperNode("subtraction", Nothing, new TreeDumperNode() {Visit(node.Subtraction, Nothing)}),
                New TreeDumperNode("lessThanOrEqual", Nothing, new TreeDumperNode() {Visit(node.LessThanOrEqual, Nothing)}),
                New TreeDumperNode("greaterThanOrEqual", Nothing, new TreeDumperNode() {Visit(node.GreaterThanOrEqual, Nothing)})
            })
        End Function

        Public Overrides Function VisitForToStatement(node As BoundForToStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("forToStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("initialValue", Nothing, new TreeDumperNode() {Visit(node.InitialValue, Nothing)}),
                New TreeDumperNode("limitValue", Nothing, new TreeDumperNode() {Visit(node.LimitValue, Nothing)}),
                New TreeDumperNode("stepValue", Nothing, new TreeDumperNode() {Visit(node.StepValue, Nothing)}),
                New TreeDumperNode("checked", node.Checked, Nothing),
                New TreeDumperNode("operatorsOpt", Nothing, new TreeDumperNode() {Visit(node.OperatorsOpt, Nothing)}),
                New TreeDumperNode("declaredOrInferredLocalOpt", node.DeclaredOrInferredLocalOpt, Nothing),
                New TreeDumperNode("controlVariable", Nothing, new TreeDumperNode() {Visit(node.ControlVariable, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("nextVariablesOpt", Nothing, From x In node.NextVariablesOpt Select Visit(x, Nothing)),
                New TreeDumperNode("continueLabel", node.ContinueLabel, Nothing),
                New TreeDumperNode("exitLabel", node.ExitLabel, Nothing)
            })
        End Function

        Public Overrides Function VisitForEachStatement(node As BoundForEachStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("forEachStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("collection", Nothing, new TreeDumperNode() {Visit(node.Collection, Nothing)}),
                New TreeDumperNode("enumeratorInfo", node.EnumeratorInfo, Nothing),
                New TreeDumperNode("declaredOrInferredLocalOpt", node.DeclaredOrInferredLocalOpt, Nothing),
                New TreeDumperNode("controlVariable", Nothing, new TreeDumperNode() {Visit(node.ControlVariable, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("nextVariablesOpt", Nothing, From x In node.NextVariablesOpt Select Visit(x, Nothing)),
                New TreeDumperNode("continueLabel", node.ContinueLabel, Nothing),
                New TreeDumperNode("exitLabel", node.ExitLabel, Nothing)
            })
        End Function

        Public Overrides Function VisitExitStatement(node As BoundExitStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("exitStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("label", node.Label, Nothing)
            })
        End Function

        Public Overrides Function VisitContinueStatement(node As BoundContinueStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("continueStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("label", node.Label, Nothing)
            })
        End Function

        Public Overrides Function VisitTryStatement(node As BoundTryStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("tryStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("tryBlock", Nothing, new TreeDumperNode() {Visit(node.TryBlock, Nothing)}),
                New TreeDumperNode("catchBlocks", Nothing, From x In node.CatchBlocks Select Visit(x, Nothing)),
                New TreeDumperNode("finallyBlockOpt", Nothing, new TreeDumperNode() {Visit(node.FinallyBlockOpt, Nothing)}),
                New TreeDumperNode("exitLabelOpt", node.ExitLabelOpt, Nothing)
            })
        End Function

        Public Overrides Function VisitCatchBlock(node As BoundCatchBlock, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("catchBlock", Nothing, New TreeDumperNode() {
                New TreeDumperNode("localOpt", node.LocalOpt, Nothing),
                New TreeDumperNode("exceptionSourceOpt", Nothing, new TreeDumperNode() {Visit(node.ExceptionSourceOpt, Nothing)}),
                New TreeDumperNode("errorLineNumberOpt", Nothing, new TreeDumperNode() {Visit(node.ErrorLineNumberOpt, Nothing)}),
                New TreeDumperNode("exceptionFilterOpt", Nothing, new TreeDumperNode() {Visit(node.ExceptionFilterOpt, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("isSynthesizedAsyncCatchAll", node.IsSynthesizedAsyncCatchAll, Nothing)
            })
        End Function

        Public Overrides Function VisitLiteral(node As BoundLiteral, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("literal", Nothing, New TreeDumperNode() {
                New TreeDumperNode("value", node.Value, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitMeReference(node As BoundMeReference, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("meReference", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitValueTypeMeReference(node As BoundValueTypeMeReference, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("valueTypeMeReference", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitMyBaseReference(node As BoundMyBaseReference, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("myBaseReference", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitMyClassReference(node As BoundMyClassReference, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("myClassReference", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitPreviousSubmissionReference(node As BoundPreviousSubmissionReference, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("previousSubmissionReference", Nothing, New TreeDumperNode() {
                New TreeDumperNode("sourceType", node.SourceType, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitHostObjectMemberReference(node As BoundHostObjectMemberReference, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("hostObjectMemberReference", Nothing, New TreeDumperNode() {
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLocal(node As BoundLocal, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("local", Nothing, New TreeDumperNode() {
                New TreeDumperNode("localSymbol", node.LocalSymbol, Nothing),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitPseudoVariable(node As BoundPseudoVariable, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("pseudoVariable", Nothing, New TreeDumperNode() {
                New TreeDumperNode("localSymbol", node.LocalSymbol, Nothing),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("emitExpressions", node.EmitExpressions, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitParameter(node As BoundParameter, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("parameter", Nothing, New TreeDumperNode() {
                New TreeDumperNode("parameterSymbol", node.ParameterSymbol, Nothing),
                New TreeDumperNode("isLValue", node.IsLValue, Nothing),
                New TreeDumperNode("suppressVirtualCalls", node.SuppressVirtualCalls, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitByRefArgumentPlaceholder(node As BoundByRefArgumentPlaceholder, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("byRefArgumentPlaceholder", Nothing, New TreeDumperNode() {
                New TreeDumperNode("isOut", node.IsOut, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitByRefArgumentWithCopyBack(node As BoundByRefArgumentWithCopyBack, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("byRefArgumentWithCopyBack", Nothing, New TreeDumperNode() {
                New TreeDumperNode("originalArgument", Nothing, new TreeDumperNode() {Visit(node.OriginalArgument, Nothing)}),
                New TreeDumperNode("inConversion", Nothing, new TreeDumperNode() {Visit(node.InConversion, Nothing)}),
                New TreeDumperNode("inPlaceholder", Nothing, new TreeDumperNode() {Visit(node.InPlaceholder, Nothing)}),
                New TreeDumperNode("outConversion", Nothing, new TreeDumperNode() {Visit(node.OutConversion, Nothing)}),
                New TreeDumperNode("outPlaceholder", Nothing, new TreeDumperNode() {Visit(node.OutPlaceholder, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLateBoundArgumentSupportingAssignmentWithCapture(node As BoundLateBoundArgumentSupportingAssignmentWithCapture, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("lateBoundArgumentSupportingAssignmentWithCapture", Nothing, New TreeDumperNode() {
                New TreeDumperNode("originalArgument", Nothing, new TreeDumperNode() {Visit(node.OriginalArgument, Nothing)}),
                New TreeDumperNode("localSymbol", node.LocalSymbol, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLabelStatement(node As BoundLabelStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("labelStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("label", node.Label, Nothing)
            })
        End Function

        Public Overrides Function VisitLabel(node As BoundLabel, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("label", Nothing, New TreeDumperNode() {
                New TreeDumperNode("label", node.Label, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitGotoStatement(node As BoundGotoStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("gotoStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("label", node.Label, Nothing),
                New TreeDumperNode("labelExpressionOpt", Nothing, new TreeDumperNode() {Visit(node.LabelExpressionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitStatementList(node As BoundStatementList, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("statementList", Nothing, New TreeDumperNode() {
                New TreeDumperNode("statements", Nothing, From x In node.Statements Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitConditionalGoto(node As BoundConditionalGoto, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("conditionalGoto", Nothing, New TreeDumperNode() {
                New TreeDumperNode("condition", Nothing, new TreeDumperNode() {Visit(node.Condition, Nothing)}),
                New TreeDumperNode("jumpIfTrue", node.JumpIfTrue, Nothing),
                New TreeDumperNode("label", node.Label, Nothing)
            })
        End Function

        Public Overrides Function VisitWithStatement(node As BoundWithStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("withStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("originalExpression", Nothing, new TreeDumperNode() {Visit(node.OriginalExpression, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("binder", node.Binder, Nothing)
            })
        End Function

        Public Overrides Function VisitUnboundLambda(node As UnboundLambda, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("unboundLambda", Nothing, New TreeDumperNode() {
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("flags", node.Flags, Nothing),
                New TreeDumperNode("parameters", node.Parameters, Nothing),
                New TreeDumperNode("returnType", node.ReturnType, Nothing),
                New TreeDumperNode("bindingCache", node.BindingCache, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLambda(node As BoundLambda, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("lambda", Nothing, New TreeDumperNode() {
                New TreeDumperNode("lambdaSymbol", node.LambdaSymbol, Nothing),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("diagnostics", node.Diagnostics, Nothing),
                New TreeDumperNode("lambdaBinderOpt", node.LambdaBinderOpt, Nothing),
                New TreeDumperNode("delegateRelaxation", node.DelegateRelaxation, Nothing),
                New TreeDumperNode("methodConversionKind", node.MethodConversionKind, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitQueryExpression(node As BoundQueryExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("queryExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("lastOperator", Nothing, new TreeDumperNode() {Visit(node.LastOperator, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitQuerySource(node As BoundQuerySource, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("querySource", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitToQueryableCollectionConversion(node As BoundToQueryableCollectionConversion, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("toQueryableCollectionConversion", Nothing, New TreeDumperNode() {
                New TreeDumperNode("conversionCall", Nothing, new TreeDumperNode() {Visit(node.ConversionCall, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitQueryableSource(node As BoundQueryableSource, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("queryableSource", Nothing, New TreeDumperNode() {
                New TreeDumperNode("source", Nothing, new TreeDumperNode() {Visit(node.Source, Nothing)}),
                New TreeDumperNode("rangeVariableOpt", node.RangeVariableOpt, Nothing),
                New TreeDumperNode("rangeVariables", node.RangeVariables, Nothing),
                New TreeDumperNode("compoundVariableType", node.CompoundVariableType, Nothing),
                New TreeDumperNode("binders", node.Binders, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitQueryClause(node As BoundQueryClause, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("queryClause", Nothing, New TreeDumperNode() {
                New TreeDumperNode("underlyingExpression", Nothing, new TreeDumperNode() {Visit(node.UnderlyingExpression, Nothing)}),
                New TreeDumperNode("rangeVariables", node.RangeVariables, Nothing),
                New TreeDumperNode("compoundVariableType", node.CompoundVariableType, Nothing),
                New TreeDumperNode("binders", node.Binders, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitOrdering(node As BoundOrdering, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("ordering", Nothing, New TreeDumperNode() {
                New TreeDumperNode("underlyingExpression", Nothing, new TreeDumperNode() {Visit(node.UnderlyingExpression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitQueryLambda(node As BoundQueryLambda, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("queryLambda", Nothing, New TreeDumperNode() {
                New TreeDumperNode("lambdaSymbol", node.LambdaSymbol, Nothing),
                New TreeDumperNode("rangeVariables", node.RangeVariables, Nothing),
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("exprIsOperandOfConditionalBranch", node.ExprIsOperandOfConditionalBranch, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitRangeVariableAssignment(node As BoundRangeVariableAssignment, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("rangeVariableAssignment", Nothing, New TreeDumperNode() {
                New TreeDumperNode("rangeVariable", node.RangeVariable, Nothing),
                New TreeDumperNode("value", Nothing, new TreeDumperNode() {Visit(node.Value, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitGroupTypeInferenceLambda(node As GroupTypeInferenceLambda, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("groupTypeInferenceLambda", Nothing, New TreeDumperNode() {
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("parameters", node.Parameters, Nothing),
                New TreeDumperNode("compilation", node.Compilation, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAggregateClause(node As BoundAggregateClause, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("aggregateClause", Nothing, New TreeDumperNode() {
                New TreeDumperNode("capturedGroupOpt", Nothing, new TreeDumperNode() {Visit(node.CapturedGroupOpt, Nothing)}),
                New TreeDumperNode("groupPlaceholderOpt", Nothing, new TreeDumperNode() {Visit(node.GroupPlaceholderOpt, Nothing)}),
                New TreeDumperNode("underlyingExpression", Nothing, new TreeDumperNode() {Visit(node.UnderlyingExpression, Nothing)}),
                New TreeDumperNode("rangeVariables", node.RangeVariables, Nothing),
                New TreeDumperNode("compoundVariableType", node.CompoundVariableType, Nothing),
                New TreeDumperNode("binders", node.Binders, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitGroupAggregation(node As BoundGroupAggregation, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("groupAggregation", Nothing, New TreeDumperNode() {
                New TreeDumperNode("group", Nothing, new TreeDumperNode() {Visit(node.Group, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitRangeVariable(node As BoundRangeVariable, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("rangeVariable", Nothing, New TreeDumperNode() {
                New TreeDumperNode("rangeVariable", node.RangeVariable, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitAddHandlerStatement(node As BoundAddHandlerStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("addHandlerStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("eventAccess", Nothing, new TreeDumperNode() {Visit(node.EventAccess, Nothing)}),
                New TreeDumperNode("handler", Nothing, new TreeDumperNode() {Visit(node.Handler, Nothing)})
            })
        End Function

        Public Overrides Function VisitRemoveHandlerStatement(node As BoundRemoveHandlerStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("removeHandlerStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("eventAccess", Nothing, new TreeDumperNode() {Visit(node.EventAccess, Nothing)}),
                New TreeDumperNode("handler", Nothing, new TreeDumperNode() {Visit(node.Handler, Nothing)})
            })
        End Function

        Public Overrides Function VisitRaiseEventStatement(node As BoundRaiseEventStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("raiseEventStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("eventSymbol", node.EventSymbol, Nothing),
                New TreeDumperNode("eventInvocation", Nothing, new TreeDumperNode() {Visit(node.EventInvocation, Nothing)})
            })
        End Function

        Public Overrides Function VisitUsingStatement(node As BoundUsingStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("usingStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("resourceList", Nothing, From x In node.ResourceList Select Visit(x, Nothing)),
                New TreeDumperNode("resourceExpressionOpt", Nothing, new TreeDumperNode() {Visit(node.ResourceExpressionOpt, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)}),
                New TreeDumperNode("usingInfo", node.UsingInfo, Nothing),
                New TreeDumperNode("locals", node.Locals, Nothing)
            })
        End Function

        Public Overrides Function VisitSyncLockStatement(node As BoundSyncLockStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("syncLockStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("lockExpression", Nothing, new TreeDumperNode() {Visit(node.LockExpression, Nothing)}),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)})
            })
        End Function

        Public Overrides Function VisitXmlName(node As BoundXmlName, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlName", Nothing, New TreeDumperNode() {
                New TreeDumperNode("xmlNamespace", Nothing, new TreeDumperNode() {Visit(node.XmlNamespace, Nothing)}),
                New TreeDumperNode("localName", Nothing, new TreeDumperNode() {Visit(node.LocalName, Nothing)}),
                New TreeDumperNode("objectCreation", Nothing, new TreeDumperNode() {Visit(node.ObjectCreation, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlNamespace(node As BoundXmlNamespace, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlNamespace", Nothing, New TreeDumperNode() {
                New TreeDumperNode("xmlNamespace", Nothing, new TreeDumperNode() {Visit(node.XmlNamespace, Nothing)}),
                New TreeDumperNode("objectCreation", Nothing, new TreeDumperNode() {Visit(node.ObjectCreation, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlDocument(node As BoundXmlDocument, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlDocument", Nothing, New TreeDumperNode() {
                New TreeDumperNode("declaration", Nothing, new TreeDumperNode() {Visit(node.Declaration, Nothing)}),
                New TreeDumperNode("childNodes", Nothing, From x In node.ChildNodes Select Visit(x, Nothing)),
                New TreeDumperNode("rewriterInfo", node.RewriterInfo, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlDeclaration(node As BoundXmlDeclaration, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlDeclaration", Nothing, New TreeDumperNode() {
                New TreeDumperNode("version", Nothing, new TreeDumperNode() {Visit(node.Version, Nothing)}),
                New TreeDumperNode("encoding", Nothing, new TreeDumperNode() {Visit(node.Encoding, Nothing)}),
                New TreeDumperNode("standalone", Nothing, new TreeDumperNode() {Visit(node.Standalone, Nothing)}),
                New TreeDumperNode("objectCreation", Nothing, new TreeDumperNode() {Visit(node.ObjectCreation, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlProcessingInstruction(node As BoundXmlProcessingInstruction, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlProcessingInstruction", Nothing, New TreeDumperNode() {
                New TreeDumperNode("target", Nothing, new TreeDumperNode() {Visit(node.Target, Nothing)}),
                New TreeDumperNode("data", Nothing, new TreeDumperNode() {Visit(node.Data, Nothing)}),
                New TreeDumperNode("objectCreation", Nothing, new TreeDumperNode() {Visit(node.ObjectCreation, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlComment(node As BoundXmlComment, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlComment", Nothing, New TreeDumperNode() {
                New TreeDumperNode("value", Nothing, new TreeDumperNode() {Visit(node.Value, Nothing)}),
                New TreeDumperNode("objectCreation", Nothing, new TreeDumperNode() {Visit(node.ObjectCreation, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlAttribute(node As BoundXmlAttribute, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlAttribute", Nothing, New TreeDumperNode() {
                New TreeDumperNode("name", Nothing, new TreeDumperNode() {Visit(node.Name, Nothing)}),
                New TreeDumperNode("value", Nothing, new TreeDumperNode() {Visit(node.Value, Nothing)}),
                New TreeDumperNode("matchesImport", node.MatchesImport, Nothing),
                New TreeDumperNode("objectCreation", Nothing, new TreeDumperNode() {Visit(node.ObjectCreation, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlElement(node As BoundXmlElement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlElement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("argument", Nothing, new TreeDumperNode() {Visit(node.Argument, Nothing)}),
                New TreeDumperNode("childNodes", Nothing, From x In node.ChildNodes Select Visit(x, Nothing)),
                New TreeDumperNode("rewriterInfo", node.RewriterInfo, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlMemberAccess(node As BoundXmlMemberAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlMemberAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("memberAccess", Nothing, new TreeDumperNode() {Visit(node.MemberAccess, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlEmbeddedExpression(node As BoundXmlEmbeddedExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlEmbeddedExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitXmlCData(node As BoundXmlCData, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("xmlCData", Nothing, New TreeDumperNode() {
                New TreeDumperNode("value", Nothing, new TreeDumperNode() {Visit(node.Value, Nothing)}),
                New TreeDumperNode("objectCreation", Nothing, new TreeDumperNode() {Visit(node.ObjectCreation, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitResumeStatement(node As BoundResumeStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("resumeStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("resumeKind", node.ResumeKind, Nothing),
                New TreeDumperNode("labelOpt", node.LabelOpt, Nothing),
                New TreeDumperNode("labelExpressionOpt", Nothing, new TreeDumperNode() {Visit(node.LabelExpressionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitOnErrorStatement(node As BoundOnErrorStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("onErrorStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("onErrorKind", node.OnErrorKind, Nothing),
                New TreeDumperNode("labelOpt", node.LabelOpt, Nothing),
                New TreeDumperNode("labelExpressionOpt", Nothing, new TreeDumperNode() {Visit(node.LabelExpressionOpt, Nothing)})
            })
        End Function

        Public Overrides Function VisitUnstructuredExceptionHandlingStatement(node As BoundUnstructuredExceptionHandlingStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("unstructuredExceptionHandlingStatement", Nothing, New TreeDumperNode() {
                New TreeDumperNode("containsOnError", node.ContainsOnError, Nothing),
                New TreeDumperNode("containsResume", node.ContainsResume, Nothing),
                New TreeDumperNode("resumeWithoutLabelOpt", node.ResumeWithoutLabelOpt, Nothing),
                New TreeDumperNode("trackLineNumber", node.TrackLineNumber, Nothing),
                New TreeDumperNode("body", Nothing, new TreeDumperNode() {Visit(node.Body, Nothing)})
            })
        End Function

        Public Overrides Function VisitUnstructuredExceptionHandlingCatchFilter(node As BoundUnstructuredExceptionHandlingCatchFilter, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("unstructuredExceptionHandlingCatchFilter", Nothing, New TreeDumperNode() {
                New TreeDumperNode("activeHandlerLocal", Nothing, new TreeDumperNode() {Visit(node.ActiveHandlerLocal, Nothing)}),
                New TreeDumperNode("resumeTargetLocal", Nothing, new TreeDumperNode() {Visit(node.ResumeTargetLocal, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitUnstructuredExceptionOnErrorSwitch(node As BoundUnstructuredExceptionOnErrorSwitch, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("unstructuredExceptionOnErrorSwitch", Nothing, New TreeDumperNode() {
                New TreeDumperNode("value", Nothing, new TreeDumperNode() {Visit(node.Value, Nothing)}),
                New TreeDumperNode("jumps", Nothing, From x In node.Jumps Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitUnstructuredExceptionResumeSwitch(node As BoundUnstructuredExceptionResumeSwitch, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("unstructuredExceptionResumeSwitch", Nothing, New TreeDumperNode() {
                New TreeDumperNode("resumeTargetTemporary", Nothing, new TreeDumperNode() {Visit(node.ResumeTargetTemporary, Nothing)}),
                New TreeDumperNode("resumeLabel", Nothing, new TreeDumperNode() {Visit(node.ResumeLabel, Nothing)}),
                New TreeDumperNode("resumeNextLabel", Nothing, new TreeDumperNode() {Visit(node.ResumeNextLabel, Nothing)}),
                New TreeDumperNode("jumps", Nothing, From x In node.Jumps Select Visit(x, Nothing))
            })
        End Function

        Public Overrides Function VisitAwaitOperator(node As BoundAwaitOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("awaitOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("operand", Nothing, new TreeDumperNode() {Visit(node.Operand, Nothing)}),
                New TreeDumperNode("awaitableInstancePlaceholder", Nothing, new TreeDumperNode() {Visit(node.AwaitableInstancePlaceholder, Nothing)}),
                New TreeDumperNode("getAwaiter", Nothing, new TreeDumperNode() {Visit(node.GetAwaiter, Nothing)}),
                New TreeDumperNode("awaiterInstancePlaceholder", Nothing, new TreeDumperNode() {Visit(node.AwaiterInstancePlaceholder, Nothing)}),
                New TreeDumperNode("isCompleted", Nothing, new TreeDumperNode() {Visit(node.IsCompleted, Nothing)}),
                New TreeDumperNode("getResult", Nothing, new TreeDumperNode() {Visit(node.GetResult, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitSpillSequence(node As BoundSpillSequence, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("spillSequence", Nothing, New TreeDumperNode() {
                New TreeDumperNode("locals", node.Locals, Nothing),
                New TreeDumperNode("spillFields", node.SpillFields, Nothing),
                New TreeDumperNode("statements", Nothing, From x In node.Statements Select Visit(x, Nothing)),
                New TreeDumperNode("valueOpt", Nothing, new TreeDumperNode() {Visit(node.ValueOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitStopStatement(node As BoundStopStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("stopStatement", Nothing, Array.Empty(Of TreeDumperNode)())
        End Function

        Public Overrides Function VisitEndStatement(node As BoundEndStatement, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("endStatement", Nothing, Array.Empty(Of TreeDumperNode)())
        End Function

        Public Overrides Function VisitMidResult(node As BoundMidResult, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("midResult", Nothing, New TreeDumperNode() {
                New TreeDumperNode("original", Nothing, new TreeDumperNode() {Visit(node.Original, Nothing)}),
                New TreeDumperNode("start", Nothing, new TreeDumperNode() {Visit(node.Start, Nothing)}),
                New TreeDumperNode("lengthOpt", Nothing, new TreeDumperNode() {Visit(node.LengthOpt, Nothing)}),
                New TreeDumperNode("source", Nothing, new TreeDumperNode() {Visit(node.Source, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitConditionalAccess(node As BoundConditionalAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("conditionalAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("receiver", Nothing, new TreeDumperNode() {Visit(node.Receiver, Nothing)}),
                New TreeDumperNode("placeholder", Nothing, new TreeDumperNode() {Visit(node.Placeholder, Nothing)}),
                New TreeDumperNode("accessExpression", Nothing, new TreeDumperNode() {Visit(node.AccessExpression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitConditionalAccessReceiverPlaceholder(node As BoundConditionalAccessReceiverPlaceholder, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("conditionalAccessReceiverPlaceholder", Nothing, New TreeDumperNode() {
                New TreeDumperNode("placeholderId", node.PlaceholderId, Nothing),
                New TreeDumperNode("capture", node.Capture, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitLoweredConditionalAccess(node As BoundLoweredConditionalAccess, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("loweredConditionalAccess", Nothing, New TreeDumperNode() {
                New TreeDumperNode("receiverOrCondition", Nothing, new TreeDumperNode() {Visit(node.ReceiverOrCondition, Nothing)}),
                New TreeDumperNode("captureReceiver", node.CaptureReceiver, Nothing),
                New TreeDumperNode("placeholderId", node.PlaceholderId, Nothing),
                New TreeDumperNode("whenNotNull", Nothing, new TreeDumperNode() {Visit(node.WhenNotNull, Nothing)}),
                New TreeDumperNode("whenNullOpt", Nothing, new TreeDumperNode() {Visit(node.WhenNullOpt, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitComplexConditionalAccessReceiver(node As BoundComplexConditionalAccessReceiver, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("complexConditionalAccessReceiver", Nothing, New TreeDumperNode() {
                New TreeDumperNode("valueTypeReceiver", Nothing, new TreeDumperNode() {Visit(node.ValueTypeReceiver, Nothing)}),
                New TreeDumperNode("referenceTypeReceiver", Nothing, new TreeDumperNode() {Visit(node.ReferenceTypeReceiver, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitNameOfOperator(node As BoundNameOfOperator, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("nameOfOperator", Nothing, New TreeDumperNode() {
                New TreeDumperNode("argument", Nothing, new TreeDumperNode() {Visit(node.Argument, Nothing)}),
                New TreeDumperNode("constantValueOpt", node.ConstantValueOpt, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitTypeAsValueExpression(node As BoundTypeAsValueExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("typeAsValueExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitInterpolatedStringExpression(node As BoundInterpolatedStringExpression, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("interpolatedStringExpression", Nothing, New TreeDumperNode() {
                New TreeDumperNode("contents", Nothing, From x In node.Contents Select Visit(x, Nothing)),
                New TreeDumperNode("binder", node.Binder, Nothing),
                New TreeDumperNode("type", node.Type, Nothing)
            })
        End Function

        Public Overrides Function VisitInterpolation(node As BoundInterpolation, arg As Object) As TreeDumperNode
            Return New TreeDumperNode("interpolation", Nothing, New TreeDumperNode() {
                New TreeDumperNode("expression", Nothing, new TreeDumperNode() {Visit(node.Expression, Nothing)}),
                New TreeDumperNode("alignmentOpt", Nothing, new TreeDumperNode() {Visit(node.AlignmentOpt, Nothing)}),
                New TreeDumperNode("formatStringOpt", Nothing, new TreeDumperNode() {Visit(node.FormatStringOpt, Nothing)})
            })
        End Function

    End Class
End Namespace
