# -*- coding: utf-8 -*-
#!/usr/bin/env python

# Copyright (C) 2009 Martin Sandve Alnæs
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.

# Modified Johan Hake 2011

from __future__ import print_function
import os

# Template for script sent to qsub
template = """#!/bin/bash
%(pbs)s

# enter the job-directory
cd %(workdir)s

# add /usr/local/bin in path
PATH=$PATH:/usr/local/bin

# setup environment
%(paths)s
%(setup)s

# execute job
%(job)s
"""

def job_script(job, jobname, nodes, ppn, walltime, mem, vmem, workdir, \
               email, paths, setup, keep_environment, queue, parallel_environment):
    """
    Generate a torque specific job script
    """
    if queue or parallel_environment:
        print("Warning: 'queue' and 'parallel_environment' is not available "\
              "for the 'torque' backend")

    # Set working dir
    if workdir == os.path.abspath(os.getcwd()):
        workdir = "$PBS_O_WORKDIR"
    
    pbs = []
    pbs.append("-j oe")
    pbs_resources = "-lnodes=%d:ppn=%d,walltime=%d:00:00" % (nodes, ppn, walltime)
    if mem:
        pbs_resources += ",mem=" + mem
    if vmem:
        pbs_resources += ",vmem=" + vmem
    pbs.append(pbs_resources)
    if email:
        pbs.append("-m abe")
        pbs.append("-M %s" % email)
    pbs.append("-N %s" % jobname)
    if keep_environment:
        pbs.append("-V")
    pbs.append("")
    pbs = "\n".join("#PBS %s" % a for a in pbs)
    
    args = dict(pbs=pbs,
                workdir=workdir,
                paths=paths,
                setup=setup,
                job=job)
    
    return template % args
