// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2000,2001 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: 7c5b160a14697177ebe2ed66ae3683b38acf764e $

#ifndef SERVER_EXTERNAL_MIND_H
#define SERVER_EXTERNAL_MIND_H

#include "common/Router.h"

class Link;
class Entity;
class LocatedEntity;

/// \brief This class connects in-game entities to the Link of the client
/// controlling it.
///
/// Essentially used to relay in-game operations that pass to the mind on
/// to the client.
class ExternalMind : public Router {
  protected:
    Link * m_external;
    Entity & m_entity;
    double m_lossTime;

    void deleteEntity(const std::string & id);
    void purgeEntity(const LocatedEntity & ent);
  public:

    ExternalMind(Entity &);
    virtual ~ExternalMind();

    virtual void operation(const Operation &, OpVector &);

    bool isLinked() { return m_external != 0; }
    bool isLinkedTo(Link * c) { return m_external == c; }

    const std::string & connectionId();

    void linkUp(Link * c);
};

#endif // SERVER_EXTERNAL_MIND_H
