/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class SortExpression
extends ComputedExpression {
    private Expression select = null;
    private SortKeyDefinition[] sortKeys = null;
    private transient Comparator[] comparators = null;

    public SortExpression(Expression expression, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.sortKeys = sortKeyDefinitionArray;
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            this.adoptChildExpression(expression2);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(8);
        arrayList.add(this.select);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            arrayList.add(this.sortKeys[i].getSortKey());
            Expression expression = this.sortKeys[i].order;
            if (expression != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].caseOrder) != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].dataTypeExpression) != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].language) != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].collationName) == null || expression instanceof Value) continue;
            arrayList.add(expression);
        }
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        for (int i = 0; i < this.sortKeys.length; ++i) {
            if (this.sortKeys[i].getSortKey() == expression) {
                this.sortKeys[i].setSortKey(expression2);
                bl = true;
            }
            if (this.sortKeys[i].getOrder() == expression) {
                this.sortKeys[i].setOrder(expression2);
                bl = true;
            }
            if (this.sortKeys[i].getCaseOrder() == expression) {
                this.sortKeys[i].setCaseOrder(expression2);
                bl = true;
            }
            if (this.sortKeys[i].getDataTypeExpression() == expression) {
                this.sortKeys[i].setDataTypeExpression(expression2);
                bl = true;
            }
            if (this.sortKeys[i].getLanguage() != expression) continue;
            this.sortKeys[i].setLanguage(expression2);
            bl = true;
        }
        return bl;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        Expression expression = this.select.typeCheck(staticContext, itemType);
        if (expression != this.select) {
            this.adoptChildExpression(expression);
            this.select = expression;
        }
        ItemType itemType2 = this.select.getItemType(staticContext.getConfiguration().getTypeHierarchy());
        boolean bl = true;
        for (n = 0; n < this.sortKeys.length; ++n) {
            this.sortKeys[n].setParentExpression(this);
            if (this.sortKeys[n].isFixed()) continue;
            bl = false;
        }
        if (bl) {
            this.comparators = new Comparator[this.sortKeys.length];
        }
        for (n = 0; n < this.sortKeys.length; ++n) {
            Object object;
            Expression expression2 = this.sortKeys[n].getSortKey();
            expression2 = expression2.typeCheck(staticContext, itemType2);
            if (staticContext.isInBackwardsCompatibleMode()) {
                expression2 = new FirstItemExpression(expression2);
            } else {
                object = new RoleLocator(4, "xsl:sort/select", 0, null);
                ((RoleLocator)object).setErrorCode("XTTE1020");
                expression2 = CardinalityChecker.makeCardinalityChecker(expression2, 24576, (RoleLocator)object);
            }
            this.sortKeys[n].setSortKey(expression2);
            if (!this.sortKeys[n].isFixed()) continue;
            object = this.sortKeys[n].makeComparator(staticContext.makeEarlyEvaluationContext());
            this.sortKeys[n].setComparer((Comparator)object);
            if (!bl) continue;
            this.comparators[n] = object;
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = this.select.optimize(optimizer, staticContext, itemType);
        if (expression != this.select) {
            this.adoptChildExpression(expression);
            this.select = expression;
        }
        ItemType itemType2 = this.select.getItemType(staticContext.getConfiguration().getTypeHierarchy());
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return this;
        }
        ComputedExpression.setParentExpression(this.select, this.getParentExpression());
        return this.select;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.select = this.doPromotion(this.select, promotionOffer);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            this.sortKeys[i].setSortKey(this.sortKeys[i].getSortKey().promote(promotionOffer));
            if (this.sortKeys[i].caseOrder != null) {
                this.sortKeys[i].caseOrder = this.sortKeys[i].caseOrder.promote(promotionOffer);
            }
            if (this.sortKeys[i].dataTypeExpression != null) {
                this.sortKeys[i].dataTypeExpression = this.sortKeys[i].dataTypeExpression.promote(promotionOffer);
            }
            if (this.sortKeys[i].language != null) {
                this.sortKeys[i].language = this.sortKeys[i].language.promote(promotionOffer);
            }
            if (this.sortKeys[i].collationName == null) continue;
            this.sortKeys[i].collationName = this.sortKeys[i].collationName.promote(promotionOffer);
        }
        return this;
    }

    public boolean isSortKey(Expression expression) {
        for (int i = 0; i < this.sortKeys.length; ++i) {
            Expression expression2 = this.sortKeys[i].getSortKey();
            if (expression2 != expression) continue;
            return true;
        }
        return false;
    }

    public int computeCardinality() {
        return this.select.getCardinality();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.select.getItemType(typeHierarchy);
    }

    public int computeSpecialProperties() {
        int n = 0;
        if ((this.select.getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        if ((this.select.getSpecialProperties() & 0x800000) != 0) {
            n |= 0x800000;
        }
        if ((this.select.getSpecialProperties() & 0x400000) != 0) {
            n |= 0x400000;
        }
        return n;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return sequenceIterator;
        }
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        Comparator[] comparatorArray = this.comparators;
        if (this.comparators == null) {
            comparatorArray = new Comparator[this.sortKeys.length];
            for (int i = 0; i < this.sortKeys.length; ++i) {
                Comparator comparator = this.sortKeys[i].getComparer();
                if (comparator == null) {
                    comparator = this.sortKeys[i].makeComparator(xPathContextMinor);
                }
                comparatorArray[i] = comparator;
            }
        }
        sequenceIterator = new SortedIterator(xPathContextMinor, sequenceIterator, this.sortKeys, comparatorArray);
        ((SortedIterator)sequenceIterator).setHostLanguage(this.getHostLanguage());
        return sequenceIterator;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "sort");
        this.select.display(n + 1, printStream, configuration);
    }
}

