/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;
    private boolean isNumberingInstruction = false;
    private boolean noNodeIfEmpty;

    public ValueOf(Expression expression, boolean bl, boolean bl2) {
        this.select = expression;
        this.options = bl ? 1 : 0;
        this.noNodeIfEmpty = bl2;
        this.adoptChildExpression(expression);
        if (expression instanceof StringValue) {
            boolean bl3 = false;
            CharSequence charSequence = ((StringValue)expression).getStringValueCS();
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&') continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.options |= 4;
            }
        }
    }

    public void setIsNumberingInstruction() {
        this.isNumberingInstruction = true;
    }

    public boolean isNumberingInstruction() {
        return this.isNumberingInstruction;
    }

    public int getInstructionNameCode() {
        if (this.isNumberingInstruction) {
            return 160;
        }
        if (this.select instanceof StringValue) {
            return 182;
        }
        return 184;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        super.promoteInst(promotionOffer);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.TEXT;
    }

    public int computeCardinality() {
        if (this.noNodeIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    public void localTypeCheck(StaticContext staticContext, ItemType itemType) {
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        if (this.select instanceof Value) {
            SimpleType simpleType = null;
            if (schemaType instanceof SimpleType && bl) {
                simpleType = (SimpleType)schemaType;
            } else if (schemaType instanceof ComplexType && ((ComplexType)schemaType).isSimpleContent()) {
                simpleType = ((ComplexType)schemaType).getSimpleContentType();
            }
            if (bl && simpleType != null && !simpleType.isNamespaceSensitive()) {
                ValidationException validationException = simpleType.validateContent(((Value)this.select).getStringValue(), null, staticContext.getConfiguration().getNameChecker());
                if (validationException != null) {
                    validationException.setLocator(this);
                    throw validationException;
                }
                return;
            }
            if (schemaType instanceof ComplexType && !((ComplexType)schemaType).isSimpleContent() && !((ComplexType)schemaType).isMixedContent() && !Whitespace.isWhite(((Value)this.select).getStringValue())) {
                StaticError staticError = new StaticError("Complex type " + schemaType.getDescription() + " does not allow text content " + Err.wrap(((Value)this.select).getStringValue()));
                staticError.setLocator(this);
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
    }

    public Expression convertToStringJoin(StaticContext staticContext) {
        if (this.select.getItemType(staticContext.getConfiguration().getTypeHierarchy()) == Type.UNTYPED_ATOMIC_TYPE) {
            return this.select;
        }
        StringFn stringFn = (StringFn)SystemFunction.makeSystemFunction("string", 2, staticContext.getNamePool());
        Expression[] expressionArray = new Expression[]{this.select};
        stringFn.setArguments(expressionArray);
        CastExpression castExpression = new CastExpression(stringFn, Type.UNTYPED_ATOMIC_TYPE, false);
        return castExpression;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        Item item = this.select.evaluateItem(xPathContext);
        if (item != null) {
            sequenceReceiver.characters(item.getStringValueCS(), this.locationId, this.options);
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            CharSequence charSequence;
            Item item = this.select.evaluateItem(xPathContext);
            if (item == null) {
                if (this.noNodeIfEmpty) {
                    return null;
                }
                charSequence = "";
            } else {
                charSequence = item.getStringValueCS();
            }
            Orphan orphan = new Orphan(xPathContext.getController().getConfiguration());
            orphan.setNodeKind((short)3);
            orphan.setStringValue(charSequence);
            return orphan;
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "value-of");
        this.select.display(n + 1, printStream, configuration);
    }
}

