/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#include "cdo_fill.h"
#include "cdo_vlist.h"
#include "process_int.h"

void
cdoFillTs(int p_vlistID, Varray2D<double> &p_varData)
{
  const auto nvars = vlistNvars(p_vlistID);
  p_varData.resize(nvars);
  for (int varID = 0; varID < nvars; varID++)
    {
      const auto gridsize = gridInqSize(vlistInqVarGrid(p_vlistID, varID));
      const auto nlev = zaxisInqSize(vlistInqVarZaxis(p_vlistID, varID));
      p_varData[varID].resize(nlev * gridsize);
    }
}

void
cdoFillTs(int p_vlistID, Varray2D<double> &p_varData, Varray2D<size_t> &p_varNmiss)
{
  const auto nvars = vlistNvars(p_vlistID);
  p_varData.resize(nvars);
  p_varNmiss.resize(nvars);
  for (int varID = 0; varID < nvars; varID++)
    {
      const auto gridsize = gridInqSize(vlistInqVarGrid(p_vlistID, varID));
      const auto nlev = zaxisInqSize(vlistInqVarZaxis(p_vlistID, varID));
      p_varData[varID].resize(nlev * gridsize);
      p_varNmiss[varID].resize(nlev);
    }
}
