/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef PM_COMPONENT_PLUGIN_H
#define PM_COMPONENT_PLUGIN_H

#include <QObject>

#include <MeshComponentExtension.h>
/**
 * @ingroup group_cepmodeling_components_physicalmodel
 *
 * @brief
 * This PML ComponentExtension allows you to manipulate physical model file ".pml".
 * see http://www-timc.imag.fr/Emmanuel.Promayon/pml for more information on
 * this type of documents.
 *
 **/
class PMComponentExtension : public camitk::MeshComponentExtension {
    Q_OBJECT
    Q_INTERFACES(camitk::ComponentExtension)

public:
    /// the constructor (do nothing really)
    PMComponentExtension() : MeshComponentExtension() {};

    /// get the plugin name
    virtual QString getName() const;

    /// get the plugin description (can be html)
    virtual QString getDescription() const;

    /// get the list of managed extensions (each file with an extension in the list can be loaded by this Extension
    virtual QStringList getFileExtensions() const;

    /// get a new instance from data stored in a file (this is the most important method to redefine in your subclass)
    virtual camitk::Component * open(const QString &) throw (camitk::AbortException);

    /// save from or to PML
    virtual bool save(camitk::Component* component) const;

protected:
    /// the destructor
    virtual ~PMComponentExtension() {};
};

#endif
