# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from pickle import load
from os.path import join, isdir, isfile, realpath
from os import listdir, getcwd
from imp import find_module
from sys import path

from common.functions import Functions
from common.config import ConfigLoader

functions = Functions()
config = ConfigLoader()

class ExtensionsLoader(object):	     
    def __init__(self): 
        # Activated plugins
        self.actived_plugins = load(open(join(config.confdir, 'Plugins.cfg')))

        # All available signals
        # If you think you need another signal, please report a bug.
        # http://codingteam.net/project/bluemindo/bugs/add
        self.signals = {
            'OnBluemindoStarted': list(),
            # When Bluemindo is starting
            # glade

            'OnBluemindoWindowClosed': list(),
            # When Bluemindo main window is closed

            'OnBluemindoQuitted': list(),
            # When Bluemindo is quitted

            'OnNotificationRequest': list(),
            # When we want to force desktop notification

            'OnTrayIconAnswer': list(),
            # Send the trayicon object

            'OnToolLyricsPressed': list(),
            # When lyrics button is pressed

            'OnToolReloadLyricsPressed': list(),
            # When lyrics reload button is pressed

            'OnToolSaveLyricsPressed': list(),
            # When lyrics save button is pressed

            'OnLyricsRequest': list(),
            # When we whant to show the lyrics of a song
            # (title, artist, album, comment, genre, year, track, length, file)

            'OnModuleConfiguration': list(),
            # When a module is waiting for configuration
            # (module, confglade)

            'OnModuleConfigurationSave': list(),
            # When: Exit from module's configuration
            # module

            'OnPlaylistRequested': list(),
            # When we open a playlist
            # playlist_name

            'OnPreviousPressed': list(),
            # When previous button is pressed

            'OnStopPressed': list(),
            # When stop button is pressed

            'OnPlayPressed': list(),
            # When play button is pressed

            'OnNextPressed': list(),
            # When next button is pressed

            'OnPlayPressedWithoutQueue': list(),
            # When play is pressed with an empty playlist

            'OnPlayNewSong': list(),
            # When a new song have to be launched
            # (title, artist, album, comment, genre, year, track, length, file)

            'OnPlayNewRadio': list()
            # When a new radio have to be launched
            # (title, url)
        }

        # Starting
        self.modules = []
        self.plugins = []
        self.conflist = {}
        self.is_in_config = False
        path.append(config.unofficial_plugins)

    def load(self):
        """Load all modules and plugins"""

        # Load both modules and plugins
        for exttype in ('modules', 'plugins', config.unofficial_plugins):

            for file_ in listdir(exttype):
                # Get only modules without `.` as first
                # character (exclude .svn/)
                if (isdir(join(getcwd(), exttype, file_))
                  and not file_.startswith('.')):
                    name = file_.lower()

                    # Try to load the module
                    try:
                        if exttype in ('modules', 'plugins'):
                            module = __import__(''.join([exttype + '.', name]))
                            cls = getattr(getattr(module, name),
                                                  name.capitalize())
                            obj = cls(self)
                        else:
                            fp, pathname, desc = find_module(name)
                            if pathname.startswith(exttype):
                                module = __import__(name)
                                cls = getattr(module, name.capitalize())
                                obj = cls(self)
                            else:
                                continue

                        if exttype == 'modules':
                            # Start the module
                            obj.start_module()
                        elif name in self.actived_plugins:
                            # Start the plugin
                            obj.start_plugin()

                        if exttype == 'modules':
                            self.modules.append(obj.module)
                        else:
                            obj.plugin['__object'] = obj
                            self.plugins.append(obj.plugin)

                    except Exception, error:
                        print "\n---------"
                        print ('Extension `%s`, registered in *%s*, could not '
                               'start.' % (file_, exttype) )
                        print error
                        print "---------\n"

                        if exttype == 'modules':
                            raise SystemExit("Bluemindo's modules are required"
                                             " to launch the software.\n"
                                             "Exiting.")

    def connect(self, signal, function):
        """Connect a signal with a module's function"""

        if self.signals.has_key(signal):
            self.signals[signal].append(function)
        else:
            print "`%s` don't exist." % signal

    def load_event(self, signal, args=None):
        """Load an event, call related functions"""

        if self.signals.has_key(signal):
            dct = self.signals[signal]
            for dct_ in dct:
                if args is not None:
                    dct_(args)
                else:
                    dct_()
        else:
            print "`%s` don't exist." % signal

    def get_extensions(self):
        self.modules.sort((lambda x,y:cmp(x['name'], y['name'])))
        self.plugins.sort((lambda x,y:cmp(x['name'], y['name'])))
        return {'modules': self.modules, 'plugins': self.plugins}

    def get_actived_plugins(self):
        return load(open(join(config.confdir, 'Plugins.cfg')))

    def activate_plugin(self, name):
        for plugin in self.plugins:
            if plugin['name'] == name.capitalize():
                obj = plugin['__object']
                obj.start_plugin()

                return

    def shutdown_plugin(self, name):
        for plugin in self.plugins:
            if plugin['name'] == name.capitalize():
                obj = plugin['__object']
                obj.stop_plugin()

                return