/*
 * snespad.h
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef VICE_SNESPAD_H
#define VICE_SNESPAD_H

#include "types.h"

#define SNESPAD_BUTTON_B        0
#define SNESPAD_BUTTON_Y        1
#define SNESPAD_BUTTON_SELECT   2
#define SNESPAD_BUTTON_START    3
#define SNESPAD_UP              4
#define SNESPAD_DOWN            5
#define SNESPAD_LEFT            6
#define SNESPAD_RIGHT           7
#define SNESPAD_BUTTON_A        8
#define SNESPAD_BUTTON_X        9
#define SNESPAD_BUMPER_LEFT    10
#define SNESPAD_BUMBER_RIGHT   11

/* End Of Sequence */
#define SNESPAD_EOS            12

extern int joyport_snespad_resources_init(void);

#endif
