#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Grim Fandango
# send your bug reports to contact@dotslashplay.it
###

script_version=20240403.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='grim-fandango'
GAME_NAME='Grim Fandango'

ARCHIVE_BASE_0_NAME='gog_grim_fandango_remastered_2.3.0.7.sh'
ARCHIVE_BASE_0_MD5='9c5d124c89521d254b0dc259635b2abe'
ARCHIVE_BASE_0_SIZE='6100000'
ARCHIVE_BASE_0_VERSION='1.4-gog2.3.0.7'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/grim_fandango_remastered'

CONTENT_PATH_DEFAULT='data/noarch/game/bin'
CONTENT_LIBS_BIN_FILES='
libchore.so
libLua.so'
CONTENT_GAME_BIN_FILES='
GrimFandango
x86'
CONTENT_GAME_MOVIES_FILES='
MoviesHD'
CONTENT_GAME_DATA_FILES='
FontsHD
patch_v2_or_v3_to_v4.bin
patch_v4_to_v5.bin
en_gagl088.lip
icon.png
controllerdef.txt
*.lab
*.LAB
*.tab'
CONTENT_DOC_DATA_FILES='
common-licenses
*License.txt'

USER_PERSISTENT_DIRECTORIES='
Saves'

APP_MAIN_EXE='GrimFandango'
APP_MAIN_ICON='icon.png'
## Work around a game crash on launch if the game exited without cleaning up its temporary files.
APP_MAIN_PRERUN="${APP_MAIN_PRERUN:-}"'
# Work around a game crash on launch if the game exited without cleaning up its temporary files.
rm --force '\''c:\\temp\sector.txt'\''
'

PACKAGES_LIST='
PKG_BIN
PKG_MOVIES
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_MOVIES_ID $PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6
libX11.so.6'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# The game binary looks for libSDL2-2.0.so.1 instead of libSDL2-2.0.so.0

path_libraries_system=$(
	set_current_package 'PKG_BIN'
	path_libraries_system
)
library_source="${path_libraries_system}/libSDL2-2.0.so.0"
library_destination="$(package_path 'PKG_BIN')$(path_libraries)/libSDL2-2.0.so.1"
mkdir --parents "$(dirname "$library_destination")"
ln --symbolic "$library_source" "$library_destination"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
