/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_BootConcreteComponent.h"

CMPIObjectPath* Boot_OpenDRIM_BootConcreteComponent_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BootConcreteComponent& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BootConcreteComponent_classnames[0], OpenDRIM_BootConcreteComponent_NAMESPACE);

	if (!instance.GroupComponent_isNULL)
		op.addKey("GroupComponent", instance.GroupComponent);

	if (!instance.PartComponent_isNULL)
		op.addKey("PartComponent", instance.PartComponent);

	_L_;
	return op.getHdl();
}

CMPIInstance* Boot_OpenDRIM_BootConcreteComponent_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BootConcreteComponent& instance) {
	_E_;
	Objectpath op(broker, Boot_OpenDRIM_BootConcreteComponent_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void Boot_OpenDRIM_BootConcreteComponent_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BootConcreteComponent& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("PartComponent", instance.PartComponent) == OK)
		instance.PartComponent_isNULL = false;

	if (op.getKey("GroupComponent", instance.GroupComponent) == OK)
		instance.GroupComponent_isNULL = false;

	_L_;
}

void Boot_OpenDRIM_BootConcreteComponent_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BootConcreteComponent& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("GroupComponent", instance.GroupComponent) == OK)
		instance.GroupComponent_isNULL = false;

	if (inst.getProperty("PartComponent", instance.PartComponent) == OK)
		instance.PartComponent_isNULL = false;

	_L_;
}

