/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.devices.CudaDevice;
import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CudaBackend
extends GDBBackend
implements IMIBackend {
    public static final String GDB_TRACE_LEVEL = "CUDA_GDB_TRACE_LEVEL";
    public static String CUDA_ERROR_LEVEL = "CUDA_ERROR_LEVEL";
    private final ILaunchConfiguration lc;
    private String fGDBInitFile;

    public CudaBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        this.lc = lc;
    }

    public void destroy() {
        try {
            Thread.sleep(50 + (Activator.GDB_TRACE > 0 ? 30000 : 0));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.destroy();
    }

    public Properties getEnvironmentVariables() throws CoreException {
        String devicesIdList;
        Properties vars = super.getEnvironmentVariables();
        if (!vars.contains("CUDA_VISIBLE_DEVICES") && !CudaDevice.devicesFilteredExternally() && (devicesIdList = DebugUtil.getDevicesIdList(this.lc)) != null) {
            vars.put("CUDA_VISIBLE_DEVICES", devicesIdList);
        }
        return vars;
    }

    protected Process launchGDBProcess(String commandLine) throws CoreException {
        Process proc = null;
        try {
            String[] launchEnvironment = LaunchUtils.getLaunchEnvironment((ILaunchConfiguration)this.lc);
            String[] environment = DebugUtil.addDevicesEnvironmentVariable(launchEnvironment, this.lc);
            proc = ProcessFactory.getFactory().exec(commandLine, environment);
        }
        catch (IOException e) {
            String message = "Error while launching command " + commandLine;
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", -1, message, (Throwable)e));
        }
        return proc;
    }

    protected void register(String[] classes, Dictionary properties) {
        if (!Arrays.asList(classes).contains(GDBBackend.class.getName())) {
            String[] newClasses = new String[classes.length + 1];
            System.arraycopy(classes, 0, newClasses, 1, classes.length);
            newClasses[0] = GDBBackend.class.getName();
            classes = newClasses;
        }
        super.register(classes, properties);
    }

    public void interruptAndWait(int timeout, RequestMonitor rm) {
        super.interruptAndWait(timeout <= 0 ? 15000 : timeout, rm);
    }

    protected IPath getGDBPath() {
        String defaultGdbCommand = DebugUtil.getCudaGdbExecutablePath(this.lc);
        Path retVal = new Path(defaultGdbCommand);
        try {
            String gdb = this.lc.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            gdb = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdb, false);
            retVal = new Path(gdb);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return retVal;
    }

    public String getGDBInitFile() throws CoreException {
        if (this.fGDBInitFile == null) {
            String defaultGdbInit = Platform.getPreferencesService().getString("com.nvidia.cuda.ide.debug", "cudagdb.initfile", ".cuda-gdbinit", null);
            this.fGDBInitFile = this.lc.getAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", defaultGdbInit);
        }
        return this.fGDBInitFile;
    }

    protected String getGDBCommandLine() {
        String basicCommandLine = super.getGDBCommandLine();
        try {
            if (!this.needsLockFile()) {
                return String.valueOf(basicCommandLine) + " --cuda-use-lockfile=0";
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return basicCommandLine;
    }

    private boolean needsLockFile() throws CoreException {
        boolean cudaPreemption = DebugUtil.isPreemptionEnabled(this.lc.getAttribute("lc.devices", null));
        boolean remoteDebug = "remote".equals(this.lc.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", null));
        return !remoteDebug && !cudaPreemption;
    }

    public boolean isKernelNotificationsEnabled() {
        try {
            return this.lc.getAttribute("lc.kernelevents", false);
        }
        catch (CoreException e) {
            Activator.log(e);
            return false;
        }
    }
}

