/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.model.UtilizationRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class UtilizationRanges {
    Comparator<UtilizationRange> comparator = new Comparator<UtilizationRange>(){

        @Override
        public int compare(UtilizationRange range1, UtilizationRange range2) {
            if (range1.getStart() < range2.getStart()) {
                return -1;
            }
            if (range1.getStart() >= range2.getStart()) {
                return 1;
            }
            return 0;
        }
    };
    TreeSet<UtilizationRange> allRanges = new TreeSet<UtilizationRange>(this.comparator);

    public void addRange(UtilizationRange range) {
        this.allRanges.add(range);
    }

    public void appendRanges(List<UtilizationRange> ranges) {
        this.allRanges.addAll(ranges);
    }

    public List<UtilizationRange> getUtilizationRanges() {
        TreeMap<Long, Integer> overlapsMap = new TreeMap<Long, Integer>();
        for (UtilizationRange interval : this.allRanges) {
            int value = overlapsMap.containsKey(interval.getStart()) ? (Integer)overlapsMap.get(interval.getStart()) + 1 : 1;
            overlapsMap.put(interval.getStart(), value);
            value = overlapsMap.containsKey(interval.getEnd()) ? (Integer)overlapsMap.get(interval.getEnd()) - 1 : -1;
            overlapsMap.put(interval.getEnd(), value);
        }
        ArrayList<UtilizationRange> rangeList = new ArrayList<UtilizationRange>();
        int overlap = 0;
        boolean needToAdd = false;
        long last = 0L;
        Iterator<Object> iterator = overlapsMap.keySet().iterator();
        while (iterator.hasNext()) {
            long point = (Long)iterator.next();
            if (needToAdd) {
                rangeList.add(new UtilizationRange(last, point));
            }
            last = point;
            boolean bl = needToAdd = (overlap += ((Integer)overlapsMap.get(point)).intValue()) > 0;
        }
        Collections.sort(rangeList, this.comparator);
        int pointer = 0;
        block2: for (UtilizationRange interval : this.allRanges) {
            int i = pointer;
            while (i < rangeList.size()) {
                UtilizationRange utilizationRange = (UtilizationRange)rangeList.get(i);
                if (interval.getStart() >= utilizationRange.getEnd()) {
                    pointer = i + 1;
                } else {
                    if (interval.getEnd() <= utilizationRange.getStart()) continue block2;
                    if (interval.getStart() <= utilizationRange.getStart() && interval.getEnd() >= utilizationRange.getEnd()) {
                        utilizationRange.addUtilization(interval.getUtilization());
                    } else if (interval.getStart() >= utilizationRange.getStart() && interval.getStart() < utilizationRange.getEnd()) {
                        utilizationRange.addUtilization(interval.getUtilization());
                    } else if (interval.getEnd() > utilizationRange.getStart() && interval.getEnd() <= utilizationRange.getEnd()) {
                        utilizationRange.addUtilization(interval.getUtilization());
                    }
                }
                ++i;
            }
        }
        return rangeList;
    }
}

