/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.internal.wizard.AbstractRemoteDebugSession;
import com.nvidia.cuda.ide.remote.internal.wizard.LocalPathField;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteConnectDebugSession;
import com.nvidia.cuda.ide.remote.internal.wizard.RemotePathField;
import com.nvidia.cuda.ide.remote.ui.connection.ConnectionStateLabel;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionField;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public final class RemoteConnectMainWizardPage
extends WizardPage {
    private final WizardContext context;
    private LocalPathField localPathField;
    private Spinner port;
    private RemoteConnectionField remoteConnectionField;
    private RemotePathField remotePathField;
    private Button btnLocal;
    private Button btnRemote;
    private ConnectionStateLabel connectionStateLabel;

    private static boolean isLocalFileEntryEnabled(IObservableValue isDownload, IObservableValue connection) {
        return connection.getValue() != null && !Boolean.FALSE.equals(isDownload.getValue());
    }

    protected RemoteConnectMainWizardPage(WizardContext context) {
        super("Connect to Remote Server", "Connect to Remote Server", null);
        this.context = context;
        this.setDescription("Configure Nsight to connect to a cuda-gdbserver on a remote system");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.remoteConnectionField = new RemoteConnectionField(composite, this.context);
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setText(Messages.RemoteDebug_label_cudagdbserver_port);
        this.port = new Spinner(composite, 2048);
        this.port.setMaximum(65535);
        this.port.setMinimum(1);
        new Label(composite, 0);
        Label lblReadDebugSymbols = new Label(composite, 0);
        lblReadDebugSymbols.setText("Debug symbols file:");
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridLayout gl_composite_1 = new GridLayout(2, true);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        this.btnLocal = new Button(composite_1, 16);
        this.btnLocal.setBounds(0, 0, 114, 24);
        this.btnLocal.setText("Local executable");
        this.btnRemote = new Button(composite_1, 16);
        this.btnRemote.setBounds(0, 0, 91, 29);
        this.btnRemote.setText("Remote executable");
        this.localPathField = new LocalPathField(composite, this.context, true);
        this.remotePathField = new RemotePathField(composite, this.context);
        new Label(composite, 0).setLayoutData((Object)new GridData(1, 1, true, true, 3, 1));
        this.connectionStateLabel = new ConnectionStateLabel(composite, this.context, AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION);
        this.setBindings();
        this.setErrorMessage(null);
    }

    private void setBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        final IObservableValue isDownload = this.context.observeProperty(RemoteConnectDebugSession.PROPERTY_DOWNLOAD_FILE);
        final IObservableValue connection = this.context.observeProperty(AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION);
        this.remoteConnectionField.bind(bindingContext, AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION);
        this.remotePathField.bind(bindingContext, AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION, AbstractRemoteDebugSession.PROPERTY_REMOTE_EXECUTABLE);
        this.localPathField.bind(bindingContext, AbstractRemoteDebugSession.PROPERTY_LOCAL_EXECUTABLE_PATH);
        bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.port), this.context.observeProperty(AbstractRemoteDebugSession.PROPERTY_REMOTE_PORT));
        bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.btnRemote), isDownload);
        this.localPathField.toggleState(RemoteConnectMainWizardPage.isLocalFileEntryEnabled(isDownload, connection));
        DataBindingUtil.bindEnablement((DataBindingContext)bindingContext, (IObservableValue)connection, (Control[])new Control[]{this.port});
        bindingContext.bindValue((IObservableValue)new ComputedValue(Boolean.class){

            protected Object calculate() {
                return RemoteConnectMainWizardPage.isLocalFileEntryEnabled(isDownload, connection);
            }
        }, (IObservableValue)new AbstractObservableValue(){

            protected Object doGetValue() {
                return Boolean.TRUE;
            }

            protected void doSetValue(Object value) {
                boolean showLocalControls = Boolean.TRUE.equals(value);
                RemoteConnectMainWizardPage.this.localPathField.toggleState(!showLocalControls);
                RemoteConnectMainWizardPage.this.remotePathField.setVisible(showLocalControls);
            }

            public Object getValueType() {
                return Boolean.class;
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER)).updateTargetToModel();
        bindingContext.bindValue((IObservableValue)new AbstractObservableValue(){

            protected Object doGetValue() {
                return CoreUtil.OK_STATUS;
            }

            protected void doSetValue(Object value) {
                RemoteConnectMainWizardPage.this.updateTitle((IStatus)value);
            }

            public Object getValueType() {
                return IStatus.class;
            }
        }, (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                return RemoteConnectMainWizardPage.this.validate();
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.connectionStateLabel.bind(bindingContext);
    }

    protected void updateTitle(IStatus status) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (status == null) {
            status = Status.OK_STATUS;
        }
        this.setPageComplete(status.getSeverity() < 4);
        switch (status.getSeverity()) {
            case 4: {
                this.setErrorMessage(status.getMessage());
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
            }
        }
    }

    private IStatus validate() {
        IStatus status = this.remoteConnectionField.validate();
        if (status.getSeverity() == 4) {
            return status;
        }
        if (!((Boolean)this.context.getProperty(RemoteConnectDebugSession.PROPERTY_DOWNLOAD_FILE)).booleanValue()) {
            return this.localPathField.validate();
        }
        return this.remotePathField.validate(true);
    }
}

