/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.DirFilter;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.TreeSet;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class PhotoAlbum
extends AbstractTool {
    public PhotoAlbum() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcdir", "The directory containing the image files", false, new DirFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("PhotoAlbum", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== PhotoAlbum OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcdir") == null) {
                throw new InstantiationException("You need to choose a source directory");
            }
            File file = (File)this.getValue("srcdir");
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            Document document = new Document();
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file2));
            pdfWriter.setViewerPreferences(256);
            PdfPageLabels pdfPageLabels = new PdfPageLabels();
            TreeSet<File> treeSet = new TreeSet<File>();
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                throw new NullPointerException("listFiles() returns null");
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                treeSet.add(fileArray[i]);
            }
            for (File file3 : treeSet) {
                System.out.println("Testing image: " + file3.getName());
                try {
                    int n;
                    Image image = Image.getInstance(file3.getAbsolutePath());
                    String string = "";
                    int n2 = image.getDpiX();
                    if (n2 == 0) {
                        n2 = 72;
                    }
                    if ((n = image.getDpiY()) == 0) {
                        n = 72;
                    }
                    float f = 72.0f * image.getPlainWidth() / (float)n2;
                    float f2 = 72.0f * image.getPlainHeight() / (float)n;
                    image.scaleAbsolute(f, f2);
                    document.setPageSize(new Rectangle(f, f2));
                    if (document.isOpen()) {
                        document.newPage();
                    } else {
                        document.open();
                    }
                    image.setAbsolutePosition(0.0f, 0.0f);
                    document.add(image);
                    BaseFont baseFont = BaseFont.createFont("Helvetica", "Cp1252", false);
                    PdfGState pdfGState = new PdfGState();
                    pdfGState.setBlendMode(PdfGState.BM_OVERLAY);
                    PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                    pdfContentByte.saveState();
                    pdfContentByte.setGState(pdfGState);
                    pdfContentByte.beginText();
                    pdfContentByte.setFontAndSize(baseFont, 40.0f);
                    pdfContentByte.setTextMatrix(50.0f, 50.0f);
                    pdfContentByte.showText(string);
                    pdfContentByte.endText();
                    pdfContentByte.restoreState();
                    String string2 = file3.getName();
                    if (string2.lastIndexOf(46) > 0) {
                        string2 = string2.substring(0, string2.lastIndexOf(46));
                    }
                    pdfPageLabels.addPageLabel(pdfWriter.getPageNumber(), 5, string2);
                    System.out.println("Added image: " + file3.getName());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            if (document.isOpen()) {
                pdfWriter.setPageLabels(pdfPageLabels);
                document.close();
            } else {
                System.err.println("No images were found in directory " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        PhotoAlbum photoAlbum = new PhotoAlbum();
        if (stringArray.length < 2) {
            System.err.println(photoAlbum.getUsage());
        }
        photoAlbum.setMainArguments(stringArray);
        photoAlbum.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        PhotoAlbum.addVersion("$Id: PhotoAlbum.java 3451 2008-05-26 02:56:13Z xlv $");
    }
}

