/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteProjectFolder;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public abstract class CheckoutProjectOperation
extends CheckoutOperation {
    private String targetLocation;

    public CheckoutProjectOperation(IWorkbenchPart part, ICVSRemoteFolder[] remoteFolders, String targetLocation) {
        super(part, remoteFolders);
        this.targetLocation = targetLocation;
    }

    protected void createAndOpenProject(IProject project, IProgressMonitor monitor) throws CVSException {
        try {
            try {
                monitor.beginTask(null, 5);
                IProjectDescription desc = this.getDescriptionFor(project);
                if (project.exists()) {
                    if (desc != null) {
                        project.move(desc, true, Policy.subMonitorFor(monitor, 3));
                    }
                } else if (desc == null) {
                    project.create(Policy.subMonitorFor(monitor, 3));
                } else {
                    project.create(desc, Policy.subMonitorFor(monitor, 3));
                }
                if (!project.isOpen()) {
                    project.open(Policy.subMonitorFor(monitor, 2));
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IProjectDescription getDescriptionFor(IProject project) {
        if (this.targetLocation == null) {
            return null;
        }
        String projectName = project.getName();
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setLocation(this.getTargetLocationFor(project));
        return description;
    }

    protected IPath getTargetLocationFor(IProject project) {
        if (this.targetLocation == null) {
            return null;
        }
        return new Path(this.targetLocation);
    }

    protected String getRemoteModuleName(ICVSRemoteFolder resource) {
        String moduleName = resource.isDefinedModule() ? resource.getName() : resource.getRepositoryRelativePath();
        return moduleName;
    }

    protected IStatus checkout(final ICVSRemoteFolder resource, IProject project, IProgressMonitor pm) throws CVSException {
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        ICVSRepositoryLocation repository = resource.getRepository();
        final Session session = new Session(repository, root);
        pm.beginTask(null, 100);
        Policy.checkCanceled(pm);
        session.open(Policy.subMonitorFor(pm, 5), false);
        try {
            IProject[] targetProjects;
            RemoteProjectFolder rpf;
            if (project == null && resource.getName().equals(".")) {
                String name = new Path(null, resource.getRepository().getRootDirectory()).lastSegment();
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            }
            if (project == null && CVSUIPlugin.getPlugin().isUseProjectNameOnCheckout() && resource instanceof RemoteProjectFolder && (rpf = (RemoteProjectFolder)resource).hasProjectName()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(rpf.getProjectName());
            }
            if ((targetProjects = this.determineProjects(session, resource, project, Policy.subMonitorFor(pm, 5))) == null) {
                IStatus iStatus = this.getLastError();
                return iStatus;
            }
            if (targetProjects.length == 0) {
                IStatus iStatus = OK;
                return iStatus;
            }
            final boolean sendModuleName = project != null;
            final IStatus[] result = new IStatus[1];
            ISchedulingRule schedulingRule = this.getSchedulingRule(targetProjects);
            if (schedulingRule instanceof IResource && ((IResource)schedulingRule).getType() == 8) {
                try {
                    Job.getJobManager().beginRule(schedulingRule, pm);
                    EclipseSynchronizer.getInstance().run(MultiRule.combine((ISchedulingRule[])targetProjects), new ICVSRunnable(){

                        public void run(IProgressMonitor monitor) throws CVSException {
                            result[0] = CheckoutProjectOperation.this.performCheckout(session, resource, targetProjects, sendModuleName, monitor);
                        }
                    }, Policy.subMonitorFor(pm, 90));
                }
                finally {
                    Job.getJobManager().endRule(schedulingRule);
                }
            } else {
                EclipseSynchronizer.getInstance().run(schedulingRule, new ICVSRunnable(){

                    public void run(IProgressMonitor monitor) throws CVSException {
                        result[0] = CheckoutProjectOperation.this.performCheckout(session, resource, targetProjects, sendModuleName, monitor);
                    }
                }, Policy.subMonitorFor(pm, 90));
            }
            IWorkingSet[] ws = this.getWorkingSets();
            if (ws != null) {
                int i = 0;
                while (i < ws.length) {
                    this.createWorkingSet(ws[i].getName(), targetProjects);
                    ++i;
                }
            }
            IStatus iStatus = result[0];
            return iStatus;
        }
        catch (CVSException e) {
            CVSStatus cVSStatus = new CVSStatus(e.getStatus().getSeverity(), NLS.bind((String)CVSUIMessages.CheckoutProjectOperation_1, (Object[])new String[]{resource.getRepositoryRelativePath(), e.getMessage()}), (Throwable)e);
            return cVSStatus;
        }
        finally {
            session.close();
            pm.done();
        }
    }

    private ISchedulingRule getSchedulingRule(IProject[] projects) {
        if (projects.length == 1) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)projects[0]);
        }
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < projects.length) {
            ISchedulingRule modifyRule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)projects[i]);
            if (modifyRule instanceof IResource && ((IResource)modifyRule).getType() == 8) {
                return modifyRule;
            }
            rules.add(modifyRule);
            ++i;
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    IStatus performCheckout(Session session, ICVSRemoteFolder resource, IProject[] targetProjects, boolean sendModuleName, IProgressMonitor pm) throws CVSException {
        String taskName = targetProjects.length == 1 ? NLS.bind((String)CVSUIMessages.CheckoutProjectOperation_8, (Object[])new String[]{resource.getName(), targetProjects[0].getName()}) : NLS.bind((String)CVSUIMessages.CheckoutProjectOperation_9, (Object[])new String[]{resource.getName(), String.valueOf(targetProjects.length)});
        pm.beginTask(taskName, 100);
        pm.setTaskName(taskName);
        Policy.checkCanceled(pm);
        try {
            IStatus iStatus;
            IStatus result;
            if (this.performScrubProjects() && !(result = this.scrubProjects(resource, targetProjects, Policy.subMonitorFor(pm, 9))).isOK()) {
                IStatus iStatus2 = result;
                return iStatus2;
            }
            IProject project = null;
            if (targetProjects.length == 1) {
                String path;
                if (sendModuleName) {
                    project = targetProjects[0];
                } else if (targetProjects[0].getName().equals(resource.getName()) && !(path = resource.getRepositoryRelativePath()).equals("CVSROOT/Emptydir") && new Path(null, path).segmentCount() > 1) {
                    project = targetProjects[0];
                }
            }
            try {
                IStatus status;
                CVSTag tag;
                ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
                if (project != null) {
                    localOptions.add(Checkout.makeDirectoryNameOption((String)project.getName()));
                }
                if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                    localOptions.add(Command.PRUNE_EMPTY_DIRECTORIES);
                }
                if ((tag = resource.getTag()) == null) {
                    tag = CVSTag.DEFAULT;
                }
                localOptions.add(Update.makeTagOption((CVSTag)tag));
                if (!this.isRecursive()) {
                    localOptions.add(Command.DO_NOT_RECURSE);
                }
                iStatus = status = Command.CHECKOUT.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{this.getRemoteModuleName(resource)}, null, Policy.subMonitorFor(pm, 90));
            }
            catch (Throwable throwable) {
                this.refreshProjects(targetProjects, Policy.subMonitorFor(pm, 1));
                throw throwable;
            }
            this.refreshProjects(targetProjects, Policy.subMonitorFor(pm, 1));
            return iStatus;
        }
        finally {
            pm.done();
        }
    }

    protected boolean isRecursive() {
        return true;
    }

    private IProject[] determineProjects(Session session, ICVSRemoteFolder remoteFolder, IProject project, IProgressMonitor pm) throws CVSException {
        HashSet<IProject> targetProjectSet = new HashSet<IProject>();
        String moduleName = this.getRemoteModuleName(remoteFolder);
        if (project == null) {
            Policy.checkCanceled(pm);
            IStatus status = Request.EXPAND_MODULES.execute(session, new String[]{moduleName}, pm);
            if (status.getCode() == -10) {
                this.collectStatus(status);
                return null;
            }
            String[] expansions = session.getModuleExpansions();
            if (expansions.length == 1 && expansions[0].equals(moduleName)) {
                RemoteProjectFolder rpf;
                String lastSegment = new Path(null, expansions[0]).lastSegment();
                if (CVSUIPlugin.getPlugin().isUseProjectNameOnCheckout() && remoteFolder instanceof RemoteProjectFolder && (rpf = (RemoteProjectFolder)remoteFolder).hasProjectName()) {
                    lastSegment = rpf.getProjectName();
                }
                targetProjectSet.add(ResourcesPlugin.getWorkspace().getRoot().getProject(lastSegment));
            } else {
                int j = 0;
                while (j < expansions.length) {
                    targetProjectSet.add(ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(null, expansions[j]).segment(0)));
                    ++j;
                }
            }
        } else {
            targetProjectSet.add(project);
        }
        IProject[] targetProjects = targetProjectSet.toArray(new IProject[targetProjectSet.size()]);
        return targetProjects;
    }

    protected boolean performScrubProjects() {
        return true;
    }

    private IStatus scrubProjects(ICVSRemoteFolder remoteFolder, IProject[] projects, IProgressMonitor monitor) throws CVSException {
        IProject project;
        if (projects == null) {
            monitor.done();
            return OK;
        }
        if (projects.length > 1) {
            this.setInvolvesMultipleResources(true);
        }
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            Policy.checkCanceled(monitor);
            if (this.needsPromptForOverwrite(project) && !this.promptToOverwrite(remoteFolder, project)) {
                return new CVSStatus(1, 8, NLS.bind((String)CVSUIMessages.CheckoutProjectOperation_0, (Object[])new String[]{remoteFolder.getRepositoryRelativePath()}), (ICVSFolder)remoteFolder);
            }
            ++i;
        }
        monitor.beginTask(null, projects.length * 100);
        i = 0;
        while (i < projects.length) {
            project = projects[i];
            this.createAndOpenProject(project, Policy.subMonitorFor(monitor, 10));
            this.scrubProject(project, Policy.subMonitorFor(monitor, 90));
            ++i;
        }
        monitor.done();
        return OK;
    }

    private void scrubProject(IProject project, IProgressMonitor monitor) throws CVSException {
        try {
            if (RepositoryProvider.getProvider((IProject)project) != null) {
                RepositoryProvider.unmap((IProject)project);
            }
            IResource[] children = project.members(2);
            Policy.checkCanceled(monitor);
            monitor.beginTask(null, 100 + children.length * 100);
            monitor.subTask(NLS.bind((String)CVSUIMessages.CheckoutOperation_scrubbingProject, (Object[])new String[]{project.getName()}));
            try {
                int j = 0;
                while (j < children.length) {
                    if (!children[j].getName().equals(".project")) {
                        children[j].delete(true, Policy.subMonitorFor(monitor, 100));
                    }
                    ++j;
                }
                EclipseSynchronizer.getInstance().flush((IContainer)project, true, Policy.subMonitorFor(monitor, 100));
            }
            finally {
                monitor.done();
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
    }

    protected boolean needsPromptForOverwrite(IProject project) {
        File localLocation;
        IProjectDescription desc = this.getDescriptionFor(project);
        if (desc != null && (localLocation = desc.getLocation().toFile()).exists()) {
            return true;
        }
        if (project.exists()) {
            return true;
        }
        localLocation = this.getFileLocation(project);
        return localLocation.exists();
    }

    protected File getFileLocation(IProject project) {
        return new File(project.getParent().getLocation().toFile(), project.getName());
    }

    private boolean promptToOverwrite(ICVSRemoteFolder remoteFolder, IProject project) {
        if (project.exists() && !this.promptToOverwrite(CVSUIMessages.CheckoutOperation_confirmOverwrite, NLS.bind((String)CVSUIMessages.CheckoutOperation_thisResourceExists, (Object[])new String[]{project.getName(), this.getRemoteModuleName(remoteFolder)}), (IResource)project)) {
            return false;
        }
        IPath path = this.getTargetLocationFor(project);
        File localLocation = null;
        if (path == null) {
            try {
                if (!project.exists() || !project.isOpen() || project.getDescription().getLocation() != null) {
                    localLocation = this.getFileLocation(project);
                }
            }
            catch (CoreException e) {
                CVSUIPlugin.log(e);
            }
        } else {
            localLocation = path.toFile();
        }
        if (localLocation != null && localLocation.exists()) {
            try {
                return this.promptToOverwrite(CVSUIMessages.CheckoutOperation_confirmOverwrite, NLS.bind((String)CVSUIMessages.CheckoutOperation_thisExternalFileExists, (Object[])new String[]{localLocation.getCanonicalPath(), this.getRemoteModuleName(remoteFolder)}), (IResource)project);
            }
            catch (IOException e) {
                CVSUIPlugin.log((CoreException)((Object)CVSException.wrapException((Exception)e)));
            }
        }
        return true;
    }

    private void refreshProjects(IProject[] projects, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, projects.length * 100);
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                try {
                    monitor.subTask(NLS.bind((String)CVSUIMessages.CheckoutOperation_refreshingProject, (Object[])new String[]{project.getName()}));
                    ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
                    if (folder.isCVSFolder()) {
                        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                    }
                }
                catch (TeamException e) {
                    throw CVSException.wrapException((CoreException)((Object)e));
                }
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                if (provider != null) {
                    provider.setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getTaskName() {
        ICVSRemoteFolder[] remoteFolders = this.getRemoteFolders();
        if (remoteFolders.length == 1) {
            return NLS.bind((String)CVSUIMessages.CheckoutSingleProjectOperation_taskname, (Object[])new String[]{remoteFolders[0].getName()});
        }
        return NLS.bind((String)CVSUIMessages.CheckoutMultipleProjectsOperation_taskName, (Object[])new String[]{new Integer(remoteFolders.length).toString()});
    }

    void createWorkingSet(String workingSetName, IProject[] projects) {
        IWorkingSetManager manager = CVSUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
        IWorkingSet oldSet = manager.getWorkingSet(workingSetName);
        if (oldSet == null) {
            IWorkingSet newSet = manager.createWorkingSet(workingSetName, (IAdaptable[])projects);
            newSet.setId("org.eclipse.ui.resourceWorkingSetPage");
            manager.addWorkingSet(newSet);
        } else {
            IAdaptable[] tempElements = oldSet.getElements();
            IAdaptable[] adaptedProjects = oldSet.adaptElements((IAdaptable[])projects);
            IAdaptable[] finalElementList = new IAdaptable[tempElements.length + adaptedProjects.length];
            System.arraycopy(tempElements, 0, finalElementList, 0, tempElements.length);
            System.arraycopy(adaptedProjects, 0, finalElementList, tempElements.length, adaptedProjects.length);
            oldSet.setElements(finalElementList);
        }
    }

    protected IWorkingSet[] getWorkingSets() {
        return null;
    }
}

