/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal.handler;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabCreationHandler;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabRenderingHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class CrosstabHandlerCache {
    private HashMap<DesignElementHandle, DesignElementHandle> cell2crosstabCache = new HashMap();
    private HashMap<DesignElementHandle, String> cell2createScriptCache = new HashMap();
    private HashMap<DesignElementHandle, CrosstabCreationHandler> crosstab2createHandlerCache = new HashMap();
    private HashMap<DesignElementHandle, String> cell2renderScriptCache = new HashMap();
    private HashMap<DesignElementHandle, CrosstabRenderingHandler> crosstab2renderHandlerCache = new HashMap();

    private DesignElementHandle getCrosstabHandle(DesignElementHandle cellHandle) {
        DesignElementHandle crosstab = this.cell2crosstabCache.get(cellHandle);
        if (crosstab == null) {
            DesignElementHandle e = cellHandle;
            while (e != null) {
                if ("Crosstab".equals(e.getStringProperty("extensionName"))) {
                    crosstab = e;
                    this.cell2crosstabCache.put(cellHandle, crosstab);
                    break;
                }
                e = e.getContainer();
            }
        }
        return crosstab;
    }

    public String getOnCreateScript(DesignElementHandle cellHandle) {
        ExtendedItemHandle crosstabHandle;
        String onCreate = this.cell2createScriptCache.get(cellHandle);
        if (onCreate == null && (crosstabHandle = (ExtendedItemHandle)this.getCrosstabHandle(cellHandle)) != null) {
            onCreate = crosstabHandle.getEventHandlerClass();
            if (onCreate == null || onCreate.trim().length() == 0) {
                onCreate = crosstabHandle.getOnCreate();
            }
            onCreate = onCreate == null ? "" : onCreate.trim();
            this.cell2createScriptCache.put(cellHandle, onCreate);
        }
        return onCreate;
    }

    public String getOnRenderScript(DesignElementHandle cellHandle) {
        ExtendedItemHandle crosstabHandle;
        String onRender = this.cell2renderScriptCache.get(cellHandle);
        if (onRender == null && (crosstabHandle = (ExtendedItemHandle)this.getCrosstabHandle(cellHandle)) != null) {
            onRender = crosstabHandle.getEventHandlerClass();
            if (onRender == null || onRender.trim().length() == 0) {
                onRender = crosstabHandle.getOnRender();
            }
            onRender = onRender == null ? "" : onRender.trim();
            this.cell2renderScriptCache.put(cellHandle, onRender);
        }
        return onRender;
    }

    public CrosstabCreationHandler getCreateHandler(DesignElementHandle cellHandle, ClassLoader contextLoader) throws BirtException {
        ExtendedItemHandle crosstabModelHandle = (ExtendedItemHandle)this.getCrosstabHandle(cellHandle);
        CrosstabCreationHandler handler = this.crosstab2createHandlerCache.get(crosstabModelHandle);
        if (handler == null) {
            handler = new CrosstabCreationHandler(crosstabModelHandle, contextLoader);
            this.crosstab2createHandlerCache.put((DesignElementHandle)crosstabModelHandle, handler);
        }
        return handler;
    }

    public CrosstabRenderingHandler getRenderHandler(DesignElementHandle cellHandle, ClassLoader contextLoader) throws BirtException {
        ExtendedItemHandle crosstabModelHandle = (ExtendedItemHandle)this.getCrosstabHandle(cellHandle);
        CrosstabRenderingHandler handler = this.crosstab2renderHandlerCache.get(crosstabModelHandle);
        if (handler == null) {
            handler = new CrosstabRenderingHandler(crosstabModelHandle, contextLoader);
            this.crosstab2renderHandlerCache.put((DesignElementHandle)crosstabModelHandle, handler);
        }
        return handler;
    }

    public void dispose() {
        this.cell2crosstabCache.clear();
        this.cell2createScriptCache.clear();
        this.crosstab2createHandlerCache.clear();
        this.cell2renderScriptCache.clear();
        this.crosstab2renderHandlerCache.clear();
        this.cell2crosstabCache = null;
        this.cell2createScriptCache = null;
        this.crosstab2createHandlerCache = null;
        this.cell2renderScriptCache = null;
        this.crosstab2renderHandlerCache = null;
    }
}

