/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.CompositeDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.cdt.dsf.debug.service.IExpressions3;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.Messages;
import org.eclipse.cdt.dsf.mi.service.IMIExpressions;
import org.eclipse.cdt.dsf.mi.service.MIRegisters;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class GDBPatternMatchingExpressions
extends AbstractDsfService
implements IMIExpressions,
ICachingService {
    private static final String EXPRESSION_GROUP_SEPARATORS_REGEXP = "[;]";
    private static final String REGISTER_PREFIX = "$";
    private static final String GLOB_EXPRESSION_PREFIX = "=";
    private static final String ARRAY_INDEX_RANGE_REGEXP = "^*\\d+(\\s*-\\s*\\d+)?(\\s*,\\s*\\d+(\\s*-\\s*\\d+)?)*$";
    private IMIExpressions fDelegate;

    public GDBPatternMatchingExpressions(DsfSession session, IMIExpressions delegate) {
        super(session);
        this.fDelegate = delegate;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            public void handleSuccess() {
                GDBPatternMatchingExpressions.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        assert (!this.fDelegate.isRegistered());
        this.register(new String[]{IExpressions.class.getName(), IExpressions2.class.getName(), IExpressions3.class.getName(), IMIExpressions.class.getName()}, new Hashtable());
        this.fDelegate.initialize(requestMonitor);
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        this.fDelegate.shutdown(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBPatternMatchingExpressions.this.unregister();
                GDBPatternMatchingExpressions.super.shutdown(requestMonitor);
            }
        });
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression) {
        IExpressions.IExpressionDMContext expressionDmc = this.fDelegate.createExpression(ctx, expression);
        if (this.isExpressionGroup(expression)) {
            return new ExpressionGroupDMC(expressionDmc);
        }
        return expressionDmc;
    }

    public IExpressions2.ICastedExpressionDMContext createCastedExpression(IExpressions.IExpressionDMContext context, IExpressions2.CastInfo castInfo) {
        assert (!(context instanceof IExpressions.IExpressionGroupDMContext));
        return this.fDelegate.createCastedExpression(context, castInfo);
    }

    public void getExpressionDataExtension(final IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions3.IExpressionDMDataExtension> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            this.getSubExpressionCount(dmc, (DataRequestMonitor<Integer>)new ImmediateDataRequestMonitor<Integer>(rm){

                protected void handleSuccess() {
                    rm.done((Object)new ExpressionGroupDMData(((IExpressions.IExpressionGroupDMContext)dmc).getExpression(), (Integer)this.getData()));
                }
            });
            return;
        }
        this.fDelegate.getExpressionDataExtension(dmc, rm);
    }

    public void getExpressionData(final IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            this.getSubExpressionCount(dmc, (DataRequestMonitor<Integer>)new ImmediateDataRequestMonitor<Integer>(rm){

                protected void handleSuccess() {
                    rm.done((Object)new ExpressionGroupDMData(((IExpressions.IExpressionGroupDMContext)dmc).getExpression(), (Integer)this.getData()));
                }
            });
            return;
        }
        this.fDelegate.getExpressionData(dmc, rm);
    }

    public void getExpressionAddressData(IExpressions.IExpressionDMContext dmc, DataRequestMonitor<IExpressions.IExpressionDMAddress> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            rm.done((Object)new IExpressions.IExpressionDMLocation(){

                public IAddress getAddress() {
                    return IExpressions.IExpressionDMLocation.INVALID_ADDRESS;
                }

                public int getSize() {
                    return 0;
                }

                public String getLocation() {
                    return "";
                }
            });
            return;
        }
        this.fDelegate.getExpressionAddressData(dmc, rm);
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprCtx, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        if (exprCtx instanceof IExpressions.IExpressionGroupDMContext) {
            this.matchExpressionGroup((IExpressions.IExpressionGroupDMContext)exprCtx, -1, -1, rm);
        } else {
            this.fDelegate.getSubExpressions(exprCtx, rm);
        }
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprCtx, int startIndex, int length, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        if (exprCtx instanceof IExpressions.IExpressionGroupDMContext) {
            this.matchExpressionGroup((IExpressions.IExpressionGroupDMContext)exprCtx, startIndex, length, rm);
        } else {
            this.fDelegate.getSubExpressions(exprCtx, startIndex, length, rm);
        }
    }

    public void getSubExpressionCount(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<Integer> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            this.matchExpressionGroup((IExpressions.IExpressionGroupDMContext)dmc, -1, -1, (DataRequestMonitor<IExpressions.IExpressionDMContext[]>)new ImmediateDataRequestMonitor<IExpressions.IExpressionDMContext[]>(rm){

                protected void handleSuccess() {
                    rm.done((Object)((IExpressions.IExpressionDMContext[])this.getData()).length);
                }
            });
        } else {
            this.fDelegate.getSubExpressionCount(dmc, rm);
        }
    }

    @Override
    public void getSubExpressionCount(IExpressions.IExpressionDMContext dmc, int maxNumberOfChildren, final DataRequestMonitor<Integer> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            this.matchExpressionGroup((IExpressions.IExpressionGroupDMContext)dmc, -1, -1, (DataRequestMonitor<IExpressions.IExpressionDMContext[]>)new ImmediateDataRequestMonitor<IExpressions.IExpressionDMContext[]>(rm){

                protected void handleSuccess() {
                    rm.done((Object)((IExpressions.IExpressionDMContext[])this.getData()).length);
                }
            });
        } else {
            this.fDelegate.getSubExpressionCount(dmc, maxNumberOfChildren, rm);
        }
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
    }

    public void canWriteExpression(IExpressions.IExpressionDMContext dmc, DataRequestMonitor<Boolean> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            rm.done((Object)false);
            return;
        }
        this.fDelegate.canWriteExpression(dmc, rm);
    }

    public void writeExpression(IExpressions.IExpressionDMContext dmc, String expressionValue, String formatId, RequestMonitor rm) {
        assert (!(dmc instanceof IExpressions.IExpressionGroupDMContext));
        this.fDelegate.writeExpression(dmc, expressionValue, formatId, rm);
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            rm.done((Object)new String[]{"NATURAL.Format"});
            return;
        }
        this.fDelegate.getAvailableFormats(dmc, rm);
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        return this.fDelegate.getFormattedValueContext(dmc, formatId);
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        IExpressions.IExpressionGroupDMContext exprGroup = (IExpressions.IExpressionGroupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IExpressions.IExpressionGroupDMContext.class);
        if (exprGroup != null) {
            this.getSubExpressionCount((IExpressions.IExpressionDMContext)exprGroup, (DataRequestMonitor<Integer>)new ImmediateDataRequestMonitor<Integer>(rm){

                protected void handleSuccess() {
                    int numChildren = (Integer)this.getData();
                    String value = numChildren == 0 ? Messages.NoMatches : (numChildren == 1 ? MessageFormat.format((String)Messages.UniqueMatch, (Object[])new Object[]{numChildren}) : MessageFormat.format((String)Messages.UniqueMatches, (Object[])new Object[]{numChildren}));
                    rm.done((Object)new IFormattedValues.FormattedValueDMData(value));
                }
            });
            return;
        }
        this.fDelegate.getFormattedExpressionValue(dmc, rm);
    }

    @Override
    public void safeToAskForAllSubExpressions(IExpressions.IExpressionDMContext dmc, DataRequestMonitor<Boolean> rm) {
        if (dmc instanceof IExpressions.IExpressionGroupDMContext) {
            rm.done((Object)true);
            return;
        }
        this.fDelegate.safeToAskForAllSubExpressions(dmc, rm);
    }

    public void flushCache(IDMContext context) {
        if (this.fDelegate instanceof ICachingService) {
            ((ICachingService)this.fDelegate).flushCache(context);
        }
    }

    protected boolean isExpressionGroup(String expr) {
        if (expr.matches(".*[;].*")) {
            return true;
        }
        return this.isGlobExpression(expr);
    }

    protected boolean isGlobExpression(String expr) {
        if ((expr = expr.trim()).equals("*") || expr.equals("$*")) {
            return true;
        }
        return expr.startsWith(GLOB_EXPRESSION_PREFIX);
    }

    protected boolean isRegisterPattern(String expr) {
        return (expr = expr.trim()).startsWith(REGISTER_PREFIX);
    }

    protected boolean isArrayPattern(String expr) {
        int openBracketIndex = (expr = expr.trim()).indexOf(91);
        if (openBracketIndex < 1) {
            return false;
        }
        if (!expr.endsWith("]")) {
            return false;
        }
        try {
            Pattern pattern = Pattern.compile(ARRAY_INDEX_RANGE_REGEXP, 2);
            Matcher matcher = pattern.matcher(expr.substring(openBracketIndex + 1, expr.length() - 1));
            return matcher.find();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected List<String> splitExpressionsInGroup(IExpressions.IExpressionGroupDMContext groupDmc) {
        String[] splitExpressions = groupDmc.getExpression().split(EXPRESSION_GROUP_SEPARATORS_REGEXP);
        ArrayList<String> expressions = new ArrayList<String>(splitExpressions.length);
        String[] stringArray = splitExpressions;
        int n = splitExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            String expr = stringArray[n2];
            if (!(expr = expr.trim()).isEmpty()) {
                expressions.add(expr);
            }
            ++n2;
        }
        return expressions;
    }

    protected void matchExpressionGroup(IExpressions.IExpressionGroupDMContext exprGroupDmc, int startIndex, int length, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        ArrayList<String> exprList = new ArrayList<String>(this.splitExpressionsInGroup(exprGroupDmc));
        final ArrayList<IExpressions.IExpressionDMContext> subExprList = new ArrayList<IExpressions.IExpressionDMContext>();
        final int startIndex1 = startIndex < 0 ? 0 : startIndex;
        final int length1 = length < 0 ? Integer.MAX_VALUE : length;
        this.matchExpressionList(exprList, subExprList, (IDMContext)exprGroupDmc, (RequestMonitor)new ImmediateRequestMonitor((RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0);
            }

            protected void handleSuccess() {
                LinkedHashSet uniqueSubExprSet = new LinkedHashSet(subExprList);
                subExprList.clear();
                subExprList.addAll(uniqueSubExprSet);
                int endIndex = Math.min(startIndex1 + length1, subExprList.size());
                List subExprRangeList = subExprList.subList(startIndex1, endIndex);
                IExpressions.IExpressionDMContext[] subExprRange = subExprRangeList.toArray(new IExpressions.IExpressionDMContext[subExprRangeList.size()]);
                this.val$rm.done((Object)subExprRange);
            }
        });
    }

    private void matchExpressionList(final List<String> exprList, final List<IExpressions.IExpressionDMContext> subExprList, final IDMContext parentDmc, final RequestMonitor rm) {
        if (exprList.isEmpty()) {
            rm.done();
            return;
        }
        String expr = exprList.remove(0);
        IExpressions.IExpressionDMContext exprDmc = this.createExpression(parentDmc, expr);
        if (exprDmc instanceof IExpressions.IExpressionGroupDMContext) {
            this.matchGlobExpression((IExpressions.IExpressionGroupDMContext)exprDmc, (DataRequestMonitor<List<IExpressions.IExpressionDMContext>>)new ImmediateDataRequestMonitor<List<IExpressions.IExpressionDMContext>>(rm){

                protected void handleSuccess() {
                    List matches = (List)this.getData();
                    Collections.sort(matches, new Comparator<IExpressions.IExpressionDMContext>(){

                        @Override
                        public int compare(IExpressions.IExpressionDMContext o1, IExpressions.IExpressionDMContext o2) {
                            if (GDBPatternMatchingExpressions.this.isArrayPattern(o1.getExpression()) && GDBPatternMatchingExpressions.this.isArrayPattern(o2.getExpression())) {
                                String[] arrayExprParts1 = o1.getExpression().split("[\\[\\]]");
                                if (!($assertionsDisabled || arrayExprParts1 != null && arrayExprParts1.length == 2)) {
                                    throw new AssertionError();
                                }
                                String[] arrayExprParts2 = o2.getExpression().split("[\\[\\]]");
                                if (!($assertionsDisabled || arrayExprParts2 != null && arrayExprParts2.length == 2)) {
                                    throw new AssertionError();
                                }
                                if (arrayExprParts1[0].compareTo(arrayExprParts2[0]) == 0) {
                                    int arrayIndex2;
                                    int arrayIndex1;
                                    block8: {
                                        try {
                                            arrayIndex1 = Integer.parseInt(arrayExprParts1[1]);
                                            arrayIndex2 = Integer.parseInt(arrayExprParts2[1]);
                                            if (arrayIndex1 != arrayIndex2) break block8;
                                            return 0;
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    if (arrayIndex1 > arrayIndex2) {
                                        return 1;
                                    }
                                    return -1;
                                }
                            }
                            return o1.getExpression().compareTo(o2.getExpression());
                        }
                    });
                    subExprList.addAll(matches);
                    GDBPatternMatchingExpressions.this.matchExpressionList(exprList, subExprList, parentDmc, rm);
                }
            });
        } else {
            subExprList.add(exprDmc);
            this.matchExpressionList(exprList, subExprList, parentDmc, rm);
        }
    }

    protected void matchGlobExpression(final IExpressions.IExpressionGroupDMContext exprDmc, final DataRequestMonitor<List<IExpressions.IExpressionDMContext>> rm) {
        String fullExpr = exprDmc.getExpression().trim();
        if (fullExpr.startsWith(GLOB_EXPRESSION_PREFIX)) {
            fullExpr = fullExpr.substring(1).trim();
        }
        if (this.isRegisterPattern(fullExpr)) {
            this.matchRegisters(exprDmc, rm);
        } else if (!this.isArrayPattern(fullExpr)) {
            this.matchLocals(exprDmc, rm);
        } else {
            this.matchArrays(exprDmc, (DataRequestMonitor<List<IExpressions.IExpressionDMContext>>)new ImmediateDataRequestMonitor<List<IExpressions.IExpressionDMContext>>(rm){

                protected void handleSuccess() {
                    final List exprList = this.getData() != null ? (List)this.getData() : new ArrayList();
                    GDBPatternMatchingExpressions.this.matchLocals(exprDmc, (DataRequestMonitor<List<IExpressions.IExpressionDMContext>>)new ImmediateDataRequestMonitor<List<IExpressions.IExpressionDMContext>>((RequestMonitor)rm){

                        protected void handleSuccess() {
                            if (this.getData() != null) {
                                exprList.addAll((Collection)this.getData());
                            }
                            rm.done((Object)exprList);
                        }
                    });
                }
            });
        }
    }

    protected void matchRegisters(final IExpressions.IExpressionGroupDMContext globDmc, final DataRequestMonitor<List<IExpressions.IExpressionDMContext>> rm) {
        final IRegisters registerService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        if (registerService == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Register service unavailable", null));
            return;
        }
        registerService.getRegisterGroups((IDMContext)globDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>(rm){

            protected void handleSuccess() {
                registerService.getRegisters((IDMContext)new CompositeDMContext(new IDMContext[]{((IRegisters.IRegisterGroupDMContext[])this.getData())[0], globDmc}), (DataRequestMonitor)new ImmediateDataRequestMonitor<IRegisters.IRegisterDMContext[]>((RequestMonitor)rm){

                    protected void handleSuccess() {
                        if (!$assertionsDisabled && !(this.getData() instanceof MIRegisters.MIRegisterDMC[])) {
                            throw new AssertionError();
                        }
                        ArrayList<IExpressions.IExpressionDMContext> matches = new ArrayList<IExpressions.IExpressionDMContext>();
                        String fullExpr = globDmc.getExpression().trim();
                        if (fullExpr.startsWith(GDBPatternMatchingExpressions.GLOB_EXPRESSION_PREFIX)) {
                            fullExpr = fullExpr.substring(1).trim();
                        }
                        MIRegisters.MIRegisterDMC[] mIRegisterDMCArray = (MIRegisters.MIRegisterDMC[])this.getData();
                        int n = mIRegisterDMCArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MIRegisters.MIRegisterDMC register = mIRegisterDMCArray[n2];
                            String potentialMatch = GDBPatternMatchingExpressions.REGISTER_PREFIX + register.getName();
                            if (GDBPatternMatchingExpressions.this.globMatches(fullExpr, potentialMatch)) {
                                matches.add(GDBPatternMatchingExpressions.this.createExpression((IDMContext)globDmc, potentialMatch));
                            }
                            ++n2;
                        }
                        rm.done(matches);
                    }
                });
            }
        });
    }

    protected void matchLocals(final IExpressions.IExpressionGroupDMContext globDmc, final DataRequestMonitor<List<IExpressions.IExpressionDMContext>> rm) {
        final IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Stack service unavailable", null));
            return;
        }
        IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)globDmc, IStack.IFrameDMContext.class);
        if (frameCtx == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Stack frame unavailable", null));
            return;
        }
        stackService.getLocals(frameCtx, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IVariableDMContext[]>(rm){

            protected void handleSuccess() {
                IStack.IVariableDMContext[] localsDMCs = (IStack.IVariableDMContext[])this.getData();
                final IStack.IVariableDMData[] localsDMData = new IStack.IVariableDMData[localsDMCs.length];
                final CountingRequestMonitor varNameCRM = new CountingRequestMonitor((Executor)GDBPatternMatchingExpressions.this.getExecutor(), (RequestMonitor)rm){

                    public void handleSuccess() {
                        ArrayList<IExpressions.IExpressionDMContext> matches = new ArrayList<IExpressions.IExpressionDMContext>(localsDMData.length);
                        String fullExpr = globDmc.getExpression().trim();
                        if (fullExpr.startsWith(GDBPatternMatchingExpressions.GLOB_EXPRESSION_PREFIX)) {
                            fullExpr = fullExpr.substring(1).trim();
                        }
                        IStack.IVariableDMData[] iVariableDMDataArray = localsDMData;
                        int n = localsDMData.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStack.IVariableDMData localDMData = iVariableDMDataArray[n2];
                            String potentialMatch = localDMData.getName();
                            if (GDBPatternMatchingExpressions.this.globMatches(fullExpr, potentialMatch)) {
                                matches.add(GDBPatternMatchingExpressions.this.createExpression((IDMContext)globDmc, potentialMatch));
                            }
                            ++n2;
                        }
                        rm.done(matches);
                    }
                };
                int count = 0;
                int index = 0;
                while (index < localsDMCs.length) {
                    final int finalIndex = index++;
                    stackService.getVariableData(localsDMCs[finalIndex], (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IVariableDMData>((RequestMonitor)varNameCRM){

                        public void handleSuccess() {
                            localsDMData[finalIndex] = (IStack.IVariableDMData)this.getData();
                            varNameCRM.done();
                        }
                    });
                    ++count;
                }
                varNameCRM.setDoneCount(count);
            }
        });
    }

    protected void matchArrays(final IExpressions.IExpressionGroupDMContext globDmc, final DataRequestMonitor<List<IExpressions.IExpressionDMContext>> rm) {
        final IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Stack service unavailable", null));
            return;
        }
        IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)globDmc, IStack.IFrameDMContext.class);
        if (frameCtx == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Stack frame unavailable", null));
            return;
        }
        String fullExpr = globDmc.getExpression().trim();
        if (fullExpr.startsWith(GLOB_EXPRESSION_PREFIX)) {
            fullExpr = fullExpr.substring(1).trim();
        }
        String[] arrayExprParts = fullExpr.split("[\\[\\]]");
        assert (arrayExprParts != null && arrayExprParts.length == 2);
        if (arrayExprParts == null || arrayExprParts.length < 2) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Error parsing array expression", null));
            return;
        }
        final String arrayName = arrayExprParts[0].trim();
        final String arrayIndexSpec = arrayExprParts[1].trim();
        stackService.getLocals(frameCtx, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IVariableDMContext[]>(rm){

            protected void handleSuccess() {
                IStack.IVariableDMContext[] localsDMCs = (IStack.IVariableDMContext[])this.getData();
                final IStack.IVariableDMData[] localsDMData = new IStack.IVariableDMData[localsDMCs.length];
                final CountingRequestMonitor varNameCRM = new CountingRequestMonitor((Executor)GDBPatternMatchingExpressions.this.getExecutor(), (RequestMonitor)rm){

                    public void handleSuccess() {
                        final ArrayList matches = new ArrayList();
                        final CountingRequestMonitor elementMatchesCRM = new CountingRequestMonitor((Executor)GDBPatternMatchingExpressions.this.getExecutor(), (RequestMonitor)rm){

                            public void handleSuccess() {
                                rm.done((Object)matches);
                            }
                        };
                        int count = 0;
                        IStack.IVariableDMData[] iVariableDMDataArray = localsDMData;
                        int n = localsDMData.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStack.IVariableDMData localDMData = iVariableDMDataArray[n2];
                            String potentialMatch = localDMData.getName();
                            if (GDBPatternMatchingExpressions.this.globMatches(arrayName, potentialMatch)) {
                                GDBPatternMatchingExpressions.this.createPotentialArrayMatches(GDBPatternMatchingExpressions.this.createExpression((IDMContext)globDmc, potentialMatch), arrayIndexSpec, (DataRequestMonitor<List<IExpressions.IExpressionDMContext>>)new ImmediateDataRequestMonitor<List<IExpressions.IExpressionDMContext>>((RequestMonitor)elementMatchesCRM){

                                    protected void handleSuccess() {
                                        if (this.getData() != null) {
                                            matches.addAll((Collection)this.getData());
                                        }
                                        elementMatchesCRM.done();
                                    }
                                });
                                ++count;
                            }
                            ++n2;
                        }
                        elementMatchesCRM.setDoneCount(count);
                    }
                };
                int count = 0;
                int index = 0;
                while (index < localsDMCs.length) {
                    final int finalIndex = index++;
                    stackService.getVariableData(localsDMCs[finalIndex], (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IVariableDMData>((RequestMonitor)varNameCRM){

                        public void handleSuccess() {
                            localsDMData[finalIndex] = (IStack.IVariableDMData)this.getData();
                            varNameCRM.done();
                        }
                    });
                    ++count;
                }
                varNameCRM.setDoneCount(count);
            }
        });
    }

    protected void createPotentialArrayMatches(final IExpressions.IExpressionDMContext exprDmc, final String indexSpec, final DataRequestMonitor<List<IExpressions.IExpressionDMContext>> rm) {
        this.getExpressionData(exprDmc, (DataRequestMonitor<IExpressions.IExpressionDMData>)new ImmediateDataRequestMonitor<IExpressions.IExpressionDMData>(rm){

            protected void handleCompleted() {
                List<IExpressions.IExpressionDMContext> indicesDmcs;
                boolean isArray = this.isSuccess() && ((IExpressions.IExpressionDMData)this.getData()).getBasicType().equals((Object)IExpressions.IExpressionDMData.BasicType.array);
                ArrayList<IExpressions.IExpressionDMContext> elements = new ArrayList<IExpressions.IExpressionDMContext>();
                if (isArray && (indicesDmcs = GDBPatternMatchingExpressions.this.createArrayIndicesExpression(exprDmc, indexSpec)) != null) {
                    elements.addAll(indicesDmcs);
                }
                rm.done(elements);
            }
        });
    }

    protected List<IExpressions.IExpressionDMContext> createArrayIndicesExpression(IExpressions.IExpressionDMContext arrayDmc, String indexSpec) {
        String[] ranges;
        ArrayList<IExpressions.IExpressionDMContext> expressionDMCs = new ArrayList<IExpressions.IExpressionDMContext>();
        String arrayName = arrayDmc.getExpression();
        IDMContext parentDmc = arrayDmc.getParents()[0];
        String[] stringArray = ranges = indexSpec.split(",");
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String range;
                block5: {
                    range = stringArray[n2];
                    String[] rangeNumbers = (range = range.trim()).split("-");
                    if (rangeNumbers.length == 2) {
                        try {
                            int lowIndex = Integer.parseInt(rangeNumbers[0]);
                            int highIndex = Integer.parseInt(rangeNumbers[1]);
                            if (lowIndex > highIndex) break block5;
                            int i = lowIndex;
                            while (i <= highIndex) {
                                expressionDMCs.add(this.createExpression(parentDmc, String.valueOf(arrayName) + "[" + i + "]"));
                                ++i;
                            }
                            break block6;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                expressionDMCs.add(this.createExpression(parentDmc, String.valueOf(arrayName) + "[" + range + "]"));
            }
            ++n2;
        }
        return expressionDMCs;
    }

    protected boolean globMatches(String globPattern, String potentialMatch) {
        boolean inBrackets = false;
        char[] patternArray = globPattern.toCharArray();
        char[] resultArray = new char[patternArray.length * 2 + 2];
        int pos = 0;
        resultArray[pos++] = 94;
        int i = 0;
        while (i < patternArray.length) {
            switch (patternArray[i]) {
                case '?': {
                    if (inBrackets) {
                        resultArray[pos++] = 63;
                        break;
                    }
                    resultArray[pos++] = 46;
                    break;
                }
                case '*': {
                    if (!inBrackets) {
                        resultArray[pos++] = 46;
                    }
                    resultArray[pos++] = 42;
                    break;
                }
                case '-': {
                    if (!inBrackets) {
                        resultArray[pos++] = 92;
                    }
                    resultArray[pos++] = 45;
                    break;
                }
                case '[': {
                    inBrackets = true;
                    resultArray[pos++] = 91;
                    if (i >= patternArray.length - 1) break;
                    switch (patternArray[i + 1]) {
                        case '!': 
                        case '^': {
                            resultArray[pos++] = 94;
                            ++i;
                            break;
                        }
                        case ']': {
                            resultArray[pos++] = 93;
                            ++i;
                        }
                    }
                    break;
                }
                case ']': {
                    resultArray[pos++] = 93;
                    inBrackets = false;
                    break;
                }
                case '\\': {
                    if (i == 0 && patternArray.length > 1 && patternArray[1] == '~') {
                        resultArray[pos++] = 126;
                        ++i;
                        break;
                    }
                    resultArray[pos++] = 92;
                    if (i < patternArray.length - 1 && "*?[]".indexOf(patternArray[i + 1]) != -1) {
                        resultArray[pos++] = patternArray[++i];
                        break;
                    }
                    resultArray[pos++] = 92;
                    break;
                }
                default: {
                    if (!Character.isLetterOrDigit(patternArray[i])) {
                        resultArray[pos++] = 92;
                    }
                    resultArray[pos++] = patternArray[i];
                }
            }
            ++i;
        }
        resultArray[pos++] = 36;
        try {
            Pattern pattern = Pattern.compile(new String(resultArray, 0, pos), 2);
            Matcher matcher = pattern.matcher(potentialMatch);
            return matcher.find();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static class ExpressionGroupDMC
    implements IExpressions.IExpressionGroupDMContext {
        private IExpressions.IExpressionDMContext fExprDelegate;

        public ExpressionGroupDMC(IExpressions.IExpressionDMContext exprDmc) {
            this.fExprDelegate = exprDmc;
        }

        protected IExpressions.IExpressionDMContext getExprDelegate() {
            return this.fExprDelegate;
        }

        public String getExpression() {
            return this.fExprDelegate.getExpression();
        }

        public String getSessionId() {
            return this.fExprDelegate.getSessionId();
        }

        public IDMContext[] getParents() {
            return this.fExprDelegate.getParents();
        }

        public Object getAdapter(Class adapterType) {
            return this.fExprDelegate.getAdapter(adapterType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExpressionGroupDMC)) {
                return false;
            }
            return ((ExpressionGroupDMC)obj).fExprDelegate.equals(this.fExprDelegate);
        }

        public int hashCode() {
            return this.fExprDelegate.hashCode();
        }

        public String toString() {
            return "Group: " + this.getExprDelegate().toString();
        }
    }

    protected static class ExpressionGroupDMData
    implements IExpressions3.IExpressionDMDataExtension {
        private final String fRelativeExpression;
        private final int fNumChildren;

        public ExpressionGroupDMData(String expr, int numChildren) {
            assert (expr != null);
            this.fRelativeExpression = expr;
            this.fNumChildren = numChildren;
        }

        public String getName() {
            return this.fRelativeExpression;
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            return IExpressions.IExpressionDMData.BasicType.array;
        }

        public String getTypeName() {
            return Messages.GroupPattern;
        }

        public String getEncoding() {
            return null;
        }

        public String getTypeId() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return new HashMap<String, Integer>();
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public boolean hasChildren() {
            return this.fNumChildren > 0;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpressionGroupDMData)) {
                return false;
            }
            return this.fRelativeExpression.equals(((ExpressionGroupDMData)other).fRelativeExpression);
        }

        public int hashCode() {
            return this.fRelativeExpression.hashCode();
        }

        public String toString() {
            return "ExprGroup: " + this.fRelativeExpression;
        }
    }
}

