/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.editor.IViewerColumnsManager;
import com.nvidia.viper.editor.SourceSassColumnControl;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.editor.ViewerControl;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.SourceSassModel;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectSourceLevelAnalysisAction
extends Action
implements IMenuCreator {
    private SourceSassEditor editor;
    private Menu menu;
    public static String ID = "com.nvidia.viper.showsourcelevelanalysis";

    public SelectSourceLevelAnalysisAction() {
        super("Source level analysis", 4);
        this.setText("View");
        this.setToolTipText("Select source level analysis");
        this.setId(ID);
        this.setMenuCreator(this);
    }

    public void run() {
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu(parent);
            this.fillMenu();
        }
        return this.menu;
    }

    public void setEditor(SourceSassEditor editor) {
        if (this.editor != editor) {
            this.editor = editor;
            if (this.menu != null && !this.menu.isDisposed()) {
                MenuItem[] menuItemArray = this.menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                this.fillMenu();
            }
        }
    }

    private void fillMenu() {
        final SourceSassModel sourceSassModel = this.editor.getSourceSassModel();
        final List<AnalysisResultSourceLevelKind> sourceLevelResultsKind = AnalysisResultSourceLevelKind.getResultsMenu(sourceSassModel.getAnalysisResultSourceLevel().getKernel().getMajorComputeCapability());
        for (final AnalysisResultSourceLevelKind sourceLevelResultKind : sourceLevelResultsKind) {
            IViewerColumnsManager columnsManager;
            final MenuItem item = new MenuItem(this.menu, 32);
            item.setText(sourceLevelResultKind.getViewLabel());
            item.setEnabled(sourceSassModel.existsSourceLevelResult(sourceLevelResultKind));
            if (item.getText().equals(AnalysisResultSourceLevelKind.GENERAL_PURPOSE_REGISTER_KIND.getViewLabel())) {
                item.setEnabled(true);
            }
            if ((columnsManager = sourceLevelResultKind.getColumnsManager(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL)).isVisible(this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getColumnControl()) && item.isEnabled()) {
                item.setSelection(true);
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SelectSourceLevelAnalysisAction.this.enableColumns(sourceLevelResultKind, item.getSelection());
                    SelectSourceLevelAnalysisAction.this.adjustLayout();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        sourceSassModel.addPropertyChangeListener(new ISessionPropertyChangeListener(){

            @Override
            public void propertyChange(IModel model, String propertyName) {
                if (propertyName.equals("sourcesassmodel:analysischanged")) {
                    AnalysisResultSourceLevelKind current = sourceSassModel.getAnalysisResultSourceLevel().getAnalysisResultSourceLevelKind();
                    int index = 0;
                    for (AnalysisResultSourceLevelKind sourceLevelResultKind : sourceLevelResultsKind) {
                        MenuItem item = SelectSourceLevelAnalysisAction.this.menu.getItem(index++);
                        if (sourceLevelResultKind.equals((Object)current)) {
                            item.setEnabled(true);
                            item.setSelection(true);
                            SelectSourceLevelAnalysisAction.this.enableColumns(sourceLevelResultKind, true);
                            continue;
                        }
                        AnalysisStage analysisStage = sourceLevelResultKind.getAnalysisStage();
                        if (analysisStage == null || !analysisStage.equals((Object)current.getAnalysisStage())) continue;
                        item.setEnabled(true);
                    }
                    SelectSourceLevelAnalysisAction.this.adjustLayout();
                }
            }
        });
    }

    private void enableColumns(AnalysisResultSourceLevelKind sourceLevelResultKind, boolean isSelected) {
        ViewerControl viewerControl = this.editor.getViewerControl(ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
        if (viewerControl != null) {
            SourceSassColumnControl cudaColumnControl = viewerControl.getColumnControl();
            IViewerColumnsManager cudaColumnsManager = sourceLevelResultKind.getColumnsManager(ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
            if (cudaColumnsManager != null) {
                cudaColumnsManager.setEnableColumns(cudaColumnControl, isSelected);
            }
        }
        SourceSassColumnControl sassColumnControl = this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getColumnControl();
        IViewerColumnsManager sassColumnsManager = sourceLevelResultKind.getColumnsManager(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
        sassColumnsManager.setEnableColumns(sassColumnControl, isSelected);
    }

    private void adjustLayout() {
        ViewerControl viewerControl = this.editor.getViewerControl(ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
        if (viewerControl != null) {
            viewerControl.getColumnControl().getLayout();
        }
        this.editor.getViewerControl(ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL).getColumnControl().getLayout();
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

