/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.language.settings.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.internal.core.WeakHashSet;
import org.eclipse.cdt.internal.core.WeakHashSetSynchronized;

public class LanguageSettingsStorage
implements Cloneable {
    protected Map<String, Map<String, List<ICLanguageSettingEntry>>> fStorage = new HashMap<String, Map<String, List<ICLanguageSettingEntry>>>();
    private static WeakHashSet<List<ICLanguageSettingEntry>> listPool = new WeakHashSetSynchronized<List<ICLanguageSettingEntry>>();

    public List<ICLanguageSettingEntry> getSettingEntries(String rcProjectPath, String languageId) {
        List<ICLanguageSettingEntry> entries = null;
        Map<String, List<ICLanguageSettingEntry>> langMap = this.fStorage.get(languageId);
        if (langMap != null) {
            entries = langMap.get(rcProjectPath);
        }
        return entries;
    }

    private List<ICLanguageSettingEntry> sortEntries(List<? extends ICLanguageSettingEntry> entries) {
        ArrayList<ICLanguageSettingEntry> sortedEntries = new ArrayList<ICLanguageSettingEntry>(entries);
        Collections.sort(sortedEntries, new Comparator<ICLanguageSettingEntry>(){

            @Override
            public int compare(ICLanguageSettingEntry entry0, ICLanguageSettingEntry entry1) {
                int kind0 = entry0.getKind();
                int kind1 = entry1.getKind();
                if (kind0 == 4 && kind1 == 4) {
                    return entry0.getName().compareTo(entry1.getName());
                }
                return kind0 - kind1;
            }
        });
        return sortedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettingEntries(String rcProjectPath, String languageId, List<? extends ICLanguageSettingEntry> entries) {
        Map<String, Map<String, List<ICLanguageSettingEntry>>> map = this.fStorage;
        synchronized (map) {
            if (entries != null) {
                Map<String, List<ICLanguageSettingEntry>> langMap = this.fStorage.get(languageId);
                if (langMap == null) {
                    langMap = new HashMap<String, List<ICLanguageSettingEntry>>();
                    this.fStorage.put(languageId, langMap);
                }
                List<ICLanguageSettingEntry> sortedEntries = LanguageSettingsStorage.getPooledList(this.sortEntries(entries), false);
                langMap.put(rcProjectPath, sortedEntries);
            } else {
                Map<String, List<ICLanguageSettingEntry>> langMap = this.fStorage.get(languageId);
                if (langMap != null) {
                    langMap.remove(rcProjectPath);
                    if (langMap.isEmpty()) {
                        this.fStorage.remove(languageId);
                    }
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.fStorage.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Map<String, List<ICLanguageSettingEntry>>> map = this.fStorage;
        synchronized (map) {
            this.fStorage.clear();
        }
    }

    public Set<String> getLanguages() {
        return new HashSet<String>(this.fStorage.keySet());
    }

    public Set<String> getResourcePaths(String languageId) {
        Map<String, List<ICLanguageSettingEntry>> rcPathsMap = this.fStorage.get(languageId);
        if (rcPathsMap == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(rcPathsMap.keySet());
    }

    private static List<ICLanguageSettingEntry> getPooledList(List<ICLanguageSettingEntry> entries, boolean copy) {
        if (entries == null) {
            return null;
        }
        List<ICLanguageSettingEntry> pooledList = listPool.get(entries);
        if (pooledList != null) {
            return pooledList;
        }
        if (entries.size() == 0) {
            return LanguageSettingsStorage.getPooledEmptyList();
        }
        if (copy) {
            entries = new ArrayList<ICLanguageSettingEntry>(entries);
        }
        pooledList = Collections.unmodifiableList(entries);
        return listPool.add(pooledList);
    }

    public static List<ICLanguageSettingEntry> getPooledList(List<ICLanguageSettingEntry> entries) {
        return LanguageSettingsStorage.getPooledList(entries, true);
    }

    public static List<ICLanguageSettingEntry> getPooledEmptyList() {
        List pooledEmptyList = Collections.emptyList();
        return listPool.add(pooledEmptyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguageSettingsStorage clone() throws CloneNotSupportedException {
        LanguageSettingsStorage storageClone = (LanguageSettingsStorage)super.clone();
        storageClone.fStorage = new HashMap<String, Map<String, List<ICLanguageSettingEntry>>>();
        Map<String, Map<String, List<ICLanguageSettingEntry>>> map = this.fStorage;
        synchronized (map) {
            Set<Map.Entry<String, Map<String, List<ICLanguageSettingEntry>>>> entrySetLang = this.fStorage.entrySet();
            for (Map.Entry<String, Map<String, List<ICLanguageSettingEntry>>> entryLang : entrySetLang) {
                String langId = entryLang.getKey();
                Map<String, List<ICLanguageSettingEntry>> mapRc = entryLang.getValue();
                HashMap<String, List<ICLanguageSettingEntry>> mapRcClone = new HashMap<String, List<ICLanguageSettingEntry>>();
                Set<Map.Entry<String, List<ICLanguageSettingEntry>>> entrySetRc = mapRc.entrySet();
                for (Map.Entry<String, List<ICLanguageSettingEntry>> entryRc : entrySetRc) {
                    String rcProjectPath = entryRc.getKey();
                    List<ICLanguageSettingEntry> lsEntries = entryRc.getValue();
                    mapRcClone.put(rcProjectPath, lsEntries);
                }
                storageClone.fStorage.put(langId, mapRcClone);
            }
        }
        return storageClone;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fStorage == null ? 0 : this.fStorage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageSettingsStorage other = (LanguageSettingsStorage)obj;
        return !(this.fStorage == null ? other.fStorage != null : !this.fStorage.equals(other.fStorage));
    }
}

