/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMNodeList
implements NodeList {
    private List<Node> sequence;

    public DOMNodeList(List<Node> extent) {
        this.sequence = extent;
    }

    public static DOMNodeList checkAndMake(SequenceExtent extent) throws XPathException {
        Item next;
        SequenceIterator it = extent.iterate();
        ArrayList<Node> list = new ArrayList<Node>(extent.getLength());
        while ((next = it.next()) != null) {
            Object o = next;
            if (!(o instanceof NodeInfo)) {
                throw new XPathException("Supplied sequence contains an item that is not a Saxon NodeInfo");
            }
            if (!(o instanceof VirtualNode)) continue;
            if (!((o = ((VirtualNode)o).getRealNode()) instanceof Node)) {
                throw new XPathException("Supplied sequence contains an item that is not a wrapper around a DOM Node");
            }
            list.add((Node)o);
        }
        return new DOMNodeList(list);
    }

    @Override
    public int getLength() {
        return this.sequence.size();
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index >= this.sequence.size()) {
            return null;
        }
        return this.sequence.get(index);
    }
}

