'\" t
.\"
.\" Copyright 1984 - 1991, 1993, 1994, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH XWAYLAND 1 @xorgversion@
.SH NAME
Xwayland \- an X server for running X clients under Wayland.
.SH SYNOPSIS
.B Xwayland
[option ...]
.SH DESCRIPTION
.I Xwayland
is an X server and a Wayland client. It plays the role of a proxy between
legacy X clients which do not support the Wayland protocols and the Wayland
server.
.PP
Usually, \fIXwayland\fP is spawned automatically by the Wayland server
and runs rootless so that X clients integrate seamlessly with the rest
of the Wayland desktop. It is however possible for a user to launch Xwayland
non-rootless, mainly for testing purposes.
.PP
Like all of the X servers, \fIXwayland\fP accepts the command line options
described in the \fIXserver\fP(@miscmansuffix@) manual page.
The following additional arguments are supported as well.
.TP 8
.B \-eglstream
Use EGLStream backend for NVidia GPUs. If \fIXwayland\fP was compiled with
EGLStream support, this option will instruct \fIXwayland\fP to try that
backend first, then fallback to the GBM backend if EGLStream is not supported
by the Wayland server. Without this option, \fIXwayland\fP tries the GBM
backend first, and fallback to EGLStream if GBM is not usable.
.TP 8
.B \-initfd \fIfd\fP
Add the given \fIfd\fP as a listen socket for initialization of X clients.
This options is aimed at \fIWayland\fP servers which run \fIXwayland\fP
on-demand, to be able to spawn specific X clients which need to complete
before other regular X clients can connect to \fIXwayland\fP, like \fIxrdb\fP.
.TP 8
.B \-listen \fIfd\fP
deprecated, use \fI\-listenfd\fP instead.
.TP 8
.B \-listenfd \fIfd\\fP
Add given fd as a listen socket. This option is used by the \fIWayland\fP
server to pass \fIXwayland\fP the socket where X clients connect.
.TP 8
.B \-noTouchPointerEmulation
Disable touch pointer emulation. This allows the Wayland compositor to
implement its own pointer emulation mechanism for X11 clients that don't
support touch input.
.TP 8
.B \-rootless
Run \fIXwayland\fP rootless, so that X clients integrate seamlessly with
Wayland clients in a Wayland desktop. That requires the Wayland server
to be an X window manager as well.
.TP 8
.BI \-shm
Force the shared memory backend instead of glamor (if available) for passing
buffers to the Wayland server.
.TP 8
.BR \-verbose " [\fIn\fP]"
Sets the verbosity level for information printed on stderr.  If the
.I n
value isn't supplied, each occurrence of this option increments the
verbosity level.  When the
.I n
value is supplied, the verbosity level is set to that value.  The default
verbosity level is 0.
.TP 8
.BI \-version
Show the server version and exit.
.TP 8
.B \-wm \fIfd\fP
This option is used by the \fIWayland\fP server to pass \fIXwayland\fP
the socket where the X window manager client connects, when \fIXwayland\fP
is running with \fI-rootless\fP.
.SH ENVIRONMENT
.TP 8
.B WAYLAND_DISPLAY
the name of the display of the Wayland server.
.TP 8
.B XWAYLAND_NO_GLAMOR
disable glamor and DRI3 support in \fIXwayland\fP, for testing purposes.
.SH "SEE ALSO"
General information: \fIX\fP(@miscmansuffix@)
