/* SPDX-License-Identifier: BSD-2-Clause */
/*******************************************************************************
 * Copyright 2017-2018, Fraunhofer SIT sponsored by Infineon Technologies AG
 * All rights reserved.
 *******************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "tss2_fapi.h"

#include "test-fapi.h"
#define LOGMODULE test
#define LOGDEFAULT LOGLEVEL_INFO
#include "util/log.h"
#include "util/aux_util.h"

#define EVENT_SIZE 10

typedef struct {
	uint32_t pcr;
    TPML_DIGEST_VALUES digest;
} test_digest;

#ifdef FAPI_TEST_FIRMWARE_PC_CLIENT
test_digest digest_list[38] = {
      { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x1d, 0x8d, 0x53, 0x2d, 0x46, 0x3c, 0x9f, 0x8c, 0x20, 0x5d,
                        0x0d, 0xf7, 0x78, 0x76, 0x69, 0xa8, 0x5f, 0x93, 0xe2, 0x60
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x97, 0x2d, 0x62, 0xff, 0x5b, 0x3a, 0x74, 0xe8, 0x99, 0x52,
                        0xe0, 0x98, 0x0b, 0x20, 0x99, 0xee, 0xd4, 0x9b, 0xf8, 0xf0
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xc7, 0x6e, 0xe5, 0x4d, 0x77, 0x35, 0x2b, 0xee, 0x74, 0x5c,
                        0xe4, 0x38, 0x29, 0x24, 0x7f, 0xf1, 0x70, 0x68, 0x86, 0xdf
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xef, 0x88, 0x5d, 0xd4, 0x11, 0x40, 0xc5, 0xfb, 0x99, 0x31,
                        0x88, 0xf6, 0x0a, 0x29, 0x8c, 0x5a, 0x9b, 0x31, 0xd0, 0x38
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xa8, 0xfe, 0x19, 0xf5, 0xa9, 0x77, 0x3e, 0xde, 0xbf, 0x7b,
                        0x7d, 0xf9, 0x0b, 0xf9, 0xce, 0x38, 0xb0, 0x71, 0xe6, 0x84
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x08, 0x01, 0xda, 0xa9, 0x4a, 0x2c, 0x43, 0xf4, 0x12, 0x00,
                        0x14, 0x3b, 0x31, 0x9f, 0x19, 0xb2, 0x8b, 0x43, 0xf7, 0x45
                    }}}}}},

    { .pcr = 0,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x06, 0x66, 0x5d, 0x6d, 0x68, 0x5d, 0x3c, 0x08, 0x46, 0x71,
                        0x1a, 0x01, 0x44, 0x10, 0x77, 0x32, 0xa2, 0x86, 0xbf, 0xb2
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xb0, 0xca, 0x06, 0xc5, 0x3a, 0xff, 0x7d, 0x0f, 0xc0, 0x6b,
                      0x11, 0xfb, 0xa6, 0xfe, 0x07, 0x6f, 0x2f, 0x13, 0x87, 0x54,
                      0x4e, 0x86, 0xc8, 0x76, 0xd5, 0xbc, 0x27, 0x75, 0xf5, 0x6b,
                      0x56, 0x4f
                  }}},
        }}},

    { .pcr = 0,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xc4, 0x2f, 0xed, 0xad, 0x26, 0x82, 0x00, 0xcb, 0x1d, 0x15,
                        0xf9, 0x78, 0x41, 0xc3, 0x44, 0xe7, 0x9d, 0xae, 0x33, 0x20
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xd4, 0x72, 0x0b, 0x40, 0x09, 0x43, 0x82, 0x13, 0xb8, 0x03,
                      0x56, 0x80, 0x17, 0xf9, 0x03, 0x09, 0x3f, 0x6b, 0xea, 0x8a,
                      0xb4, 0x7d, 0x28, 0x3d, 0xb3, 0x2b, 0x6e, 0xab, 0xed, 0xbb,
                      0xf1, 0x55
                  }}},
        }}},

    { .pcr = 0,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x3f, 0x1f, 0xcf, 0xee, 0x86, 0x5e, 0x30, 0xbb, 0xfe, 0x11,
                        0x39, 0x05, 0x4e, 0x28, 0x20, 0x2c, 0x1e, 0x96, 0x41, 0x47
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xa4, 0x30, 0x91, 0xb0, 0x25, 0x3f, 0xef, 0x6b, 0x59, 0x61,
                      0x11, 0xa8, 0x04, 0xac, 0x9c, 0x69, 0xd9, 0x94, 0xa1, 0xfb,
                      0x21, 0x27, 0x88, 0xa4, 0x4c, 0x86, 0xff, 0x87, 0xb6, 0x04,
                      0x82, 0xdc
                  }}},
        }}},

    { .pcr = 6,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x9b, 0x3e, 0x57, 0x10, 0xc6, 0x12, 0x7b, 0x0c, 0xe7, 0x3a,
                        0xa8, 0x26, 0x0e, 0xa9, 0x07, 0xf7, 0xf2, 0x18, 0xe6, 0x8f
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x42, 0xe1, 0x4d, 0xc4, 0x86, 0x9c, 0x7a, 0x57, 0x64, 0x6d,
                      0xc2, 0xc9, 0x73, 0x5e, 0x34, 0xc0, 0x4a, 0xe3, 0x64, 0x90,
                      0x6d, 0x77, 0x34, 0x55, 0xfc, 0xb6, 0x69, 0xd6, 0x24, 0x34,
                      0x50, 0x29
                  }}},
        }}},

    { .pcr = 6,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xde, 0x26, 0xb0, 0x84, 0x4f, 0x74, 0x94, 0xea, 0xb8, 0x82,
                        0x19, 0xf7, 0xb6, 0x27, 0xe1, 0xd8, 0xa5, 0x99, 0xb0, 0x2c
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xf7, 0x32, 0x5f, 0xa7, 0x6f, 0xf3, 0x8c, 0x4e, 0xd2, 0x3b,
                      0xe2, 0xe9, 0x2c, 0x77, 0x08, 0x8d, 0xaf, 0xd4, 0x25, 0x52,
                      0xa5, 0x0b, 0xb9, 0x06, 0xfa, 0x79, 0x99, 0x7a, 0x11, 0x44,
                      0x29, 0xa4
                  }}},
        }}},

    { .pcr = 6,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xba, 0xc9, 0xa8, 0x93, 0x5b, 0x72, 0x07, 0x60, 0xbc, 0xde,
                        0xa2, 0xfa, 0xae, 0x75, 0x15, 0x2f, 0x5d, 0x1e, 0x4b, 0xea
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xd1, 0x8b, 0xf8, 0xd2, 0x21, 0xa3, 0xa3, 0xb0, 0x87, 0x74,
                      0xc8, 0xd0, 0x77, 0x32, 0x8c, 0x4b, 0x2c, 0xa2, 0x05, 0xe4,
                      0xf1, 0x61, 0x8a, 0xd4, 0xba, 0xc2, 0xb5, 0x78, 0x6f, 0x45,
                      0x3b, 0xc7
                  }}},
        }}},

    { .pcr = 7,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x2f, 0x20, 0x11, 0x2a, 0x3f, 0x55, 0x39, 0x8b, 0x20, 0x8e,
                        0x0c, 0x42, 0x68, 0x13, 0x89, 0xb4, 0xcb, 0x5b, 0x18, 0x23
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xce, 0x9c, 0xe3, 0x86, 0xb5, 0x2e, 0x09, 0x9f, 0x30, 0x19,
                      0xe5, 0x12, 0xa0, 0xd6, 0x06, 0x2d, 0x6b, 0x56, 0x0e, 0xfe,
                      0x4f, 0xf3, 0xe5, 0x66, 0x1c, 0x75, 0x25, 0xe2, 0xf9, 0xc2,
                      0x63, 0xdf
                  }}},
        }}},

    { .pcr = 7,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xd6, 0xde, 0x6e, 0xf4, 0x5e, 0x09, 0x85, 0xb3, 0xc5, 0x8f,
                        0x13, 0xd5, 0xd5, 0xd2, 0xc4, 0xf9, 0xfb, 0x59, 0x01, 0xf3
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x2a, 0xbf, 0xe9, 0x86, 0x5a, 0x65, 0x41, 0x02, 0xac, 0xb1,
                      0x2f, 0x0f, 0xef, 0xe5, 0x2d, 0xc4, 0xd0, 0x1b, 0xce, 0x40,
                      0x90, 0x14, 0x10, 0xeb, 0x3d, 0xad, 0xaf, 0x21, 0x27, 0x00,
                      0xa2, 0xb7
                  }}},
        }}},

    { .pcr = 7,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xb5, 0x55, 0xa7, 0x90, 0x9e, 0xf7, 0xc3, 0xae, 0x2e, 0xca,
                        0x5f, 0xca, 0x5f, 0x81, 0x39, 0xa9, 0xf6, 0x63, 0x3f, 0xf4
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x63, 0xa5, 0x25, 0x13, 0x4b, 0xfb, 0xc2, 0x42, 0x05, 0x8c,
                      0x0e, 0x6b, 0x42, 0x79, 0x4f, 0x8b, 0x1d, 0x14, 0x2d, 0x13,
                      0x02, 0x9a, 0x9a, 0xa3, 0x8a, 0x32, 0x72, 0xc5, 0xca, 0x23,
                      0x90, 0xc5
                  }}},
        }}},

    { .pcr = 7,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xd1, 0x62, 0x55, 0xd2, 0xac, 0xbe, 0x03, 0x83, 0x44, 0x59,
                        0xaa, 0xff, 0x12, 0xc3, 0x85, 0x88, 0x92, 0x1c, 0x61, 0x75
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xad, 0x18, 0x50, 0xa4, 0x88, 0x56, 0x28, 0xd8, 0x62, 0x73,
                      0xba, 0xd7, 0x43, 0x77, 0x9c, 0x9e, 0x66, 0x5d, 0xb0, 0x60,
                      0x23, 0x62, 0x70, 0xb5, 0xd2, 0x4d, 0xd9, 0x8f, 0x3a, 0x22,
                      0xfe, 0x86
                  }}},
        }}},

    { .pcr = 7,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x9e, 0xb4, 0x1d, 0xa1, 0x43, 0xcd, 0x35, 0x2e, 0xcf, 0x41,
                        0xae, 0x6f, 0xa4, 0x90, 0xfb, 0x3f, 0xd5, 0x98, 0x55, 0x4d
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xf0, 0xbf, 0x49, 0xc6, 0xa2, 0xd3, 0xe1, 0x70, 0x07, 0x7f,
                      0x1f, 0x66, 0x87, 0x5d, 0x6c, 0xb9, 0xb2, 0xaa, 0x38, 0x20,
                      0x60, 0xca, 0xc5, 0xc0, 0xb6, 0x45, 0x66, 0x0b, 0xb9, 0x5b,
                      0xc0, 0x58
                  }}},
        }}},

    { .pcr = 7,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x3a, 0xf7, 0x5d, 0xc6, 0xb4, 0xa8, 0x9b, 0x72, 0x66, 0xe1,
                        0x19, 0xf1, 0xe4, 0xa4, 0x30, 0xff, 0x18, 0xa6, 0x5e, 0xed
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x91, 0x43, 0x3c, 0xca, 0xe2, 0x8b, 0x7a, 0xa8, 0xd3, 0xb7,
                      0x4d, 0xef, 0x87, 0x7e, 0x55, 0xdb, 0x95, 0xe6, 0xd0, 0x32,
                      0x5b, 0x82, 0xf3, 0x86, 0x2a, 0xf0, 0xc9, 0x09, 0xf2, 0xf3,
                      0x8b, 0xaa
                  }}},
        }}},

    { .pcr = 0,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 2,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 3,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 4,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 5,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 6,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xdf, 0x3f, 0x61, 0x98, 0x04, 0xa9, 0x2f, 0xdb, 0x40, 0x57,
                      0x19, 0x2d, 0xc4, 0x3d, 0xd7, 0x48, 0xea, 0x77, 0x8a, 0xdc,
                      0x52, 0xbc, 0x49, 0x8c, 0xe8, 0x05, 0x24, 0xc0, 0x14, 0xb8,
                      0x11, 0x19
                  }}},
        }}},

    { .pcr = 5,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x2a, 0x60, 0xc2, 0x5b, 0x92, 0x13, 0xf4, 0xce, 0x0c, 0xcb,
                        0xed, 0x30, 0x53, 0x0a, 0xd3, 0x09, 0xe7, 0x1a, 0x98, 0x7c
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xb3, 0x59, 0xa9, 0x8a, 0xd1, 0x1e, 0x07, 0xf1, 0x3e, 0x23,
                      0x30, 0x96, 0x4f, 0xfd, 0x30, 0x90, 0x0b, 0x29, 0xd3, 0x5a,
                      0x30, 0xc0, 0x5f, 0xb9, 0x2f, 0xc9, 0x9f, 0x62, 0xe8, 0x4b,
                      0x29, 0x4c
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xed, 0xb3, 0x94, 0x43, 0x5d, 0x50, 0xcb, 0x4e, 0x15, 0xec,
                        0xdb, 0x8a, 0x4c, 0xb0, 0x34, 0x17, 0x98, 0xcb, 0x95, 0x1a
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xd7, 0x5b, 0x4b, 0x64, 0xef, 0x27, 0xca, 0x22, 0x84, 0x28,
                      0x52, 0x9d, 0x45, 0xc3, 0x12, 0xf9, 0xfe, 0x72, 0xf6, 0x9e,
                      0x60, 0xf6, 0xbc, 0x7b, 0x68, 0xd4, 0x7e, 0xa5, 0x89, 0xe5,
                      0x3f, 0xd5
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xc5, 0x86, 0xf4, 0xf7, 0x0b, 0x3b, 0x6e, 0xf9, 0xe1, 0xcf,
                        0xb4, 0xe1, 0x95, 0x85, 0xc6, 0x31, 0x84, 0x69, 0xf5, 0x2c
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x55, 0x56, 0x21, 0x90, 0x16, 0x78, 0x28, 0x72, 0x30, 0x79,
                      0x4e, 0x78, 0x4f, 0xb0, 0xd5, 0x1e, 0x62, 0x0e, 0x85, 0x98,
                      0x95, 0xe1, 0x7c, 0x1d, 0x14, 0x58, 0xc4, 0x32, 0x84, 0x2a,
                      0x7a, 0xb3
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xc4, 0x22, 0xcc, 0x3f, 0x0e, 0xc4, 0xf5, 0xf0, 0x08, 0x0f,
                        0x33, 0xa0, 0x71, 0x87, 0x05, 0xb4, 0x03, 0xa1, 0xa7, 0x09
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xe5, 0xb9, 0xfb, 0x62, 0x30, 0x38, 0xb1, 0x13, 0xa4, 0x00,
                      0x8b, 0xc9, 0x98, 0xec, 0xe4, 0x91, 0xf2, 0xc8, 0x4c, 0xf1,
                      0x5e, 0x42, 0x86, 0x88, 0x5a, 0xa2, 0xfc, 0xec, 0xc8, 0xa5,
                      0x3b, 0xc4
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x32, 0x7a, 0x71, 0xe0, 0xa3, 0xa7, 0x1c, 0xd4, 0x8a, 0x91,
                        0x18, 0x0d, 0xb3, 0x38, 0xa6, 0x60, 0x94, 0x87, 0xed, 0x33
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x98, 0x46, 0x26, 0xc6, 0x9f, 0xd3, 0x9b, 0xf4, 0x8b, 0xac,
                      0x77, 0x1e, 0x41, 0xe2, 0x18, 0x58, 0x2b, 0x50, 0xcb, 0xf7,
                      0x4f, 0x26, 0x35, 0x1d, 0x2c, 0x78, 0x90, 0xb6, 0x4f, 0x7f,
                      0xd6, 0x1d
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x04, 0x77, 0xf3, 0xe1, 0x46, 0x44, 0xd0, 0x7f, 0x13, 0x5a,
                        0xce, 0x5d, 0x3b, 0xf7, 0x30, 0x7c, 0x04, 0x36, 0x5a, 0x5d
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xa3, 0x1b, 0xb7, 0x49, 0x51, 0x13, 0xe5, 0x86, 0x8c, 0x1d,
                      0x4c, 0x47, 0xb2, 0x69, 0x59, 0x7a, 0xf3, 0x13, 0x76, 0x90,
                      0xec, 0x4c, 0x82, 0xca, 0xc0, 0x26, 0xe3, 0xa0, 0xd6, 0x6c,
                      0x3a, 0xfc
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xe6, 0x42, 0xd1, 0x6c, 0xfd, 0x0d, 0x02, 0xdb, 0x04, 0x44,
                        0x02, 0x89, 0xf1, 0xa3, 0x9c, 0x7b, 0xf7, 0xdf, 0x89, 0xe6
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xd1, 0x21, 0x90, 0x74, 0x07, 0x3a, 0xf9, 0xd8, 0x1b, 0x5c,
                      0x45, 0x24, 0x95, 0xfb, 0x69, 0x9f, 0x24, 0xd5, 0xd1, 0x5d,
                      0x45, 0xc5, 0xbf, 0x05, 0x9c, 0xda, 0x9f, 0x92, 0xcf, 0x50,
                      0x86, 0x46
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xef, 0x9e, 0x78, 0xf3, 0x48, 0xab, 0x81, 0x3c, 0xd4, 0x1b,
                        0xe6, 0xb2, 0x8e, 0xcf, 0x74, 0xf0, 0x0c, 0x7a, 0xb6, 0x23
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x08, 0x22, 0x71, 0x25, 0x5d, 0xcc, 0xb5, 0xfe, 0x8d, 0x86,
                      0x90, 0x89, 0x78, 0xb9, 0xeb, 0x67, 0x88, 0x1b, 0x49, 0xc7,
                      0xeb, 0x0e, 0x04, 0xfa, 0xf8, 0xbf, 0x23, 0xf3, 0x77, 0xfd,
                      0x0b, 0xf2
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x85, 0xd6, 0x4b, 0x3c, 0x1d, 0x4e, 0xb4, 0x9f, 0x59, 0x11,
                        0x58, 0x58, 0x93, 0x11, 0xf4, 0x26, 0xab, 0x18, 0x6e, 0x83
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0xb7, 0x0b, 0x7c, 0x1b, 0x92, 0x20, 0x9a, 0xf6, 0x6d, 0x79,
                      0xd1, 0x2d, 0xec, 0x1f, 0x14, 0xf4, 0xb8, 0xc7, 0x1c, 0x0c,
                      0x69, 0xbe, 0x22, 0xa1, 0xa0, 0x4f, 0x5c, 0x58, 0x04, 0xe2,
                      0x6e, 0xc3
                  }}},
        }}},

    { .pcr = 1,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x9f, 0xab, 0x6b, 0xeb, 0x96, 0x18, 0x98, 0x64, 0x5e, 0xd1,
                        0x67, 0xec, 0x77, 0xfb, 0xc8, 0x10, 0x16, 0x0f, 0x13, 0x19
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x0a, 0x7a, 0xfb, 0x6f, 0xc2, 0x40, 0x04, 0x8c, 0x2f, 0xde,
                      0x38, 0x0d, 0xf0, 0x13, 0x59, 0x50, 0x28, 0xa0, 0x82, 0x1d,
                      0xae, 0xec, 0x5d, 0x8f, 0xac, 0xf4, 0xce, 0x18, 0x53, 0xdd,
                      0xba, 0x64
                  }}},
        }}},

    { .pcr = 4,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x21, 0xe7, 0x94, 0x38, 0x58, 0x0e, 0xc8, 0x9d, 0xf6, 0x74,
                        0xdf, 0xe1, 0x26, 0x53, 0xd7, 0x7d, 0x13, 0x2c, 0x39, 0x36
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x2e, 0xa4, 0xcb, 0x6a, 0x1f, 0x1e, 0xb1, 0xd3, 0xdc, 0xe8,
                      0x2d, 0x54, 0xfd, 0xe2, 0x6d, 0xed, 0x24, 0x3b, 0xa3, 0xe1,
                      0x8d, 0xe7, 0xc6, 0xd2, 0x11, 0x90, 0x2a, 0x59, 0x4f, 0xe5,
                      0x67, 0x88
                  }}},
        }}},

    { .pcr = 4,
      .digest =
      { .count = 2,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x4a, 0x54, 0xaf, 0xf5, 0x98, 0x3b, 0xa3, 0x49, 0xfe, 0x3d,
                        0x18, 0x78, 0x1c, 0xed, 0x45, 0x9c, 0xce, 0x23, 0x07, 0x77
                    }}},
          { .hashAlg = TPM2_ALG_SHA256,
            .digest = {
                  .sha256 = {
                      0x09, 0xac, 0x5e, 0x2c, 0x25, 0xc7, 0xa9, 0x4a, 0x3b, 0xb0,
                      0x8d, 0x7f, 0xff, 0x61, 0x9d, 0x7e, 0x79, 0xfc, 0x06, 0xa0,
                      0xcb, 0xc3, 0x51, 0x14, 0xa2, 0x27, 0x8c, 0x9b, 0x5b, 0x3c,
                      0x51, 0xec
                  }}},
        }}},
};
#endif
#ifdef FAPI_TEST_FIRMWARE_NUC /* Test the NUC firmware */
test_digest digest_list[23] = {
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x1d, 0x8d, 0x53, 0x2d, 0x46, 0x3c, 0x9f, 0x8c, 0x20, 0x5d,
                        0x0d, 0xf7, 0x78, 0x76, 0x69, 0xa8, 0x5f, 0x93, 0xe2, 0x60
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x97, 0x2d, 0x62, 0xff, 0x5b, 0x3a, 0x74, 0xe8, 0x99, 0x52,
                        0xe0, 0x98, 0x0b, 0x20, 0x99, 0xee, 0xd4, 0x9b, 0xf8, 0xf0
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xc7, 0x6e, 0xe5, 0x4d, 0x77, 0x35, 0x2b, 0xee, 0x74, 0x5c,
                        0xe4, 0x38, 0x29, 0x24, 0x7f, 0xf1, 0x70, 0x68, 0x86, 0xdf
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xef, 0x88, 0x5d, 0xd4, 0x11, 0x40, 0xc5, 0xfb, 0x99, 0x31,
                        0x88, 0xf6, 0x0a, 0x29, 0x8c, 0x5a, 0x9b, 0x31, 0xd0, 0x38
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xa8, 0xfe, 0x19, 0xf5, 0xa9, 0x77, 0x3e, 0xde, 0xbf, 0x7b,
                        0x7d, 0xf9, 0x0b, 0xf9, 0xce, 0x38, 0xb0, 0x71, 0xe6, 0x84
                    }}}}}},
    { .pcr = 10,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x08, 0x01, 0xda, 0xa9, 0x4a, 0x2c, 0x43, 0xf4, 0x12, 0x00,
                        0x14, 0x3b, 0x31, 0x9f, 0x19, 0xb2, 0x8b, 0x43, 0xf7, 0x45
                    }}}}}},
    { .pcr = 0,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xc4, 0x2f, 0xed, 0xad, 0x26, 0x82, 0x00, 0xcb, 0x1d, 0x15,
                        0xf9, 0x78, 0x41, 0xc3, 0x44, 0xe7, 0x9d, 0xae, 0x33, 0x20
                    }}}}}},
    { .pcr = 7,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x2f, 0x20, 0x11, 0x2a, 0x3f, 0x55, 0x39, 0x8b, 0x20, 0x8e,
                        0x0c, 0x42, 0x68, 0x13, 0x89, 0xb4, 0xcb, 0x5b, 0x18, 0x23
                    }}}}}},
    { .pcr = 7,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x9b, 0x13, 0x87, 0x30, 0x6e, 0xbb, 0x7f, 0xf8, 0xe7, 0x95,
                        0xe7, 0xbe, 0x77, 0x56, 0x36, 0x66, 0xbb, 0xf4, 0x51, 0x6e
                    }}}}}},
    { .pcr = 7,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x13, 0xf0, 0x2f, 0xbc, 0x73, 0x83, 0xed, 0x7c, 0x89, 0x01,
                        0x7e, 0x0b, 0x32, 0xf6, 0x0e, 0x38, 0xe2, 0x82, 0x05, 0x6c
                    }}}}}},
    { .pcr = 7,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xa2, 0x33, 0xad, 0xbc, 0x63, 0xe3, 0xfd, 0xc5, 0xf7, 0x36,
                        0x93, 0xa3, 0xcc, 0x4a, 0x27, 0x04, 0x17, 0x14, 0x38, 0x3f
                    }}}}}},
    { .pcr = 7,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x67, 0xe4, 0x8e, 0x75, 0x99, 0x54, 0x34, 0x95, 0x37, 0xed,
                        0x49, 0x02, 0xba, 0x1a, 0x8e, 0xef, 0x74, 0xdb, 0xd1, 0xb5
                    }}}}}},
    { .pcr = 0,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 1,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 2,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 3,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 4,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 5,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 6,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 7,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x90, 0x69, 0xca, 0x78, 0xe7, 0x45, 0x0a, 0x28, 0x51, 0x73,
                        0x43, 0x1b, 0x3e, 0x52, 0xc5, 0xc2, 0x52, 0x99, 0xe4, 0x73
                    }}}}}},
    { .pcr = 5,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xf8, 0x83, 0x0f, 0x40, 0xb1, 0x40, 0x64, 0xe7, 0xcc, 0x4e,
                        0x80, 0x08, 0x98, 0xaf, 0xb9, 0x46, 0xad, 0x86, 0x5e, 0xdd
                    }}}}}},
    { .pcr = 4,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0xd0, 0xe6, 0xf9, 0x39, 0xf1, 0x30, 0x4a, 0x83, 0x97, 0x5f,
                        0x34, 0xff, 0x67, 0x8d, 0xa5, 0x73, 0xae, 0x2b, 0x3e, 0xe5
                    }}}}}},
    { .pcr = 4,
      .digest =
      { .count = 1,
        .digests =
        { { .hashAlg = TPM2_ALG_SHA1,
            .digest = {
                    .sha1 = {
                        0x5b, 0x13, 0x53, 0x51, 0xac, 0x81, 0xe9, 0x3f, 0x17, 0xc4,
                        0x3e, 0xc6, 0x5e, 0xc0, 0xe4, 0x75, 0x5e, 0xc2, 0x9e, 0x45
                    }}}}}},
};
#endif


/** Test the FAPI functions for quote commands.
 *
 * Tested FAPI commands:
 *  - Fapi_Provision()
 *  - Fapi_CreateKey()
 *  - Fapi_PcrExtend()
 *  - Fapi_Quote()
 *  - Fapi_VerifyQuote()
 *  - Fapi_List()
 *  - Fapi_Delete()
 *
 * @param[in,out] context The FAPI_CONTEXT.
 * @retval EXIT_FAILURE
 * @retval EXIT_SUCCESS
 */
int
test_fapi_quote_destructive(FAPI_CONTEXT *context)
{
    TSS2_RC r;
    char *pubkey_pem = NULL;
    uint8_t *signature = NULL;
    char *quoteInfo = NULL;
    char *pcrEventLog = NULL;
    char *pcrEventLog2 = NULL;
    char *certificate = NULL;
    char *export_data = NULL;
    uint8_t *pcr_digest = NULL;
    char *log = NULL;
    char *pathlist = NULL;
    size_t i;
    json_object *jso_log = NULL;
    json_object *jso_log2 = NULL;
    bool sha1_bank_exists;

    uint8_t data[EVENT_SIZE] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    size_t signatureSize = 0;
    uint32_t pcrList[13] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 14, 16 };

    #ifdef WORDS_BIGENDIAN
    return EXIT_SKIP;
    #endif

    r = pcr_bank_sha1_exists(context, &sha1_bank_exists);
    goto_if_error(r, "Test sha1 bank", error);

    if (!sha1_bank_exists) {
        return EXIT_SKIP;
    }

    r = Fapi_Provision(context, NULL, NULL, NULL);

    goto_if_error(r, "Error Fapi_Provision", error);

 #ifndef  FAPI_TEST_FIRMWARE_NULL
    for (i = 0; i < sizeof(digest_list) / sizeof(test_digest); i++) {
        pcr_extend(context, digest_list[i].pcr, &digest_list[i].digest);
    }
#endif

    r = Fapi_CreateKey(context, "HS/SRK/mySignKey", "sign,noDa", "", NULL);
    goto_if_error(r, "Error Fapi_CreateKey", error);

    r = Fapi_SetCertificate(context, "HS/SRK/mySignKey", "-----BEGIN "  \
        "CERTIFICATE-----[...]-----END CERTIFICATE-----");
    goto_if_error(r, "Error Fapi_SetCertificate", error);

    uint8_t qualifyingData[20] = {
        0x67, 0x68, 0x03, 0x3e, 0x21, 0x64, 0x68, 0x24, 0x7b, 0xd0,
        0x31, 0xa0, 0xa2, 0xd9, 0x87, 0x6d, 0x79, 0x81, 0x8f, 0x8f
    };

    r = pcr_reset(context, 16);
    goto_if_error(r, "Error pcr_reset", error);

    r = Fapi_PcrExtend(context, 16, data, EVENT_SIZE, "{ \"test\": \"myfile\" }");
    goto_if_error(r, "Error Fapi_PcrExtend", error);

    r = Fapi_PcrExtend(context, 16, data, EVENT_SIZE, "{ \"test\": \"myfile\" }");
    goto_if_error(r, "Error Fapi_PcrExtend", error);

    r = Fapi_PcrExtend(context, 11, data, EVENT_SIZE, "{ \"test\": \"myfile\" }");
    goto_if_error(r, "Error Fapi_PcrExtend", error);

    r = Fapi_Quote(context, pcrList, 12, "HS/SRK/mySignKey",
                   "TPM-Quote",
                   qualifyingData, 20,
                   &quoteInfo,
                   &signature, &signatureSize,
                   &pcrEventLog, &certificate);
    goto_if_error(r, "Error Fapi_Quote", error);
    ASSERT(quoteInfo != NULL);
    ASSERT(signature != NULL);
    ASSERT(pcrEventLog != NULL);
    ASSERT(certificate != NULL);
    ASSERT(strlen(quoteInfo) > ASSERT_SIZE);
    ASSERT(strlen(pcrEventLog) > ASSERT_SIZE);
    ASSERT(strlen(certificate) > ASSERT_SIZE);

    LOG_INFO("\nquoteInfo: %s\n", quoteInfo);

    LOG_INFO("\npcrEventLog: %s\n", pcrEventLog);

    r = Fapi_VerifyQuote(context, "HS/SRK/mySignKey",
                         qualifyingData, 20,  quoteInfo,
                         signature, signatureSize, pcrEventLog);
    goto_if_error(r, "Error Fapi_Verfiy_Quote", error);

    jso_log = json_tokener_parse(pcrEventLog);
    goto_if_null(jso_log, "Parsing eventlog failed", TSS2_FAPI_RC_MEMORY, error);

    json_object *jso_event, *jso_duplicate;
    size_t n_events = json_object_array_length(jso_log);

    jso_log2 = json_object_new_array();
    goto_if_null(jso_log2, "Out of memory.", TSS2_FAPI_RC_MEMORY, error);

    /* Remove last element of log to check if verification fails. */
    for (i = 0; i < n_events - 1; i++) {
        jso_event = json_object_array_get_idx(jso_log, i);
        jso_duplicate = json_object_get(jso_event);
        goto_if_null(jso_duplicate, "Out of memory.", TSS2_FAPI_RC_MEMORY, error);

        if (json_object_array_add(jso_log2, jso_duplicate)) {
            return_error(TSS2_FAPI_RC_GENERAL_FAILURE, "Could not add json object.");
        }
    }

    pcrEventLog2 = strdup(json_object_to_json_string_ext(jso_log2, JSON_C_TO_STRING_PRETTY));
    goto_if_null(pcrEventLog2, "Out of memory.", TSS2_FAPI_RC_MEMORY, error);

    LOG_WARNING("*** TEST ERROR CASE WITH INVALID EVENT LIST ***");

    r = Fapi_VerifyQuote(context, "HS/SRK/mySignKey",
                         qualifyingData, 20,  quoteInfo,
                         signature, signatureSize, pcrEventLog2);

    if (r != TSS2_FAPI_RC_SIGNATURE_VERIFICATION_FAILED) {
        LOG_ERROR("Quote verification should fail.");
        goto error;
    }

    r = Fapi_List(context, "/", &pathlist);
    goto_if_error(r, "Pathlist", error);
    ASSERT(pathlist != NULL);
    ASSERT(strlen(pathlist) > ASSERT_SIZE);

    r = Fapi_Delete(context, "/");
    goto_if_error(r, "Error Fapi_Delete", error);

    SAFE_FREE(pubkey_pem);
    SAFE_FREE(signature);
    SAFE_FREE(quoteInfo);
    SAFE_FREE(pcrEventLog);
    SAFE_FREE(certificate);
    SAFE_FREE(export_data);
    SAFE_FREE(pcr_digest);
    SAFE_FREE(log);
    SAFE_FREE(pathlist);
    json_object_put(jso_log);
    json_object_put(jso_log2);
    SAFE_FREE(pcrEventLog2);
    return EXIT_SUCCESS;

error:
    Fapi_Delete(context, "/");
    SAFE_FREE(pubkey_pem);
    SAFE_FREE(signature);
    SAFE_FREE(quoteInfo);
    SAFE_FREE(pcrEventLog);
    SAFE_FREE(certificate);
    SAFE_FREE(export_data);
    SAFE_FREE(pcr_digest);
    SAFE_FREE(log);
    SAFE_FREE(pathlist);
    SAFE_FREE(pcrEventLog2);
    if (jso_log)
        json_object_put(jso_log);
    if (jso_log2)
        json_object_put(jso_log2);
    return EXIT_FAILURE;
}

int
test_invoke_fapi(FAPI_CONTEXT *fapi_context)
{
    return test_fapi_quote_destructive(fapi_context);
}
