#! /bin/sh
# Make an NBI hard disk image using MTOOLS & DOS files
# Requires a bootsector from your target OS in file 'bootsect.bin'
# Make this once from a bootable floppy with the command:
#   dd if=/dev/fd0 of=bootsect.bin bs=512 count=1
mv ~/.mtoolsrc ~/.mtoolsrc.tmp
echo drive x: file=\"$1.img\" > ~/.mtoolsrc
# comment out the line below if image is a VFAT aware OS (Win9X+)
echo 'mtools_no_vfat=1' >> ~/.mtoolsrc
rm -f $1.img
# Capacity in bytes = (cyls)*(heads)*(sectors_per_track)*512
# example for a 10MB disk (10485760 = 320 * 8 * 8 * 512)
mformat -C -t 320 -h 4 -n 16 -B bootsect.bin x:
mcopy io.sys x:
mcopy msdos.sys x:
mcopy command.com x:
# additional files below this line
# additional files above this line
mknbi-dos --harddisk $1.img > $1.nbi
rm $1.img
rm -f ~/.mtoolsrc
mv ~./mtoolsrc.tmp ~/.mtoolsrc
