# -*- tab-width: 4; indent-tabs-mode: nil; py-indent-offset: 4 -*-
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

from uitest.framework import UITestCase
from uitest.uihelper.common import type_text

class insertEndnote(UITestCase):

   def test_insert_endnote(self):
        with self.ui_test.create_doc_in_start_center("writer") as document:
            xWriterDoc = self.xUITest.getTopFocusWindow()
            xWriterEdit = xWriterDoc.getChild("writer_edit")

            self.xUITest.executeCommand(".uno:InsertEndnote")

            type_text(xWriterEdit, "LibreOffice")

            self.assertEqual(document.Endnotes[0].String, "LibreOffice")
            self.assertEqual(document.Endnotes.getCount(), 1)
            self.xUITest.executeCommand(".uno:Undo")
            self.assertEqual(document.Endnotes[0].String, "")
            self.xUITest.executeCommand(".uno:Undo")
            self.assertEqual(document.Endnotes.getCount(), 0)
            self.xUITest.executeCommand(".uno:Redo")
            self.assertEqual(document.Endnotes[0].String, "")
            self.assertEqual(document.Endnotes.getCount(), 1)
            self.xUITest.executeCommand(".uno:Redo")
            self.assertEqual(document.Endnotes[0].String, "LibreOffice")

# vim: set shiftwidth=4 softtabstop=4 expandtab:
