; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=sparc64 -sparc-bpcc-offset-bits=4 | FileCheck --check-prefix=SPARC64 %s

define i32 @branch_relax_int(i32 %in) {
; SPARC64-LABEL: branch_relax_int:
; SPARC64:         .cfi_startproc
; SPARC64-NEXT:  ! %bb.0:
; SPARC64-NEXT:    save %sp, -128, %sp
; SPARC64-NEXT:    .cfi_def_cfa_register %fp
; SPARC64-NEXT:    .cfi_window_save
; SPARC64-NEXT:    .cfi_register %o7, %i7
; SPARC64-NEXT:    cmp %i0, 0
; SPARC64-NEXT:    bne %icc, .LBB0_1
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    ba .LBB0_2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:  .LBB0_1: ! %false
; SPARC64-NEXT:    !APP
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    !NO_APP
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore %g0, %g0, %o0
; SPARC64-NEXT:  .LBB0_2: ! %true
; SPARC64-NEXT:    mov 4, %i0
; SPARC64-NEXT:    !APP
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    !NO_APP
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %tst = icmp eq i32 %in, 0
  br i1 %tst, label %true, label %false

true:
  call void asm sideeffect "nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop", ""()
  ret i32 4

false:
  call void asm sideeffect "nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop", ""()
  ret i32 0
}

define float @branch_relax_float(float %in) {
; SPARC64-LABEL: branch_relax_float:
; SPARC64:         .cfi_startproc
; SPARC64-NEXT:  ! %bb.0:
; SPARC64-NEXT:    save %sp, -128, %sp
; SPARC64-NEXT:    .cfi_def_cfa_register %fp
; SPARC64-NEXT:    .cfi_window_save
; SPARC64-NEXT:    .cfi_register %o7, %i7
; SPARC64-NEXT:    sethi %h44(.LCPI1_0), %i0
; SPARC64-NEXT:    add %i0, %m44(.LCPI1_0), %i0
; SPARC64-NEXT:    sllx %i0, 12, %i0
; SPARC64-NEXT:    ld [%i0+%l44(.LCPI1_0)], %f0
; SPARC64-NEXT:    fcmps %fcc0, %f1, %f0
; SPARC64-NEXT:    fbe %fcc0, .LBB1_1
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    ba .LBB1_2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:  .LBB1_1: ! %true
; SPARC64-NEXT:    sethi %h44(.LCPI1_1), %i0
; SPARC64-NEXT:    add %i0, %m44(.LCPI1_1), %i0
; SPARC64-NEXT:    sllx %i0, 12, %i0
; SPARC64-NEXT:    ld [%i0+%l44(.LCPI1_1)], %f0
; SPARC64-NEXT:    !APP
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    !NO_APP
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
; SPARC64-NEXT:  .LBB1_2: ! %false
; SPARC64-NEXT:    !APP
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    !NO_APP
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %tst = fcmp oeq float %in, 0.0
  br i1 %tst, label %true, label %false

true:
  call void asm sideeffect "nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop", ""()
  ret float 4.0

false:
  call void asm sideeffect "nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop\0A\09nop", ""()
  ret float 0.0
}
