; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-apple-darwin | FileCheck %s

; Check that the legalizer doesn't crash when scalarizing FP conversion
; instructions' operands.  The operands are all illegal on AArch64,
; ensuring they are legalized.  The results are all legal.

define <1 x double> @test_sitofp(<1 x i1> %in) #0 {
; CHECK-LABEL: test_sitofp:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    sbfx w8, w0, #0, #1
; CHECK-NEXT:    scvtf d0, w8
; CHECK-NEXT:    ret
entry:
  %0 = call <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i1(<1 x i1> %in, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <1 x double> %0
}

define <1 x double> @test_uitofp(<1 x i1> %in) #0 {
; CHECK-LABEL: test_uitofp:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    and w8, w0, #0x1
; CHECK-NEXT:    ucvtf d0, w8
; CHECK-NEXT:    ret
entry:
  %0 = call <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i1(<1 x i1> %in, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <1 x double> %0
}

attributes #0 = { strictfp }

declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i1(<1 x i1>, metadata, metadata)
declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i1(<1 x i1>, metadata, metadata)
