// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;

namespace Microsoft.AspNetCore.Mvc.Razor.Internal
{
    /// <summary>
    /// Specifies that the attributed property should be bound using request services.
    /// <para>
    /// This attribute is used as the backing attribute for the <c>@inject</c>
    /// Razor directive.
    /// </para>
    /// </summary>
    [AttributeUsage(AttributeTargets.Property, AllowMultiple = false, Inherited = true)]
    public class RazorInjectAttribute : Attribute
    {
    }
}
