// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package flight

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion7

// FlightServiceClient is the client API for FlightService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FlightServiceClient interface {
	//
	// Handshake between client and server. Depending on the server, the
	// handshake may be required to determine the token that should be used for
	// future operations. Both request and response are streams to allow multiple
	// round-trips depending on auth mechanism.
	Handshake(ctx context.Context, opts ...grpc.CallOption) (FlightService_HandshakeClient, error)
	//
	// Get a list of available streams given a particular criteria. Most flight
	// services will expose one or more streams that are readily available for
	// retrieval. This api allows listing the streams available for
	// consumption. A user can also provide a criteria. The criteria can limit
	// the subset of streams that can be listed via this interface. Each flight
	// service allows its own definition of how to consume criteria.
	ListFlights(ctx context.Context, in *Criteria, opts ...grpc.CallOption) (FlightService_ListFlightsClient, error)
	//
	// For a given FlightDescriptor, get information about how the flight can be
	// consumed. This is a useful interface if the consumer of the interface
	// already can identify the specific flight to consume. This interface can
	// also allow a consumer to generate a flight stream through a specified
	// descriptor. For example, a flight descriptor might be something that
	// includes a SQL statement or a Pickled Python operation that will be
	// executed. In those cases, the descriptor will not be previously available
	// within the list of available streams provided by ListFlights but will be
	// available for consumption for the duration defined by the specific flight
	// service.
	GetFlightInfo(ctx context.Context, in *FlightDescriptor, opts ...grpc.CallOption) (*FlightInfo, error)
	//
	// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
	// This is used when a consumer needs the Schema of flight stream. Similar to
	// GetFlightInfo this interface may generate a new flight that was not previously
	// available in ListFlights.
	GetSchema(ctx context.Context, in *FlightDescriptor, opts ...grpc.CallOption) (*SchemaResult, error)
	//
	// Retrieve a single stream associated with a particular descriptor
	// associated with the referenced ticket. A Flight can be composed of one or
	// more streams where each stream can be retrieved using a separate opaque
	// ticket that the flight service uses for managing a collection of streams.
	DoGet(ctx context.Context, in *Ticket, opts ...grpc.CallOption) (FlightService_DoGetClient, error)
	//
	// Push a stream to the flight service associated with a particular
	// flight stream. This allows a client of a flight service to upload a stream
	// of data. Depending on the particular flight service, a client consumer
	// could be allowed to upload a single stream per descriptor or an unlimited
	// number. In the latter, the service might implement a 'seal' action that
	// can be applied to a descriptor once all streams are uploaded.
	DoPut(ctx context.Context, opts ...grpc.CallOption) (FlightService_DoPutClient, error)
	//
	// Open a bidirectional data channel for a given descriptor. This
	// allows clients to send and receive arbitrary Arrow data and
	// application-specific metadata in a single logical stream. In
	// contrast to DoGet/DoPut, this is more suited for clients
	// offloading computation (rather than storage) to a Flight service.
	DoExchange(ctx context.Context, opts ...grpc.CallOption) (FlightService_DoExchangeClient, error)
	//
	// Flight services can support an arbitrary number of simple actions in
	// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
	// operations that are potentially available. DoAction allows a flight client
	// to do a specific action against a flight service. An action includes
	// opaque request and response objects that are specific to the type action
	// being undertaken.
	DoAction(ctx context.Context, in *Action, opts ...grpc.CallOption) (FlightService_DoActionClient, error)
	//
	// A flight service exposes all of the available action types that it has
	// along with descriptions. This allows different flight consumers to
	// understand the capabilities of the flight service.
	ListActions(ctx context.Context, in *Empty, opts ...grpc.CallOption) (FlightService_ListActionsClient, error)
}

type flightServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFlightServiceClient(cc grpc.ClientConnInterface) FlightServiceClient {
	return &flightServiceClient{cc}
}

var flightServiceHandshakeStreamDesc = &grpc.StreamDesc{
	StreamName:    "Handshake",
	ServerStreams: true,
	ClientStreams: true,
}

func (c *flightServiceClient) Handshake(ctx context.Context, opts ...grpc.CallOption) (FlightService_HandshakeClient, error) {
	stream, err := c.cc.NewStream(ctx, flightServiceHandshakeStreamDesc, "/arrow.flight.protocol.FlightService/Handshake", opts...)
	if err != nil {
		return nil, err
	}
	x := &flightServiceHandshakeClient{stream}
	return x, nil
}

type FlightService_HandshakeClient interface {
	Send(*HandshakeRequest) error
	Recv() (*HandshakeResponse, error)
	grpc.ClientStream
}

type flightServiceHandshakeClient struct {
	grpc.ClientStream
}

func (x *flightServiceHandshakeClient) Send(m *HandshakeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *flightServiceHandshakeClient) Recv() (*HandshakeResponse, error) {
	m := new(HandshakeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var flightServiceListFlightsStreamDesc = &grpc.StreamDesc{
	StreamName:    "ListFlights",
	ServerStreams: true,
}

func (c *flightServiceClient) ListFlights(ctx context.Context, in *Criteria, opts ...grpc.CallOption) (FlightService_ListFlightsClient, error) {
	stream, err := c.cc.NewStream(ctx, flightServiceListFlightsStreamDesc, "/arrow.flight.protocol.FlightService/ListFlights", opts...)
	if err != nil {
		return nil, err
	}
	x := &flightServiceListFlightsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FlightService_ListFlightsClient interface {
	Recv() (*FlightInfo, error)
	grpc.ClientStream
}

type flightServiceListFlightsClient struct {
	grpc.ClientStream
}

func (x *flightServiceListFlightsClient) Recv() (*FlightInfo, error) {
	m := new(FlightInfo)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var flightServiceGetFlightInfoStreamDesc = &grpc.StreamDesc{
	StreamName: "GetFlightInfo",
}

func (c *flightServiceClient) GetFlightInfo(ctx context.Context, in *FlightDescriptor, opts ...grpc.CallOption) (*FlightInfo, error) {
	out := new(FlightInfo)
	err := c.cc.Invoke(ctx, "/arrow.flight.protocol.FlightService/GetFlightInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

var flightServiceGetSchemaStreamDesc = &grpc.StreamDesc{
	StreamName: "GetSchema",
}

func (c *flightServiceClient) GetSchema(ctx context.Context, in *FlightDescriptor, opts ...grpc.CallOption) (*SchemaResult, error) {
	out := new(SchemaResult)
	err := c.cc.Invoke(ctx, "/arrow.flight.protocol.FlightService/GetSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

var flightServiceDoGetStreamDesc = &grpc.StreamDesc{
	StreamName:    "DoGet",
	ServerStreams: true,
}

func (c *flightServiceClient) DoGet(ctx context.Context, in *Ticket, opts ...grpc.CallOption) (FlightService_DoGetClient, error) {
	stream, err := c.cc.NewStream(ctx, flightServiceDoGetStreamDesc, "/arrow.flight.protocol.FlightService/DoGet", opts...)
	if err != nil {
		return nil, err
	}
	x := &flightServiceDoGetClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FlightService_DoGetClient interface {
	Recv() (*FlightData, error)
	grpc.ClientStream
}

type flightServiceDoGetClient struct {
	grpc.ClientStream
}

func (x *flightServiceDoGetClient) Recv() (*FlightData, error) {
	m := new(FlightData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var flightServiceDoPutStreamDesc = &grpc.StreamDesc{
	StreamName:    "DoPut",
	ServerStreams: true,
	ClientStreams: true,
}

func (c *flightServiceClient) DoPut(ctx context.Context, opts ...grpc.CallOption) (FlightService_DoPutClient, error) {
	stream, err := c.cc.NewStream(ctx, flightServiceDoPutStreamDesc, "/arrow.flight.protocol.FlightService/DoPut", opts...)
	if err != nil {
		return nil, err
	}
	x := &flightServiceDoPutClient{stream}
	return x, nil
}

type FlightService_DoPutClient interface {
	Send(*FlightData) error
	Recv() (*PutResult, error)
	grpc.ClientStream
}

type flightServiceDoPutClient struct {
	grpc.ClientStream
}

func (x *flightServiceDoPutClient) Send(m *FlightData) error {
	return x.ClientStream.SendMsg(m)
}

func (x *flightServiceDoPutClient) Recv() (*PutResult, error) {
	m := new(PutResult)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var flightServiceDoExchangeStreamDesc = &grpc.StreamDesc{
	StreamName:    "DoExchange",
	ServerStreams: true,
	ClientStreams: true,
}

func (c *flightServiceClient) DoExchange(ctx context.Context, opts ...grpc.CallOption) (FlightService_DoExchangeClient, error) {
	stream, err := c.cc.NewStream(ctx, flightServiceDoExchangeStreamDesc, "/arrow.flight.protocol.FlightService/DoExchange", opts...)
	if err != nil {
		return nil, err
	}
	x := &flightServiceDoExchangeClient{stream}
	return x, nil
}

type FlightService_DoExchangeClient interface {
	Send(*FlightData) error
	Recv() (*FlightData, error)
	grpc.ClientStream
}

type flightServiceDoExchangeClient struct {
	grpc.ClientStream
}

func (x *flightServiceDoExchangeClient) Send(m *FlightData) error {
	return x.ClientStream.SendMsg(m)
}

func (x *flightServiceDoExchangeClient) Recv() (*FlightData, error) {
	m := new(FlightData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var flightServiceDoActionStreamDesc = &grpc.StreamDesc{
	StreamName:    "DoAction",
	ServerStreams: true,
}

func (c *flightServiceClient) DoAction(ctx context.Context, in *Action, opts ...grpc.CallOption) (FlightService_DoActionClient, error) {
	stream, err := c.cc.NewStream(ctx, flightServiceDoActionStreamDesc, "/arrow.flight.protocol.FlightService/DoAction", opts...)
	if err != nil {
		return nil, err
	}
	x := &flightServiceDoActionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FlightService_DoActionClient interface {
	Recv() (*Result, error)
	grpc.ClientStream
}

type flightServiceDoActionClient struct {
	grpc.ClientStream
}

func (x *flightServiceDoActionClient) Recv() (*Result, error) {
	m := new(Result)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var flightServiceListActionsStreamDesc = &grpc.StreamDesc{
	StreamName:    "ListActions",
	ServerStreams: true,
}

func (c *flightServiceClient) ListActions(ctx context.Context, in *Empty, opts ...grpc.CallOption) (FlightService_ListActionsClient, error) {
	stream, err := c.cc.NewStream(ctx, flightServiceListActionsStreamDesc, "/arrow.flight.protocol.FlightService/ListActions", opts...)
	if err != nil {
		return nil, err
	}
	x := &flightServiceListActionsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type FlightService_ListActionsClient interface {
	Recv() (*ActionType, error)
	grpc.ClientStream
}

type flightServiceListActionsClient struct {
	grpc.ClientStream
}

func (x *flightServiceListActionsClient) Recv() (*ActionType, error) {
	m := new(ActionType)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// FlightServiceService is the service API for FlightService service.
// Fields should be assigned to their respective handler implementations only before
// RegisterFlightServiceService is called.  Any unassigned fields will result in the
// handler for that method returning an Unimplemented error.
type FlightServiceService struct {
	//
	// Handshake between client and server. Depending on the server, the
	// handshake may be required to determine the token that should be used for
	// future operations. Both request and response are streams to allow multiple
	// round-trips depending on auth mechanism.
	Handshake func(FlightService_HandshakeServer) error
	//
	// Get a list of available streams given a particular criteria. Most flight
	// services will expose one or more streams that are readily available for
	// retrieval. This api allows listing the streams available for
	// consumption. A user can also provide a criteria. The criteria can limit
	// the subset of streams that can be listed via this interface. Each flight
	// service allows its own definition of how to consume criteria.
	ListFlights func(*Criteria, FlightService_ListFlightsServer) error
	//
	// For a given FlightDescriptor, get information about how the flight can be
	// consumed. This is a useful interface if the consumer of the interface
	// already can identify the specific flight to consume. This interface can
	// also allow a consumer to generate a flight stream through a specified
	// descriptor. For example, a flight descriptor might be something that
	// includes a SQL statement or a Pickled Python operation that will be
	// executed. In those cases, the descriptor will not be previously available
	// within the list of available streams provided by ListFlights but will be
	// available for consumption for the duration defined by the specific flight
	// service.
	GetFlightInfo func(context.Context, *FlightDescriptor) (*FlightInfo, error)
	//
	// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
	// This is used when a consumer needs the Schema of flight stream. Similar to
	// GetFlightInfo this interface may generate a new flight that was not previously
	// available in ListFlights.
	GetSchema func(context.Context, *FlightDescriptor) (*SchemaResult, error)
	//
	// Retrieve a single stream associated with a particular descriptor
	// associated with the referenced ticket. A Flight can be composed of one or
	// more streams where each stream can be retrieved using a separate opaque
	// ticket that the flight service uses for managing a collection of streams.
	DoGet func(*Ticket, FlightService_DoGetServer) error
	//
	// Push a stream to the flight service associated with a particular
	// flight stream. This allows a client of a flight service to upload a stream
	// of data. Depending on the particular flight service, a client consumer
	// could be allowed to upload a single stream per descriptor or an unlimited
	// number. In the latter, the service might implement a 'seal' action that
	// can be applied to a descriptor once all streams are uploaded.
	DoPut func(FlightService_DoPutServer) error
	//
	// Open a bidirectional data channel for a given descriptor. This
	// allows clients to send and receive arbitrary Arrow data and
	// application-specific metadata in a single logical stream. In
	// contrast to DoGet/DoPut, this is more suited for clients
	// offloading computation (rather than storage) to a Flight service.
	DoExchange func(FlightService_DoExchangeServer) error
	//
	// Flight services can support an arbitrary number of simple actions in
	// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
	// operations that are potentially available. DoAction allows a flight client
	// to do a specific action against a flight service. An action includes
	// opaque request and response objects that are specific to the type action
	// being undertaken.
	DoAction func(*Action, FlightService_DoActionServer) error
	//
	// A flight service exposes all of the available action types that it has
	// along with descriptions. This allows different flight consumers to
	// understand the capabilities of the flight service.
	ListActions func(*Empty, FlightService_ListActionsServer) error
}

func (s *FlightServiceService) handshake(_ interface{}, stream grpc.ServerStream) error {
	return s.Handshake(&flightServiceHandshakeServer{stream})
}
func (s *FlightServiceService) listFlights(_ interface{}, stream grpc.ServerStream) error {
	m := new(Criteria)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return s.ListFlights(m, &flightServiceListFlightsServer{stream})
}
func (s *FlightServiceService) getFlightInfo(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FlightDescriptor)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetFlightInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/arrow.flight.protocol.FlightService/GetFlightInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetFlightInfo(ctx, req.(*FlightDescriptor))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *FlightServiceService) getSchema(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FlightDescriptor)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/arrow.flight.protocol.FlightService/GetSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetSchema(ctx, req.(*FlightDescriptor))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *FlightServiceService) doGet(_ interface{}, stream grpc.ServerStream) error {
	m := new(Ticket)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return s.DoGet(m, &flightServiceDoGetServer{stream})
}
func (s *FlightServiceService) doPut(_ interface{}, stream grpc.ServerStream) error {
	return s.DoPut(&flightServiceDoPutServer{stream})
}
func (s *FlightServiceService) doExchange(_ interface{}, stream grpc.ServerStream) error {
	return s.DoExchange(&flightServiceDoExchangeServer{stream})
}
func (s *FlightServiceService) doAction(_ interface{}, stream grpc.ServerStream) error {
	m := new(Action)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return s.DoAction(m, &flightServiceDoActionServer{stream})
}
func (s *FlightServiceService) listActions(_ interface{}, stream grpc.ServerStream) error {
	m := new(Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return s.ListActions(m, &flightServiceListActionsServer{stream})
}

type FlightService_HandshakeServer interface {
	Send(*HandshakeResponse) error
	Recv() (*HandshakeRequest, error)
	grpc.ServerStream
}

type flightServiceHandshakeServer struct {
	grpc.ServerStream
}

func (x *flightServiceHandshakeServer) Send(m *HandshakeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *flightServiceHandshakeServer) Recv() (*HandshakeRequest, error) {
	m := new(HandshakeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

type FlightService_ListFlightsServer interface {
	Send(*FlightInfo) error
	grpc.ServerStream
}

type flightServiceListFlightsServer struct {
	grpc.ServerStream
}

func (x *flightServiceListFlightsServer) Send(m *FlightInfo) error {
	return x.ServerStream.SendMsg(m)
}

type FlightService_DoGetServer interface {
	Send(*FlightData) error
	grpc.ServerStream
}

type flightServiceDoGetServer struct {
	grpc.ServerStream
}

func (x *flightServiceDoGetServer) Send(m *FlightData) error {
	return x.ServerStream.SendMsg(m)
}

type FlightService_DoPutServer interface {
	Send(*PutResult) error
	Recv() (*FlightData, error)
	grpc.ServerStream
}

type flightServiceDoPutServer struct {
	grpc.ServerStream
}

func (x *flightServiceDoPutServer) Send(m *PutResult) error {
	return x.ServerStream.SendMsg(m)
}

func (x *flightServiceDoPutServer) Recv() (*FlightData, error) {
	m := new(FlightData)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

type FlightService_DoExchangeServer interface {
	Send(*FlightData) error
	Recv() (*FlightData, error)
	grpc.ServerStream
}

type flightServiceDoExchangeServer struct {
	grpc.ServerStream
}

func (x *flightServiceDoExchangeServer) Send(m *FlightData) error {
	return x.ServerStream.SendMsg(m)
}

func (x *flightServiceDoExchangeServer) Recv() (*FlightData, error) {
	m := new(FlightData)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

type FlightService_DoActionServer interface {
	Send(*Result) error
	grpc.ServerStream
}

type flightServiceDoActionServer struct {
	grpc.ServerStream
}

func (x *flightServiceDoActionServer) Send(m *Result) error {
	return x.ServerStream.SendMsg(m)
}

type FlightService_ListActionsServer interface {
	Send(*ActionType) error
	grpc.ServerStream
}

type flightServiceListActionsServer struct {
	grpc.ServerStream
}

func (x *flightServiceListActionsServer) Send(m *ActionType) error {
	return x.ServerStream.SendMsg(m)
}

// RegisterFlightServiceService registers a service implementation with a gRPC server.
func RegisterFlightServiceService(s grpc.ServiceRegistrar, srv *FlightServiceService) {
	srvCopy := *srv
	if srvCopy.Handshake == nil {
		srvCopy.Handshake = func(FlightService_HandshakeServer) error {
			return status.Errorf(codes.Unimplemented, "method Handshake not implemented")
		}
	}
	if srvCopy.ListFlights == nil {
		srvCopy.ListFlights = func(*Criteria, FlightService_ListFlightsServer) error {
			return status.Errorf(codes.Unimplemented, "method ListFlights not implemented")
		}
	}
	if srvCopy.GetFlightInfo == nil {
		srvCopy.GetFlightInfo = func(context.Context, *FlightDescriptor) (*FlightInfo, error) {
			return nil, status.Errorf(codes.Unimplemented, "method GetFlightInfo not implemented")
		}
	}
	if srvCopy.GetSchema == nil {
		srvCopy.GetSchema = func(context.Context, *FlightDescriptor) (*SchemaResult, error) {
			return nil, status.Errorf(codes.Unimplemented, "method GetSchema not implemented")
		}
	}
	if srvCopy.DoGet == nil {
		srvCopy.DoGet = func(*Ticket, FlightService_DoGetServer) error {
			return status.Errorf(codes.Unimplemented, "method DoGet not implemented")
		}
	}
	if srvCopy.DoPut == nil {
		srvCopy.DoPut = func(FlightService_DoPutServer) error {
			return status.Errorf(codes.Unimplemented, "method DoPut not implemented")
		}
	}
	if srvCopy.DoExchange == nil {
		srvCopy.DoExchange = func(FlightService_DoExchangeServer) error {
			return status.Errorf(codes.Unimplemented, "method DoExchange not implemented")
		}
	}
	if srvCopy.DoAction == nil {
		srvCopy.DoAction = func(*Action, FlightService_DoActionServer) error {
			return status.Errorf(codes.Unimplemented, "method DoAction not implemented")
		}
	}
	if srvCopy.ListActions == nil {
		srvCopy.ListActions = func(*Empty, FlightService_ListActionsServer) error {
			return status.Errorf(codes.Unimplemented, "method ListActions not implemented")
		}
	}
	sd := grpc.ServiceDesc{
		ServiceName: "arrow.flight.protocol.FlightService",
		Methods: []grpc.MethodDesc{
			{
				MethodName: "GetFlightInfo",
				Handler:    srvCopy.getFlightInfo,
			},
			{
				MethodName: "GetSchema",
				Handler:    srvCopy.getSchema,
			},
		},
		Streams: []grpc.StreamDesc{
			{
				StreamName:    "Handshake",
				Handler:       srvCopy.handshake,
				ServerStreams: true,
				ClientStreams: true,
			},
			{
				StreamName:    "ListFlights",
				Handler:       srvCopy.listFlights,
				ServerStreams: true,
			},
			{
				StreamName:    "DoGet",
				Handler:       srvCopy.doGet,
				ServerStreams: true,
			},
			{
				StreamName:    "DoPut",
				Handler:       srvCopy.doPut,
				ServerStreams: true,
				ClientStreams: true,
			},
			{
				StreamName:    "DoExchange",
				Handler:       srvCopy.doExchange,
				ServerStreams: true,
				ClientStreams: true,
			},
			{
				StreamName:    "DoAction",
				Handler:       srvCopy.doAction,
				ServerStreams: true,
			},
			{
				StreamName:    "ListActions",
				Handler:       srvCopy.listActions,
				ServerStreams: true,
			},
		},
		Metadata: "Flight.proto",
	}

	s.RegisterService(&sd, nil)
}

// NewFlightServiceService creates a new FlightServiceService containing the
// implemented methods of the FlightService service in s.  Any unimplemented
// methods will result in the gRPC server returning an UNIMPLEMENTED status to the client.
// This includes situations where the method handler is misspelled or has the wrong
// signature.  For this reason, this function should be used with great care and
// is not recommended to be used by most users.
func NewFlightServiceService(s interface{}) *FlightServiceService {
	ns := &FlightServiceService{}
	if h, ok := s.(interface {
		Handshake(FlightService_HandshakeServer) error
	}); ok {
		ns.Handshake = h.Handshake
	}
	if h, ok := s.(interface {
		ListFlights(*Criteria, FlightService_ListFlightsServer) error
	}); ok {
		ns.ListFlights = h.ListFlights
	}
	if h, ok := s.(interface {
		GetFlightInfo(context.Context, *FlightDescriptor) (*FlightInfo, error)
	}); ok {
		ns.GetFlightInfo = h.GetFlightInfo
	}
	if h, ok := s.(interface {
		GetSchema(context.Context, *FlightDescriptor) (*SchemaResult, error)
	}); ok {
		ns.GetSchema = h.GetSchema
	}
	if h, ok := s.(interface {
		DoGet(*Ticket, FlightService_DoGetServer) error
	}); ok {
		ns.DoGet = h.DoGet
	}
	if h, ok := s.(interface {
		DoPut(FlightService_DoPutServer) error
	}); ok {
		ns.DoPut = h.DoPut
	}
	if h, ok := s.(interface {
		DoExchange(FlightService_DoExchangeServer) error
	}); ok {
		ns.DoExchange = h.DoExchange
	}
	if h, ok := s.(interface {
		DoAction(*Action, FlightService_DoActionServer) error
	}); ok {
		ns.DoAction = h.DoAction
	}
	if h, ok := s.(interface {
		ListActions(*Empty, FlightService_ListActionsServer) error
	}); ok {
		ns.ListActions = h.ListActions
	}
	return ns
}

// UnstableFlightServiceService is the service API for FlightService service.
// New methods may be added to this interface if they are added to the service
// definition, which is not a backward-compatible change.  For this reason,
// use of this type is not recommended.
type UnstableFlightServiceService interface {
	//
	// Handshake between client and server. Depending on the server, the
	// handshake may be required to determine the token that should be used for
	// future operations. Both request and response are streams to allow multiple
	// round-trips depending on auth mechanism.
	Handshake(FlightService_HandshakeServer) error
	//
	// Get a list of available streams given a particular criteria. Most flight
	// services will expose one or more streams that are readily available for
	// retrieval. This api allows listing the streams available for
	// consumption. A user can also provide a criteria. The criteria can limit
	// the subset of streams that can be listed via this interface. Each flight
	// service allows its own definition of how to consume criteria.
	ListFlights(*Criteria, FlightService_ListFlightsServer) error
	//
	// For a given FlightDescriptor, get information about how the flight can be
	// consumed. This is a useful interface if the consumer of the interface
	// already can identify the specific flight to consume. This interface can
	// also allow a consumer to generate a flight stream through a specified
	// descriptor. For example, a flight descriptor might be something that
	// includes a SQL statement or a Pickled Python operation that will be
	// executed. In those cases, the descriptor will not be previously available
	// within the list of available streams provided by ListFlights but will be
	// available for consumption for the duration defined by the specific flight
	// service.
	GetFlightInfo(context.Context, *FlightDescriptor) (*FlightInfo, error)
	//
	// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
	// This is used when a consumer needs the Schema of flight stream. Similar to
	// GetFlightInfo this interface may generate a new flight that was not previously
	// available in ListFlights.
	GetSchema(context.Context, *FlightDescriptor) (*SchemaResult, error)
	//
	// Retrieve a single stream associated with a particular descriptor
	// associated with the referenced ticket. A Flight can be composed of one or
	// more streams where each stream can be retrieved using a separate opaque
	// ticket that the flight service uses for managing a collection of streams.
	DoGet(*Ticket, FlightService_DoGetServer) error
	//
	// Push a stream to the flight service associated with a particular
	// flight stream. This allows a client of a flight service to upload a stream
	// of data. Depending on the particular flight service, a client consumer
	// could be allowed to upload a single stream per descriptor or an unlimited
	// number. In the latter, the service might implement a 'seal' action that
	// can be applied to a descriptor once all streams are uploaded.
	DoPut(FlightService_DoPutServer) error
	//
	// Open a bidirectional data channel for a given descriptor. This
	// allows clients to send and receive arbitrary Arrow data and
	// application-specific metadata in a single logical stream. In
	// contrast to DoGet/DoPut, this is more suited for clients
	// offloading computation (rather than storage) to a Flight service.
	DoExchange(FlightService_DoExchangeServer) error
	//
	// Flight services can support an arbitrary number of simple actions in
	// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
	// operations that are potentially available. DoAction allows a flight client
	// to do a specific action against a flight service. An action includes
	// opaque request and response objects that are specific to the type action
	// being undertaken.
	DoAction(*Action, FlightService_DoActionServer) error
	//
	// A flight service exposes all of the available action types that it has
	// along with descriptions. This allows different flight consumers to
	// understand the capabilities of the flight service.
	ListActions(*Empty, FlightService_ListActionsServer) error
}
