/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class EMFReader
implements ImageReader {
    protected static final int EMF_SIG_LENGTH = 88;
    private static final int SIGNATURE_OFFSET = 40;
    private static final int WIDTH_OFFSET = 32;
    private static final int HEIGHT_OFFSET = 36;
    private static final int HRES_PIXEL_OFFSET = 72;
    private static final int VRES_PIXEL_OFFSET = 76;
    private static final int HRES_MM_OFFSET = 80;
    private static final int VRES_MM_OFFSET = 84;

    public FopImage.ImageInfo verifySignature(String uri, InputStream bis, FOUserAgent ua) throws IOException {
        boolean supported;
        byte[] header = this.getDefaultHeader(bis);
        boolean bl = supported = header[40] == 32 && header[41] == 69 && header[42] == 77 && header[43] == 70;
        if (supported) {
            FopImage.ImageInfo info = this.getDimension(header);
            info.originalURI = uri;
            info.mimeType = this.getMimeType();
            info.inputStream = bis;
            return info;
        }
        return null;
    }

    public String getMimeType() {
        return "image/emf";
    }

    private FopImage.ImageInfo getDimension(byte[] header) {
        FopImage.ImageInfo info = new FopImage.ImageInfo();
        long value = 0L;
        int byte1 = header[80] & 0xFF;
        int byte2 = header[81] & 0xFF;
        int byte3 = header[82] & 0xFF;
        int byte4 = header[83] & 0xFF;
        long hresMM = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        byte1 = header[84] & 0xFF;
        byte2 = header[85] & 0xFF;
        byte3 = header[86] & 0xFF;
        byte4 = header[87] & 0xFF;
        long vresMM = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        byte1 = header[72] & 0xFF;
        byte2 = header[73] & 0xFF;
        byte3 = header[74] & 0xFF;
        byte4 = header[75] & 0xFF;
        long hresPixel = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        byte1 = header[76] & 0xFF;
        byte2 = header[77] & 0xFF;
        byte3 = header[78] & 0xFF;
        byte4 = header[79] & 0xFF;
        long vresPixel = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        info.dpiHorizontal = (float)hresPixel / ((float)hresMM / 25.4f);
        info.dpiVertical = (float)vresPixel / ((float)vresMM / 25.4f);
        byte1 = header[32] & 0xFF;
        byte2 = header[33] & 0xFF;
        byte3 = header[34] & 0xFF;
        byte4 = header[35] & 0xFF;
        value = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        value = Math.round((double)((float)value / 100.0f / 25.4f) * info.dpiHorizontal);
        info.width = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        byte1 = header[36] & 0xFF;
        byte2 = header[37] & 0xFF;
        byte3 = header[38] & 0xFF;
        byte4 = header[39] & 0xFF;
        value = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        value = Math.round((double)((float)value / 100.0f / 25.4f) * info.dpiVertical);
        info.height = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        return info;
    }

    private byte[] getDefaultHeader(InputStream imageStream) throws IOException {
        byte[] header = new byte[88];
        try {
            imageStream.mark(89);
            imageStream.read(header);
            imageStream.reset();
        }
        catch (IOException ex) {
            try {
                imageStream.reset();
            }
            catch (IOException exbis) {
                // empty catch block
            }
            throw ex;
        }
        return header;
    }
}

