#import <Foundation/Foundation.h>
#import "SevenZipTestCase.h"
#import "SevenZipArchive.h"
#import "FileInfo.h"

@implementation SevenZipTestCase : ArchiveTestCase

- (Archive *)sampleArchive;
{
	NSString *path;
	
    path = [NSBundle pathForResource:@"sample" ofType:@"7z" inDirectory:@"TestResources"];
    [self assertNotNil:path];
    path = [path stringByStandardizingPath];
    return [SevenZipArchive newWithPath:path];
}

- (void)testSortBySize
{
	Archive *archive;
	FileInfo *info;
	
	archive = [self sampleArchive];
	[archive sortBySize];
	info = [archive elementAtIndex:0];
	
	[self assert:[info size] equals:[NSNumber numberWithInt:651]];
	[self assert:[info filename] equals:@"genjunk.txt"];
	
	// sort descending
	[archive sortBySize];
	info = [archive elementAtIndex:0];
	[self assert:[info size] equals:[NSNumber numberWithInt:14533]];
	[self assert:[info filename] equals:@"spam.rc.orig"];
}

@end
