/* fonts/upcean_woff2.h - OCR-B (EAN/UPC subset) as base 64 string of WOFF2, for embedding in SVG */
/*
    libzint - the open source barcode library
    Copyright (C) 2023 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef Z_UPCEAN_WOFF2_H
#define Z_UPCEAN_WOFF2_H

/* Adapted from OCR-B font version 0.2 Matthew Skala
 *   https://tsukurimashou.osdn.jp/ocr.php.en
 *
 * Copyright Matthew Skala (2011); based on code by Norbert Schwarz (1986, 2011)
 *
 * "The version in this package descends from a set of Metafont
 *  definitions by Norbert Schwarz of Ruhr-Universitaet Bochum,
 *  bearing dates ranging from 1986 to 2010. He originally
 *  distributed it under a "non-commercial use only"
 *  restriction but has since released it for unrestricted use
 *  and distribution. See the README file for more details."
 *
 * The README states (http://mirrors.ctan.org/fonts/ocr-b.zip)
 *
 * "As far as the digitization in METAFONT input which I have
 *  developed, you may freely use, modify, and/or distribute any of
 *  these files or the resulting fonts, without limitation.  A previous
 *  release of ocr-b only granted rights for non-commercial use; that
 *  restriction is now lifted."
 */
static const char upcean_woff2[1905] = {
    'd','0','9','G','M','g','A','B','A','A','A','A','A','A','W','U','A','A','4','A','A','A','A','A','C',
    'W','w','A','A','A','V','A','A','A','E','A','A','A','A','A','A','A','A','A','A','A','A','A','A','A',
    'A','A','A','A','A','A','A','A','A','A','A','A','A','A','G','h','Y','b','I','B','w','q','B','l','Y',
    'A','R','B','E','I','C','o','o','s','i','E','M','L','H','A','A','B','N','g','I','k','A','x','w','E',
    'I','A','W','C','d','g','c','g','G','3','A','H','U','Z','Q','N','T','o','D','s','Z','0','L','m','p',
    'o','d','m','l','0','M','o','c','Y','i','J','W','q','3','M','r','p','V','L','Z','E','J','+','v','N',
    '3','P','v','5','v','+','u','Q','S','v','2','A','2','0','n','h','m','l','o','g','7','V','l','N','R',
    'E','y','O','Z','0','r','4','9','O','V','Z','E','J','P','L','V','f','U','R','5','4','b','v','k','7',
    'L','o','s','0','C','q','T','n','C','f','S','i','2','i','E','a','0','i','6','7','d','W','9','6','4',
    'k','D','G','5','b','9','/','e','c','D','9','z','/','1','8','f','q','P','N','w','o','Z','R','u','A',
    'H','O','h','v','i','i','7','r','u','L','D','K','o','8','X','i','Y','b','D','f','t','H','U','5','Q',
    'X','f','p','I','P','y','F','9','j','b','U','b','2','M','T','D','y','Z','y','c','g','A','J','a','s',
    'I','Q','4','E','s','e','R','/','E','I','C','Y','K','3','e','o','S','V','f','Q','I','M','Q','F','A',
    'P','8','D','A','I','D','S','y','8','h','x','1','r','M','e','a','g','e','6','w','B','F','g','o','B',
    'v','D','B','9','L','i','A','c','4','U','H','g','C','s','L','r','P','o','C','9','W','0','E','n','D',
    'C','h','c','g','R','+','d','P','8','P','q','0','B','E','g','W','K','j','6','g','5','U','l','l','0',
    'J','G','h','p','g','g','O','E','q','s','c','I','C','L','h','Y','A','0','B','I','O','N','+','I','E',
    'i','v','+','E','s','7','A','e','u','V','8','9','9','K','L','7','Q','F','R','G','C','p','o','l','R',
    'P','O','0','3','Y','A','b','Q','G','n','p','m','e','5','3','y','J','D','T','O','s','k','R','g','9',
    '6','r','j','u','W','B','P','p','7','y','p','0','t','3','S','U','W','N','o','5','W','p','K','S','c',
    'N','U','a','W','b','4','0','W','M','/','r','X','e','i','W','o','d','d','a','p','m','n','V','i','z',
    'Q','G','x','x','l','B','l','1','M','X','r','L','e','a','j','B','G','L','V','6','J','3','w','D','e',
    'O','h','V','9','S','u','a','l','b','K','b','N','R','3','H','A','a','u','+','p','D','m','C','O','L',
    'R','r','O','I','R','F','z','x','X','o','L','m','3','X','N','N','d','i','r','x','0','6','d','U','p',
    'V','6','t','l','j','f','q','Q','2','H','I','r','Y','j','3','O','G','h','l','j','w','E','n','E','G',
    'k','J','J','g','U','Y','Z','9','q','j','m','J','R','+','H','5','B','x','j','5','Y','+','w','U','o',
    'a','N','8','i','m','R','b','Q','B','q','T','O','v','1','A','D','r','d','d','O','y','B','4','Q','Y',
    'd','k','5','Z','v','h','O','H','w','p','K','/','E','A','q','B','V','t','F','g','9','I','I','Y','z',
    'A','D','I','k','4','4','q','2','z','F','H','E','x','t','8','R','a','x','Y','W','E','G','K','2','r',
    'k','Y','j','S','F','/','N','S','+','v','c','S','Q','a','x','z','E','n','j','2','6','K','N','a','l',
    'J','H','H','z','x','3','V','W','N','g','1','P','o','G','j','Z','c','J','6','q','q','v','Q','b','E',
    'X','D','u','l','8','d','Q','c','w','I','n','m','f','k','y','6','W','p','y','8','x','B','s','Q','+',
    'V','1','J','k','Q','V','o','s','y','u','j','7','V','L','p','y','9','f','H','L','+','x','c','d','P',
    'H','j','1','w','d','R','G','P','C','b','S','F','q','5','7','a','s','n','I','7','B','M','f','F','m',
    'R','2','6','q','W','P','r','L','T','5','R','L','G','a','2','v','U','y','O','Y','5','K','m','h','i',
    '9','U','F','+','3','A','b','0','W','N','M','p','+','3','C','B','6','Q','Y','8','q','h','V','t','u',
    '0','z','4','v','v','b','L','I','L','S','o','y','/','R','c','r','5','2','X','Y','t','n','E','r','k',
    't','M','c','+','n','y','a','i','+','L','X','E','V','o','O','j','+','J','l','N','o','a','H','N','k',
    'p','G','6','p','U','/','N','J','J','z','M','o','k','a','/','K','O','5','2','f','a','l','Z','2','W',
    's','L','O','7','2','/','V','/','h','0','z','D','p','z','x','e','2','f','b','S','n','s','B','k','f',
    'w','m','a','5','i','V','S','p','O','5','9','i','8','j','m','w','2','1','2','V','5','b','E','j','t',
    'V','O','D','1','T','L','n','N','M','v','E','c','M','/','0','E','S','9','U','4','e','R','H','P','p',
    'e','b','c','Q','0','2','Y','z','J','v','z','q','2','q','O','s','O','v','N','n','7','N','H','l','l',
    'I','e','l','x','Y','5','Z','N','L','d','t','g','M','P','a','m','k','C','Q','v','O','/','p','y','Z',
    '2','5','J','J','p','I','s','y','h','z','K','K','s','V','l','+','5','O','I','t','K','U','f','s','G',
    'd','k','e','v','n','i','B','/','W','8','7','D','p','Z','K','O','g','b','L','b','L','i','d','e','9',
    'T','D','b','v','v','T','r','e','9','A','j','9','5','H','l','P','P','u','R','Y','7','W','e','r','n',
    'J','I','u','v','p','m','e','s','D','Q','q','Q','a','G','A','j','b','M','R','A','2','0','X','v','z',
    'x','O','/','Y','B','B','o','b','b','x','N','+','E','d','t','u','4','5','5','O','v','B','6','c','9',
    'x','U','X','f','3','Q','g','r','P','5','y','u','I','J','l','2','K','t','+','F','2','h','t','V','u',
    '5','k','p','5','p','p','R','U','P','p','A','w','z','f','W','E','6','l','9','d','8','o','a','J','m',
    'K','f','H','G','F','n','3','J','4','M','T','g','d','r','t','B','T','A','8','t','m','h','t','p','n',
    'l','p','t','W','L','q','3','p','S','C','7','I','S','U','0','p','V','C','Q','p','c','g','q','y','M',
    '5','V','F','c','J','d','8','R','m','r','J','5','1','g','Z','w','z','i','3','s','k','3','J','g','9',
    'f','f','Z','8','+','7','v','J','n','R','z','p','X','C','Z','f','3','0','Q','z','/','7','4','Y','S',
    '2','r','i','u','5','S','7','G','k','h','i','5','a','W','p','s','T','F','1','W','Y','q','K','2','b',
    'K','B','i','a','U','P','F','9','O','1','c','P','1','V','W','G','F','c','c','k','k','W','E','5','y',
    'f','4','V','a','x','W','b','l','P','N','D','H','R','0','+','u','f','n','s','2','Y','t','J','7','L',
    'g','g','e','1','F','h','8','t','m','A','2','u','Y','2','t','b','T','P','z','g','5','k','e','v','X',
    'J','k','m','n','t','R','P','c','v','9','t','j','k','/','X','9','d','a','V','r','n','3','v','k','9',
    'q','1','b','V','N','y','X','k','K','9','N','G','H','F','K','1','n','l','k','F','x','a','k','J','q',
    'k','q','d','0','N','P','5','P','9','t','k','v','S','m','x','l','3','X','+','s','S','T','H','9','x',
    'v','Z','e','G','0','v','j','e','t','6','1','v','h','z','Y','/','v','n','m','D','R','h','m','0','c',
    'b','r','Z','9','S','l','3','d','5','6','W','a','D','n','7','+','I','C','s','C','j','q','s','b','i',
    'b','d','U','2','s','X','+','h','R','f','Q','D','A','M','+','m','k','C','L','/','h','M','O','f','i',
    's','r','o','C','P','i','d','G','A','G','y','T','8','5','k','l','Y','V','v','C','b','m','j','A','p',
    'o','D','P','+','c','Q','g','F','5','a','i','3','N','1','r','x','n','e','Y','E','C','9','F','Q','Z',
    'P','4','p','j','M','O','J','w','o','u','k','2','g','D','A','H','F','B','Y','D','l','o','D','U','i',
    'Q','s','u','N','H','N','Z','m','j','Y','R','C','2','4','x','c','z','n','4','z','8','u','B','A','i',
    'H','y','x','3','6','F','U','a','8','C','A','F','o','2','G','U','Y','q','0','q','9','W','h','F','k',
    'U','u','W','K','A','g','Q','b','z','E','o','N','S','p','1','a','9','R','A','0','q','3','L','p','R',
    '6','3','R','o','0','z','s','O','o','D','7','l','9','6','G','u','h','M','c','e','B','j','b','T','1',
    'W','g','y','T','K','j','E','G','c','n','l','z','l','E','j','h','f','F','E','b','2','+','Z','J','U',
    'S','h','Z','Y','a','P','Z','o','A','4','Y','0','w','/','A','g','R','L','6','5','r','A','R','B','3',
    '/','T','S','I','l','G','A','W','X','O','o','0','y','W','m','g','4','W','w','U','8','U','v','0','O',
    'W','D','Y','Z','R','d','d','1','U','v','9','Z','H','Q','X','B','q','J','g','A','A','g','e','w','A',
    'A','A','A','A','\0'
};

/* vim: set ts=4 sw=4 et : */
#endif /* Z_UPCEAN_WOFF2_H */
