// This file has been auto-generated by the ontology2code script.
// Do not modify it directly.

/* ontology-uris.vala
 *
 * Copyright © 2009-2012 The Zeitgeist Team
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace Zeitgeist
{

    namespace NCAL
    {

	    /**
	     * ALARM:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Alarm]]
	     *
	     * Provide a grouping of component properties that define an alarm.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string ALARM = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Alarm";

	    /**
	     * ATTACHMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Attachment]]
	     *
	     * An object attached to a calendar entity. This class has been introduced to serve as a structured value of the ncal:attach property. See the documentation of ncal:attach for details.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.ATTACHMENT}
	     */
	    public const string ATTACHMENT = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Attachment";

	    /**
	     * CALENDAR:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Calendar]]
	     *
	     * A calendar. Inspirations for this class can be traced to the VCALENDAR component defined in RFC 2445 sec. 4.4, but it may just as well be used to represent any kind of Calendar.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string CALENDAR = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Calendar";

	    /**
	     * CALENDAR_DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarDataObject]]
	     *
	     * A DataObject found in a calendar. It is usually interpreted as one of the calendar entity types (e.g. Event, Journal, Todo etc.)
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string CALENDAR_DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarDataObject";

	    /**
	     * EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Event]]
	     *
	     * Provide a grouping of component properties that describe an event.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string EVENT = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Event";

	    /**
	     * FREEBUSY:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Freebusy]]
	     *
	     * Provide a grouping of component properties that describe either a request for free/busy time, describe a response to a request for free/busy time or describe a published set of busy time.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string FREEBUSY = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Freebusy";

	    /**
	     * JOURNAL:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Journal]]
	     *
	     * Provide a grouping of component properties that describe a journal entry.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string JOURNAL = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Journal";

	    /**
	     * TIMEZONE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Timezone]]
	     *
	     * Provide a grouping of component properties that defines a time zone.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string TIMEZONE = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Timezone";

	    /**
	     * TODO:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Todo]]
	     *
	     * Provide a grouping of calendar properties that describe a to-do.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string TODO = "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Todo";

    }

    namespace NCO
    {

	    /**
	     * CONTACT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Contact]]
	     *
	     * A Contact. A piece of data that can provide means to identify or communicate with an entity.
	     *
	     * Children: {@link NCO.ORGANIZATION_CONTACT}, {@link NCO.PERSON_CONTACT}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string CONTACT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Contact";

	    /**
	     * CONTACT_GROUP:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactGroup]]
	     *
	     * A group of Contacts. Could be used to express a group in an addressbook or on a contact list of an IM application. One contact can belong to many groups.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string CONTACT_GROUP = "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactGroup";

	    /**
	     * CONTACT_LIST:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactList]]
	     *
	     * A contact list, this class represents an addressbook or a contact list of an IM application. Contacts inside a contact list can belong to contact groups.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string CONTACT_LIST = "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactList";

	    /**
	     * CONTACT_LIST_DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactListDataObject]]
	     *
	     * An entity occuring on a contact list (usually interpreted as an nco:Contact)
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string CONTACT_LIST_DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactListDataObject";

	    /**
	     * ORGANIZATION_CONTACT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nco#OrganizationContact]]
	     *
	     * A Contact that denotes on Organization.
	     *
	     * Children: None
	     *
	     * Parents: {@link NCO.CONTACT}
	     */
	    public const string ORGANIZATION_CONTACT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#OrganizationContact";

	    /**
	     * PERSON_CONTACT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PersonContact]]
	     *
	     * A Contact that denotes a Person. A person can have multiple Affiliations.
	     *
	     * Children: None
	     *
	     * Parents: {@link NCO.CONTACT}
	     */
	    public const string PERSON_CONTACT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PersonContact";

    }

    namespace NFO
    {

	    /**
	     * APPLICATION:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Application]]
	     *
	     * An application
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.SOFTWARE}
	     */
	    public const string APPLICATION = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Application";

	    /**
	     * ARCHIVE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Archive]]
	     *
	     * A compressed file. May contain other files or folder inside. 
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.DATA_CONTAINER}
	     */
	    public const string ARCHIVE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Archive";

	    /**
	     * ARCHIVE_ITEM:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#ArchiveItem]]
	     *
	     * A file entity inside an archive.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.EMBEDDED_FILE_DATA_OBJECT}
	     */
	    public const string ARCHIVE_ITEM = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#ArchiveItem";

	    /**
	     * ATTACHMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Attachment]]
	     *
	     * A file attached to another data object. Many data formats allow for attachments: emails, vcards, ical events, id3 and exif...
	     *
	     * Children: {@link NCAL.ATTACHMENT}
	     *
	     * Parents: {@link NFO.EMBEDDED_FILE_DATA_OBJECT}
	     */
	    public const string ATTACHMENT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Attachment";

	    /**
	     * AUDIO:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Audio]]
	     *
	     * A file containing audio content
	     *
	     * Children: {@link NMM.MUSIC_PIECE}
	     *
	     * Parents: {@link NFO.MEDIA}
	     */
	    public const string AUDIO = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Audio";

	    /**
	     * BOOKMARK:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Bookmark]]
	     *
	     * A bookmark of a webbrowser. Use nie:title for the name/label, nie:contentCreated to represent the date when the user added the bookmark, and nie:contentLastModified for modifications. nfo:bookmarks to store the link.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string BOOKMARK = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Bookmark";

	    /**
	     * BOOKMARK_FOLDER:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#BookmarkFolder]]
	     *
	     * A folder with bookmarks of a webbrowser. Use nfo:containsBookmark to relate Bookmarks. Folders can contain subfolders, use containsBookmarkFolder to relate them.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string BOOKMARK_FOLDER = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#BookmarkFolder";

	    /**
	     * CURSOR:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Cursor]]
	     *
	     * A Cursor.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.RASTER_IMAGE}
	     */
	    public const string CURSOR = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Cursor";

	    /**
	     * DATA_CONTAINER:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DataContainer]]
	     *
	     * A superclass for all entities, whose primary purpose is to serve as containers for other data object. They usually don't have any "meaning" by themselves. Examples include folders, archives and optical disc images.
	     *
	     * Children: {@link NFO.ARCHIVE}, {@link NFO.FOLDER}, {@link NFO.TRASH}, {@link NFO.FILESYSTEM}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string DATA_CONTAINER = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DataContainer";

	    /**
	     * DELETED_RESOURCE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DeletedResource]]
	     *
	     * A file entity that has been deleted from the original source. Usually such entities are stored within various kinds of 'Trash' or 'Recycle Bin' folders.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.FILE_DATA_OBJECT}
	     */
	    public const string DELETED_RESOURCE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DeletedResource";

	    /**
	     * DOCUMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Document]]
	     *
	     * A generic document. A common superclass for all documents on the desktop.
	     *
	     * Children: {@link NFO.TEXT_DOCUMENT}, {@link NFO.SPREADSHEET}, {@link NFO.PRESENTATION}, {@link NFO.MIND_MAP}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string DOCUMENT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Document";

	    /**
	     * EMBEDDED_FILE_DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#EmbeddedFileDataObject]]
	     *
	     * A file embedded in another data object. There are many ways in which a file may be embedded in another one. Use this class directly only in cases if none of the subclasses gives a better description of your case.
	     *
	     * Children: {@link NFO.ATTACHMENT}, {@link NFO.ARCHIVE_ITEM}
	     *
	     * Parents: {@link NFO.FILE_DATA_OBJECT}
	     */
	    public const string EMBEDDED_FILE_DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#EmbeddedFileDataObject";

	    /**
	     * EXECUTABLE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Executable]]
	     *
	     * An executable file.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string EXECUTABLE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Executable";

	    /**
	     * FILESYSTEM:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Filesystem]]
	     *
	     * A filesystem. Examples of filesystems include hard disk partitions, removable media, but also images thereof stored in files such as ISO.
	     *
	     * Children: {@link NFO.FILESYSTEM_IMAGE}
	     *
	     * Parents: {@link NFO.DATA_CONTAINER}
	     */
	    public const string FILESYSTEM = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Filesystem";

	    /**
	     * FILESYSTEM_IMAGE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FilesystemImage]]
	     *
	     * An image of a filesystem. Instances of this class may include CD images, DVD images or hard disk partition images created by various pieces of software (e.g. Norton Ghost). Deprecated in favor of nfo:Filesystem.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.FILESYSTEM}
	     */
	    public const string FILESYSTEM_IMAGE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FilesystemImage";

	    /**
	     * FILE_DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObject]]
	     *
	     * A resource containing a finite sequence of bytes with arbitrary information, that is available to a computer program and is usually based on some kind of durable storage. A file is durable in the sense that it remains available for programs to use after the current program has finished.
	     *
	     * Children: {@link NFO.EMBEDDED_FILE_DATA_OBJECT}, {@link NFO.DELETED_RESOURCE}, {@link NFO.REMOTE_DATA_OBJECT}
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string FILE_DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObject";

	    /**
	     * FOLDER:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Folder]]
	     *
	     * A folder/directory. Examples of folders include folders on a filesystem and message folders in a mailbox.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.DATA_CONTAINER}
	     */
	    public const string FOLDER = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Folder";

	    /**
	     * FONT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Font]]
	     *
	     * A font.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string FONT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Font";

	    /**
	     * HARD_DISK_PARTITION:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HardDiskPartition]]
	     *
	     * A partition on a hard disk
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string HARD_DISK_PARTITION = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HardDiskPartition";

	    /**
	     * HTML_DOCUMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HtmlDocument]]
	     *
	     * A HTML document, may contain links to other files.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.PLAIN_TEXT_DOCUMENT}
	     */
	    public const string HTML_DOCUMENT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HtmlDocument";

	    /**
	     * ICON:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Icon]]
	     *
	     * An Icon (regardless of whether it's a raster or a vector icon. A resource representing an icon could have two types (Icon and Raster, or Icon and Vector) if required.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.IMAGE}
	     */
	    public const string ICON = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Icon";

	    /**
	     * IMAGE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Image]]
	     *
	     * A file containing an image.
	     *
	     * Children: {@link NFO.ICON}, {@link NFO.RASTER_IMAGE}, {@link NFO.VECTOR_IMAGE}
	     *
	     * Parents: {@link NFO.VISUAL}
	     */
	    public const string IMAGE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Image";

	    /**
	     * MEDIA:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Media]]
	     *
	     * A piece of media content. This class may be used to express complex media containers with many streams of various media content (both aural and visual).
	     *
	     * Children: {@link NFO.AUDIO}, {@link NFO.VISUAL}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string MEDIA = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Media";

	    /**
	     * MEDIA_LIST:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaList]]
	     *
	     * A file containing a list of media files.e.g. a playlist
	     *
	     * Children: {@link NMM.MUSIC_ALBUM}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string MEDIA_LIST = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaList";

	    /**
	     * MEDIA_STREAM:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaStream]]
	     *
	     * A stream of multimedia content, usually contained within a media container such as a movie (containing both audio and video) or a DVD (possibly containing many streams of audio and video). Most common interpretations for such a DataObject include Audio and Video.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string MEDIA_STREAM = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaStream";

	    /**
	     * MIND_MAP:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MindMap]]
	     *
	     * A MindMap, created by a mind-mapping utility. Examples might include FreeMind or mind mapper.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.DOCUMENT}
	     */
	    public const string MIND_MAP = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MindMap";

	    /**
	     * OPERATING_SYSTEM:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#OperatingSystem]]
	     *
	     * An OperatingSystem
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.SOFTWARE}
	     */
	    public const string OPERATING_SYSTEM = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#OperatingSystem";

	    /**
	     * PAGINATED_TEXT_DOCUMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PaginatedTextDocument]]
	     *
	     * A file containing a text document, that is unambiguously divided into pages. Examples might include PDF, DOC, PS, DVI etc.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.TEXT_DOCUMENT}
	     */
	    public const string PAGINATED_TEXT_DOCUMENT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PaginatedTextDocument";

	    /**
	     * PLAIN_TEXT_DOCUMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PlainTextDocument]]
	     *
	     * A file containing plain text (ASCII, Unicode or other encodings). Examples may include TXT, HTML, XML, program source code etc.
	     *
	     * Children: {@link NFO.HTML_DOCUMENT}, {@link NFO.SOURCE_CODE}
	     *
	     * Parents: {@link NFO.TEXT_DOCUMENT}
	     */
	    public const string PLAIN_TEXT_DOCUMENT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PlainTextDocument";

	    /**
	     * PRESENTATION:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Presentation]]
	     *
	     * A Presentation made by some presentation software (Corel Presentations, OpenOffice Impress, MS Powerpoint etc.)
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.DOCUMENT}
	     */
	    public const string PRESENTATION = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Presentation";

	    /**
	     * RASTER_IMAGE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RasterImage]]
	     *
	     * A raster image.
	     *
	     * Children: {@link NFO.CURSOR}
	     *
	     * Parents: {@link NFO.IMAGE}
	     */
	    public const string RASTER_IMAGE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RasterImage";

	    /**
	     * REMOTE_DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemoteDataObject]]
	     *
	     * A file data object stored at a remote location. Don't confuse this class with a RemotePortAddress. This one applies to a particular resource, RemotePortAddress applies to an address, that can have various interpretations.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.FILE_DATA_OBJECT}
	     */
	    public const string REMOTE_DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemoteDataObject";

	    /**
	     * REMOTE_PORT_ADDRESS:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemotePortAddress]]
	     *
	     * An address specifying a remote host and port. Such an address can be interpreted in many ways (examples of such interpretations include mailboxes, websites, remote calendars or filesystems), depending on an interpretation, various kinds of data may be extracted from such an address.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string REMOTE_PORT_ADDRESS = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemotePortAddress";

	    /**
	     * SOFTWARE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Software]]
	     *
	     * A piece of software. Examples may include applications and the operating system. This interpretation most commonly applies to SoftwareItems.
	     *
	     * Children: {@link NFO.APPLICATION}, {@link NFO.OPERATING_SYSTEM}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string SOFTWARE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Software";

	    /**
	     * SOFTWARE_ITEM:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareItem]]
	     *
	     * A DataObject representing a piece of software. Examples of interpretations of a SoftwareItem include an Application and an OperatingSystem.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string SOFTWARE_ITEM = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareItem";

	    /**
	     * SOFTWARE_SERVICE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareService]]
	     *
	     * A service published by a piece of software, either by an operating system or an application. Examples of such services may include calendar, addressbook and mailbox managed by a PIM application. This category is introduced to distinguish between data available directly from the applications (Via some Interprocess Communication Mechanisms) and data available from files on a disk. In either case both DataObjects would receive a similar interpretation (e.g. a Mailbox) and wouldn't differ on the content level.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string SOFTWARE_SERVICE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareService";

	    /**
	     * SOURCE_CODE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SourceCode]]
	     *
	     * Code in a compilable or interpreted programming language.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.PLAIN_TEXT_DOCUMENT}
	     */
	    public const string SOURCE_CODE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SourceCode";

	    /**
	     * SPREADSHEET:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Spreadsheet]]
	     *
	     * A spreadsheet, created by a spreadsheet application. Examples might include Gnumeric, OpenOffice Calc or MS Excel.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.DOCUMENT}
	     */
	    public const string SPREADSHEET = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Spreadsheet";

	    /**
	     * TEXT_DOCUMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#TextDocument]]
	     *
	     * A text document
	     *
	     * Children: {@link NFO.PAGINATED_TEXT_DOCUMENT}, {@link NFO.PLAIN_TEXT_DOCUMENT}
	     *
	     * Parents: {@link NFO.DOCUMENT}
	     */
	    public const string TEXT_DOCUMENT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#TextDocument";

	    /**
	     * TRASH:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Trash]]
	     *
	     * Represents a container for deleted files, a feature common in modern operating systems.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.DATA_CONTAINER}
	     */
	    public const string TRASH = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Trash";

	    /**
	     * VECTOR_IMAGE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#VectorImage]]
	     *
	     * 
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.IMAGE}
	     */
	    public const string VECTOR_IMAGE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#VectorImage";

	    /**
	     * VIDEO:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Video]]
	     *
	     * A video file.
	     *
	     * Children: {@link NMM.TVSHOW}, {@link NMM.MOVIE}
	     *
	     * Parents: {@link NFO.VISUAL}
	     */
	    public const string VIDEO = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Video";

	    /**
	     * VISUAL:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Visual]]
	     *
	     * File containing visual content.
	     *
	     * Children: {@link NFO.VIDEO}, {@link NFO.IMAGE}
	     *
	     * Parents: {@link NFO.MEDIA}
	     */
	    public const string VISUAL = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Visual";

	    /**
	     * WEBSITE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Website]]
	     *
	     * A website, usually a container for remote resources, that may be interpreted as HTMLDocuments, images or other types of content.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string WEBSITE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Website";

	    /**
	     * WEB_DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject]]
	     *
	     * An information resources of which representations (files, streams) can be retrieved through a web server. They may be generated at retrieval time. Typical examples are pages served by PHP or AJAX or mp3 streams.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string WEB_DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject";

    }

    namespace NIE
    {

	    /**
	     * DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/01/19/nie#DataObject]]
	     *
	     * A unit of data that is created, annotated and processed on the user desktop. It represents a native structure the user works with. The usage of the term 'native' is important. It means that a DataObject can be directly mapped to a data structure maintained by a native application. This may be a file, a set of files or a part of a file. The granularity depends on the user. This class is not intended to be instantiated by itself. Use more specific subclasses.
	     *
	     * Children: {@link NFO.FILE_DATA_OBJECT}, {@link NCAL.CALENDAR_DATA_OBJECT}, {@link NFO.HARD_DISK_PARTITION}, {@link NFO.MEDIA_STREAM}, {@link NCO.CONTACT_LIST_DATA_OBJECT}, {@link NFO.REMOTE_PORT_ADDRESS}, {@link NFO.SOFTWARE_SERVICE}, {@link NFO.SOFTWARE_ITEM}, {@link NFO.WEB_DATA_OBJECT}, {@link NMO.MAILBOX_DATA_OBJECT}, {@link ZG.EVENT_MANIFESTATION}
	     *
	     * Parents: None
	     */
	    public const string DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#DataObject";

	    /**
	     * INFORMATION_ELEMENT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/01/19/nie#InformationElement]]
	     *
	     * A unit of content the user works with. This is a superclass for all interpretations of a DataObject.
	     *
	     * Children: {@link NMM.TVSERIES}, {@link NCAL.TODO}, {@link ZG.EVENT_INTERPRETATION}, {@link NFO.DOCUMENT}, {@link NMO.MIME_ENTITY}, {@link NFO.BOOKMARK_FOLDER}, {@link NCAL.EVENT}, {@link NCO.CONTACT_LIST}, {@link NFO.SOFTWARE}, {@link NCO.CONTACT_GROUP}, {@link NCAL.TIMEZONE}, {@link NCAL.ALARM}, {@link NFO.FONT}, {@link NFO.MEDIA}, {@link ZG.APPLICATION_ACTION}, {@link NFO.WEBSITE}, {@link NCO.CONTACT}, {@link NMO.MAILBOX}, {@link NFO.MEDIA_LIST}, {@link NFO.BOOKMARK}, {@link NCAL.JOURNAL}, {@link NCAL.CALENDAR}, {@link NMO.MESSAGE}, {@link NFO.EXECUTABLE}, {@link NCAL.FREEBUSY}, {@link NFO.DATA_CONTAINER}
	     *
	     * Parents: None
	     */
	    public const string INFORMATION_ELEMENT = "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#InformationElement";

    }

    namespace NMM
    {

	    /**
	     * MOVIE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#Movie]]
	     *
	     * A Movie
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.VIDEO}
	     */
	    public const string MOVIE = "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#Movie";

	    /**
	     * MUSIC_ALBUM:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicAlbum]]
	     *
	     * The music album as provided by the publisher. Not to be confused with media lists or collections.
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.MEDIA_LIST}
	     */
	    public const string MUSIC_ALBUM = "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicAlbum";

	    /**
	     * MUSIC_PIECE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicPiece]]
	     *
	     * Used to assign music-specific properties such a BPM to video and audio
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.AUDIO}
	     */
	    public const string MUSIC_PIECE = "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicPiece";

	    /**
	     * TVSERIES:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVSeries]]
	     *
	     * A TV Series has multiple seasons and episodes
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string TVSERIES = "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVSeries";

	    /**
	     * TVSHOW:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVShow]]
	     *
	     * A TV Show
	     *
	     * Children: None
	     *
	     * Parents: {@link NFO.VIDEO}
	     */
	    public const string TVSHOW = "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVShow";

    }

    namespace NMO
    {

	    /**
	     * EMAIL:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Email]]
	     *
	     * An email.
	     *
	     * Children: None
	     *
	     * Parents: {@link NMO.MESSAGE}
	     */
	    public const string EMAIL = "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Email";

	    /**
	     * IMMESSAGE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#IMMessage]]
	     *
	     * A message sent with Instant Messaging software.
	     *
	     * Children: None
	     *
	     * Parents: {@link NMO.MESSAGE}
	     */
	    public const string IMMESSAGE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#IMMessage";

	    /**
	     * MAILBOX:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Mailbox]]
	     *
	     * A mailbox - container for MailboxDataObjects.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string MAILBOX = "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Mailbox";

	    /**
	     * MAILBOX_DATA_OBJECT:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MailboxDataObject]]
	     *
	     * An entity encountered in a mailbox. Most common interpretations for such an entity include Message or Folder
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string MAILBOX_DATA_OBJECT = "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MailboxDataObject";

	    /**
	     * MESSAGE:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Message]]
	     *
	     * A message. Could be an email, instant messanging message, SMS message etc.
	     *
	     * Children: {@link NMO.IMMESSAGE}, {@link NMO.EMAIL}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string MESSAGE = "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Message";

	    /**
	     * MIME_ENTITY:
	     *
	     * Macro defining the interpretation type [[http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MimeEntity]]
	     *
	     * A MIME entity, as defined in RFC2045, Section 2.4.
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string MIME_ENTITY = "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MimeEntity";

    }

    namespace ZG
    {

	    /**
	     * ACCEPT_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AcceptEvent]]
	     *
	     * Event triggered when the user accepts a request of some sort. Examples could be answering a phone call, accepting a file transfer, or accepting a friendship request over an IM protocol. See also DenyEvent for when the user denies a similar request
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string ACCEPT_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AcceptEvent";

	    /**
	     * ACCESS_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AccessEvent]]
	     *
	     * Event triggered by opening, accessing, or starting a resource. Most zg:AccessEvents will have an accompanying zg:LeaveEvent, but this need not always be the case
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string ACCESS_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AccessEvent";

	    /**
	     * APPLICATION_ACTION:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ApplicationAction]]
	     *
	     * Representation of a specific Action on an Application
	     *
	     * Children: None
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string APPLICATION_ACTION = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ApplicationAction";

	    /**
	     * CREATE_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#CreateEvent]]
	     *
	     * Event type triggered when an item is created
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string CREATE_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#CreateEvent";

	    /**
	     * DELETE_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DeleteEvent]]
	     *
	     * Event triggered because a resource has been deleted or otherwise made permanently unavailable. Fx. when deleting a file. FIXME: How about when moving to trash?
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string DELETE_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DeleteEvent";

	    /**
	     * DENY_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DenyEvent]]
	     *
	     * Event triggered when the user denies a request of some sort. Examples could be rejecting a phone call, rejecting a file transfer, or denying a friendship request over an IM protocol. See also AcceptEvent for the converse event type
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string DENY_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DenyEvent";

	    /**
	     * EVENT_INTERPRETATION:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventInterpretation]]
	     *
	     * Base class for event interpretations. Please do no instantiate directly, but use one of the sub classes. The interpretation of an event describes 'what happened' - fx. 'something was created' or 'something was accessed'
	     *
	     * Children: {@link ZG.MOVE_EVENT}, {@link ZG.DENY_EVENT}, {@link ZG.DELETE_EVENT}, {@link ZG.LEAVE_EVENT}, {@link ZG.EXPIRE_EVENT}, {@link ZG.SEND_EVENT}, {@link ZG.CREATE_EVENT}, {@link ZG.ACCEPT_EVENT}, {@link ZG.RECEIVE_EVENT}, {@link ZG.ACCESS_EVENT}, {@link ZG.MODIFY_EVENT}
	     *
	     * Parents: {@link NIE.INFORMATION_ELEMENT}
	     */
	    public const string EVENT_INTERPRETATION = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventInterpretation";

	    /**
	     * EVENT_MANIFESTATION:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventManifestation]]
	     *
	     * Base class for event manifestation types. Please do no instantiate directly, but use one of the sub classes. The manifestation of an event describes 'how it happened'. Fx. 'the user did this' or 'the system notified the user'
	     *
	     * Children: {@link ZG.WORLD_ACTIVITY}, {@link ZG.HEURISTIC_ACTIVITY}, {@link ZG.SYSTEM_NOTIFICATION}, {@link ZG.SCHEDULED_ACTIVITY}, {@link ZG.USER_ACTIVITY}
	     *
	     * Parents: {@link NIE.DATA_OBJECT}
	     */
	    public const string EVENT_MANIFESTATION = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventManifestation";

	    /**
	     * EXPIRE_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ExpireEvent]]
	     *
	     * Event triggered when something expires or times out. These types of events are normally not triggered by the user, but by the operating system or some external party. Examples are a recurring calendar item or task deadline that expires or a when the user fails to respond to an external request such as a phone call
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string EXPIRE_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ExpireEvent";

	    /**
	     * HEURISTIC_ACTIVITY:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#HeuristicActivity]]
	     *
	     * An event that is caused indirectly from user activity or deducted via analysis of other events. Fx. if an algorithm divides a user workflow into disjoint 'projects' based on temporal analysis it could insert heuristic events when the user changed project
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_MANIFESTATION}
	     */
	    public const string HEURISTIC_ACTIVITY = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#HeuristicActivity";

	    /**
	     * LEAVE_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#LeaveEvent]]
	     *
	     * Event triggered by closing, leaving, or stopping a resource. Most zg:LeaveEvents will be following a zg:Access event, but this need not always be the case
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string LEAVE_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#LeaveEvent";

	    /**
	     * MODIFY_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ModifyEvent]]
	     *
	     * Event triggered by modifying an existing resources. Fx. when editing and saving a file on disk or correcting a typo in the name of a contact
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string MODIFY_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ModifyEvent";

	    /**
	     * MOVE_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#MoveEvent]]
	     *
	     * Event triggered when a resource has been moved from a location to another. Fx. moving a file from a folder to another.
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string MOVE_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#MoveEvent";

	    /**
	     * RECEIVE_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ReceiveEvent]]
	     *
	     * Event triggered when something is received from an external party. The event manifestation must be set according to the world view of the receiving party. Most often the item that is being received will be some sort of message - an email, instant message, or broadcasted media such as micro blogging
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string RECEIVE_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ReceiveEvent";

	    /**
	     * SCHEDULED_ACTIVITY:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ScheduledActivity]]
	     *
	     * An event that was directly triggered by some user initiated sequence of actions. For example a music player automatically changing to the next song in a playlist
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_MANIFESTATION}
	     */
	    public const string SCHEDULED_ACTIVITY = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ScheduledActivity";

	    /**
	     * SEND_EVENT:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SendEvent]]
	     *
	     * Event triggered when something is send to an external party. The event manifestation must be set according to the world view of the sending party. Most often the item that is being send will be some sort of message - an email, instant message, or broadcasted media such as micro blogging
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_INTERPRETATION}
	     */
	    public const string SEND_EVENT = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SendEvent";

	    /**
	     * SYSTEM_NOTIFICATION:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SystemNotification]]
	     *
	     * An event send to the user by the operating system. Examples could include when the user inserts a USB stick or when the system warns that the hard disk is full
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_MANIFESTATION}
	     */
	    public const string SYSTEM_NOTIFICATION = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SystemNotification";

	    /**
	     * USER_ACTIVITY:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#UserActivity]]
	     *
	     * An event that was actively performed by the user. For example saving or opening a file by clicking on it in the file manager
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_MANIFESTATION}
	     */
	    public const string USER_ACTIVITY = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#UserActivity";

	    /**
	     * WORLD_ACTIVITY:
	     *
	     * Macro defining the interpretation type [[http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#WorldActivity]]
	     *
	     * An event that was performed by an entity, usually human or organization, other than the user. An example could be logging the activities of other people in a team
	     *
	     * Children: None
	     *
	     * Parents: {@link ZG.EVENT_MANIFESTATION}
	     */
	    public const string WORLD_ACTIVITY = "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#WorldActivity";

    }
}

// vim:expandtab:ts=4:sw=4
