/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 1997-2006  Gaspar Sinai <gaspar@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "swidget/SIconFactory.h"

#include "icons/SS_Caution.xpm"
#include "icons/SS_Inform.xpm"
#include "icons/SS_Open.xpm"
#include "icons/SS_Print.xpm"
#include "icons/SS_Redo.xpm"
#include "icons/SS_Save.xpm"
#include "icons/SS_SaveNotNeeded.xpm"
#include "icons/SS_Undo.xpm"
#include "icons/SS_MagnifyPlus.xpm"
#include "icons/SS_MagnifyMinus.xpm"
#include "icons/SS_GreenRight.xpm"
#include "icons/SS_GreenLeft.xpm"
#include "icons/SS_Right.xpm"
#include "icons/SS_Font.xpm"
#include "icons/SS_Help.xpm"
#include "icons/SS_Document.xpm"
#include "icons/SS_DocumentCX.xpm"
#include "icons/SS_DocumentXX.xpm"
#include "icons/SS_DocumentXM.xpm"
#include "icons/SS_Preview.xpm"
#include "icons/SS_Error.xpm"
#include "icons/SS_Goto.xpm"
#include "icons/SS_Find.xpm"
#include "icons/SS_Yes.xpm"
#include "icons/SS_Cancel.xpm"
#include "icons/SS_Folder.xpm"
#include "icons/SS_CreateFolder.xpm"
#include "icons/SS_CircleOff.xpm"
#include "icons/SS_CircleOn.xpm"
#include "icons/SS_Best.xpm"
#include "icons/SS_Home.xpm"

#include "icons/SS_LBDOS.xpm"
#include "icons/SS_LBLS.xpm"
#include "icons/SS_LBMAC.xpm"
#include "icons/SS_LBPS.xpm"
#include "icons/SS_LBUNIX.xpm"
#include "icons/SS_Clear.xpm"

#include "icons/SS_EmbedLeft.xpm"
#include "icons/SS_EmbedRight.xpm"
#include "icons/SS_EmbedNone.xpm"

#include "icons/SS_RLO_XPM.xpm"
#include "icons/SS_LRO_XPM.xpm"

#include "icons/SS_RLE_XPM.xpm"
#include "icons/SS_LRE_XPM.xpm"

#include "icons/SS_RL_XPM.xpm"
#include "icons/SS_LR_XPM.xpm"
#include "icons/SS_Yudit_XPM.xpm"

struct _icon_map {
  const char*  name;
  const char** icon;
} icon_map[] = {
  { "Caution", SS_Caution },
  { "Inform", SS_Inform   },
  { "Open", SS_Open       },
  { "Print", SS_Print     },
  { "Redo", SS_Redo       },    
  { "Save", SS_Save       },
  { "SaveNotNeeded", SS_SaveNotNeeded       },
  { "Undo", SS_Undo       },
  { "MagnifyPlus", SS_MagnifyPlus },
  { "MagnifyMinus", SS_MagnifyMinus },
  { "GreenRight", SS_GreenRight },
  { "GreenLeft", SS_GreenLeft },
  { "Right", SS_Right },
  { "Font", SS_Font },
  { "Help", SS_Help },
  { "Document", SS_Document },
  { "DocumentXM", SS_DocumentXM },
  { "DocumentCX", SS_DocumentCX },
  { "DocumentXX", SS_DocumentXX },
  { "Preview", SS_Preview },
  { "Error", SS_Error },
  { "Goto", SS_Goto },
  { "Find", SS_Find },
  { "Yes", SS_Yes },
  { "Cancel", SS_Cancel },
  { "Clear", SS_Clear },
  { "Folder", SS_Folder },
  { "CreateFolder", SS_CreateFolder },
  { "CircleOff", SS_CircleOff },
  { "CircleOn", SS_CircleOn },
  { "Best", SS_Best },
  { "Home", SS_Home },

  { "DOS", SS_LB_DOS_XPM },
  { "LS", SS_LB_LS_XPM },
  { "PS", SS_LB_PS_XPM },
  { "MAC", SS_LB_MAC_XPM },
  { "UNIX", SS_LB_UNIX_XPM },

  { "LRO", SS_LRO_XPM },
  { "RLO", SS_RLO_XPM },
  { "LRE", SS_LRE_XPM },
  { "RLE", SS_RLE_XPM },
  { "LR", SS_LR_XPM },
  { "RL", SS_RL_XPM },

  { "EmbedLeft", SS_EmbedLeft },
  { "EmbedRight", SS_EmbedRight },
  { "EmbedNone", SS_EmbedNone },

  { "Yudit", SS_Yudit_XPM },
  {  0, 0 }
};


SIconFactory::SIconFactory (void)
{
}

SIconFactory::~SIconFactory ()
{
}

SIcon*
SIconFactory::getIcon (const SString& name)
{
  if (SIcon::exists(name))
  {
    return new SIcon (name);
  }
  unsigned int i=0;
  while (icon_map[i].name)
  {
    if (name == SString (icon_map[i].name)) break;
    i++;
  }
  if (icon_map[i].name==0)
  {
    fprintf (stderr, "SIconFactory::getIcon does not know how to load %*.*s\n",
        SSARGS(name));
    return 0;
  }
  SImage im((const char* const*)icon_map[i].icon);
  return new SIcon (im);
}
