#!/bin/sh

CONFIG_HDR=extensions/config_features.h

echo > $CONFIG_HDR

srctree="/lib/modules/${kernelver:-`uname -r`}/build"
if egrep -A 10 '\<ip_route_me_harder\(' $srctree/include/linux/netfilter_ipv4.h | awk '/;/ { print; exit } { print }' | egrep -q 'struct sock \*sk'
then
	echo '#define IP_ROUTE_ME_HARDER_HAS_SK' >> $CONFIG_HDR
fi
if egrep -A 10 '\<ip6_route_me_harder\(' $srctree/include/linux/netfilter_ipv6.h | awk '/;/ { print; exit } { print }' | egrep -q 'struct sock \*sk'
then
	echo '#define IP6_ROUTE_ME_HARDER_HAS_SK' >> $CONFIG_HDR
fi
