<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:func="http://exslt.org/functions"
                              xmlns:exsl="http://exslt.org/common"
                              extension-element-prefixes="func exsl">

   <!-- Build month name from number -->

   <func:function name="func:month_name">
      <xsl:param name="number"/>
      <xsl:choose>
         <xsl:when test="$number = '01'">
            <func:result select="'January'"/>
         </xsl:when>
         <xsl:when test="$number = '02'">
            <func:result select="'February'"/>
         </xsl:when>
         <xsl:when test="$number = '03'">
            <func:result select="'March'"/>
         </xsl:when>
         <xsl:when test="$number = '04'">
            <func:result select="'April'"/>
         </xsl:when>
         <xsl:when test="$number = '05'">
            <func:result select="'May'"/>
         </xsl:when>
         <xsl:when test="$number = '06'">
            <func:result select="'June'"/>
         </xsl:when>
         <xsl:when test="$number = '07'">
            <func:result select="'July'"/>
         </xsl:when>
         <xsl:when test="$number = '08'">
            <func:result select="'August'"/>
         </xsl:when>
         <xsl:when test="$number = '09'">
            <func:result select="'September'"/>
         </xsl:when>
         <xsl:when test="$number = '10'">
            <func:result select="'October'"/>
         </xsl:when>
         <xsl:when test="$number = '11'">
            <func:result select="'November'"/>
         </xsl:when>
         <xsl:when test="$number = '12'">
            <func:result select="'December'"/>
         </xsl:when>
      </xsl:choose>
   </func:function>

   <!-- left panel area creation -->

   <xsl:template name="leftpanel">
      <!-- We want to change visual of active link. So we need to know on which page we are -->
      <!-- Possible values are:
             - welcome
             - glossary
             - about
             - summary
             - daily
             - hourly
             - top_urls
             - lazy_urls
             - path
             - entry_page
             - exit_page
             - sites
             - response_codes
             - search_engines
             - referrers
             - users
             - browsers
             - countries
      -->
      <xsl:param name="cur_page"/>

      <!-- which month to use for links ?-->
      <xsl:param name="month"/>

      <!-- which month to use for years ?-->
      <xsl:param name="year"/>

      <td width="150">

         <table border="0" cellspacing="0" cellpadding="4">
            <tr><td bgcolor="#0654b6">
               <div class="LP_section_header">
                  The WebDruid
               </div>
            </td></tr>
            <tr><td>
               <div class="LP_section_item">
                  <xsl:if test="$cur_page != 'welcome'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'welcome'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">index.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'welcome'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Welcome
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'glossary'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'glossary'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">glossary.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'glossary'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Glossary
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'about'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'about'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">about.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'about'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     About
                  </xsl:element><br/>
               </div>
            </td></tr>
            <tr><td>
            </td></tr>
            <tr><td bgcolor="#0654b6">
               <div class="LP_section_header">
                  Statistics
               </div>
            </td></tr>
            <tr><td>
               <div class="LP_section_item">
                  <xsl:if test="$cur_page != 'summary'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'summary'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">summary.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'summary'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Summary
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'daily'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'daily'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">daily_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'daily'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Daily statistics
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'hourly'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'hourly'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">hourly_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'hourly'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Hourly statistics
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'topurls'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'topurls'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">topurls_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'topurls'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Most viewed Urls
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'lazyurls'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'lazyurls'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">lazyurls_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'lazyurls'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Less viewed Urls
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'path'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'path'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">path_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'path'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Path graph
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'entry_page'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'entry_page'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">entry_page_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'entry_page'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Entry pages
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'exit_page'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'exit_page'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">exit_page_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'exit_page'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Exit pages
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'sites'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'sites'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">sites_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'sites'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Sites
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'response_codes'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'response_codes'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">response_codes_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'response_codes'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Response codes
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'search_engines'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'search_engines'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">search_engines_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'search_engines'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Search engines
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'referrers'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'referrers'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">referrers_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'referrers'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Referrers
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'users'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'users'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">users_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'users'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Users
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'browsers'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'browsers'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">browsers_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'browsers'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Browsers
                  </xsl:element><br/>
                  <xsl:if test="$cur_page != 'countries'">
                     <img src="bullet.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:if test="$cur_page = 'countries'">
                     <img src="bullet2.png" width="12" height="12" align="absmiddle"/>
                  </xsl:if>
                  <xsl:element name="a">
                     <xsl:attribute name="href">countries_<xsl:value-of select="$year"/>_<xsl:value-of select="$month"/>_.html</xsl:attribute>
                     <xsl:if test="$cur_page = 'countries'">
                        <xsl:attribute name="class">RP_current_link</xsl:attribute>
                     </xsl:if>
                     Countries
                  </xsl:element><br/>
               </div>
            </td></tr>
         </table>
      </td>
   </xsl:template>

   <!-- header of the view -->

   <xsl:template name="header">
      <xsl:param name="page_title">page title</xsl:param>
      <xsl:param name="page_name">page_name</xsl:param>
      <xsl:param name="cur_month"></xsl:param>
      <xsl:param name="cur_year"></xsl:param>

      <form name="form">
         <p class="RP_title"><xsl:value-of select="$page_title"/></p>

         <p class="RP_site_name">
         <a href="" class="RP_month_text">
            <img src="left_arrow.png" width="12" height="12" align="absmiddle" border="0"/>
            Previous month -
         </a>
         <xsl:element name="select">
            <xsl:attribute name="name">month</xsl:attribute>
            <xsl:attribute name="onchange">window.location = window.document.form.month.value;</xsl:attribute>
            <xsl:for-each select="$history_settings/month">
               <xsl:element name="option">
                  <xsl:attribute name="value"><xsl:value-of select="concat($page_name, '_', ../@value, '_', @value, '.html')"/></xsl:attribute>
                  <xsl:if test="($cur_month = @value) and ($cur_year = ../@value)">
                     <xsl:attribute name="selected">yes</xsl:attribute>
                  </xsl:if>
                  <xsl:value-of select="concat(func:month_name(@value), ' ', ../@value)"/>
               </xsl:element>
            </xsl:for-each>
         </xsl:element>
         <a href="" class="RP_month_text">
            - Next Month
            <img src="right_arrow.png" width="12" height="12" align="absmiddle" border="0"/>
         </a></p>
         <p class="RP_site_name">
            <xsl:value-of select="/body/globalsettings/setting[@name='HostName']/value"/>
         </p>
      </form>
   </xsl:template>

   <!-- footer of the view -->

   <xsl:template name="footer">
      <xsl:param name="cur_month">month</xsl:param>
      <xsl:param name="cur_year">year</xsl:param>
      <p/>
      <div class="RP_report_date">
      <p>
         Document generated on
         <xsl:value-of select=" date:date-time() "/>
         by The WebDruid 'classic' skin release
         <xsl:value-of select=" $skin_version"/>
         <br/>
         Figures computed by The WebDruid engine release
         <xsl:value-of select=" /body/globalsettings/setting[@name='Version']/value "/>
      </p>
      </div>

      <div class="RP_month_text">
      <p class="RP_site_name"><a href="" class="RP_month_text"><img src="left_arrow.png" width="12" height="12" align="absmiddle" border="0"/>
         Previous month -</a><xsl:value-of select="concat(func:month_name($cur_month), ' ', $cur_year)"/><a href="" class="RP_month_text">- Next
         Month <img src="right_arrow.png" width="12" height="12" align="absmiddle" border="0"/></a></p>
      </div>
   </xsl:template>

</xsl:stylesheet>
