/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseIndexedTriangleGeometryNode;

public abstract class BaseIndexedTriangleSet
extends BaseIndexedTriangleGeometryNode {
    private static final int NUM_FIELDS = 13;
    private static final String MAX_INDEX_COUNT_MSG = "Max coordIndex value > number of coords in IndexedTriangleSet";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    private int[][] vertexToFace;
    private int maxIndexValue;

    protected BaseIndexedTriangleSet() {
        super("IndexedTriangleSet");
        this.hasChanged = new boolean[13];
    }

    protected BaseIndexedTriangleSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 12) {
            return null;
        }
        return fieldDecl[n];
    }

    protected void updateIndexMaps() {
        int n;
        this.maxIndexValue = 0;
        for (int i = 0; i < this.numIndex; ++i) {
            if (this.vfIndex[i] <= this.maxIndexValue) continue;
            this.maxIndexValue = this.vfIndex[i];
        }
        if (this.vfCoord != null && (this.maxIndexValue + 1) * 3 > this.vfCoord.getNumPoints()) {
            this.errorReporter.warningReport(MAX_INDEX_COUNT_MSG, null);
        }
        if (this.vertexToFace == null || this.vertexToFace.length < this.maxIndexValue + 1) {
            this.vertexToFace = new int[this.maxIndexValue + 1][];
        }
        int[] nArray = new int[this.maxIndexValue + 1];
        for (n = 0; n < this.numIndex; ++n) {
            int n2 = this.vfIndex[n];
            nArray[n2] = nArray[n2] + 1;
        }
        for (n = 0; n < this.maxIndexValue + 1; ++n) {
            if (this.vertexToFace[n] != null && this.vertexToFace[n].length == nArray[n]) continue;
            this.vertexToFace[n] = new int[nArray[n]];
        }
        for (n = 0; n < this.maxIndexValue + 1; ++n) {
            nArray[n] = 0;
        }
        n = 0;
        for (int i = 0; i < this.numIndex; ++i) {
            int n3 = this.vfIndex[i];
            int n4 = nArray[n3];
            this.vertexToFace[n3][n4] = n++;
            int n5 = n3;
            nArray[n5] = nArray[n5] + 1;
            if (i % 3 != 2) continue;
        }
    }

    static {
        nodeFields = new int[]{1, 3, 4, 2, 0};
        fieldDecl = new VRMLFieldDeclaration[13];
        fieldMap = new HashMap(39);
        BaseIndexedTriangleSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseIndexedTriangleSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseIndexedTriangleSet.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseIndexedTriangleSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseIndexedTriangleSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseIndexedTriangleSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseIndexedTriangleSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseIndexedTriangleSet.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseIndexedTriangleSet.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        BaseIndexedTriangleSet.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFInt32", "index");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        fieldMap.put("solid", new Integer(5));
        fieldMap.put("ccw", new Integer(6));
        fieldMap.put("colorPerVertex", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(8));
        fieldMap.put("index", new Integer(11));
        fieldMap.put("set_index", new Integer(12));
    }
}

