/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public abstract class BaseCoordinate
extends BaseGeometricPropertyNode
implements VRMLCoordinateNodeType {
    protected static final int FIELD_POINT = 1;
    protected static final int LAST_COORDINATE_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfPoint = FieldConstants.EMPTY_MFFLOAT;
    protected int numPoint;

    public BaseCoordinate() {
        super("Coordinate");
        this.hasChanged = new boolean[2];
    }

    public BaseCoordinate(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("point");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfPoint = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfPoint, 0, vRMLFieldData.numElements * 3);
                this.numPoint = vRMLFieldData.numElements * 3;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setPoint(float[] fArray, int n) {
        if (n > this.vfPoint.length) {
            this.vfPoint = new float[n];
        }
        this.numPoint = n;
        System.arraycopy(fArray, 0, this.vfPoint, 0, this.numPoint);
        if (!this.inSetup) {
            this.fireComponentChanged(1);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public int getNumPoints() {
        return this.numPoint;
    }

    public void getPoint(float[] fArray) {
        if (this.numPoint != 0) {
            System.arraycopy(this.vfPoint, 0, fArray, 0, this.numPoint);
        }
    }

    public float[] getPointRef() {
        return this.vfPoint;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 11;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numPoint / 3;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfPoint, this.numPoint);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setPoint(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseCoordinate.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCoordinate.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFVec3f", "point");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("point", n);
        fieldMap.put("set_point", n);
        fieldMap.put("point_changed", n);
    }
}

