/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_partial;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_opaque;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_partial (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_partial;
	return result;
}

void
vala_class_set_is_partial (ValaClass* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_partial = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_opaque (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_opaque;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "Compact", "opaque", FALSE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_opaque);
		self->priv->_is_opaque = _tmp2_;
	}
	_tmp3_ = self->priv->_is_opaque;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp25_ = FALSE;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_parameter_new ("this", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		vala_method_set_this_parameter (m, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_method_get_this_parameter (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_method_get_this_parameter (m);
		_tmp24_ = _tmp23_;
		vala_scope_add (_tmp18_, _tmp22_, (ValaSymbol*) _tmp24_);
	}
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp27_ = _tmp26_;
	if (!VALA_IS_VOID_TYPE (_tmp27_)) {
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp28_ = vala_method_get_postconditions (m);
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp30_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		ValaLocalVariable* _tmp48_;
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		if (_tmp32_ != NULL) {
			ValaScope* _tmp33_;
			ValaScope* _tmp34_;
			ValaLocalVariable* _tmp35_;
			ValaLocalVariable* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_scope_remove (_tmp34_, _tmp38_);
		}
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_copy (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_local_variable_new (_tmp42_, "result", NULL, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp46_);
		_vala_code_node_unref0 (_tmp46_);
		_vala_code_node_unref0 (_tmp42_);
		_tmp47_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp48_ = _tmp47_;
		vala_local_variable_set_is_result (_tmp48_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp50_ = _tmp49_;
		if (_tmp50_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp61_, "missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp16_;
	ValaField* _tmp17_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		vala_property_set_this_parameter (prop, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_property_get_this_parameter (prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp16_ = vala_property_get_field (prop);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaField* _tmp18_;
		ValaField* _tmp19_;
		_tmp18_ = vala_property_get_field (prop);
		_tmp19_ = _tmp18_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp19_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_constructor_set_this_parameter (c, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constructor_get_this_parameter (c);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_constructor_get_this_parameter (c);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_destructor_set_this_parameter (d, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_destructor_get_this_parameter (d);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_destructor_get_this_parameter (d);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp17_;
	ValaConstructor* _tmp18_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp29_;
	ValaDestructor* _tmp30_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp9_ = vala_class_get_constructor (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaConstructor* _tmp11_;
		ValaConstructor* _tmp12_;
		_tmp11_ = vala_class_get_constructor (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_class_get_class_constructor (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaConstructor* _tmp15_;
		ValaConstructor* _tmp16_;
		_tmp15_ = vala_class_get_class_constructor (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	_tmp17_ = vala_class_get_static_constructor (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaConstructor* _tmp19_;
		ValaConstructor* _tmp20_;
		_tmp19_ = vala_class_get_static_constructor (self);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
	_tmp21_ = vala_class_get_destructor (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaDestructor* _tmp23_;
		ValaDestructor* _tmp24_;
		_tmp23_ = vala_class_get_destructor (self);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
	}
	_tmp25_ = vala_class_get_static_destructor (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaDestructor* _tmp27_;
		ValaDestructor* _tmp28_;
		_tmp27_ = vala_class_get_static_destructor (self);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
	}
	_tmp29_ = vala_class_get_class_destructor (self);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		ValaDestructor* _tmp31_;
		ValaDestructor* _tmp32_;
		_tmp31_ = vala_class_get_class_destructor (self);
		_tmp32_ = _tmp31_;
		vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp18_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_prereq_index = _prereq_index + 1;
			_tmp4_ = _prereq_index;
			_tmp5_ = _prereq_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prereq_list;
			_tmp7_ = vala_list_get (_tmp6_, _prereq_index);
			prereq = (ValaDataType*) _tmp7_;
			_tmp8_ = prereq;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			type = _tmp11_;
			_tmp12_ = type;
			if (_tmp12_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp13_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp13_);
			_tmp14_ = type;
			if (VALA_IS_INTERFACE (_tmp14_)) {
				ValaTypeSymbol* _tmp15_;
				_tmp15_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_CLASS (_tmp10_)) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			} else {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp71_ = FALSE;
	ValaClass* _tmp72_;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp107_ = FALSE;
	ValaClass* _tmp108_;
	gboolean _tmp118_;
	ValaConstructor* _tmp233_;
	ValaConstructor* _tmp234_;
	ValaConstructor* _tmp237_;
	ValaConstructor* _tmp238_;
	ValaConstructor* _tmp241_;
	ValaConstructor* _tmp242_;
	ValaDestructor* _tmp245_;
	ValaDestructor* _tmp246_;
	ValaDestructor* _tmp249_;
	ValaDestructor* _tmp250_;
	ValaDestructor* _tmp253_;
	ValaDestructor* _tmp254_;
	gboolean _tmp293_;
	gboolean _tmp294_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp335_;
	ValaArrayList* _tmp336_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp352_;
	ValaArrayList* _tmp353_;
	ValaList* _tmp367_;
	gint _tmp368_;
	gint _tmp369_;
	ValaSourceFileType _tmp393_;
	ValaSourceFileType _tmp394_;
	ValaSemanticAnalyzer* _tmp611_;
	ValaSemanticAnalyzer* _tmp612_;
	ValaSourceFile* _tmp613_;
	ValaSemanticAnalyzer* _tmp614_;
	ValaSemanticAnalyzer* _tmp615_;
	ValaSymbol* _tmp616_;
	gboolean _tmp617_;
	gboolean _tmp618_;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp41_;
			ValaDataType* _tmp49_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp28_ = _base_type_reference_index;
			_tmp29_ = _base_type_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _base_type_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp32_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp33_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp33_)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = base_type_reference;
				_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp35_, "base type `%s' of class `%s' is not an object type", _tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = base_type_reference;
			if (!vala_data_type_is_accessible (_tmp41_, (ValaSymbol*) self)) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaDataType* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = base_type_reference;
				_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp48_ = _tmp47_;
				vala_report_error (_tmp43_, "base type `%s' is less accessible than class `%s'", _tmp46_, _tmp48_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp49_ = base_type_reference;
			if (!vala_data_type_check_type_arguments (_tmp49_, context, FALSE)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (base_type_reference);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp50_;
		gint _type_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _type_index = 0;
		_tmp50_ = self->priv->base_types;
		_type_list = _tmp50_;
		_tmp51_ = _type_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_type_size = _tmp53_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp54_;
			gint _tmp55_;
			ValaDataType* type = NULL;
			ValaList* _tmp56_;
			gpointer _tmp57_;
			ValaDataType* _tmp58_;
			ValaSemanticAnalyzer* _tmp59_;
			ValaSemanticAnalyzer* _tmp60_;
			ValaDataType* _tmp61_;
			_type_index = _type_index + 1;
			_tmp54_ = _type_index;
			_tmp55_ = _type_size;
			if (!(_tmp54_ < _tmp55_)) {
				break;
			}
			_tmp56_ = _type_list;
			_tmp57_ = vala_list_get (_tmp56_, _type_index);
			type = (ValaDataType*) _tmp57_;
			_tmp58_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp58_, context);
			_tmp59_ = vala_code_context_get_analyzer (context);
			_tmp60_ = _tmp59_;
			_tmp61_ = type;
			vala_semantic_analyzer_check_type (_tmp60_, _tmp61_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp62_;
		gint _p_size = 0;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _p_index = 0;
		_tmp62_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp62_;
		_tmp63_ = _p_list;
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_p_size = _tmp65_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaTypeParameter* _tmp70_;
			_p_index = _p_index + 1;
			_tmp66_ = _p_index;
			_tmp67_ = _p_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _p_list;
			_tmp69_ = vala_list_get (_tmp68_, _p_index);
			p = (ValaTypeParameter*) _tmp69_;
			_tmp70_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp70_, context);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp72_ = self->priv->_base_class;
	if (_tmp72_ != NULL) {
		ValaClass* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp73_ = self->priv->_base_class;
		_tmp74_ = vala_class_get_is_singleton (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp71_ = _tmp75_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		ValaSourceReference* _tmp76_;
		ValaSourceReference* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		ValaClass* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = self->priv->_base_class;
		_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp80_);
		_tmp82_ = _tmp81_;
		vala_report_error (_tmp77_, "`%s' cannot inherit from SingleInstance class `%s'", _tmp79_, _tmp82_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp79_);
	}
	_tmp84_ = vala_class_get_is_singleton (self);
	_tmp85_ = _tmp84_;
	if (_tmp85_) {
		ValaSemanticAnalyzer* _tmp86_;
		ValaSemanticAnalyzer* _tmp87_;
		ValaClass* _tmp88_;
		_tmp86_ = vala_code_context_get_analyzer (context);
		_tmp87_ = _tmp86_;
		_tmp88_ = _tmp87_->object_type;
		_tmp83_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp88_);
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp90_, "SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp92_);
		_g_free0 (_tmp92_);
	}
	_tmp94_ = vala_class_get_is_singleton (self);
	_tmp95_ = _tmp94_;
	if (_tmp95_) {
		ValaConstructor* _tmp96_;
		ValaConstructor* _tmp97_;
		_tmp96_ = vala_class_get_constructor (self);
		_tmp97_ = _tmp96_;
		_tmp93_ = _tmp97_ == NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		ValaConstructor* _tmp100_;
		ValaConstructor* _tmp101_;
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaBlock* _tmp104_;
		ValaBlock* _tmp105_;
		ValaConstructor* _tmp106_;
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_constructor_new (_tmp99_);
		c = _tmp100_;
		_tmp101_ = c;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_block_new (_tmp103_);
		_tmp105_ = _tmp104_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp101_, _tmp105_);
		_vala_code_node_unref0 (_tmp105_);
		_tmp106_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp106_);
		_vala_code_node_unref0 (c);
	}
	_tmp108_ = self->priv->_base_class;
	if (_tmp108_ != NULL) {
		ValaClass* _tmp109_;
		gboolean _tmp110_;
		_tmp109_ = self->priv->_base_class;
		_tmp110_ = _tmp109_->priv->_is_sealed;
		_tmp107_ = _tmp110_;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaSourceReference* _tmp111_;
		ValaSourceReference* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
		ValaClass* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = self->priv->_base_class;
		_tmp116_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp115_);
		_tmp117_ = _tmp116_;
		vala_report_error (_tmp112_, "`%s' cannot inherit from sealed class `%s'", _tmp114_, _tmp117_);
		_g_free0 (_tmp117_);
		_g_free0 (_tmp114_);
	}
	_tmp118_ = self->priv->_is_sealed;
	if (_tmp118_) {
		gboolean _tmp119_;
		gboolean _tmp120_;
		gboolean _tmp125_;
		_tmp119_ = vala_class_get_is_compact (self);
		_tmp120_ = _tmp119_;
		if (_tmp120_) {
			ValaSourceReference* _tmp121_;
			ValaSourceReference* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp122_, "Sealed class `%s' cannot be compact", _tmp124_);
			_g_free0 (_tmp124_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp125_ = self->priv->_is_abstract;
		if (_tmp125_) {
			ValaSourceReference* _tmp126_;
			ValaSourceReference* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp129_ = _tmp128_;
			vala_report_error (_tmp127_, "Sealed class `%s' cannot be abstract", _tmp129_);
			_g_free0 (_tmp129_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp130_;
		gint _en_size = 0;
		ValaList* _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
		gint _en_index = 0;
		_tmp130_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp130_;
		_tmp131_ = _en_list;
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		_en_size = _tmp133_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp134_;
			gint _tmp135_;
			ValaEnum* en = NULL;
			ValaList* _tmp136_;
			gpointer _tmp137_;
			ValaEnum* _tmp138_;
			_en_index = _en_index + 1;
			_tmp134_ = _en_index;
			_tmp135_ = _en_size;
			if (!(_tmp134_ < _tmp135_)) {
				break;
			}
			_tmp136_ = _en_list;
			_tmp137_ = vala_list_get (_tmp136_, _en_index);
			en = (ValaEnum*) _tmp137_;
			_tmp138_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp138_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp139_;
		gint _f_size = 0;
		ValaList* _tmp140_;
		gint _tmp141_;
		gint _tmp142_;
		gint _f_index = 0;
		_tmp139_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp139_;
		_tmp140_ = _f_list;
		_tmp141_ = vala_collection_get_size ((ValaCollection*) _tmp140_);
		_tmp142_ = _tmp141_;
		_f_size = _tmp142_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp143_;
			gint _tmp144_;
			ValaField* f = NULL;
			ValaList* _tmp145_;
			gpointer _tmp146_;
			gboolean _tmp147_ = FALSE;
			gboolean _tmp148_;
			gboolean _tmp149_;
			ValaField* _tmp187_;
			_f_index = _f_index + 1;
			_tmp143_ = _f_index;
			_tmp144_ = _f_size;
			if (!(_tmp143_ < _tmp144_)) {
				break;
			}
			_tmp145_ = _f_list;
			_tmp146_ = vala_list_get (_tmp145_, _f_index);
			f = (ValaField*) _tmp146_;
			_tmp148_ = vala_class_get_is_compact (self);
			_tmp149_ = _tmp148_;
			if (_tmp149_) {
				ValaField* _tmp150_;
				ValaMemberBinding _tmp151_;
				ValaMemberBinding _tmp152_;
				_tmp150_ = f;
				_tmp151_ = vala_field_get_binding (_tmp150_);
				_tmp152_ = _tmp151_;
				_tmp147_ = _tmp152_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp147_ = FALSE;
			}
			if (_tmp147_) {
				gboolean _tmp153_ = FALSE;
				gboolean _tmp154_ = FALSE;
				gboolean _tmp155_;
				gboolean _tmp156_;
				gboolean _tmp165_ = FALSE;
				gboolean _tmp166_ = FALSE;
				gboolean _tmp167_;
				gboolean _tmp168_;
				ValaField* _tmp181_;
				ValaMemberBinding _tmp182_;
				ValaMemberBinding _tmp183_;
				_tmp155_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp156_ = _tmp155_;
				if (!_tmp156_) {
					gboolean _tmp157_;
					gboolean _tmp158_;
					_tmp157_ = vala_class_get_is_opaque (self);
					_tmp158_ = _tmp157_;
					_tmp154_ = !_tmp158_;
				} else {
					_tmp154_ = FALSE;
				}
				if (_tmp154_) {
					ValaField* _tmp159_;
					ValaSymbolAccessibility _tmp160_;
					ValaSymbolAccessibility _tmp161_;
					_tmp159_ = f;
					_tmp160_ = vala_symbol_get_access ((ValaSymbol*) _tmp159_);
					_tmp161_ = _tmp160_;
					_tmp153_ = _tmp161_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp153_ = FALSE;
				}
				if (_tmp153_) {
					ValaField* _tmp162_;
					ValaSourceReference* _tmp163_;
					ValaSourceReference* _tmp164_;
					_tmp162_ = f;
					_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp162_);
					_tmp164_ = _tmp163_;
					vala_report_error (_tmp164_, "private fields are only supported in opaque compact classes, use [Comp" \
"act (opaque = true)]");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp167_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp168_ = _tmp167_;
				if (!_tmp168_) {
					gboolean _tmp169_;
					gboolean _tmp170_;
					_tmp169_ = vala_class_get_is_opaque (self);
					_tmp170_ = _tmp169_;
					_tmp166_ = _tmp170_;
				} else {
					_tmp166_ = FALSE;
				}
				if (_tmp166_) {
					gboolean _tmp171_ = FALSE;
					ValaField* _tmp172_;
					ValaSymbolAccessibility _tmp173_;
					ValaSymbolAccessibility _tmp174_;
					_tmp172_ = f;
					_tmp173_ = vala_symbol_get_access ((ValaSymbol*) _tmp172_);
					_tmp174_ = _tmp173_;
					if (_tmp174_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						_tmp171_ = TRUE;
					} else {
						ValaField* _tmp175_;
						ValaSymbolAccessibility _tmp176_;
						ValaSymbolAccessibility _tmp177_;
						_tmp175_ = f;
						_tmp176_ = vala_symbol_get_access ((ValaSymbol*) _tmp175_);
						_tmp177_ = _tmp176_;
						_tmp171_ = _tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
					}
					_tmp165_ = _tmp171_;
				} else {
					_tmp165_ = FALSE;
				}
				if (_tmp165_) {
					ValaField* _tmp178_;
					ValaSourceReference* _tmp179_;
					ValaSourceReference* _tmp180_;
					_tmp178_ = f;
					_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp178_);
					_tmp180_ = _tmp179_;
					vala_report_error (_tmp180_, "fields in opaque compact classes must be private or internal");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp181_ = f;
				_tmp182_ = vala_field_get_binding (_tmp181_);
				_tmp183_ = _tmp182_;
				if (_tmp183_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaSourceReference* _tmp186_;
					_tmp184_ = f;
					_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp184_);
					_tmp186_ = _tmp185_;
					vala_report_error (_tmp186_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp187_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp187_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp188_;
		gint _c_size = 0;
		ValaList* _tmp189_;
		gint _tmp190_;
		gint _tmp191_;
		gint _c_index = 0;
		_tmp188_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp188_;
		_tmp189_ = _c_list;
		_tmp190_ = vala_collection_get_size ((ValaCollection*) _tmp189_);
		_tmp191_ = _tmp190_;
		_c_size = _tmp191_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp192_;
			gint _tmp193_;
			ValaConstant* c = NULL;
			ValaList* _tmp194_;
			gpointer _tmp195_;
			ValaConstant* _tmp196_;
			_c_index = _c_index + 1;
			_tmp192_ = _c_index;
			_tmp193_ = _c_size;
			if (!(_tmp192_ < _tmp193_)) {
				break;
			}
			_tmp194_ = _c_list;
			_tmp195_ = vala_list_get (_tmp194_, _c_index);
			c = (ValaConstant*) _tmp195_;
			_tmp196_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp196_, context);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp197_;
		gint _m_size = 0;
		ValaList* _tmp198_;
		gint _tmp199_;
		gint _tmp200_;
		gint _m_index = 0;
		_tmp197_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp197_;
		_tmp198_ = _m_list;
		_tmp199_ = vala_collection_get_size ((ValaCollection*) _tmp198_);
		_tmp200_ = _tmp199_;
		_m_size = _tmp200_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp201_;
			gint _tmp202_;
			ValaMethod* m = NULL;
			ValaList* _tmp203_;
			gpointer _tmp204_;
			ValaMethod* _tmp205_;
			_m_index = _m_index + 1;
			_tmp201_ = _m_index;
			_tmp202_ = _m_size;
			if (!(_tmp201_ < _tmp202_)) {
				break;
			}
			_tmp203_ = _m_list;
			_tmp204_ = vala_list_get (_tmp203_, _m_index);
			m = (ValaMethod*) _tmp204_;
			_tmp205_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp205_, context);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp206_;
		gint _prop_size = 0;
		ValaList* _tmp207_;
		gint _tmp208_;
		gint _tmp209_;
		gint _prop_index = 0;
		_tmp206_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp206_;
		_tmp207_ = _prop_list;
		_tmp208_ = vala_collection_get_size ((ValaCollection*) _tmp207_);
		_tmp209_ = _tmp208_;
		_prop_size = _tmp209_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp210_;
			gint _tmp211_;
			ValaProperty* prop = NULL;
			ValaList* _tmp212_;
			gpointer _tmp213_;
			gboolean _tmp214_ = FALSE;
			ValaProperty* _tmp215_;
			ValaAttribute* _tmp216_;
			ValaProperty* _tmp223_;
			_prop_index = _prop_index + 1;
			_tmp210_ = _prop_index;
			_tmp211_ = _prop_size;
			if (!(_tmp210_ < _tmp211_)) {
				break;
			}
			_tmp212_ = _prop_list;
			_tmp213_ = vala_list_get (_tmp212_, _prop_index);
			prop = (ValaProperty*) _tmp213_;
			_tmp215_ = prop;
			_tmp216_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp215_, "NoAccessorMethod");
			if (_tmp216_ != NULL) {
				ValaSemanticAnalyzer* _tmp217_;
				ValaSemanticAnalyzer* _tmp218_;
				ValaClass* _tmp219_;
				_tmp217_ = vala_code_context_get_analyzer (context);
				_tmp218_ = _tmp217_;
				_tmp219_ = _tmp218_->object_type;
				_tmp214_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp219_);
			} else {
				_tmp214_ = FALSE;
			}
			if (_tmp214_) {
				ValaProperty* _tmp220_;
				ValaSourceReference* _tmp221_;
				ValaSourceReference* _tmp222_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp220_ = prop;
				_tmp221_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp220_);
				_tmp222_ = _tmp221_;
				vala_report_error (_tmp222_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp223_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp223_, context);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp224_;
		gint _sig_size = 0;
		ValaList* _tmp225_;
		gint _tmp226_;
		gint _tmp227_;
		gint _sig_index = 0;
		_tmp224_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp224_;
		_tmp225_ = _sig_list;
		_tmp226_ = vala_collection_get_size ((ValaCollection*) _tmp225_);
		_tmp227_ = _tmp226_;
		_sig_size = _tmp227_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp228_;
			gint _tmp229_;
			ValaSignal* sig = NULL;
			ValaList* _tmp230_;
			gpointer _tmp231_;
			ValaSignal* _tmp232_;
			_sig_index = _sig_index + 1;
			_tmp228_ = _sig_index;
			_tmp229_ = _sig_size;
			if (!(_tmp228_ < _tmp229_)) {
				break;
			}
			_tmp230_ = _sig_list;
			_tmp231_ = vala_list_get (_tmp230_, _sig_index);
			sig = (ValaSignal*) _tmp231_;
			_tmp232_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
			_vala_code_node_unref0 (sig);
		}
	}
	_tmp233_ = vala_class_get_constructor (self);
	_tmp234_ = _tmp233_;
	if (_tmp234_ != NULL) {
		ValaConstructor* _tmp235_;
		ValaConstructor* _tmp236_;
		_tmp235_ = vala_class_get_constructor (self);
		_tmp236_ = _tmp235_;
		vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
	}
	_tmp237_ = vala_class_get_class_constructor (self);
	_tmp238_ = _tmp237_;
	if (_tmp238_ != NULL) {
		ValaConstructor* _tmp239_;
		ValaConstructor* _tmp240_;
		_tmp239_ = vala_class_get_class_constructor (self);
		_tmp240_ = _tmp239_;
		vala_code_node_check ((ValaCodeNode*) _tmp240_, context);
	}
	_tmp241_ = vala_class_get_static_constructor (self);
	_tmp242_ = _tmp241_;
	if (_tmp242_ != NULL) {
		ValaConstructor* _tmp243_;
		ValaConstructor* _tmp244_;
		_tmp243_ = vala_class_get_static_constructor (self);
		_tmp244_ = _tmp243_;
		vala_code_node_check ((ValaCodeNode*) _tmp244_, context);
	}
	_tmp245_ = vala_class_get_destructor (self);
	_tmp246_ = _tmp245_;
	if (_tmp246_ != NULL) {
		ValaDestructor* _tmp247_;
		ValaDestructor* _tmp248_;
		_tmp247_ = vala_class_get_destructor (self);
		_tmp248_ = _tmp247_;
		vala_code_node_check ((ValaCodeNode*) _tmp248_, context);
	}
	_tmp249_ = vala_class_get_static_destructor (self);
	_tmp250_ = _tmp249_;
	if (_tmp250_ != NULL) {
		ValaDestructor* _tmp251_;
		ValaDestructor* _tmp252_;
		_tmp251_ = vala_class_get_static_destructor (self);
		_tmp252_ = _tmp251_;
		vala_code_node_check ((ValaCodeNode*) _tmp252_, context);
	}
	_tmp253_ = vala_class_get_class_destructor (self);
	_tmp254_ = _tmp253_;
	if (_tmp254_ != NULL) {
		ValaDestructor* _tmp255_;
		ValaDestructor* _tmp256_;
		_tmp255_ = vala_class_get_class_destructor (self);
		_tmp256_ = _tmp255_;
		vala_code_node_check ((ValaCodeNode*) _tmp256_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp257_;
		gint _cl_size = 0;
		ValaList* _tmp258_;
		gint _tmp259_;
		gint _tmp260_;
		gint _cl_index = 0;
		_tmp257_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp257_;
		_tmp258_ = _cl_list;
		_tmp259_ = vala_collection_get_size ((ValaCollection*) _tmp258_);
		_tmp260_ = _tmp259_;
		_cl_size = _tmp260_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp261_;
			gint _tmp262_;
			ValaClass* cl = NULL;
			ValaList* _tmp263_;
			gpointer _tmp264_;
			ValaClass* _tmp265_;
			_cl_index = _cl_index + 1;
			_tmp261_ = _cl_index;
			_tmp262_ = _cl_size;
			if (!(_tmp261_ < _tmp262_)) {
				break;
			}
			_tmp263_ = _cl_list;
			_tmp264_ = vala_list_get (_tmp263_, _cl_index);
			cl = (ValaClass*) _tmp264_;
			_tmp265_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp265_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp266_;
		gint _iface_size = 0;
		ValaList* _tmp267_;
		gint _tmp268_;
		gint _tmp269_;
		gint _iface_index = 0;
		_tmp266_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp266_;
		_tmp267_ = _iface_list;
		_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
		_tmp269_ = _tmp268_;
		_iface_size = _tmp269_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp270_;
			gint _tmp271_;
			ValaInterface* iface = NULL;
			ValaList* _tmp272_;
			gpointer _tmp273_;
			ValaInterface* _tmp274_;
			_iface_index = _iface_index + 1;
			_tmp270_ = _iface_index;
			_tmp271_ = _iface_size;
			if (!(_tmp270_ < _tmp271_)) {
				break;
			}
			_tmp272_ = _iface_list;
			_tmp273_ = vala_list_get (_tmp272_, _iface_index);
			iface = (ValaInterface*) _tmp273_;
			_tmp274_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp274_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp275_;
		gint _st_size = 0;
		ValaList* _tmp276_;
		gint _tmp277_;
		gint _tmp278_;
		gint _st_index = 0;
		_tmp275_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp275_;
		_tmp276_ = _st_list;
		_tmp277_ = vala_collection_get_size ((ValaCollection*) _tmp276_);
		_tmp278_ = _tmp277_;
		_st_size = _tmp278_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp279_;
			gint _tmp280_;
			ValaStruct* st = NULL;
			ValaList* _tmp281_;
			gpointer _tmp282_;
			ValaStruct* _tmp283_;
			_st_index = _st_index + 1;
			_tmp279_ = _st_index;
			_tmp280_ = _st_size;
			if (!(_tmp279_ < _tmp280_)) {
				break;
			}
			_tmp281_ = _st_list;
			_tmp282_ = vala_list_get (_tmp281_, _st_index);
			st = (ValaStruct*) _tmp282_;
			_tmp283_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp283_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp284_;
		gint _d_size = 0;
		ValaList* _tmp285_;
		gint _tmp286_;
		gint _tmp287_;
		gint _d_index = 0;
		_tmp284_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp284_;
		_tmp285_ = _d_list;
		_tmp286_ = vala_collection_get_size ((ValaCollection*) _tmp285_);
		_tmp287_ = _tmp286_;
		_d_size = _tmp287_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp288_;
			gint _tmp289_;
			ValaDelegate* d = NULL;
			ValaList* _tmp290_;
			gpointer _tmp291_;
			ValaDelegate* _tmp292_;
			_d_index = _d_index + 1;
			_tmp288_ = _d_index;
			_tmp289_ = _d_size;
			if (!(_tmp288_ < _tmp289_)) {
				break;
			}
			_tmp290_ = _d_list;
			_tmp291_ = vala_list_get (_tmp290_, _d_index);
			d = (ValaDelegate*) _tmp291_;
			_tmp292_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp292_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp293_ = vala_class_get_is_compact (self);
	_tmp294_ = _tmp293_;
	if (_tmp294_) {
		gboolean _tmp310_ = FALSE;
		gboolean _tmp311_ = FALSE;
		gboolean _tmp312_ = FALSE;
		gboolean _tmp313_;
		gboolean _tmp314_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp295_;
			gint _base_type_size = 0;
			ValaList* _tmp296_;
			gint _tmp297_;
			gint _tmp298_;
			gint _base_type_index = 0;
			_tmp295_ = vala_class_get_base_types (self);
			_base_type_list = _tmp295_;
			_tmp296_ = _base_type_list;
			_tmp297_ = vala_collection_get_size ((ValaCollection*) _tmp296_);
			_tmp298_ = _tmp297_;
			_base_type_size = _tmp298_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp299_;
				gint _tmp300_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp301_;
				gpointer _tmp302_;
				ValaDataType* _tmp303_;
				ValaTypeSymbol* _tmp304_;
				ValaTypeSymbol* _tmp305_;
				_base_type_index = _base_type_index + 1;
				_tmp299_ = _base_type_index;
				_tmp300_ = _base_type_size;
				if (!(_tmp299_ < _tmp300_)) {
					break;
				}
				_tmp301_ = _base_type_list;
				_tmp302_ = vala_list_get (_tmp301_, _base_type_index);
				base_type = (ValaDataType*) _tmp302_;
				_tmp303_ = base_type;
				_tmp304_ = vala_data_type_get_type_symbol (_tmp303_);
				_tmp305_ = _tmp304_;
				if (VALA_IS_INTERFACE (_tmp305_)) {
					ValaSourceReference* _tmp306_;
					ValaSourceReference* _tmp307_;
					gchar* _tmp308_;
					gchar* _tmp309_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp307_ = _tmp306_;
					_tmp308_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp309_ = _tmp308_;
					vala_report_error (_tmp307_, "compact classes `%s' may not implement interfaces", _tmp309_);
					_g_free0 (_tmp309_);
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp313_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp314_ = _tmp313_;
		if (!_tmp314_) {
			gboolean _tmp315_;
			gboolean _tmp316_;
			_tmp315_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp316_ = _tmp315_;
			_tmp312_ = !_tmp316_;
		} else {
			_tmp312_ = FALSE;
		}
		if (_tmp312_) {
			ValaClass* _tmp317_;
			_tmp317_ = self->priv->_base_class;
			_tmp311_ = _tmp317_ != NULL;
		} else {
			_tmp311_ = FALSE;
		}
		if (_tmp311_) {
			ValaClass* _tmp318_;
			ValaSemanticAnalyzer* _tmp319_;
			ValaSemanticAnalyzer* _tmp320_;
			ValaClass* _tmp321_;
			_tmp318_ = self->priv->_base_class;
			_tmp319_ = vala_code_context_get_analyzer (context);
			_tmp320_ = _tmp319_;
			_tmp321_ = _tmp320_->gsource_type;
			_tmp310_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp318_, (ValaTypeSymbol*) _tmp321_);
		} else {
			_tmp310_ = FALSE;
		}
		if (_tmp310_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp322_;
				gint _f_size = 0;
				ValaList* _tmp323_;
				gint _tmp324_;
				gint _tmp325_;
				gint _f_index = 0;
				_tmp322_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp322_;
				_tmp323_ = _f_list;
				_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
				_tmp325_ = _tmp324_;
				_f_size = _tmp325_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp326_;
					gint _tmp327_;
					ValaField* f = NULL;
					ValaList* _tmp328_;
					gpointer _tmp329_;
					ValaField* _tmp330_;
					ValaMemberBinding _tmp331_;
					ValaMemberBinding _tmp332_;
					_f_index = _f_index + 1;
					_tmp326_ = _f_index;
					_tmp327_ = _f_size;
					if (!(_tmp326_ < _tmp327_)) {
						break;
					}
					_tmp328_ = _f_list;
					_tmp329_ = vala_list_get (_tmp328_, _f_index);
					f = (ValaField*) _tmp329_;
					_tmp330_ = f;
					_tmp331_ = vala_field_get_binding (_tmp330_);
					_tmp332_ = _tmp331_;
					if (_tmp332_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp333_;
						ValaSourceReference* _tmp334_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp333_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp334_ = _tmp333_;
						vala_report_error (_tmp334_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
	}
	_tmp335_ = g_direct_equal;
	_tmp336_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp335_);
	prerequisites = (ValaList*) _tmp336_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp337_;
		gint _base_type_size = 0;
		ValaList* _tmp338_;
		gint _tmp339_;
		gint _tmp340_;
		gint _base_type_index = 0;
		_tmp337_ = vala_class_get_base_types (self);
		_base_type_list = _tmp337_;
		_tmp338_ = _base_type_list;
		_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
		_tmp340_ = _tmp339_;
		_base_type_size = _tmp340_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp341_;
			gint _tmp342_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp343_;
			gpointer _tmp344_;
			ValaDataType* _tmp345_;
			ValaTypeSymbol* _tmp346_;
			ValaTypeSymbol* _tmp347_;
			_base_type_index = _base_type_index + 1;
			_tmp341_ = _base_type_index;
			_tmp342_ = _base_type_size;
			if (!(_tmp341_ < _tmp342_)) {
				break;
			}
			_tmp343_ = _base_type_list;
			_tmp344_ = vala_list_get (_tmp343_, _base_type_index);
			base_type = (ValaDataType*) _tmp344_;
			_tmp345_ = base_type;
			_tmp346_ = vala_data_type_get_type_symbol (_tmp345_);
			_tmp347_ = _tmp346_;
			if (VALA_IS_INTERFACE (_tmp347_)) {
				ValaDataType* _tmp348_;
				ValaTypeSymbol* _tmp349_;
				ValaTypeSymbol* _tmp350_;
				ValaList* _tmp351_;
				_tmp348_ = base_type;
				_tmp349_ = vala_data_type_get_type_symbol (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp351_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp350_, VALA_TYPE_INTERFACE, ValaInterface), _tmp351_);
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	_tmp352_ = g_str_equal;
	_tmp353_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp352_);
	missing_prereqs = (ValaList*) _tmp353_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp354_;
		gint _prereq_size = 0;
		ValaList* _tmp355_;
		gint _tmp356_;
		gint _tmp357_;
		gint _prereq_index = 0;
		_tmp354_ = prerequisites;
		_prereq_list = _tmp354_;
		_tmp355_ = _prereq_list;
		_tmp356_ = vala_collection_get_size ((ValaCollection*) _tmp355_);
		_tmp357_ = _tmp356_;
		_prereq_size = _tmp357_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp358_;
			gint _tmp359_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp360_;
			gpointer _tmp361_;
			ValaTypeSymbol* _tmp362_;
			_prereq_index = _prereq_index + 1;
			_tmp358_ = _prereq_index;
			_tmp359_ = _prereq_size;
			if (!(_tmp358_ < _tmp359_)) {
				break;
			}
			_tmp360_ = _prereq_list;
			_tmp361_ = vala_list_get (_tmp360_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp361_;
			_tmp362_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp362_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp363_;
				ValaTypeSymbol* _tmp364_;
				gchar* _tmp365_;
				gchar* _tmp366_;
				_tmp363_ = missing_prereqs;
				_tmp364_ = prereq;
				_tmp365_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp364_);
				_tmp366_ = _tmp365_;
				vala_list_insert (_tmp363_, 0, _tmp366_);
				_g_free0 (_tmp366_);
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	_tmp367_ = missing_prereqs;
	_tmp368_ = vala_collection_get_size ((ValaCollection*) _tmp367_);
	_tmp369_ = _tmp368_;
	if (_tmp369_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp370_;
		gchar* _tmp371_;
		gchar* _tmp372_;
		gchar* _tmp373_;
		gboolean first = FALSE;
		const gchar* _tmp388_;
		gchar* _tmp389_;
		ValaSourceReference* _tmp390_;
		ValaSourceReference* _tmp391_;
		const gchar* _tmp392_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp370_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp371_ = _tmp370_;
		_tmp372_ = g_strdup_printf ("%s: some prerequisites (", _tmp371_);
		_tmp373_ = _tmp372_;
		_g_free0 (_tmp371_);
		error_string = _tmp373_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp374_;
			gint _s_size = 0;
			ValaList* _tmp375_;
			gint _tmp376_;
			gint _tmp377_;
			gint _s_index = 0;
			_tmp374_ = missing_prereqs;
			_s_list = _tmp374_;
			_tmp375_ = _s_list;
			_tmp376_ = vala_collection_get_size ((ValaCollection*) _tmp375_);
			_tmp377_ = _tmp376_;
			_s_size = _tmp377_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp378_;
				gint _tmp379_;
				gchar* s = NULL;
				ValaList* _tmp380_;
				gpointer _tmp381_;
				_s_index = _s_index + 1;
				_tmp378_ = _s_index;
				_tmp379_ = _s_size;
				if (!(_tmp378_ < _tmp379_)) {
					break;
				}
				_tmp380_ = _s_list;
				_tmp381_ = vala_list_get (_tmp380_, _s_index);
				s = (gchar*) _tmp381_;
				if (first) {
					const gchar* _tmp382_;
					const gchar* _tmp383_;
					gchar* _tmp384_;
					_tmp382_ = error_string;
					_tmp383_ = s;
					_tmp384_ = g_strdup_printf ("%s`%s'", _tmp382_, _tmp383_);
					_g_free0 (error_string);
					error_string = _tmp384_;
					first = FALSE;
				} else {
					const gchar* _tmp385_;
					const gchar* _tmp386_;
					gchar* _tmp387_;
					_tmp385_ = error_string;
					_tmp386_ = s;
					_tmp387_ = g_strdup_printf ("%s, `%s'", _tmp385_, _tmp386_);
					_g_free0 (error_string);
					error_string = _tmp387_;
				}
				_g_free0 (s);
			}
		}
		_tmp388_ = error_string;
		_tmp389_ = g_strconcat (_tmp388_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp389_;
		_tmp390_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp391_ = _tmp390_;
		_tmp392_ = error_string;
		vala_report_error (_tmp391_, "%s", _tmp392_);
		_g_free0 (error_string);
	}
	_tmp393_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp394_ = _tmp393_;
	if (_tmp394_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp545_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp395_;
			gint _base_type_size = 0;
			ValaList* _tmp396_;
			gint _tmp397_;
			gint _tmp398_;
			gint _base_type_index = 0;
			_tmp395_ = vala_class_get_base_types (self);
			_base_type_list = _tmp395_;
			_tmp396_ = _base_type_list;
			_tmp397_ = vala_collection_get_size ((ValaCollection*) _tmp396_);
			_tmp398_ = _tmp397_;
			_base_type_size = _tmp398_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp399_;
				gint _tmp400_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp401_;
				gpointer _tmp402_;
				ValaDataType* _tmp403_;
				ValaTypeSymbol* _tmp404_;
				ValaTypeSymbol* _tmp405_;
				_base_type_index = _base_type_index + 1;
				_tmp399_ = _base_type_index;
				_tmp400_ = _base_type_size;
				if (!(_tmp399_ < _tmp400_)) {
					break;
				}
				_tmp401_ = _base_type_list;
				_tmp402_ = vala_list_get (_tmp401_, _base_type_index);
				base_type = (ValaDataType*) _tmp402_;
				_tmp403_ = base_type;
				_tmp404_ = vala_data_type_get_type_symbol (_tmp403_);
				_tmp405_ = _tmp404_;
				if (VALA_IS_INTERFACE (_tmp405_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp406_;
					ValaTypeSymbol* _tmp407_;
					ValaTypeSymbol* _tmp408_;
					gboolean _tmp409_ = FALSE;
					ValaClass* _tmp410_;
					_tmp406_ = base_type;
					_tmp407_ = vala_data_type_get_type_symbol (_tmp406_);
					_tmp408_ = _tmp407_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp408_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp410_ = self->priv->_base_class;
					if (_tmp410_ != NULL) {
						ValaClass* _tmp411_;
						ValaInterface* _tmp412_;
						_tmp411_ = self->priv->_base_class;
						_tmp412_ = iface;
						_tmp409_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp411_, (ValaTypeSymbol*) _tmp412_);
					} else {
						_tmp409_ = FALSE;
					}
					if (_tmp409_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp413_;
						ValaList* _tmp414_;
						gint _m_size = 0;
						ValaList* _tmp415_;
						gint _tmp416_;
						gint _tmp417_;
						gint _m_index = 0;
						_tmp413_ = iface;
						_tmp414_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp413_);
						_m_list = _tmp414_;
						_tmp415_ = _m_list;
						_tmp416_ = vala_collection_get_size ((ValaCollection*) _tmp415_);
						_tmp417_ = _tmp416_;
						_m_size = _tmp417_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp418_;
							gint _tmp419_;
							ValaMethod* m = NULL;
							ValaList* _tmp420_;
							gpointer _tmp421_;
							ValaMethod* _tmp422_;
							gboolean _tmp423_;
							gboolean _tmp424_;
							_m_index = _m_index + 1;
							_tmp418_ = _m_index;
							_tmp419_ = _m_size;
							if (!(_tmp418_ < _tmp419_)) {
								break;
							}
							_tmp420_ = _m_list;
							_tmp421_ = vala_list_get (_tmp420_, _m_index);
							m = (ValaMethod*) _tmp421_;
							_tmp422_ = m;
							_tmp423_ = vala_method_get_is_abstract (_tmp422_);
							_tmp424_ = _tmp423_;
							if (_tmp424_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp425_ = FALSE;
									ValaClass* _tmp426_;
									ValaClass* _tmp479_;
									ValaClass* _tmp480_;
									_tmp426_ = base_class;
									if (_tmp426_ != NULL) {
										_tmp425_ = !implemented;
									} else {
										_tmp425_ = FALSE;
									}
									if (!_tmp425_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp427_;
										ValaList* _tmp428_;
										gint _impl_size = 0;
										ValaList* _tmp429_;
										gint _tmp430_;
										gint _tmp431_;
										gint _impl_index = 0;
										_tmp427_ = base_class;
										_tmp428_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp427_);
										_impl_list = _tmp428_;
										_tmp429_ = _impl_list;
										_tmp430_ = vala_collection_get_size ((ValaCollection*) _tmp429_);
										_tmp431_ = _tmp430_;
										_impl_size = _tmp431_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp432_;
											gint _tmp433_;
											ValaMethod* impl = NULL;
											ValaList* _tmp434_;
											gpointer _tmp435_;
											gboolean _tmp436_ = FALSE;
											ValaMethod* _tmp437_;
											ValaMethod* _tmp438_;
											ValaMethod* _tmp439_;
											ValaMethod* _tmp440_;
											_impl_index = _impl_index + 1;
											_tmp432_ = _impl_index;
											_tmp433_ = _impl_size;
											if (!(_tmp432_ < _tmp433_)) {
												break;
											}
											_tmp434_ = _impl_list;
											_tmp435_ = vala_list_get (_tmp434_, _impl_index);
											impl = (ValaMethod*) _tmp435_;
											_tmp437_ = impl;
											_tmp438_ = vala_method_get_base_interface_method (_tmp437_);
											_tmp439_ = _tmp438_;
											_tmp440_ = m;
											if (_tmp439_ == _tmp440_) {
												_tmp436_ = TRUE;
											} else {
												gboolean _tmp441_ = FALSE;
												gboolean _tmp442_ = FALSE;
												gboolean _tmp443_ = FALSE;
												gboolean _tmp444_ = FALSE;
												ValaClass* _tmp445_;
												_tmp445_ = base_class;
												if (_tmp445_ != self) {
													ValaMethod* _tmp446_;
													ValaMethod* _tmp447_;
													ValaMethod* _tmp448_;
													_tmp446_ = impl;
													_tmp447_ = vala_method_get_base_interface_method (_tmp446_);
													_tmp448_ = _tmp447_;
													_tmp444_ = _tmp448_ == NULL;
												} else {
													_tmp444_ = FALSE;
												}
												if (_tmp444_) {
													ValaMethod* _tmp449_;
													const gchar* _tmp450_;
													const gchar* _tmp451_;
													ValaMethod* _tmp452_;
													const gchar* _tmp453_;
													const gchar* _tmp454_;
													_tmp449_ = impl;
													_tmp450_ = vala_symbol_get_name ((ValaSymbol*) _tmp449_);
													_tmp451_ = _tmp450_;
													_tmp452_ = m;
													_tmp453_ = vala_symbol_get_name ((ValaSymbol*) _tmp452_);
													_tmp454_ = _tmp453_;
													_tmp443_ = g_strcmp0 (_tmp451_, _tmp454_) == 0;
												} else {
													_tmp443_ = FALSE;
												}
												if (_tmp443_) {
													gboolean _tmp455_ = FALSE;
													ValaMethod* _tmp456_;
													ValaDataType* _tmp457_;
													ValaDataType* _tmp458_;
													_tmp456_ = impl;
													_tmp457_ = vala_method_get_base_interface_type (_tmp456_);
													_tmp458_ = _tmp457_;
													if (_tmp458_ == NULL) {
														_tmp455_ = TRUE;
													} else {
														ValaMethod* _tmp459_;
														ValaDataType* _tmp460_;
														ValaDataType* _tmp461_;
														ValaTypeSymbol* _tmp462_;
														ValaTypeSymbol* _tmp463_;
														ValaInterface* _tmp464_;
														_tmp459_ = impl;
														_tmp460_ = vala_method_get_base_interface_type (_tmp459_);
														_tmp461_ = _tmp460_;
														_tmp462_ = vala_data_type_get_type_symbol (_tmp461_);
														_tmp463_ = _tmp462_;
														_tmp464_ = iface;
														_tmp455_ = _tmp463_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp464_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp442_ = _tmp455_;
												} else {
													_tmp442_ = FALSE;
												}
												if (_tmp442_) {
													ValaMethod* _tmp465_;
													ValaMethod* _tmp466_;
													_tmp465_ = impl;
													_tmp466_ = m;
													_tmp441_ = vala_method_compatible_no_error (_tmp465_, _tmp466_);
												} else {
													_tmp441_ = FALSE;
												}
												_tmp436_ = _tmp441_;
											}
											if (_tmp436_) {
												ValaMethod* _tmp467_;
												ValaVersionAttribute* _tmp468_;
												ValaVersionAttribute* _tmp469_;
												ValaSourceReference* _tmp470_;
												ValaSourceReference* _tmp471_;
												ValaMethod* _tmp472_;
												ValaMethod* _tmp473_;
												ValaMethod* _tmp474_;
												ValaMethod* _tmp475_;
												_tmp467_ = impl;
												_tmp468_ = vala_symbol_get_version ((ValaSymbol*) _tmp467_);
												_tmp469_ = _tmp468_;
												_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp471_ = _tmp470_;
												vala_version_attribute_check (_tmp469_, context, _tmp471_);
												_tmp472_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp472_, TRUE);
												implemented = TRUE;
												_tmp473_ = impl;
												_tmp474_ = vala_method_get_base_interface_method (_tmp473_);
												_tmp475_ = _tmp474_;
												if (_tmp475_ == NULL) {
													ValaHashMap* _tmp476_;
													ValaMethod* _tmp477_;
													ValaMethod* _tmp478_;
													_tmp476_ = self->priv->implicit_implementations;
													_tmp477_ = m;
													_tmp478_ = impl;
													vala_map_set ((ValaMap*) _tmp476_, _tmp477_, _tmp478_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
									}
									_tmp479_ = base_class;
									_tmp480_ = _tmp479_->priv->_base_class;
									base_class = _tmp480_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp481_;
									ValaSourceReference* _tmp482_;
									gchar* _tmp483_;
									gchar* _tmp484_;
									ValaMethod* _tmp485_;
									gchar* _tmp486_;
									gchar* _tmp487_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp482_ = _tmp481_;
									_tmp483_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp484_ = _tmp483_;
									_tmp485_ = m;
									_tmp486_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp485_);
									_tmp487_ = _tmp486_;
									vala_report_error (_tmp482_, "`%s' does not implement interface method `%s'", _tmp484_, _tmp487_);
									_g_free0 (_tmp487_);
									_g_free0 (_tmp484_);
								}
							}
							_vala_code_node_unref0 (m);
						}
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp488_;
						ValaList* _tmp489_;
						gint _prop_size = 0;
						ValaList* _tmp490_;
						gint _tmp491_;
						gint _tmp492_;
						gint _prop_index = 0;
						_tmp488_ = iface;
						_tmp489_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp488_);
						_prop_list = _tmp489_;
						_tmp490_ = _prop_list;
						_tmp491_ = vala_collection_get_size ((ValaCollection*) _tmp490_);
						_tmp492_ = _tmp491_;
						_prop_size = _tmp492_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp493_;
							gint _tmp494_;
							ValaProperty* prop = NULL;
							ValaList* _tmp495_;
							gpointer _tmp496_;
							ValaProperty* _tmp497_;
							gboolean _tmp498_;
							gboolean _tmp499_;
							_prop_index = _prop_index + 1;
							_tmp493_ = _prop_index;
							_tmp494_ = _prop_size;
							if (!(_tmp493_ < _tmp494_)) {
								break;
							}
							_tmp495_ = _prop_list;
							_tmp496_ = vala_list_get (_tmp495_, _prop_index);
							prop = (ValaProperty*) _tmp496_;
							_tmp497_ = prop;
							_tmp498_ = vala_property_get_is_abstract (_tmp497_);
							_tmp499_ = _tmp498_;
							if (_tmp499_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp512_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp500_ = FALSE;
									ValaClass* _tmp501_;
									ValaClass* _tmp503_;
									ValaScope* _tmp504_;
									ValaScope* _tmp505_;
									ValaProperty* _tmp506_;
									const gchar* _tmp507_;
									const gchar* _tmp508_;
									ValaSymbol* _tmp509_;
									ValaClass* _tmp510_;
									ValaClass* _tmp511_;
									_tmp501_ = base_class;
									if (_tmp501_ != NULL) {
										ValaSymbol* _tmp502_;
										_tmp502_ = sym;
										_tmp500_ = !VALA_IS_PROPERTY (_tmp502_);
									} else {
										_tmp500_ = FALSE;
									}
									if (!_tmp500_) {
										break;
									}
									_tmp503_ = base_class;
									_tmp504_ = vala_symbol_get_scope ((ValaSymbol*) _tmp503_);
									_tmp505_ = _tmp504_;
									_tmp506_ = prop;
									_tmp507_ = vala_symbol_get_name ((ValaSymbol*) _tmp506_);
									_tmp508_ = _tmp507_;
									_tmp509_ = vala_scope_lookup (_tmp505_, _tmp508_);
									_vala_code_node_unref0 (sym);
									sym = _tmp509_;
									_tmp510_ = base_class;
									_tmp511_ = _tmp510_->priv->_base_class;
									base_class = _tmp511_;
								}
								_tmp512_ = sym;
								if (VALA_IS_PROPERTY (_tmp512_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp513_;
									ValaProperty* _tmp514_;
									gchar* invalid_match = NULL;
									gboolean _tmp515_ = FALSE;
									ValaProperty* _tmp516_;
									gboolean _tmp517_;
									gboolean _tmp518_;
									ValaSymbol* _tmp532_;
									ValaVersionAttribute* _tmp533_;
									ValaVersionAttribute* _tmp534_;
									ValaSourceReference* _tmp535_;
									ValaSourceReference* _tmp536_;
									ValaSymbol* _tmp537_;
									_tmp513_ = sym;
									_tmp514_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp513_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp514_;
									invalid_match = NULL;
									_tmp516_ = base_prop;
									_tmp517_ = vala_symbol_get_hides ((ValaSymbol*) _tmp516_);
									_tmp518_ = _tmp517_;
									if (!_tmp518_) {
										ValaProperty* _tmp519_;
										ValaProperty* _tmp520_;
										gchar* _tmp521_ = NULL;
										gboolean _tmp522_;
										_tmp519_ = base_prop;
										_tmp520_ = prop;
										_tmp522_ = vala_property_compatible (_tmp519_, _tmp520_, &_tmp521_);
										_g_free0 (invalid_match);
										invalid_match = _tmp521_;
										_tmp515_ = !_tmp522_;
									} else {
										_tmp515_ = FALSE;
									}
									if (_tmp515_) {
										ValaSourceReference* _tmp523_;
										ValaSourceReference* _tmp524_;
										ValaProperty* _tmp525_;
										gchar* _tmp526_;
										gchar* _tmp527_;
										ValaProperty* _tmp528_;
										gchar* _tmp529_;
										gchar* _tmp530_;
										const gchar* _tmp531_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp523_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp524_ = _tmp523_;
										_tmp525_ = prop;
										_tmp526_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp525_);
										_tmp527_ = _tmp526_;
										_tmp528_ = base_prop;
										_tmp529_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp528_);
										_tmp530_ = _tmp529_;
										_tmp531_ = invalid_match;
										vala_report_error (_tmp524_, "Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp527_, _tmp530_, _tmp531_);
										_g_free0 (_tmp530_);
										_g_free0 (_tmp527_);
									}
									_tmp532_ = sym;
									_tmp533_ = vala_symbol_get_version (_tmp532_);
									_tmp534_ = _tmp533_;
									_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp536_ = _tmp535_;
									vala_version_attribute_check (_tmp534_, context, _tmp536_);
									_tmp537_ = sym;
									vala_symbol_set_used (_tmp537_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp538_;
									ValaSourceReference* _tmp539_;
									gchar* _tmp540_;
									gchar* _tmp541_;
									ValaProperty* _tmp542_;
									gchar* _tmp543_;
									gchar* _tmp544_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp539_ = _tmp538_;
									_tmp540_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp541_ = _tmp540_;
									_tmp542_ = prop;
									_tmp543_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp542_);
									_tmp544_ = _tmp543_;
									vala_report_error (_tmp539_, "`%s' does not implement interface property `%s'", _tmp541_, _tmp544_);
									_g_free0 (_tmp544_);
									_g_free0 (_tmp541_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp545_ = self->priv->_is_abstract;
		if (!_tmp545_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp546_;
			_tmp546_ = self->priv->_base_class;
			base_class = _tmp546_;
			while (TRUE) {
				gboolean _tmp547_ = FALSE;
				ValaClass* _tmp548_;
				ValaClass* _tmp609_;
				ValaClass* _tmp610_;
				_tmp548_ = base_class;
				if (_tmp548_ != NULL) {
					ValaClass* _tmp549_;
					gboolean _tmp550_;
					_tmp549_ = base_class;
					_tmp550_ = _tmp549_->priv->_is_abstract;
					_tmp547_ = _tmp550_;
				} else {
					_tmp547_ = FALSE;
				}
				if (!_tmp547_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp551_;
					ValaList* _tmp552_;
					gint _base_method_size = 0;
					ValaList* _tmp553_;
					gint _tmp554_;
					gint _tmp555_;
					gint _base_method_index = 0;
					_tmp551_ = base_class;
					_tmp552_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp551_);
					_base_method_list = _tmp552_;
					_tmp553_ = _base_method_list;
					_tmp554_ = vala_collection_get_size ((ValaCollection*) _tmp553_);
					_tmp555_ = _tmp554_;
					_base_method_size = _tmp555_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp556_;
						gint _tmp557_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp558_;
						gpointer _tmp559_;
						ValaMethod* _tmp560_;
						gboolean _tmp561_;
						gboolean _tmp562_;
						_base_method_index = _base_method_index + 1;
						_tmp556_ = _base_method_index;
						_tmp557_ = _base_method_size;
						if (!(_tmp556_ < _tmp557_)) {
							break;
						}
						_tmp558_ = _base_method_list;
						_tmp559_ = vala_list_get (_tmp558_, _base_method_index);
						base_method = (ValaMethod*) _tmp559_;
						_tmp560_ = base_method;
						_tmp561_ = vala_method_get_is_abstract (_tmp560_);
						_tmp562_ = _tmp561_;
						if (_tmp562_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp563_;
							const gchar* _tmp564_;
							const gchar* _tmp565_;
							ValaSymbol* _tmp566_;
							ValaMethod* _tmp567_;
							gboolean _tmp568_ = FALSE;
							ValaMethod* _tmp569_;
							_tmp563_ = base_method;
							_tmp564_ = vala_symbol_get_name ((ValaSymbol*) _tmp563_);
							_tmp565_ = _tmp564_;
							_tmp566_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp565_);
							_tmp567_ = VALA_IS_METHOD (_tmp566_) ? ((ValaMethod*) _tmp566_) : NULL;
							if (_tmp567_ == NULL) {
								_vala_code_node_unref0 (_tmp566_);
							}
							override_method = _tmp567_;
							_tmp569_ = override_method;
							if (_tmp569_ == NULL) {
								_tmp568_ = TRUE;
							} else {
								ValaMethod* _tmp570_;
								gboolean _tmp571_;
								gboolean _tmp572_;
								_tmp570_ = override_method;
								_tmp571_ = vala_method_get_overrides (_tmp570_);
								_tmp572_ = _tmp571_;
								_tmp568_ = !_tmp572_;
							}
							if (_tmp568_) {
								ValaSourceReference* _tmp573_;
								ValaSourceReference* _tmp574_;
								gchar* _tmp575_;
								gchar* _tmp576_;
								ValaMethod* _tmp577_;
								gchar* _tmp578_;
								gchar* _tmp579_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp573_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp574_ = _tmp573_;
								_tmp575_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp576_ = _tmp575_;
								_tmp577_ = base_method;
								_tmp578_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp577_);
								_tmp579_ = _tmp578_;
								vala_report_error (_tmp574_, "`%s' does not implement abstract method `%s'", _tmp576_, _tmp579_);
								_g_free0 (_tmp579_);
								_g_free0 (_tmp576_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp580_;
					ValaList* _tmp581_;
					gint _base_property_size = 0;
					ValaList* _tmp582_;
					gint _tmp583_;
					gint _tmp584_;
					gint _base_property_index = 0;
					_tmp580_ = base_class;
					_tmp581_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp580_);
					_base_property_list = _tmp581_;
					_tmp582_ = _base_property_list;
					_tmp583_ = vala_collection_get_size ((ValaCollection*) _tmp582_);
					_tmp584_ = _tmp583_;
					_base_property_size = _tmp584_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp585_;
						gint _tmp586_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp587_;
						gpointer _tmp588_;
						ValaProperty* _tmp589_;
						gboolean _tmp590_;
						gboolean _tmp591_;
						_base_property_index = _base_property_index + 1;
						_tmp585_ = _base_property_index;
						_tmp586_ = _base_property_size;
						if (!(_tmp585_ < _tmp586_)) {
							break;
						}
						_tmp587_ = _base_property_list;
						_tmp588_ = vala_list_get (_tmp587_, _base_property_index);
						base_property = (ValaProperty*) _tmp588_;
						_tmp589_ = base_property;
						_tmp590_ = vala_property_get_is_abstract (_tmp589_);
						_tmp591_ = _tmp590_;
						if (_tmp591_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp592_;
							const gchar* _tmp593_;
							const gchar* _tmp594_;
							ValaSymbol* _tmp595_;
							ValaProperty* _tmp596_;
							gboolean _tmp597_ = FALSE;
							ValaProperty* _tmp598_;
							_tmp592_ = base_property;
							_tmp593_ = vala_symbol_get_name ((ValaSymbol*) _tmp592_);
							_tmp594_ = _tmp593_;
							_tmp595_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp594_);
							_tmp596_ = VALA_IS_PROPERTY (_tmp595_) ? ((ValaProperty*) _tmp595_) : NULL;
							if (_tmp596_ == NULL) {
								_vala_code_node_unref0 (_tmp595_);
							}
							override_property = _tmp596_;
							_tmp598_ = override_property;
							if (_tmp598_ == NULL) {
								_tmp597_ = TRUE;
							} else {
								ValaProperty* _tmp599_;
								gboolean _tmp600_;
								gboolean _tmp601_;
								_tmp599_ = override_property;
								_tmp600_ = vala_property_get_overrides (_tmp599_);
								_tmp601_ = _tmp600_;
								_tmp597_ = !_tmp601_;
							}
							if (_tmp597_) {
								ValaSourceReference* _tmp602_;
								ValaSourceReference* _tmp603_;
								gchar* _tmp604_;
								gchar* _tmp605_;
								ValaProperty* _tmp606_;
								gchar* _tmp607_;
								gchar* _tmp608_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp603_ = _tmp602_;
								_tmp604_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp605_ = _tmp604_;
								_tmp606_ = base_property;
								_tmp607_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp606_);
								_tmp608_ = _tmp607_;
								vala_report_error (_tmp603_, "`%s' does not implement abstract property `%s'", _tmp605_, _tmp608_);
								_g_free0 (_tmp608_);
								_g_free0 (_tmp605_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
				}
				_tmp609_ = base_class;
				_tmp610_ = _tmp609_->priv->_base_class;
				base_class = _tmp610_;
			}
		}
	}
	_tmp611_ = vala_code_context_get_analyzer (context);
	_tmp612_ = _tmp611_;
	_tmp613_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp612_, _tmp613_);
	_tmp614_ = vala_code_context_get_analyzer (context);
	_tmp615_ = _tmp614_;
	_tmp616_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp615_, _tmp616_);
	_tmp617_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp618_ = _tmp617_;
	result = !_tmp618_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_opaque);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__once = 0;
	if (g_once_init_enter (&vala_class_type_id__once)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__once, vala_class_type_id);
	}
	return vala_class_type_id__once;
}

