#ifndef QRC_COORDINATE_H
#define QRC_COORDINATE_H

/*!
  \file
  \brief Wn

  \author Satofumi KAMIMURA

  $Id: Coordinate.h 1601 2010-01-04 15:09:50Z satofumi $
*/

#include "Position.h"
#include <set>
#include <memory>


namespace qrk
{
  /*!
    \brief Wn
  */
  class Coordinate
  {
  public:
    Coordinate(void);
    virtual ~Coordinate(void);


    /*!
      \brief O[oWn̎擾
    */
    static Coordinate* root(void);


    /*!
      \brief Wň_ݒ

      w肵WnɌ_ʒutB

      \param[in,out] parent eƂĐݒ肷Wn
      \param[in] position _̐eWnł̈ʒu
    */
    void setOriginTo(Coordinate* parent, const Position<long>& position);


    /*!
      \brief eWn̎擾

      \retval eWn
    */
    Coordinate* parent(void) const;


    /*!
      \brief qWn̎擾

      \retval qWñ|C^ꗗ
    */
    std::set<Coordinate*> children(void) const;


    /*!
      \brief qWň_ʒu擾

      \param[in] child qWn
      \retval qWň_ʒu

      \todo ]͂΁ACӂ̍Wn^ďł悤ɕύX
    */
    Position<long> offset(const Coordinate* child) const;


    /*!
      \brief w肵ʒuWn̂ǂɑ邩擾

      \param[in] position ʒu
      \param[in] coordinate ʒu݂Wn
      \retval g̍Wnł̈ʒu
    */
    Position<long> pointPosition(const Coordinate* coordinate,
                                 const Position<long>& position) const;

  protected:
    /*!
      \brief Wn̕]OɌĂ΂郁\bh
    */
    virtual void beforeEvaluate(void)
    {
    }

  private:
    Coordinate(Coordinate* parent);
    Coordinate(const Coordinate& rhs);
    Coordinate& operator = (const Coordinate& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /*! QRC_COORDINATE_H */
