/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#include "statusnotifier_storagearrow.h"
#include "statusnotifierbutton.h"
#include "../panel/customstyle.h"
#include <QApplication>

StatusNotifierStorageArrow::StatusNotifierStorageArrow(IUKUIPanelPlugin* plugin, QWidget *parent):
    StatusNotifierButtonAbstract(parent),
    m_plugin(plugin)
{
    m_parent=parent;
    this->setParent(parent);
    this->setAcceptDrops(true);

    systemThemeChanges();
    //设置按钮属性
    this->setProperty("useButtonPalette",true);
    this->setAutoRaise(true);
    this->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    setHoverBtnProperty();

    const QByteArray id(UKUI_PANEL_SETTINGS);
    if(QGSettings::isSchemaInstalled(id)) {
        m_gsettings = new QGSettings(id);
        connect(m_gsettings, &QGSettings::changed, this, [=] (const QString &key) {
            if(key == PANEL_POSITION_KEY) {
                m_panelPosition=m_gsettings->get(PANEL_POSITION_KEY).toInt();
                setArrowIcon();
            }
        });
    }
    QTimer::singleShot(10,this,[=](){
       setArrowIcon();
    });
    this->setProperty("useIconHighlightEffect", 0x2);
    this->setContextMenuPolicy(Qt::PreventContextMenu); //不显示右键菜单并且不将事件往基类传递
}

StatusNotifierStorageArrow::~StatusNotifierStorageArrow()
{
    if(m_themeSettings) {
        delete(m_themeSettings);
        m_themeSettings = NULL;
    }
}

void StatusNotifierStorageArrow::dropEvent(QDropEvent *event)
{
}

void StatusNotifierStorageArrow::dragEnterEvent(QDragEnterEvent *event)
{
    const StatusNotifierButtonMimeData *mimeData = qobject_cast<const StatusNotifierButtonMimeData*>(event->mimeData());
    if (mimeData && mimeData->button()){
        if(m_gsettings && m_gsettings->get(SHOW_STATUSNOTIFIER_BUTTON).toBool()==false) {
            m_gsettings->set(SHOW_STATUSNOTIFIER_BUTTON,true);
            setArrowIcon();
        }
        emit addButton(mimeData->button(), this);
    }
    event->accept();
    QToolButton::dragEnterEvent(event);
}

void StatusNotifierStorageArrow::dragLeaveEvent(QDragLeaveEvent *event)
{
    update();
    event->accept();
}

void StatusNotifierStorageArrow::mousePressEvent(QMouseEvent *event)
{
   setPressBtnProperty();
}

void StatusNotifierStorageArrow::mouseReleaseEvent(QMouseEvent *event)
{
    setHoverBtnProperty();

    if(event->button() == Qt::LeftButton) {
        if(m_gsettings) {
            if(m_plugin->panel()->isHorizontal()) {
                if(m_gsettings->get(SHOW_STATUSNOTIFIER_BUTTON).toBool()) {
                    setIcon(QIcon::fromTheme("ukui-start-symbolic"));
                    m_gsettings->set(SHOW_STATUSNOTIFIER_BUTTON,false);
                } else {
                    setIcon(QIcon::fromTheme("ukui-end-symbolic"));
                    m_gsettings->set(SHOW_STATUSNOTIFIER_BUTTON,true);
                }
            } else {
                if(m_gsettings->get(SHOW_STATUSNOTIFIER_BUTTON).toBool()) {
                    setIcon(QIcon::fromTheme("ukui-up-symbolic"));
                    m_gsettings->set(SHOW_STATUSNOTIFIER_BUTTON,false);
                } else {
                    setIcon(QIcon::fromTheme("ukui-down-symbolic"));
                    m_gsettings->set(SHOW_STATUSNOTIFIER_BUTTON,true);
                }
            }
        }
    }
    QToolButton::mouseReleaseEvent(event);
}

void StatusNotifierStorageArrow::setArrowIcon()
{
    if(m_gsettings) {
        if(m_plugin->panel()->isHorizontal()) {
            if(m_gsettings->get(SHOW_STATUSNOTIFIER_BUTTON).toBool()) {
                setIcon(QIcon::fromTheme("ukui-end-symbolic"));
            } else {
                setIcon(QIcon::fromTheme("ukui-start-symbolic"));
            }
        } else {
            if(m_gsettings->get(SHOW_STATUSNOTIFIER_BUTTON).toBool()) {
                setIcon(QIcon::fromTheme("ukui-down-symbolic"));
            } else {
                setIcon(QIcon::fromTheme("ukui-up-symbolic"));
            }
        }
    }
}

void StatusNotifierStorageArrow::systemThemeChanges()
{
    //主题变化 重新设置按钮背景颜色属性
    const QByteArray styleId(ORG_UKUI_STYLE);
    if(QGSettings::isSchemaInstalled(styleId)) {
        m_themeSettings = new QGSettings(styleId);
        connect(m_themeSettings, &QGSettings::changed, this, [=] (const QString &key) {
            if(key == STYLE_NAME) {
                setHoverBtnProperty();
            }
        });
    }
}

void StatusNotifierStorageArrow::resizeEvent(QResizeEvent *event)
{
    if (m_plugin->panel()->isHorizontal()) {
        this->setIconSize(QSize(this->width()*0.5,this->width()*0.5));
    } else {
        this->setIconSize(QSize(this->height()*0.5,this->height()*0.5));
    }
    QToolButton::resizeEvent(event);
}

void StatusNotifierStorageArrow::paintEvent(QPaintEvent *event)
{
    if (m_plugin->panel()->isHorizontal()) {
        this->setFixedSize(m_plugin->panel()->panelSize()*0.7, m_plugin->panel()->panelSize()*0.7);
    } else {
        this->setFixedSize(m_plugin->panel()->panelSize()*0.7, m_plugin->panel()->panelSize()*0.7);
    }
    QToolButton::paintEvent(event);
}

void StatusNotifierStorageArrow::mouseMoveEvent(QMouseEvent *event)
{
    QDrag *drag = new QDrag(this);
    drag->exec();
    drag->deleteLater();
}
void StatusNotifierStorageArrow::setHoverBtnProperty()
{
    if(m_themeSettings) {
        QStringList allKeys = m_themeSettings->keys();
        if(allKeys.contains(STYLE_NAME)) {
            QPalette pal = qApp->palette();
            QColor col = pal.color(QPalette::Active, QPalette::ButtonText);
            QString styleName = m_themeSettings->get(STYLE_NAME).toString();
            if(styleName==STYLE_NAME_KEY_DARK || styleName==STYLE_NAME_KEY_BLACK) {
                col.setAlphaF(m_blackHoverBtnAlphaF);
            } else if(styleName==STYLE_NAME_KEY_LIGHT || styleName==STYLE_NAME_KEY_WHITE || styleName==STYLE_NAME_KEY_DEFAULT) {
                col.setAlphaF(m_lightHoverBtnAlphaF);
            }
            pal.setColor(QPalette::Button, col);
            this->setPalette(pal);
        }
    }
}

void StatusNotifierStorageArrow::setPressBtnProperty()
{
    if(m_themeSettings) {
        QStringList allKeys = m_themeSettings->keys();
        if(allKeys.contains(STYLE_NAME)) {
            QPalette pal = qApp->palette();
            QColor col = pal.color(QPalette::Active, QPalette::ButtonText);
            QString styleName = m_themeSettings->get(STYLE_NAME).toString();
            if(styleName==STYLE_NAME_KEY_DARK || styleName==STYLE_NAME_KEY_BLACK) {
                col.setAlphaF(m_blackPressBtnAlphaF);
            } else if(styleName==STYLE_NAME_KEY_LIGHT || styleName==STYLE_NAME_KEY_WHITE || styleName==STYLE_NAME_KEY_DEFAULT) {
                col.setAlphaF(m_lightPressBtnAlphaF);
            }
            pal.setColor(QPalette::Button, col);
            this->setPalette(pal);
        }
    }
}
