/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2014 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 4.1 - Feb 2014
 */


#include "GUI.h"
#include "twpskWids.h"
#include "twpskHelp.h"

#define TEXT 0
#define INSERT 1
#define ABOUT 0

extern AppRes appRes;
extern Wids pskwids;
extern Help help;
extern Widget shell;
#if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
extern Pixmap pixmap;
#endif

/*
 * aboutDiag Function - Just an info dialog
 */
void aboutDiag ()
{
   static Widget diag = NULL;
   XmString  msg_xs;
   char msg_str[] = PACKAGE_STRING " \251 2000\n"
                   "Interfaces by Ted Williams - WA\330EIR\n"
                   "PSK classes by Hansi Reiser - DL9RDZ\n\n"
                   "Please send bug reports to\n" PACKAGE_BUGREPORT;

   if (diag == NULL)
      {
      diag = XmCreateInformationDialog (shell, (char *)"aboutDiag",  (ArgList) NULL, 0);
      XtVaSetValues (XtParent(diag),
         XmNtitle, "ABOUT TWPSK",
         #if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
         XmNiconPixmap, pixmap,
         #endif
         XmNmwmDecorations, MWM_DECOR_ALL | MWM_DECOR_RESIZEH,
         NULL);

      msg_xs = XmStringCreateLtoR (msg_str, XmFONTLIST_DEFAULT_TAG);
      XtVaSetValues (diag,
         XmNmessageAlignment, XmALIGNMENT_CENTER,
         XmNmessageString, msg_xs,
         NULL);
      XmStringFree(msg_xs);

      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_HELP_BUTTON));
      }
   XtManageChild (diag);
}


/*
 * helpCB - help menu buttons callback
 */
void helpCB (Widget w, XtPointer topic, XtPointer call_data)
{
   switch ((long)topic)
   {
   case ABOUT:
      aboutDiag();
      break;

   default:
      help.popupHelp ((long)topic);
      break;
   }
}


/*
 * Ok Callback for promptDiag
 * cdata is the last char to transmit
 */
 void OkCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   char lastChar = (long) cdata;
   XmSelectionBoxCallbackStruct *pt = (XmSelectionBoxCallbackStruct *) cbs;
   char *inputString, *freeMe;
   
   XmStringGetLtoR (pt->value, XmFONTLIST_DEFAULT_TAG, &inputString);
   freeMe = inputString;

   while (*inputString != '\0')
   {
      appendTXtext (*inputString, appRes.zero);
      inputString++; 
   }
   appendTXtext (lastChar, appRes.zero);
   XtAppAddWorkProc (XtWidgetToApplicationContext(w), procFileText,
      (XtPointer) NULL);
   XtFree (freeMe);
}


/*
 * promptDiag - used to enter text when sending a file
 */
void promptDiag (char *word, char lastChar)
{
   int i = 0;
   Arg args[5];
   Widget promptDiag;
   XmString msg_xs;
   XmString textField;

   /* Create the Prompt Dialog and remove Help and Cancel buttons */

   XtSetArg (args[i], XmNtitle, "TWPSK PROMPT DIALOG"); i++;
   /* We can only try this! Lesstif bug?*/
   XtSetArg (args[i], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); i++;

   promptDiag = XmCreatePromptDialog (pskwids.getShell(), "promptDiag",
       args, i);

   XtUnmanageChild (XmSelectionBoxGetChild (promptDiag,
      XmDIALOG_HELP_BUTTON));
   XtUnmanageChild (XmSelectionBoxGetChild (promptDiag,
      XmDIALOG_CANCEL_BUTTON));
   XtAddCallback (promptDiag, XmNokCallback, OkCB, (XtPointer) ((long)lastChar));

   msg_xs = XmStringCreateLocalized (word);
   textField = XmStringCreateLocalized ("");

   XtVaSetValues (promptDiag,
      XmNmessageAlignment, XmALIGNMENT_CENTER,
      XmNtextString, textField,
      XmNselectionLabelString, msg_xs,
      NULL); 

   XtVaSetValues (XtParent (promptDiag),
      #if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
      XmNiconPixmap, pixmap,
      #endif
      NULL); 

   XtVaSetValues (promptDiag,
      XmNmessageAlignment, XmALIGNMENT_CENTER,
      XmNtextString, textField,
      XmNselectionLabelString, msg_xs,
      NULL); 

   XmStringFree (msg_xs);
   XmStringFree (textField);
   XtManageChild (promptDiag);
}
 

/*
 * Error Dialog - called from many places and passed the parrent widget,
 * the error message to display and a flag that indicates the Cancel 
 * button is wanted.  
 */
void errorDiag (Widget w, char *emess, int flag)
{
   Widget errDiag;
   XmString xs;

   errDiag = XmCreateErrorDialog (w, "errDiag", NULL, 0);
   xs = XmStringCreateLocalized(emess);

   XtVaSetValues (XtParent(errDiag),
      XmNtitle, "TWCW ERROR",
      #if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
      XmNiconPixmap, pixmap,
      #endif
      XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
      NULL);

   XtVaSetValues (errDiag,
      XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
      XmNmessageString, xs,
      NULL);
   XmStringFree (xs);

   XtUnmanageChild (XmMessageBoxGetChild(errDiag, XmDIALOG_HELP_BUTTON));
   XtAddCallback (errDiag, XmNokCallback, errOkCB, (XtPointer) w);
   if (flag == CANCEL_BTN)
   {
      XtAddCallback (errDiag, XmNcancelCallback, errCancelCB, w);
   }
   else
   {
      XtUnmanageChild (XmMessageBoxGetChild(errDiag, XmDIALOG_CANCEL_BUTTON));
   }

   XtManageChild (errDiag);
}


/*
 * errOkCB - does cleanup and exits
 */
void errOkCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   /* no cleanup so just exit */
   exit (1);
} 


/*
 * errCancelCB - unmanage the shell to exit
 */
void errCancelCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   // Do nothing
}


/*
 * procFileText - Sends the contents of a file
 * If the file contains a '~', stop the work
 * proc and popup a prompt dialog for text.
 */
Boolean procFileText (XtPointer data)
{
   static char *start, *ptr, *begin;
   static Boolean first = True;
   static int ToDo = TEXT;
   char lastChar;
   int i = 0;

   if (first == True)
   {
      start = (char *) data;            /* starting point within text */
      begin = (char *) data;            /* keep this to free later */
      first = False;
   }

   switch (ToDo)
   {
      case TEXT:                        /* send file text and check for ~ */
         while (start[i] != '\0')
         {
            /* if char is a '~' and previous char was a ' ', '\0' or '\n'  */
            /* then ask for text.  '\0' happens when there is a ~WORD at   */
            /* the end of a line, and the next line starts with a ~WORD    */

            if (start[i] == '~' &&
               (start[i-1] == ' ' || start[i-1] == '\0' || start[i-1] == '\n'))
            {
               i++;
               start = start + i;
               ToDo = INSERT;           /* make us go to the other case next */
               return (False);          /* reschedule the work proc */
            }
            else
            {
               appendTXtext (*start, appRes.zero);    /*send the char */
               start++; 
               continue;
            }
         }
         first = True;
         XtFree (begin);                /* Free space used by file */
         return (True);                 /* All done so don't resked work proc */

      case INSERT:                      /* Inserts text for *word */
         ptr = start;

         while ( *start != ' ' && *start != '\n')
            start++;

         lastChar = *start;             /* save the terminating char */
         *start = '\0';                 /* "~word " is now "word\0" */
         promptDiag (ptr, lastChar);    /* popup the prompt dialog */
         start++;
         ToDo = TEXT;
         return (True);                 /* Don't reschedule the work proc, */
                                        /* The diag will reschedule it */

      default:
         printf ("We never get here :-) \n");
   }
   return (False);                      /* We never get here either */
} 


/*
 * getFile Function
 * Passed a pathname, this will XtMalloc space for the file,
 * reads the file, and returns a pointer to the file contents.
 * The caller must XtFree this pointer!
 */
char *getFile (char *filename)
{
   FILE *fp;
   struct stat info;
   char *pt;
   if (stat (filename, &info) != 0)
   {
       perror ("File Stat");
       exit (1);
   }

   if ((pt = (char *)XtMalloc ((int)info.st_size + 1)) == NULL)
   {
       perror ("twpskDiags getFile - XtMalloc error");
       exit (1);
   }

   if ((fp = fopen (filename, "r")) == NULL)   
   {
       perror ("twpskDiags getFile - File Open error");
       exit (1);
   }

   if (fread (pt, 1, (int)info.st_size, fp) != (unsigned int)(info.st_size))
   {
       perror ("twpskDiags getFile - Read error");
       exit (1);
   }  
   pt[(int)info.st_size] = '\0';

//TJW
if (0)
{
   fprintf (stderr, "\ngetFile XtMalloc %p\nFILENAME %s\nLEN %ld\nTEXT\n%s\n",
            pt, filename, info.st_size+1, pt);
}
   return (pt);
} 
