/**
 * Copyright (c) 2007 Arch Rock Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the Arch Rock Corporation nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * ARCHED ROCK OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE
 */

/**
 * Implementation of the user button for the telosb platform. Get
 * returns the current state of the button by reading the pin,
 * regardless of whether enable() or disable() has been called on the
 * Interface. Notify.enable() and Notify.disable() modify the
 * underlying interrupt state of the pin, and have the effect of
 * enabling or disabling notifications that the button has changed
 * state.
 *
 * @author Gilman Tolle <gtolle@archrock.com>
 * @version $Revision: 1.1 $
 * port to shimmer-style
 * @author Steve Ayer
 * @date   February, 2010
 */

#include <UserButton.h>

configuration UserButtonC {
  provides interface Notify<button_state_t>;
}
implementation {
  components HplUserButtonC;
  components new SwitchToggleC();
  SwitchToggleC.GpioInterrupt -> HplUserButtonC.GpioInterrupt;
  SwitchToggleC.GeneralIO -> HplUserButtonC.GeneralIO;

  components UserButtonP;
  Notify = UserButtonP;

  components new TimerMilliC() as debounceTimer;
  UserButtonP.NotifyLower -> SwitchToggleC.Notify;
  UserButtonP.debounceTimer -> debounceTimer;
}
