/* legacy-config.c generated by valac 0.56.18, the Vala compiler
 * generated from legacy-config.vala, do not modify */

/*
 * Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */
/* Compatibility with old (gnome-config) configuration files. */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "paths.h"
#include <gio/gio.h>
#include "uuid.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN GSList* tg_read_files (void);
static void _g_key_file_unref0_ (gpointer var);
static inline void _g_slist_free__g_key_file_unref0_ (GSList* self);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN gchar* tg_get_value (GSList* keyfiles,
                     const gchar* group,
                     const gchar* key);
VALA_EXTERN void tg_legacy_convert (GSettings* settings);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static void
_g_key_file_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL));
}

static inline void
_g_slist_free__g_key_file_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_key_file_unref0_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

GSList*
tg_read_files (void)
{
	GSList* names = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GSList* keyfiles = NULL;
	GSList* _tmp6_;
	GError* _inner_error0_ = NULL;
	GSList* result;
	names = NULL;
	_tmp0_ = tg_get_sysconf_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome", "config-override", "telegnome", NULL);
	names = g_slist_append (names, _tmp1_);
	_tmp2_ = g_get_home_dir ();
	_tmp3_ = g_build_filename (_tmp2_, ".gnome2", "telegnome", NULL);
	names = g_slist_append (names, _tmp3_);
	_tmp4_ = tg_get_sysconf_dir ();
	_tmp5_ = g_build_filename (_tmp4_, "gnome", "config", "telegnome", NULL);
	names = g_slist_append (names, _tmp5_);
	keyfiles = NULL;
	_tmp6_ = names;
	{
		GSList* name_collection = NULL;
		GSList* name_it = NULL;
		name_collection = _tmp6_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp7_;
			gchar* name = NULL;
			_tmp7_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp7_;
			{
				GKeyFile* keyfile = NULL;
				GKeyFile* _tmp8_;
				_tmp8_ = g_key_file_new ();
				keyfile = _tmp8_;
				{
					GKeyFile* _tmp9_;
					const gchar* _tmp10_;
					GKeyFile* _tmp11_;
					_tmp9_ = keyfile;
					_tmp10_ = name;
					g_key_file_load_from_file (_tmp9_, _tmp10_, G_KEY_FILE_NONE, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						_g_key_file_unref0 (keyfile);
						_g_free0 (name);
						(keyfiles == NULL) ? NULL : (keyfiles = (_g_slist_free__g_key_file_unref0_ (keyfiles), NULL));
						(names == NULL) ? NULL : (names = (_g_slist_free__g_free0_ (names), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp11_ = keyfile;
					keyfile = NULL;
					keyfiles = g_slist_append (keyfiles, _tmp11_);
				}
				goto __finally0;
				__catch0_g_file_error:
				{
					g_clear_error (&_inner_error0_);
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_key_file_unref0 (keyfile);
					_g_free0 (name);
					(keyfiles == NULL) ? NULL : (keyfiles = (_g_slist_free__g_key_file_unref0_ (keyfiles), NULL));
					(names == NULL) ? NULL : (names = (_g_slist_free__g_free0_ (names), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_key_file_unref0 (keyfile);
				_g_free0 (name);
			}
		}
	}
	result = keyfiles;
	(names == NULL) ? NULL : (names = (_g_slist_free__g_free0_ (names), NULL));
	return result;
}

gchar*
tg_get_value (GSList* keyfiles,
              const gchar* group,
              const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GSList* keyfile_collection = NULL;
		GSList* keyfile_it = NULL;
		keyfile_collection = keyfiles;
		for (keyfile_it = keyfile_collection; keyfile_it != NULL; keyfile_it = keyfile_it->next) {
			GKeyFile* keyfile = NULL;
			keyfile = (GKeyFile*) keyfile_it->data;
			{
				{
					gchar* _tmp0_ = NULL;
					GKeyFile* _tmp1_;
					gchar* _tmp2_;
					gchar* _tmp3_;
					_tmp1_ = keyfile;
					_tmp2_ = g_key_file_get_string (_tmp1_, group, key, &_inner_error0_);
					_tmp0_ = _tmp2_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp3_ = _tmp0_;
					_tmp0_ = NULL;
					result = _tmp3_;
					_g_free0 (_tmp0_);
					return result;
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
tg_legacy_convert (GSettings* settings)
{
	GSList* keyfiles = NULL;
	GSList* _tmp0_;
	gchar* val = NULL;
	gint channel_count = 0;
	gint current_channel = 0;
	GSList* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GSList* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GSList* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GSList* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GSList* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	GSList* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	GSList* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar** children = NULL;
	gchar** _tmp34_;
	gint children_length1;
	gint _children_size_;
	gchar** _tmp87_;
	gint _tmp87__length1;
	g_return_if_fail (settings != NULL);
	if (g_settings_get_boolean (settings, "legacy-migration-complete")) {
		return;
	}
	_tmp0_ = tg_read_files ();
	keyfiles = _tmp0_;
	channel_count = 0;
	current_channel = -1;
	_tmp1_ = keyfiles;
	_tmp2_ = tg_get_value (_tmp1_, "Channels", "count");
	_g_free0 (val);
	val = _tmp2_;
	_tmp3_ = val;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = val;
		channel_count = atoi (_tmp4_);
	}
	_tmp5_ = keyfiles;
	_tmp6_ = tg_get_value (_tmp5_, "Default", "server");
	_g_free0 (val);
	val = _tmp6_;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = val;
		current_channel = atoi (_tmp8_);
	}
	_tmp9_ = keyfiles;
	_tmp10_ = tg_get_value (_tmp9_, "Zooming", "factor");
	_g_free0 (val);
	val = _tmp10_;
	_tmp11_ = val;
	if (_tmp11_ != NULL) {
		gint _tmp12_ = 0;
		const gchar* _tmp13_;
		_tmp13_ = val;
		if (atoi (_tmp13_) == 1) {
			_tmp12_ = 1;
		} else {
			_tmp12_ = 2;
		}
		g_settings_set_int (settings, "zoom-factor", _tmp12_);
	}
	_tmp14_ = keyfiles;
	_tmp15_ = tg_get_value (_tmp14_, "Paging", "enabled");
	_g_free0 (val);
	val = _tmp15_;
	_tmp16_ = val;
	if (_tmp16_ != NULL) {
		gboolean paging_enabled = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		_tmp19_ = val;
		if (g_ascii_tolower (string_get (_tmp19_, (glong) 0)) == 't') {
			_tmp18_ = TRUE;
		} else {
			const gchar* _tmp20_;
			_tmp20_ = val;
			_tmp18_ = g_ascii_tolower (string_get (_tmp20_, (glong) 0)) == 'y';
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			const gchar* _tmp21_;
			_tmp21_ = val;
			_tmp17_ = atoi (_tmp21_) != 0;
		}
		if (_tmp17_) {
			paging_enabled = TRUE;
		} else {
			paging_enabled = FALSE;
		}
		g_settings_set_boolean (settings, "paging-enabled", paging_enabled);
	}
	_tmp22_ = keyfiles;
	_tmp23_ = tg_get_value (_tmp22_, "Paging", "interval");
	_g_free0 (val);
	val = _tmp23_;
	_tmp24_ = val;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_;
		_tmp25_ = val;
		g_settings_set_int (settings, "paging-interval", atoi (_tmp25_));
	}
	_tmp26_ = keyfiles;
	_tmp27_ = tg_get_value (_tmp26_, "Paging", "page_nr");
	_g_free0 (val);
	val = _tmp27_;
	_tmp28_ = val;
	if (_tmp28_ != NULL) {
		const gchar* _tmp29_;
		_tmp29_ = val;
		g_settings_set_int (settings, "current-page-number", atoi (_tmp29_));
	}
	_tmp30_ = keyfiles;
	_tmp31_ = tg_get_value (_tmp30_, "Paging", "subpage_nr");
	_g_free0 (val);
	val = _tmp31_;
	_tmp32_ = val;
	if (_tmp32_ != NULL) {
		const gchar* _tmp33_;
		_tmp33_ = val;
		g_settings_set_int (settings, "current-subpage-number", atoi (_tmp33_));
	}
	_tmp34_ = g_new0 (gchar*, (channel_count + 1) + 1);
	children = _tmp34_;
	children_length1 = channel_count + 1;
	_children_size_ = children_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				gchar* channel_group = NULL;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				guint8* uu = NULL;
				guint8* _tmp41_;
				gint uu_length1;
				gint _uu_size_;
				guint8* _tmp42_;
				gint _tmp42__length1;
				gchar* uuid_bytes = NULL;
				gchar* _tmp43_;
				gint uuid_bytes_length1;
				gint _uuid_bytes_size_;
				guint8* _tmp44_;
				gint _tmp44__length1;
				gchar* _tmp45_;
				gint _tmp45__length1;
				gchar* uuid = NULL;
				gchar* _tmp46_;
				gint _tmp46__length1;
				gchar* _tmp47_;
				gchar* child_path = NULL;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				gchar** _tmp51_;
				gint _tmp51__length1;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				GSettings* channel_settings = NULL;
				const gchar* _tmp54_;
				GSettings* _tmp55_;
				GSList* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				const gchar* _tmp59_;
				GSList* _tmp62_;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				const gchar* _tmp65_;
				GSList* _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				GSList* _tmp74_;
				const gchar* _tmp75_;
				gchar* _tmp76_;
				const gchar* _tmp77_;
				GSList* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				const gchar* _tmp83_;
				if (!_tmp35_) {
					gint _tmp36_;
					i = i + 1;
					_tmp36_ = i;
				}
				_tmp35_ = FALSE;
				if (!(i < channel_count)) {
					break;
				}
				_tmp37_ = g_strdup_printf ("%i", i);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strconcat ("Channel", _tmp38_, NULL);
				_tmp40_ = _tmp39_;
				_g_free0 (_tmp38_);
				channel_group = _tmp40_;
				_tmp41_ = g_new0 (guint8, 16);
				uu = _tmp41_;
				uu_length1 = 16;
				_uu_size_ = uu_length1;
				_tmp42_ = uu;
				_tmp42__length1 = uu_length1;
				uuid_generate (_tmp42_);
				_tmp43_ = g_new0 (gchar, 37);
				uuid_bytes = _tmp43_;
				uuid_bytes_length1 = 37;
				_uuid_bytes_size_ = uuid_bytes_length1;
				_tmp44_ = uu;
				_tmp44__length1 = uu_length1;
				_tmp45_ = uuid_bytes;
				_tmp45__length1 = uuid_bytes_length1;
				uuid_unparse (_tmp44_, _tmp45_);
				_tmp46_ = uuid_bytes;
				_tmp46__length1 = uuid_bytes_length1;
				_tmp47_ = g_strdup ((const gchar*) _tmp46_);
				uuid = _tmp47_;
				_tmp48_ = uuid;
				_tmp49_ = string_to_string (_tmp48_);
				_tmp50_ = g_strconcat ("/org/gnome/telegnome/channel/", _tmp49_, "/", NULL);
				child_path = _tmp50_;
				_tmp51_ = children;
				_tmp51__length1 = children_length1;
				_tmp52_ = uuid;
				_tmp53_ = g_strdup (_tmp52_);
				_g_free0 (_tmp51_[i]);
				_tmp51_[i] = _tmp53_;
				_tmp54_ = child_path;
				_tmp55_ = g_settings_new_with_path ("org.gnome.telegnome.channel", _tmp54_);
				channel_settings = _tmp55_;
				_tmp56_ = keyfiles;
				_tmp57_ = channel_group;
				_tmp58_ = tg_get_value (_tmp56_, _tmp57_, "name");
				_g_free0 (val);
				val = _tmp58_;
				_tmp59_ = val;
				if (_tmp59_ != NULL) {
					GSettings* _tmp60_;
					const gchar* _tmp61_;
					_tmp60_ = channel_settings;
					_tmp61_ = val;
					g_settings_set_string (_tmp60_, "name", _tmp61_);
				}
				_tmp62_ = keyfiles;
				_tmp63_ = channel_group;
				_tmp64_ = tg_get_value (_tmp62_, _tmp63_, "desc");
				_g_free0 (val);
				val = _tmp64_;
				_tmp65_ = val;
				if (_tmp65_ != NULL) {
					GSettings* _tmp66_;
					const gchar* _tmp67_;
					_tmp66_ = channel_settings;
					_tmp67_ = val;
					g_settings_set_string (_tmp66_, "description", _tmp67_);
				}
				_tmp68_ = keyfiles;
				_tmp69_ = channel_group;
				_tmp70_ = tg_get_value (_tmp68_, _tmp69_, "page_url");
				_g_free0 (val);
				val = _tmp70_;
				_tmp71_ = val;
				if (_tmp71_ != NULL) {
					GSettings* _tmp72_;
					const gchar* _tmp73_;
					_tmp72_ = channel_settings;
					_tmp73_ = val;
					g_settings_set_string (_tmp72_, "page-url", _tmp73_);
				}
				_tmp74_ = keyfiles;
				_tmp75_ = channel_group;
				_tmp76_ = tg_get_value (_tmp74_, _tmp75_, "subpage_url");
				_g_free0 (val);
				val = _tmp76_;
				_tmp77_ = val;
				if (_tmp77_ != NULL) {
					GSettings* _tmp78_;
					const gchar* _tmp79_;
					_tmp78_ = channel_settings;
					_tmp79_ = val;
					g_settings_set_string (_tmp78_, "subpage-url", _tmp79_);
				}
				_tmp80_ = keyfiles;
				_tmp81_ = channel_group;
				_tmp82_ = tg_get_value (_tmp80_, _tmp81_, "country");
				_g_free0 (val);
				val = _tmp82_;
				_tmp83_ = val;
				if (_tmp83_ != NULL) {
					GSettings* _tmp84_;
					const gchar* _tmp85_;
					_tmp84_ = channel_settings;
					_tmp85_ = val;
					g_settings_set_string (_tmp84_, "country", _tmp85_);
				}
				if (i == current_channel) {
					const gchar* _tmp86_;
					_tmp86_ = uuid;
					g_settings_set_string (settings, "current-channel", _tmp86_);
				}
				_g_object_unref0 (channel_settings);
				_g_free0 (child_path);
				_g_free0 (uuid);
				uuid_bytes = (g_free (uuid_bytes), NULL);
				uu = (g_free (uu), NULL);
				_g_free0 (channel_group);
			}
		}
	}
	_tmp87_ = children;
	_tmp87__length1 = children_length1;
	g_settings_set_strv (settings, "channel-children", _tmp87_);
	g_settings_set_boolean (settings, "legacy-migration-complete", TRUE);
	g_settings_sync ();
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (val);
	(keyfiles == NULL) ? NULL : (keyfiles = (_g_slist_free__g_key_file_unref0_ (keyfiles), NULL));
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

