from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


FULLRANGE = _Mock()

_ = _Mock()

_histogram = _Mock()

_nanmax = _Mock()

_nanmin = _Mock()

_scale_quads = _Mock()

_scale_rect = _Mock()

_scale_tr = _Mock()

_scale_xy = _Mock()

assemble_imageitems = _Mock()

assert_interfaces_valid = _Mock()

axes_to_canvas = _Mock()

canvas_to_axes = _Mock()

colvector = _Mock()

compute_trimageitems_original_size = _Mock()

fabs = _Mock()

get_cmap = _Mock()

get_cmap_name = _Mock()

get_image_from_plot = _Mock()

get_image_from_qrect = _Mock()

get_image_in_shape = _Mock()

get_items_in_rectangle = _Mock()

get_plot_qrect = _Mock()

getcwd = _Mock()

histogram2d = _Mock()

histogram2d_func = _Mock()

io = _Mock()

is_text_string = _Mock()

np = _Mock()

osp = _Mock()

pixelround = _Mock()

print_function = _Mock()

rotate = _Mock()

scale = _Mock()

stderr = _Mock()

sys = _Mock()

to_bins = _Mock()

translate = _Mock()

unicode_literals = _Mock()

update_dataset = _Mock()

INTERP_AA = 2

INTERP_LINEAR = 1

INTERP_NEAREST = 0

LUT_MAX = 1023.0

LUT_SIZE = 1024

SIG_ITEM_MOVED = '2item_moved(PyQt_PyObject,double,double,double,double)'

SIG_LUT_CHANGED = '2lut_changed(PyQt_PyObject)'

SIG_MASK_CHANGED = '2mask_changed(PyQt_PyObject)'

class BaseImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class CurveItem(_Mock):
  pass
  AutoScale = 2
  ClipPolygons = 2
  Dots = 4
  Fitted = 2
  Inverted = 1
  Legend = 1
  Lines = 1
  NoCurve = 0
  PaintFiltered = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  Steps = 3
  Sticks = 2
  UserCurve = 100
  Xfy = 1
  Yfx = 0
  _private = False
  _readonly = False

class CurvePlot(_Mock):
  pass
  BottomLegend = 2
  Box = 1
  DEFAULT_ACTIVE_XAXIS = 2
  DEFAULT_ACTIVE_YAXIS = 0
  DrawChildren = 2
  DrawWindowBackground = 1
  ExternalLegend = 4
  HLine = 4
  IgnoreMask = 4
  LeftLegend = 0
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RightLegend = 1
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  TopLegend = 3
  VLine = 5
  WinPanel = 3
  X_BOTTOM = 2
  X_TOP = 3
  Y_LEFT = 0
  Y_RIGHT = 1
  axisCnt = 4
  xBottom = 2
  xTop = 3
  yLeft = 0
  yRight = 1

class Histogram2DItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False
  fill_canvas = True

class IBaseImageItem(_Mock):
  pass
  _can_setfullscale = True
  _can_sethistogram = False

class IBasePlotItem(_Mock):
  pass
  _can_move = True
  _can_resize = True
  _can_rotate = True
  _can_select = True
  _private = False
  _readonly = False
  selected = False

class ICSImageItemType(_Mock):
  pass


class IColormapImageItemType(_Mock):
  pass


class IExportROIImageItemType(_Mock):
  pass


class IHistDataSource(_Mock):
  pass


class IImageItemType(_Mock):
  pass


class ISerializableType(_Mock):
  pass


class IStatsImageItemType(_Mock):
  pass


class ITrackableItemType(_Mock):
  pass


class IVoiImageItemType(_Mock):
  pass


class ImageAxesParam(_Mock):
  pass


class ImageFilterItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class ImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class ImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class ImagePlot(_Mock):
  pass
  BottomLegend = 2
  Box = 1
  DEFAULT_ACTIVE_XAXIS = 2
  DEFAULT_ACTIVE_YAXIS = 0
  DrawChildren = 2
  DrawWindowBackground = 1
  ExternalLegend = 4
  HLine = 4
  IgnoreMask = 4
  LeftLegend = 0
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RightLegend = 1
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  TopLegend = 3
  VLine = 5
  WinPanel = 3
  X_BOTTOM = 2
  X_TOP = 3
  Y_LEFT = 0
  Y_RIGHT = 1
  axisCnt = 4
  xBottom = 2
  xTop = 3
  yLeft = 0
  yRight = 1

class MaskedArea(_Mock):
  pass


class MaskedImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class MaskedImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class PolygonMapItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = False
  _private = False
  _readonly = False

class QColor(_Mock):
  pass
  Cmyk = 3
  Hsl = 4
  Hsv = 2
  Invalid = 0
  Rgb = 1

class QImage(_Mock):
  pass
  Format_ARGB32 = 5
  Format_ARGB32_Premultiplied = 6
  Format_ARGB4444_Premultiplied = 15
  Format_ARGB6666_Premultiplied = 10
  Format_ARGB8555_Premultiplied = 12
  Format_ARGB8565_Premultiplied = 8
  Format_Indexed8 = 3
  Format_Invalid = 0
  Format_Mono = 1
  Format_MonoLSB = 2
  Format_RGB16 = 7
  Format_RGB32 = 4
  Format_RGB444 = 14
  Format_RGB555 = 11
  Format_RGB666 = 9
  Format_RGB888 = 13
  InvertRgb = 0
  InvertRgba = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QPoint(_Mock):
  pass


class QPointF(_Mock):
  pass


class QRect(_Mock):
  pass


class QRectF(_Mock):
  pass


class QuadGridItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class QwtDoubleInterval(_Mock):
  pass
  ExcludeBorders = 3
  ExcludeMaximum = 2
  ExcludeMinimum = 1
  IncludeBorders = 0

class QwtPlotItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class RGBImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class RGBImageParam(_Mock):
  pass
  _hide_background = True
  _hide_colormap = True
  _multiselection = False

class RawImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class RawImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class RectangleShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 0
  AutoScale = 2
  CLOSED = True
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class TrImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = True
  _can_select = True
  _private = False
  _readonly = False

class TrImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

class XYImageFilterItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class XYImageItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = False
  _can_resize = False
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class XYImageParam(_Mock):
  pass
  _hide_background = False
  _hide_colormap = False
  _multiselection = False

