C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=NDLOCS,SSI=0
C
                        SUBROUTINE NDLOCS
C                       *****************
C
C      --------------------------------------------------------
     * (NELESS,NDMASS,NBCOUS,NPOINS,NODESS,NCOUPS,ITRAV)
C      --------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   TRANSFORMATION DE LA TABLE NODESS                       *
C              ON PASSE DE LA NUMEROTAION GLOBALE A LA NUMEROTATION    *
C              LOCALE DES NOEUDS                                       *
C                                                                      *
C        Avant : NODESS(n,1) = num glob du 1er noeuds de l'elt n       *
C        Apres : NODESS(n,1) = num loc couple du 1er noeuds de l'elt n *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NELESS !   E  ! D  ! NOMBRE D'ELTS SURF SOLIDE                   !
C   ! NDMASS !   E  ! D  ! NOMBRE DE NOEUDS DES ELTS SURF SOLIDES      !
C   ! NBCOUS !   E  ! D  ! NOMBRE DE NOEUDS COUPLES SOLIDES            !
C   ! NPOINS !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE  3D     !
C   ! NODESS !  TE  ! M  ! TABLE DES ELTS DE BORD SOLIDES COUPLES      !
C   ! NCOUPS !  TE  ! D  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES  !
C   ! ITRAV  !  TA  ! D  ! TABLEAU DE TRAVAIL                          !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C
C.. Variables externes
      INTEGER NELESS,NDMASS,NBCOUS,NPOINS
      INTEGER ITRAV(NPOINS),NODESS(NELESS,NDMASS),NCOUPS(NBCOUS)

C.. Variables internes
      INTEGER N,M
      LOGICAL LVERIF
C
C
C**********************************************************************
C
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
C
      DO 100 N=1,NPOINS
         ITRAV(N) = 0
  100 CONTINUE
C
C
C     2- CREATION DE LA TABLE NUM_GLOG --> NUM_LOC_COUPLE
C     ===================================================
C
      DO 200 N=1,NBCOUS
         ITRAV(NCOUPS(N)) = N
  200 CONTINUE
C
C
C     3- TRANSFORMATION DE LA TABLE DES ELEMENTS
C     ==========================================
C
      DO 300 M=1,NDMASS
         DO 310 N=1,NELESS
           NODESS(N,M) = ITRAV (NODESS(N,M))
  310    CONTINUE
  300 CONTINUE
C
C
C-------
C FORMAT
C-------
C
C----
C FIN
C----
C
      RETURN
      END
