C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LIMNUM
C                       *****************
C
C      -----------------------------------------------------
     * (NCOUPS,NBCOUS,NFLUSS,NBFLUS,NDIRS,NBDIRS,NECHS,NBECHS,
     *  NRAYTS,NBRAYS,NRAYIS,NBRAIS,NRESCS,NBRESS,
     *  NPRIOS,NBPRIO,NMOBIL,NBMOBS,NBCOPR,NREFS,NPOINS)
C      -----------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA NUMEROTATION LOCALE DES NOEUDS        *
C            PORTANT DES CONDITIONS AUX LIMITES DIFFERENTES            * 
C            ET DES NOEUDS PORTANT UN FLUX VOLUMIQUE                   *
C                                                                      *
C            Cas des conditions aux limites traitees par noeud         *
C                                                                      *
C            ON NE TRAITE ICI QUE lE SOLIDE                            *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NCOUPS   ! TE ! R  ! Numero des noeuds solides couples            !
C !  NBCOUS   !  E ! D  ! Nombre de noeuds solides couples             !
C !  NFLUSS   ! TE ! R  ! Numero des noeuds portant une C.L. de flux   !
C !  NFLUSS   !  E ! D  ! Nombre de noeuds portant une C.L. de flux    !
C !  NDIRS    ! TE ! R  ! Numero des noeuds portant une C.L. Dirichlet !
C !  NBDIRS   !  E ! D  ! Nombre de noeuds portant une C.L. Dirichlet  !
C !  NECHS    ! TE ! R  ! Numero des noeuds avec C.L. coeff echange    ! 
C !  NBECHS   !  E ! D  ! Nombre de noeuds avec C.L. coeff echange     ! 
C !  NRAYTS   ! TE ! R  ! Numero des noeuds avec rayonnement confine   !
C !  NBRAYS   !  E ! D  ! Nombre de noeuds avec rayonnement confine    !
C !  NRAYIS   ! TE ! R  ! Numero des noeuds avec rayonnement infini    !
C !  NBRAIS   !  E ! D  ! Nombre de noeuds avec rayonnement infini     !
C !  NRESCS   ! TE ! R  ! Numero des noeuds avec resistance de contact !
C !  NBRESS   !  E ! D  ! Nombre de noeuds avec resistance de contact  !
C !  NPRIOS   ! TE ! R  ! Numero des noeuds periodiques                !
C !  NBPRIO   !  E ! D  ! Nombre de noeuds periodiques                 !
C !  NMOBIL   ! TE ! R  ! Numero des noeuds en mouvement               !
C !  NBMOBS   !  E ! D  ! Nombre de  noeuds en mouvement               !
C !  NBCOPR   !  E ! D  ! NBRE DE CORREPONDANTS POUR LES NOEUDS PERIOD !
C !  NREFS    ! TE ! D  ! References des noeuds solides                !
C !  NPOINS   !  E ! D  ! Nombre de noeuds du maillage solide          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NBCOUS,NBFLUS,NBDIRS,NBECHS,NBRAYS,NBRAIS,NBRESS
      INTEGER NBCOPR,NBPRIO,NBMOBS
      INTEGER NCOUPS(NBCOUS),NFLUSS(NBFLUS),NDIRS(NBDIRS)
      INTEGER NECHS(NBECHS),NMOBIL(NBMOBS,2)
      INTEGER NRAYTS(NBRAYS),NRAYIS(NBRAIS),NRESCS(NBRESS,2)
      INTEGER NPRIOS(NBPRIO,1+NBCOPR)
      INTEGER NPOINS,NREFS(NPOINS)
C
C.. Variables internes
      INTEGER NUMREF,N,N1
      INTEGER NCOU,NFLU,NDIR,NECH,NRES,NRAY,NRAI,NPR,NMOB
      LOGICAL ERR
C
C***********************************************************************
C Rq : attention, dans le cas du modele coque, il faut NCOUPS(I) = I
C      (car le tableau NODESS n'existe pas et on travaille directement
C       avec NODES)
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      DO 1 N=1,NBCOUS
        NCOUPS(N) = 0
    1 CONTINUE
C
      DO 2 N=1,NBFLUS
        NFLUSS(N) = 0
    2 CONTINUE
C
      DO 3 N=1,NBDIRS
        NDIRS(N) = 0
    3 CONTINUE
C
      DO 4 N=1,NBECHS
        NECHS(N) = 0
    4 CONTINUE
C
      DO 6 N=1,NBRESS*2
        NRESCS(N,1) = 0
    6 CONTINUE
C
      DO 7 N=1,NBRAYS
        NRAYTS(N) = 0
    7 CONTINUE
C
      DO 8 N=1,NBRAIS
        NRAYIS(N) = 0
    8 CONTINUE
C
      DO 9 N=1,NBPRIO*(1+NBCOPR)
        NPRIOS(N,1) = 0
    9 CONTINUE
C
      DO 10 N=1,NBMOBS*2
        NMOBIL(N,1) = 0
   10 CONTINUE
C
      NCOU = 0
      NFLU = 0
      NDIR = 0
      NECH = 0
      NRES = 0
      NRAY = 0
      NRAI = 0
      NPR = 0
      NMOB = 0
C
C
C     2- COMPTE DES NOEUDS SUIVANT LES CL
C     ===================================
C
C
      DO 200 N=1,NPOINS
C
        NUMREF = ABS(NREFS(N))
C
        DO 210 N1=1,NRFMAX
C
           IF (IREFSC(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NCOU = NCOU + 1
              NCOUPS(NCOU) = N
           ENDIF
C
           IF (IREFSF(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NFLU = NFLU + 1
              NFLUSS(NFLU) = N
           ENDIF
C              
           IF (IREFSD(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NDIR = NDIR + 1
              NDIRS(NDIR) = N
           ENDIF
C
           IF (IREFSE(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NECH = NECH + 1
              NECHS(NECH) = N
           ENDIF
C
           IF (IREFRA(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NRAY = NRAY + 1
              NRAYTS(NRAY) = N
           ENDIF
C
           IF (IREFRI(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NRAI = NRAI + 1
              NRAYIS(NRAI) = N
           ENDIF
C
           IF (IREFRE(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NRES = NRES + 1
              NRESCS(NRES,1) = N
           ENDIF
C
           IF (IREFPR(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NPR  = NPR  + 1
              NPRIOS(NPR,1) = N
           ENDIF
C
           IF (IREFMO(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NMOB = NMOB + 1
              NMOBIL(NMOB,1) = N
           ENDIF
C
  210   CONTINUE
  200  CONTINUE
C
C
C     3- TRAITEMENT SPECIFIQUE DE CERTAINS DIRICHLET
C     ==============================================
C
      DO 300 N=1,NPOINS
C
        IF (NREFS(N).LT.0) THEN
           NFLU = NFLU + 1
           NFLUSS(NFLU) = N
        ENDIF
C
  300 CONTINUE
C
C
C     4- CONTROLE DES DIMENSIONS
C     ==========================
C
      ERR = .FALSE.
C
      IF (NCOU.NE.NBCOUS) THEN
         WRITE(NFECRA,4000) 'noeuds couples',NCOU,NBCOUS
         ERR = .TRUE.
      ENDIF
      IF (NFLU.NE.NBFLUS) THEN
         WRITE(NFECRA,4000) 'noeuds avec flux',NFLU,NBFLUS
         ERR = .TRUE.
      ENDIF
      IF (NDIR.NE.NBDIRS) THEN
         WRITE(NFECRA,4000) 'noeuds Dirichlet',NDIR,NBDIRS
         ERR = .TRUE.
      ENDIF
      IF (NECH.NE.NBECHS) THEN
         WRITE(NFECRA,4000) 'noeuds avec echange',NECH,NBECHS
         ERR = .TRUE.
      ENDIF
      IF (NRAY.NE.NBRAYS) THEN
         WRITE(NFECRA,4000) 'noeuds avec rayonnement confine ',
     *                      NRAY,NBRAYS
         ERR = .TRUE.
      ENDIF
      IF (NRAI.NE.NBRAIS) THEN
         WRITE(NFECRA,4000) 'noeuds avec rayonnement infini',
     *                      NRAI,NBRAIS
         ERR = .TRUE.
      ENDIF
      IF (NRES.NE.NBRESS) THEN
         WRITE(NFECRA,4000) 'noeuds avec resistance de contact',
     &                      NRES,NBRESS
         ERR = .TRUE.
      ENDIF
      IF (NPR .NE.NBPRIO) THEN
         WRITE(NFECRA,4000) 'noeuds periodiques',NPR ,NBPRIO
         ERR = .TRUE.
      ENDIF
      IF (NMOB.NE.NBMOBS) THEN
         WRITE(NFECRA,4000) 'noeuds en mouvement',NMOB ,NBMOBS
         ERR = .TRUE.
      ENDIF
C
C
C
C     5- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.GT.0)
     *  WRITE(NFECRA,5000) NBCOUS,NBFLUS,NBDIRS,NBECHS,NBRESS,
     *                     NBRAYS,NBRAIS,NBPRIO,NBMOBS
C
      IF (NBLBLA.EQ.10) THEN
        IF (NBCOUS.GT.0) THEN
          WRITE(NFECRA,5010) 
          WRITE(NFECRA,5001) (NCOUPS(N),N=1,NBCOUS)
        ENDIF
        IF (NBFLUS.GT.0) THEN
          WRITE(NFECRA,5020) 
          WRITE(NFECRA,5001) (NFLUSS(N),N=1,NBFLUS)
        ENDIF
        IF (NBDIRS.GT.0) THEN
          WRITE(NFECRA,5030) 
          WRITE(NFECRA,5001) (NDIRS(N),N=1,NBDIRS)
        ENDIF
        IF (NBECHS.GT.0) THEN
          WRITE(NFECRA,5040) 
          WRITE(NFECRA,5001) (NECHS(N),N=1,NBECHS)
        ENDIF
        IF (NBRAYS.GT.0) THEN
          WRITE(NFECRA,5060) 
          WRITE(NFECRA,5001) (NRAYTS(N),N=1,NBRAYS)
        ENDIF
        IF (NBRAIS.GT.0) THEN
          WRITE(NFECRA,5061) 
          WRITE(NFECRA,5001) (NRAYIS(N),N=1,NBRAIS)
        ENDIF
        IF (NBRESS.GT.0) THEN
          WRITE(NFECRA,5070) 
          WRITE(NFECRA,5001) (NRESCS(N,1),N=1,NBRESS)
        ENDIF
        IF (NBPRIO.GT.0) THEN
          WRITE(NFECRA,5080) 
          WRITE(NFECRA,5001) (NPRIOS(N,1),N=1,NBPRIO)
        ENDIF
        IF (NBMOBS.GT.0) THEN
          WRITE(NFECRA,5090) 
          WRITE(NFECRA,5001) (NMOBIL(N,1),N=1,NBMOBS)
        ENDIF
C
      ENDIF
C
C     6- ARRET DU PROGRAMME EN CAS D'ERREUR DE DIMENSION
C     ==================================================
      IF (ERR) STOP

C--------
C FORMATS
C--------
C
 5000 FORMAT(/,' *** LIMNUM : Nombre de points du solide :',/,
     &       '        - couples avec le fluide     : ',I6,/,
     &       '        - condition de type flux     : ',I6,/,
     &       '        - condition de Dirichlet     : ',I6,/,
     &       '        - condition de type coefficient d''echange : '
     &       ,I6,/,
     &       '        - avec resistance de contact : ',I6,/,
     &       '        - avec rayonnement confine   : ',I6,/,
     &       '        - avec rayonnement infini    : ',I6,/,
     &       '        - periodiques                : ',I6,/,
     &       '        - en mouvement               : ',I6)
C 
 4000 FORMAT(' %% ERREUR LIMNUM : incoherence sur les ',A30,/,
     &       '                    On en compte :',I9,/,
     &       '                    Il y en a ',I9,' de declares')
 5001 FORMAT(8X,12I6)
 5010 FORMAT(/,8X,'Liste des noeuds solides couples :',/)
 5020 FORMAT(/,8X,'Liste des noeuds solides avec flux :',/)
 5030 FORMAT(/,8X,'Liste des noeuds solides avec Dirichlet :',/)
 5040 FORMAT(/,8X,'Liste des noeuds solides avec coeff d''echange :',/)
 5060 FORMAT(/,8X,'Liste des noeuds solides avec rayonnement ',
     &         'confine :',/)
 5061 FORMAT(/,8X,'Liste des noeuds solides avec rayonnement ',
     &         'infini :',/)
 5070 FORMAT(/,8X,'Liste des noeuds solides avec ',
     &         'resistance de contact :',/)
 5080 FORMAT(/,8X,'Liste des noeuds solides periodiques :',/)
 5090 FORMAT(/,8X,'Liste des noeuds solides en mouvement :',/)
C
C----
C FIN
C----
      END
