C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C
                        SUBROUTINE LECME3
C                       *****************
C
C      -----------------------------------------
     * (NDIM,NDIELE,NPOINS,NELEMS,NDMATS,NBFACE,
     *  NODES,NREFS,NREFE,NREFAC,COORDS)
C      ------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE DU MAILLAGE ELEMENTS FINIS                       *
C             STRUCTURE DE DONNEE ISSUE DE MED                         *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NODES    ! TE ! R  ! TABLE DES ELEMENTS DU MAILLAGE SOLIDE        !
C !  NREFS    ! TE ! R  ! REFERENCES DES NOEUDS DU MAILLAGE SOLIDE     !
C !  NREFAC   ! TE ! R  ! REFERENCES DES FACES                         !
C !  COORDS   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /MOBIL/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "xrefer.h"
#ifdef MED
#include "med.hf"
#endif
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFS(NPOINS),NREFE(NELEMS)
      INTEGER NREFAC(NELEMS,NBFACE),ITRMED(NDMATS,NELEMS)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM)
C
#ifdef MED
C.. Variables internes
      INTEGER I,J,ITYCOO,NBFAM,IDIM,IRET,NBATT,NBIDON
      INTEGER NB,NGRO,NUMFAM,IFAN(NRFMAX),IFAE(NRFMAX)
      CHARACTER*8 NOMCO2(2),UNICO2(2),NOMCO3(3),UNICO3(3)
      CHARACTER*32 NOM,NOMFAM
      CHARACTER*80 GRO
      LOGICAL LFAE
      CHARACTER*200 ATDES0(1),ATDES2(4),ATDES3(5)
      INTEGER ATIDE0(1),ATIDE2(4),ATIDE3(5)
      INTEGER ATVAL0(1),ATVAL2(4),ATVAL3(5)
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      DO I=1,NPOINS
        NREFS(I) = 0
      ENDDO
      DO I=1,NELEMS
        NREFE(I) = 0
      ENDDO
C
C     2- LECTURE
C     ==========
C     lecture du nom du maillage
      CALL EFMAAI(NFSGCT,1,NOM,IDIM,IRET)
C
C     lecture des noeuds
      IF (NDIM.EQ.2) THEN
        CALL EFCOOL(NFSGCT,NOM,NDIM,COORDS,MED_NO_INTERLACE,NPOINS,
     *              ITYCOO,NOMCO2,UNICO2,IRET)
      ELSE
        CALL EFCOOL(NFSGCT,NOM,NDIM,COORDS,MED_NO_INTERLACE,NPOINS,
     *              ITYCOO,NOMCO3,UNICO3,IRET)
      ENDIF
C
C     lecture de la connectivite
      IF (NDMATS.EQ.6) THEN
CMED20        CALL EFCONL(NFSGCT,NOM,NDIM,ITRMED,NELEMS,
CMED20     *              MED_MAILLE,MED_TRIA6,MED_NOD,IRET)
        CALL EFCONL(NFSGCT,NOM,NDIM,NODES,MED_NO_INTERLACE,NBIDON,0,
     *              MED_MAILLE,MED_TRIA6,MED_NOD,IRET)
      ELSEIF (NDMATS.EQ.10) THEN
CMED20        CALL EFCONL(NFSGCT,NOM,NDIM,ITRMED,NELEMS,
CMED20     *              MED_MAILLE,MED_TETRA10,MED_NOD,IRET)
        CALL EFCONL(NFSGCT,NOM,NDIM,NODES,MED_NO_INTERLACE,NBIDON,0,
     *              MED_MAILLE,MED_TETRA10,MED_NOD,IRET)
      ENDIF
C
      DO J=1,NDMATS
        DO I=1,NELEMS
          NODES(I,J)=ITRMED(J,I)
        ENDDO
      ENDDO
C
C     lecture des numeros de famille des noeuds
      CALL EFFAML(NFSGCT,NOM,NREFS,NPOINS,MED_NOEUD,0,IRET)
C
C     lecture des numeros de famille des elements
      IF (NDMATS.EQ.6) THEN
        CALL EFFAML(NFSGCT,NOM,NREFE,NELEMS,MED_MAILLE,MED_TRIA6,IRET)
      ELSEIF (NDMATS.EQ.10) THEN
        CALL EFFAML(NFSGCT,NOM,NREFE,NELEMS,MED_MAILLE,MED_TETRA10,IRET)
      ENDIF
C
C     nombre de familles
      CALL EFNFAM(NFSGCT,NOM,0,0,NBFAM,IRET)
C      
C     lecture des familles
      LFAE=.FALSE.
      DO I=1,NBFAM
        CALL EFNFAM(NFSGCT,NOM,I,MED_ATTR,NBATT,IRET)
        IF (NBATT.EQ.1) THEN
           CALL EFFAMI(NFSGCT,NOM,I,NOMFAM,NUMFAM,
     *                 ATIDE0,ATVAL0,ATDES0,NB,GRO,NGRO,IRET)
           IF (NUMFAM.GT.0) THEN          ! famille de noeud
             IFAN(NUMFAM)=ATVAL0(1)
           ELSEIF (NUMFAM.LT.0) THEN      ! famille d'element
             LFAE=.TRUE.
             IFAE(-NUMFAM)=ATVAL0(1)
           ENDIF
        ELSEIF (NBATT.EQ.4) THEN
           CALL EFFAMI(NFSGCT,NOM,I,NOMFAM,NUMFAM,
     *                 ATIDE2,ATVAL2,ATDES2,NB,GRO,NGRO,IRET)
           NREFE(-NUMFAM)=ATVAL2(1)
           NREFAC(-NUMFAM,1)=ATVAL2(2)
           NREFAC(-NUMFAM,2)=ATVAL2(3)
           NREFAC(-NUMFAM,3)=ATVAL2(4)
        ELSEIF (NBATT.EQ.5) THEN
           CALL EFFAMI(NFSGCT,NOM,I,NOMFAM,NUMFAM,
     *                 ATIDE3,ATVAL3,ATDES3,NB,GRO,NGRO,IRET)
           NREFE(-NUMFAM)=ATVAL3(1)
           NREFAC(-NUMFAM,1)=ATVAL3(2)
           NREFAC(-NUMFAM,2)=ATVAL3(3)
           NREFAC(-NUMFAM,3)=ATVAL3(4)
           NREFAC(-NUMFAM,4)=ATVAL3(5)
        ENDIF
      ENDDO
C
C     On remet d'aplomb les references des noeuds
      DO I=1,NPOINS
        NREFS(I)=IFAN(NREFS(I))
      ENDDO
C
C     Quand il n'y a pas de references de face on remet d'aplomb
C     les references des elements
      IF (LFAE) THEN
        DO I=1,NELEMS
          NREFE(I)=IFAE(-NREFE(I))
        ENDDO
      ENDIF
C
C
C     3- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLA.GT.0) THEN
        WRITE(NFECRA,5000)
        WRITE(NFECRA,5010) NDIM,NPOINS,NELEMS 
        IF (.NOT.LFAE) THEN
          WRITE(NFECRA,5020) 
        ELSE
          WRITE(NFECRA,5030) 
        ENDIF
      ENDIF
C
C
C     6- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLA.GE.2) THEN
C
      WRITE(NFECRA,6000) 
      WRITE(NFECRA,6010)
      DO I=1,10
        WRITE(NFECRA,6011) I,(COORDS(I,J),J=1,NDIM)
      ENDDO
C
      WRITE(NFECRA,6020)
      DO I=1,10
        WRITE(NFECRA,6012) I,(NODES(I,J),J=1,NDMATS)
      ENDDO
C
      WRITE(NFECRA,6030)
      DO I=1,10
         WRITE(NFECRA,6013) I,NREFS(I)
      ENDDO
C
      IF (NDPROP.GT.1) THEN
        WRITE(NFECRA,6031)
        DO I=1,10
           WRITE(NFECRA,6013) I,NREFE(I)
        ENDDO
      ENDIF
C
      IF (.NOT.LFAE) THEN
        WRITE(NFECRA,6040)
        DO I=1,10
           WRITE(NFECRA,6014) I,(NREFAC(I,J),J=1,NDIELE+1)
        ENDDO
      ENDIF   
C
      ENDIF  
C

C
C--------
C FORMATS
C--------
C
 2100 FORMAT(//,' *** LECME3 : LE FICHIER SUITE NE CONTIENT PAS LA',
     &          ' TABLE DES NOEUDS')
 2200 FORMAT(A7,I3,1X,3E14.7)
 3100 FORMAT(//,' *** LECME3 : LE FICHIER SUITE NE CONTIENT PAS LA',
     &          ' TABLE DES ELEMENTS')
 3200 FORMAT(I7,I3,6I7)
 3201 FORMAT(I7,I3,10I7)
 4200 FORMAT(I6,1X,4I5)
C
 5000 FORMAT(//,' *** LECME3 : MAILLAGE ELEMENTS FINIS DU SOLIDE :')
 5010 FORMAT(8X,'- Dimension du maillage            : ',I6,/
     &       8X,'- Nombre total de noeuds           : ',I6,/
     &       8X,'- Nombre d''elements                : ',I6)
 5020 FORMAT(8X,'- Il y a des references sur les faces')
 5030 FORMAT(8X,'- Il n''y a pas de references sur les faces')
C
 6000 FORMAT(/,' *** LECME3 : Verification du maillage solide',/)
 6010 FORMAT(/,14X,'Coordonnees des 10 premiers noeuds :',/)
 6020 FORMAT(/,14X,'Table des 10 premiers elements :',/)
 6030 FORMAT(/,14X,'References des 10 premiers noeuds :',/)
 6031 FORMAT(/,14X,'References des 10 premiers elements :',/)
 6040 FORMAT(/,14X,'References des faces des 10 premiers elements :',/)
 6011 FORMAT(14X,'N=',I2,'   COORDS : ',3E12.5) 
 6012 FORMAT(14X,'N=',I2,'   NOEUDS : ',10I6)
 6013 FORMAT(14X,'N=',I2,'   REFERENCE : ',I3)
 6014 FORMAT(14X,'N=',I2,'   REFERENCE DES FACES : ',4I3)
C
#endif
      END
